/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.streams.aggregation;

import com.google.common.base.MoreObjects;
import io.confluent.controlcenter.streams.aggregation.MetricValues;
import java.nio.ByteBuffer;
import java.util.Objects;

public class MetricHolder
implements MetricValues {
    final ByteBuffer buffer;
    private static int pos = 0;
    static final int COUNT = pos++ * 8;
    static final int SUM = pos++ * 8;
    static final int MIN = pos++ * 8;
    static final int MAX = pos++ * 8;

    public void reset() {
        MetricHolder.reset(this.buffer);
    }

    public static void reset(ByteBuffer buffer) {
        buffer.putLong(COUNT, 0L);
        buffer.putLong(SUM, 0L);
        buffer.putLong(MIN, Long.MAX_VALUE);
        buffer.putLong(MAX, Long.MIN_VALUE);
    }

    public static ByteBuffer allocateBuffer() {
        return ByteBuffer.allocate(8 * pos);
    }

    public static MetricHolder fromByteBuffer(ByteBuffer buffer) {
        return new MetricHolder(buffer);
    }

    public static MetricHolder fromValue(long value) {
        return MetricHolder.fromValues(1L, value, value, value);
    }

    public static MetricHolder fromValues(long count, long sum, long min, long max) {
        ByteBuffer buffer = MetricHolder.allocateBuffer();
        buffer.putLong(COUNT, count);
        buffer.putLong(SUM, sum);
        buffer.putLong(MIN, min);
        buffer.putLong(MAX, max);
        return MetricHolder.fromByteBuffer(buffer);
    }

    public static ByteBuffer asByteBuffer(MetricHolder holder) {
        return holder.buffer;
    }

    private MetricHolder(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public long max() {
        return MetricHolder.max(this.buffer);
    }

    static long max(ByteBuffer buffer) {
        return buffer.getLong(MAX);
    }

    @Override
    public long min() {
        return MetricHolder.min(this.buffer);
    }

    static long min(ByteBuffer buffer) {
        return buffer.getLong(MIN);
    }

    @Override
    public long sum() {
        return MetricHolder.sum(this.buffer);
    }

    static long sum(ByteBuffer buffer) {
        return buffer.getLong(SUM);
    }

    @Override
    public long count() {
        return MetricHolder.count(this.buffer);
    }

    static long count(ByteBuffer buffer) {
        return buffer.getLong(COUNT);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("count", this.count()).add("sum", this.sum()).add("min", this.min()).add("max", this.max()).toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MetricHolder that = (MetricHolder)obj;
        boolean eq = Objects.equals(this.buffer, that.buffer);
        eq |= Objects.equals(this.max(), that.max());
        eq |= Objects.equals(this.min(), that.min());
        eq |= Objects.equals(this.sum(), that.sum());
        return eq |= Objects.equals(this.count(), that.count());
    }

    public int hashCode() {
        return Objects.hash(this.max(), this.min(), this.sum(), this.count());
    }
}

