/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.streams.alert;

import com.google.inject.Inject;
import io.confluent.controlcenter.keys.Keys;
import io.confluent.controlcenter.serialization.OrderedKeyPrefixedSerdeSupplier;
import io.confluent.monitoring.record.Monitoring;
import io.confluent.serializers.OrderedKeyPrefixedSerde;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.kstream.Predicate;
import org.apache.kafka.streams.kstream.Windowed;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupMeasurement
implements Predicate<Windowed<Bytes>, Monitoring.MonitoringMessage> {
    private static final Logger log = LoggerFactory.getLogger(GroupMeasurement.class);
    private final OrderedKeyPrefixedSerde<Keys.KeyType, Monitoring.MonitoringMessage> keySerde;

    @Inject
    public GroupMeasurement(OrderedKeyPrefixedSerdeSupplier<Keys.KeyType, Monitoring.MonitoringMessage> keySerdeSupplier) {
        this.keySerde = keySerdeSupplier.get();
    }

    public boolean test(Windowed<Bytes> key, Monitoring.MonitoringMessage value) {
        Keys.KeyType keyType = (Keys.KeyType)this.keySerde.extractPrefix((Bytes)key.key());
        return keyType.equals((Object)Keys.KeyType.EXPECTED_PRODUCTION_GROUP) || keyType.equals((Object)Keys.KeyType.LOOKUP_CLIENTTYPE_GROUP);
    }
}

