/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.streams.consumergroups;

import io.confluent.controlcenter.ControlCenterProtoHelper;
import io.confluent.controlcenter.record.Controlcenter;
import io.confluent.controlcenter.streams.monitoring.MonitoringMessageAggregator;
import io.confluent.monitoring.common.MonitoringMessageUtil;
import io.confluent.monitoring.record.Monitoring;
import java.util.Objects;
import org.apache.kafka.streams.kstream.Aggregator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerGroupProductionAggregator<K>
implements Aggregator<Controlcenter.TopicPartition, Monitoring.MonitoringMessage, Controlcenter.ClientGroupProductionAggregate> {
    private static final Logger log = LoggerFactory.getLogger(ConsumerGroupProductionAggregator.class);
    private MonitoringMessageAggregator<Void> aggregator = new MonitoringMessageAggregator();

    public static boolean clientGroupHasValues(Controlcenter.ClientGroup clientGroup, String group, String clientId) {
        return Objects.equals(clientGroup.getGroup(), group) && Objects.equals(clientGroup.getClient(), clientId);
    }

    public Controlcenter.ClientGroupProductionAggregate apply(Controlcenter.TopicPartition aggKey, Monitoring.MonitoringMessage value, Controlcenter.ClientGroupProductionAggregate aggregate) {
        Controlcenter.ClientGroupProductionAggregate.Builder builder = ControlCenterProtoHelper.clientGroupProductionAggregateBuilder(aggregate);
        switch (value.getClientType()) {
            case CONSUMER: {
                Controlcenter.ClientGroup.Builder newClientGroup = ControlCenterProtoHelper.clientGroupBuilder(value);
                for (Controlcenter.ClientGroup cg : aggregate.getClientGroupList()) {
                    if (!ConsumerGroupProductionAggregator.clientGroupHasValues(cg, value.getGroup(), value.getClientId())) continue;
                    newClientGroup.setWindow(-1L);
                    break;
                }
                builder = builder.setNewClientGroup(newClientGroup);
                if (newClientGroup.getWindow() > -1L) {
                    builder.addClientGroup(newClientGroup);
                    builder.getAggBuilder().setClientId(newClientGroup.getClient()).setGroup(newClientGroup.getGroup());
                }
                return builder.build();
            }
            case PRODUCER: {
                if (!aggregate.hasAgg() || aggregate.getAgg().getWindow() < 0L) {
                    builder.setDiff(value);
                    builder.setAgg(value);
                } else {
                    builder.setAgg(this.aggregator.aggregate(value, aggregate.getAgg()));
                    if (builder.getAgg().getCount() > aggregate.getAgg().getCount() || builder.getAgg().getType() == Monitoring.MessageType.ERROR) {
                        builder.setDiff(value);
                    } else {
                        builder.setDiff(MonitoringMessageUtil.baseMonitoringMessage());
                    }
                }
                return builder.build();
            }
        }
        log.warn("unrecognized client type");
        return builder.build();
    }
}

