/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.streams.monitoring;

import io.confluent.monitoring.record.Monitoring;
import org.apache.kafka.streams.kstream.Aggregator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitoringMessageAggregator<K>
implements Aggregator<K, Monitoring.MonitoringMessage, Monitoring.MonitoringMessage> {
    private static final Logger log = LoggerFactory.getLogger(MonitoringMessageAggregator.class);
    private final boolean strip;

    public static <K> MonitoringMessageAggregator<K> stripped() {
        return new MonitoringMessageAggregator<K>(true);
    }

    private MonitoringMessageAggregator(boolean strip) {
        this.strip = strip;
    }

    public MonitoringMessageAggregator() {
        this(false);
    }

    public Monitoring.MonitoringMessage apply(K aggKey, Monitoring.MonitoringMessage value, Monitoring.MonitoringMessage aggregate) {
        if (value == null) {
            log.warn("action=apply value=null aggKey={}", aggKey);
            return aggregate;
        }
        if (aggregate == null) {
            log.warn("action=apply aggregate=null aggKey={}", aggKey);
            return aggregate;
        }
        return this.aggregate(value, aggregate);
    }

    public Monitoring.MonitoringMessage aggregate(Monitoring.MonitoringMessage value, Monitoring.MonitoringMessage aggregate) {
        Monitoring.MonitoringMessage.Builder builder = Monitoring.MonitoringMessage.newBuilder((Monitoring.MonitoringMessage)aggregate).setCount(aggregate.getCount() + value.getCount()).setAggregateBytes(aggregate.getAggregateBytes() + value.getAggregateBytes()).setAggregateCrc(aggregate.getAggregateCrc() ^ value.getAggregateCrc()).setTotalLatency(aggregate.getTotalLatency() + value.getTotalLatency()).setMinLatency(Math.min(aggregate.getMinLatency(), value.getMinLatency())).setMaxLatency(Math.max(aggregate.getMaxLatency(), value.getMaxLatency())).setType(value.getType() == Monitoring.MessageType.ERROR || aggregate.getType() == Monitoring.MessageType.ERROR ? Monitoring.MessageType.ERROR : Monitoring.MessageType.NORMAL).setClientType(value.getClientType()).setSequence(Math.max(aggregate.getSequence(), value.getSequence()) + 1L).setWindow(Math.max(value.getWindow(), aggregate.getWindow())).setArrivalTime(Math.max(aggregate.getArrivalTime(), value.getArrivalTime())).setPartition(value.getPartition()).setClientId(value.getClientId()).setTopic(value.getTopic()).setGroup(value.getGroup()).setSession(value.getSession());
        if (this.strip) {
            builder = builder.clearPartition().clearClientId().clearTopic().clearSession();
        }
        return builder.build();
    }
}

