/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.tools;

import com.google.common.base.Charsets;
import io.confluent.controlcenter.ControlCenterConfig;
import io.confluent.controlcenter.KafkaHelper;
import io.confluent.controlcenter.serialization.formatter.CsvUberFormatter;
import io.confluent.controlcenter.serialization.formatter.JsonUberFormatter;
import io.confluent.controlcenter.serialization.formatter.UberFormatter;
import io.confluent.controlcenter.util.ConfigUtils;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.utils.Utils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataExporter {
    private static final String GROUP_ID = "control-center-export-cg";
    private static final String CLIENT_ID = "control-center-export-client";
    private static final long PROGRESS_UPDATE_MS = 5000L;
    private static final String JSON_FORMAT = "json";
    private static final String CSV_FORMAT = "csv";
    private static final Logger log = LoggerFactory.getLogger(DataExporter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        String format;
        CommandLine cmd;
        Options options = new Options().addOption(Option.builder((String)"topic").hasArg().required().longOpt("topic").desc("Topic to consume").build()).addOption(Option.builder((String)"from").hasArg().longOpt("from").type(Number.class).desc("Start consuming from this timestamp").build()).addOption(Option.builder((String)"to").hasArg().longOpt("to").type(Number.class).desc("Consume until this timestamp").build()).addOption(Option.builder((String)"outfile").hasArg().required().longOpt("outfile").desc("File to dump output").build()).addOption(Option.builder((String)"prop").argName("property=value").hasArgs().valueSeparator().numberOfArgs(2).longOpt("property").desc("Properties to initialize the message formatter. Properties include:\n" + "  | allow.errors=true (default) | false\n" + "  | print.topic=true (default) | false\n" + "  | print.partition=true (default) | false\n" + "  | print.timestamp=true (default) | false\n" + "  | print.key=true (default) | false\n").build()).addOption(Option.builder((String)"format").hasArg().longOpt("format").desc("Format to export messages. json (default) | csv").build());
        Options completeOptions = new Options();
        options.getOptions().forEach(arg_0 -> ((Options)completeOptions).addOption(arg_0));
        completeOptions.addOption(Option.builder((String)"config").hasArg().longOpt("config").required().desc("Control center properties file").build());
        try {
            cmd = new DefaultParser().parse(completeOptions, args);
            format = cmd.getOptionValue("format", JSON_FORMAT);
            if (!format.equals(CSV_FORMAT) && !format.equals(JSON_FORMAT)) {
                throw new ParseException("-format currently supports csv or json, with json as default.");
            }
        }
        catch (ParseException e) {
            HelpFormatter formatter = new HelpFormatter();
            System.out.println(e.getMessage());
            formatter.printHelp("control-center-export props_file", "", options, "", true);
            return;
        }
        Properties config = new Properties();
        config.put("bootstrap.servers", "localhost:9092");
        config.putAll((Map<?, ?>)ConfigUtils.getPropsFromFile(cmd.getOptionValue("config")));
        config.put("group.id", GROUP_ID);
        config.put("client.id", CLIENT_ID);
        config.put("enable.auto.commit", "false");
        config.put("auto.offset.reset", "earliest");
        long fromTs = cmd.hasOption("from") ? (Long)cmd.getParsedOptionValue("from") : 0L;
        long toTs = cmd.hasOption("to") ? (Long)cmd.getParsedOptionValue("to") : Long.MAX_VALUE;
        String topic = cmd.getOptionValue("topic");
        String outfile = cmd.getOptionValue("outfile");
        UberFormatter formatter = format.equals(JSON_FORMAT) ? new JsonUberFormatter(DataExporter.getControlCenterConfig(cmd), topic) : new CsvUberFormatter(DataExporter.getControlCenterConfig(cmd), topic);
        formatter.configure(Utils.propsToMap((Properties)cmd.getOptionProperties("property")));
        PrintStream ps = new PrintStream(outfile, Charsets.UTF_8.name());
        if (formatter instanceof CsvUberFormatter) {
            ((CsvUberFormatter)formatter).setPrinter(ps, true);
        }
        long lastTimestamp = -1L;
        long consumedCount = 0L;
        try (KafkaConsumer consumer = new KafkaConsumer(config, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());){
            Set<TopicPartition> allPartitions = KafkaHelper.partitionsForTopic(consumer, topic);
            Map<TopicPartition, OffsetAndMetadata> newOffsets = DataExporter.offsetsForTimestamp(consumer, allPartitions, fromTs);
            if (newOffsets.size() > 0) {
                log.debug("seeking to new offsets");
                consumer.commitSync(newOffsets);
            }
            long lastStatusUpdate = 0L;
            while (true) {
                ConsumerRecords records = consumer.poll(1000L);
                log.debug("polled {} records", (Object)records.count());
                if (records.isEmpty()) {
                    break;
                }
                for (ConsumerRecord record : records) {
                    if (record.timestamp() < fromTs || record.timestamp() > toTs) continue;
                    formatter.writeTo(record, ps);
                    lastTimestamp = record.timestamp();
                    ++consumedCount;
                }
                consumer.commitSync();
                long now = System.currentTimeMillis();
                if (now - lastStatusUpdate <= 5000L) continue;
                lastStatusUpdate = now;
                log.info("exported {} records so far, last exported record time={}", (Object)consumedCount, (Object)new DateTime(lastTimestamp).toString());
            }
        }
        catch (Exception e) {
            try {
                log.error("failed exporting from topic={} after {} records and last_timestamp={}", new Object[]{topic, consumedCount, lastTimestamp, e});
            }
            catch (Throwable throwable) {
                log.info("exported a total of {} records, last_timestamp={}, output_file={}", new Object[]{consumedCount, lastTimestamp, outfile});
                log.info("shutting down");
                throw throwable;
            }
            log.info("exported a total of {} records, last_timestamp={}, output_file={}", new Object[]{consumedCount, lastTimestamp, outfile});
            log.info("shutting down");
        }
        log.info("exported a total of {} records, last_timestamp={}, output_file={}", new Object[]{consumedCount, lastTimestamp, outfile});
        log.info("shutting down");
    }

    private static ControlCenterConfig getControlCenterConfig(CommandLine cmd) {
        Properties propsFromFile = ConfigUtils.getPropsFromFile(cmd.getOptionValue("config"));
        propsFromFile.setProperty("confluent.controlcenter.mode.enable", "all");
        return new ControlCenterConfig(propsFromFile);
    }

    protected static <K, V> Map<TopicPartition, OffsetAndMetadata> offsetsForTimestamp(KafkaConsumer<K, V> consumer, Set<TopicPartition> topicPartitions, long timestamp) {
        HashMap<TopicPartition, OffsetAndMetadata> newOffsets = new HashMap<TopicPartition, OffsetAndMetadata>();
        if (topicPartitions == null || topicPartitions.isEmpty()) {
            return newOffsets;
        }
        consumer.assign(topicPartitions);
        HashMap<TopicPartition, Long> timestampsToSearch = new HashMap<TopicPartition, Long>();
        for (TopicPartition tp : topicPartitions) {
            timestampsToSearch.put(tp, timestamp);
        }
        Map offsetsAndTimestamps = consumer.offsetsForTimes(timestampsToSearch);
        for (TopicPartition tp : topicPartitions) {
            if (!offsetsAndTimestamps.containsKey(tp) || offsetsAndTimestamps.get(tp) == null) continue;
            long newOffset = ((OffsetAndTimestamp)offsetsAndTimestamps.get(tp)).offset();
            newOffsets.put(tp, new OffsetAndMetadata(newOffset));
            log.debug("new offset for tp={} offset={}", (Object)tp, (Object)newOffset);
        }
        return newOffsets;
    }
}

