/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.util;

import com.google.common.collect.ImmutableList;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import io.confluent.controlcenter.ControlCenterConfig;
import io.confluent.controlcenter.ControlCenterConfigModule;
import io.confluent.controlcenter.ControlCenterModule;
import io.confluent.controlcenter.alert.SenderModule;
import io.confluent.controlcenter.command.CommandModule;
import io.confluent.controlcenter.data.ConsumerOffsetsModule;
import io.confluent.controlcenter.healthcheck.HealthCheckModule;
import io.confluent.controlcenter.kafka.ClusterManagementModule;
import io.confluent.controlcenter.license.LicenseModule;
import io.confluent.controlcenter.rest.ControlCenterRestModule;
import io.confluent.controlcenter.rest.RestModule;
import io.confluent.controlcenter.rollup.RollupFactory;
import io.confluent.controlcenter.serialization.SerializationModule;
import io.confluent.controlcenter.servicehealthcheck.ServiceHealthCheckModule;
import io.confluent.controlcenter.streams.StreamsConfigModule;
import io.confluent.controlcenter.streams.StreamsModule;
import io.confluent.controlcenter.streams.TopicStoreModule;
import io.confluent.controlcenter.telemetry.TelemetryModule;
import java.util.List;

public class InjectorFactory {
    private static final List<Module> minimumCommonModules = ImmutableList.of((Object)((Object)new ControlCenterModule()), (Object)((Object)new CommandModule()), (Object)new SerializationModule());
    private static final List<Module> minimumMonitoringModules = ImmutableList.of((Object)((Object)new StreamsConfigModule()), (Object)((Object)new TopicStoreModule()));
    private static final List<Module> fullCommonModules = ImmutableList.builder().addAll(minimumCommonModules).addAll((Iterable)ImmutableList.of((Object)((Object)new TelemetryModule()), (Object)((Object)new HealthCheckModule()), (Object)((Object)new ServiceHealthCheckModule()), (Object)((Object)new ConsumerOffsetsModule()), (Object)((Object)new ClusterManagementModule()), (Object)new RestModule(), (Object)new ControlCenterRestModule(), (Object)new LicenseModule(), (Object)((Object)new SenderModule()))).build();
    private static final List<Module> fullMonitoringModules = ImmutableList.builder().addAll(minimumMonitoringModules).add((Object)new StreamsModule()).build();

    public static Injector createInjectorForApplication(ControlCenterConfig config, ControlCenterConfigModule controlCenterConfigModule) {
        InjectorFactory.initRollups(config);
        return InjectorFactory.createInjectorHelper(true, config, controlCenterConfigModule, (List<Module>)ImmutableList.of());
    }

    public static Injector createInjectorForScripts(ControlCenterConfig config) {
        InjectorFactory.initRollups(config);
        return InjectorFactory.createInjectorHelper(false, config, new ControlCenterConfigModule(config), (List<Module>)ImmutableList.of());
    }

    private static void initRollups(ControlCenterConfig config) {
        RollupFactory.initRollups(config.getLong("confluent.controlcenter.one.minute.rollup.topics.retention.ms"), config.getLong("confluent.controlcenter.three.hour.rollup.topics.retention.ms"));
    }

    static Injector createInjectorHelper(boolean full, ControlCenterConfig config, ControlCenterConfigModule controlCenterConfigModule, List<Module> overrideModules) {
        ImmutableList.Builder builder = ImmutableList.builder().add((Object)controlCenterConfigModule).addAll(full ? fullCommonModules : minimumCommonModules);
        if (config.getString("confluent.controlcenter.mode.enable").equals("all")) {
            builder.addAll(full ? fullMonitoringModules : minimumMonitoringModules);
        }
        return Guice.createInjector((Module[])new Module[]{Modules.override((Iterable)builder.build()).with(overrideModules)});
    }
}

