/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.util;

import io.confluent.command.kafka.FilteredKeyValueIterator;
import io.confluent.serializers.OrderedBytes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.kstream.Predicate;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.ReadOnlyKeyValueStore;

public class KvQuery {
    public static final Bytes LAST_KEY = Bytes.wrap((byte[])new byte[]{-1});
    public static final Bytes FIRST_KEY = Bytes.wrap((byte[])new byte[0]);

    public static <T> KeyValueIterator<Bytes, T> rangeFrom(ReadOnlyKeyValueStore<Bytes, T> store, Bytes from) {
        if (from == null) {
            return store.all();
        }
        return store.range((Object)from, (Object)LAST_KEY);
    }

    public static <T> KeyValueIterator<Bytes, T> rangeTo(ReadOnlyKeyValueStore<Bytes, T> store, Bytes to) {
        if (to == null) {
            return store.all();
        }
        return store.range((Object)FIRST_KEY, (Object)to);
    }

    public static <T> KeyValueIterator<Bytes, T> prefixScan(ReadOnlyKeyValueStore<Bytes, T> store, Bytes prefix) {
        return KvQuery.prefixIterator(store.range((Object)prefix, (Object)LAST_KEY), prefix);
    }

    public static <T> KeyValueIterator<Bytes, T> prefixScan(ReadOnlyKeyValueStore<Bytes, T> store, Bytes prefix, Bytes start) {
        return KvQuery.prefixIterator(store.range((Object)start, (Object)LAST_KEY), prefix);
    }

    public static <T> KeyValueIterator<Bytes, T> prefixIterator(KeyValueIterator<Bytes, T> keyValueIterator, Bytes prefix) {
        return new FilteredKeyValueIterator(keyValueIterator, new PrefixPredicate(prefix));
    }

    public static class PrefixPredicate<T>
    implements Predicate<Bytes, T> {
        private final Bytes prefix;

        public PrefixPredicate(Bytes prefix) {
            this.prefix = prefix;
        }

        public boolean test(Bytes bytes, T t) {
            return OrderedBytes.startsWith((byte[])bytes.get(), (byte[])this.prefix.get());
        }
    }
}

