/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.util;

import io.confluent.security.authorizer.Scope;

public class ScopeUtils {
    public static final String KAFKA_CLUSTER = "kafka-cluster";
    public static final String CONNECT_CLUSTER = "connect-cluster";
    public static final String SR_CLUSTER = "schema-registry-cluster";
    public static final String KSQL_CLUSTER = "ksql-cluster";

    public static Scope buildKafkaScope(String kafkaClusterId) {
        return new Scope.Builder(new String[0]).withKafkaCluster(kafkaClusterId).build();
    }

    public static Scope buildConnectScope(String kafkaClusterId, String connectClusterId) {
        return new Scope.Builder(new String[0]).withKafkaCluster(kafkaClusterId).withCluster(CONNECT_CLUSTER, connectClusterId).build();
    }

    public static Scope buildSchemaRegistryScope(String kafkaClusterId, String srClusterId) {
        return new Scope.Builder(new String[0]).withKafkaCluster(kafkaClusterId).withCluster(SR_CLUSTER, srClusterId).build();
    }

    public static Scope buildKsqlScope(String kafkaClusterId, String ksqlClusterId) {
        return new Scope.Builder(new String[0]).withKafkaCluster(kafkaClusterId).withCluster(KSQL_CLUSTER, ksqlClusterId).build();
    }
}

