/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.util;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import javax.inject.Singleton;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class StreamProgressReporter
implements MetricsReporter {
    private static final Logger log = LoggerFactory.getLogger(StreamProgressReporter.class);
    private Map<String, KafkaMetric> monitoringInputProgress = Maps.newConcurrentMap();
    private Map<String, KafkaMetric> monitoringInputRate = Maps.newConcurrentMap();
    private Map<String, KafkaMetric> metricsInputProgress = Maps.newConcurrentMap();
    private Map<String, KafkaMetric> metricsInputRate = Maps.newConcurrentMap();

    public void configure(Map<String, ?> map) {
    }

    public void init(List<KafkaMetric> metrics) {
        for (KafkaMetric metric : metrics) {
            this.metricChange(metric);
        }
    }

    public void metricChange(KafkaMetric kafkaMetric) {
        String cluster = (String)kafkaMetric.metricName().tags().get("cluster");
        String inputType = (String)kafkaMetric.metricName().tags().get("input");
        String progressType = (String)kafkaMetric.metricName().tags().get("progress");
        String name = kafkaMetric.metricName().name();
        if (inputType != null && cluster != null) {
            log.info("name={} type={} cluster={} value={}", new Object[]{name, inputType, cluster, kafkaMetric.metricValue()});
            if ("monitoring".equals(inputType)) {
                if ("input-topic".equals(progressType)) {
                    if (name.endsWith(".timestamp")) {
                        this.monitoringInputProgress.put(cluster, kafkaMetric);
                    } else if (name.endsWith(".rate")) {
                        this.monitoringInputRate.put(cluster, kafkaMetric);
                    }
                }
            } else if ("metrics".equals(inputType) && "input-topic".equals(progressType)) {
                if (name.endsWith(".timestamp")) {
                    this.metricsInputProgress.put(cluster, kafkaMetric);
                } else if (name.endsWith(".rate")) {
                    this.metricsInputRate.put(cluster, kafkaMetric);
                }
            }
        }
    }

    public void metricRemoval(KafkaMetric kafkaMetric) {
    }

    public void close() {
    }

    public double getMonitoringInputProgress(String cluster) {
        return StreamProgressReporter.getDouble(this.monitoringInputProgress, cluster);
    }

    public double getMonitoringInputProgress() {
        return StreamProgressReporter.getInputProgress(this.monitoringInputProgress);
    }

    public double getMonitoringInputProgressRate(String cluster) {
        return StreamProgressReporter.getDouble(this.monitoringInputRate, cluster);
    }

    public double getMonitoringInputProgressRate() {
        return StreamProgressReporter.getInputRate(this.monitoringInputRate);
    }

    public double getMetricsInputProgress(String cluster) {
        return StreamProgressReporter.getDouble(this.metricsInputProgress, cluster);
    }

    public double getMetricsInputProgress() {
        return StreamProgressReporter.getInputProgress(this.metricsInputProgress);
    }

    public double getMetricsInputProgressRate(String cluster) {
        return StreamProgressReporter.getDouble(this.metricsInputRate, cluster);
    }

    public double getMetricsInputProgressRate() {
        return StreamProgressReporter.getInputRate(this.metricsInputRate);
    }

    private static double getInputProgress(Map<String, KafkaMetric> progress) {
        double out = Double.MAX_VALUE;
        for (KafkaMetric metric : progress.values()) {
            if (metric == null) continue;
            out = Math.min(out, (Double)metric.metricValue());
        }
        return out;
    }

    private static double getInputRate(Map<String, KafkaMetric> rate) {
        double out = 0.0;
        for (KafkaMetric metric : rate.values()) {
            if (metric == null) continue;
            out += ((Double)metric.metricValue()).doubleValue();
        }
        return out;
    }

    private static double getDouble(Map<String, KafkaMetric> map, String key) {
        KafkaMetric metric = map.get(key);
        if (metric != null) {
            return (Double)metric.metricValue();
        }
        return -1.0;
    }
}

