/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.util;

import java.net.URI;
import java.net.URISyntaxException;

public class UriUtils {
    public static URI uriWithDefaultScheme(String uriString, String defaultScheme) throws URISyntaxException {
        boolean prependScheme;
        URI uri = null;
        URISyntaxException originalException = null;
        try {
            uri = new URI(uriString);
            prependScheme = uri.isOpaque() || !uri.isAbsolute();
        }
        catch (URISyntaxException e) {
            originalException = e;
            prependScheme = true;
        }
        if (prependScheme) {
            try {
                return new URI(defaultScheme + "://" + uriString);
            }
            catch (URISyntaxException e) {
                if (originalException != null) {
                    throw originalException;
                }
                throw e;
            }
        }
        return uri;
    }
}

