/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.util.versions;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Singleton;
import io.confluent.controlcenter.util.versions.BrokerVersion;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Singleton
public class KafkaVersionTracker {
    private final ConcurrentHashMap<String, ConcurrentHashMap<Integer, BrokerVersion>> clusters = new ConcurrentHashMap();

    public void register(String clusterId, Integer brokerId, BrokerVersion brokerVersion) {
        ConcurrentHashMap cluster = this.clusters.computeIfAbsent(clusterId, k -> new ConcurrentHashMap());
        cluster.put(brokerId, brokerVersion);
    }

    public Collection<String> clusters() {
        return this.clusters.keySet();
    }

    public Integer brokerCountForCluster(String clusterId) {
        return this.clusters.get(clusterId).size();
    }

    public ImmutableMap<String, Integer> versionCountsForCluster(String clusterId) {
        ConcurrentHashMap<Integer, BrokerVersion> brokerVersions = this.clusters.get(clusterId);
        HashMap<String, Integer> versionCount = new HashMap<String, Integer>();
        for (Map.Entry<Integer, BrokerVersion> entry : brokerVersions.entrySet()) {
            Integer count = versionCount.getOrDefault(entry.getValue().getVersion(), 0);
            versionCount.put(entry.getValue().getVersion(), count + 1);
            count = versionCount.getOrDefault(entry.getValue().getCommitId(), 0);
            versionCount.put(entry.getValue().getCommitId(), count + 1);
        }
        return ImmutableMap.copyOf(versionCount);
    }
}

