/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.secretregistry.masterelector.kafka;

import java.util.Map;
import org.apache.kafka.clients.CommonClientConfigs;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;

class ClientConfig
extends AbstractConfig {
    private static final ConfigDef CONFIG = new ConfigDef().define("metadata.max.age.ms", ConfigDef.Type.LONG, (Object)300000L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.LOW, "The period of time in milliseconds after which we force a refresh of metadata even if we haven't seen any partition leadership changes to proactively discover any new brokers or partitions.").define("send.buffer.bytes", ConfigDef.Type.INT, (Object)131072, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)-1), ConfigDef.Importance.MEDIUM, "The size of the TCP send buffer (SO_SNDBUF) to use when sending data. If the value is -1, the OS default will be used.").define("receive.buffer.bytes", ConfigDef.Type.INT, (Object)65536, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)-1), ConfigDef.Importance.MEDIUM, "The size of the TCP receive buffer (SO_RCVBUF) to use when reading data. If the value is -1, the OS default will be used.").define("reconnect.backoff.ms", ConfigDef.Type.LONG, (Object)50L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0L), ConfigDef.Importance.LOW, "The base amount of time to wait before attempting to reconnect to a given host. This avoids repeatedly connecting to a host in a tight loop. This backoff applies to all connection attempts by the client to a broker.").define("reconnect.backoff.max.ms", ConfigDef.Type.LONG, (Object)1000L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0L), ConfigDef.Importance.LOW, "The maximum amount of time in milliseconds to wait when reconnecting to a broker that has repeatedly failed to connect. If provided, the backoff per host will increase exponentially for each consecutive connection failure, up to this maximum. After calculating the backoff increase, 20% random jitter is added to avoid connection storms.").define("retry.backoff.ms", ConfigDef.Type.LONG, (Object)100L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0L), ConfigDef.Importance.LOW, "The amount of time to wait before attempting to retry a failed request to a given topic partition. This avoids repeatedly sending requests in a tight loop under some failure scenarios.").define("request.timeout.ms", ConfigDef.Type.INT, (Object)305000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, "The configuration controls the maximum amount of time the client will wait for the response of a request. If the response is not received before the timeout elapses the client will resend the request if necessary or fail the request if retries are exhausted.").define("connections.max.idle.ms", ConfigDef.Type.LONG, (Object)540000L, ConfigDef.Importance.MEDIUM, "Close idle connections after the number of milliseconds specified by this config.").define("security.protocol", ConfigDef.Type.STRING, (Object)"PLAINTEXT", ConfigDef.Importance.MEDIUM, CommonClientConfigs.SECURITY_PROTOCOL_DOC).withClientSslSupport().withClientSaslSupport();
    public static final long METADATA_MAX_AGE_DEFAULT = 300000L;
    public static final int SEND_BUFFER_DEFAULT = 131072;
    public static final int RECEIVE_BUFFER_DEFAULT = 65536;
    public static final long RECONNECT_BACKOFF_MS_DEFAULT = 50L;
    public static final long RECONNECT_BACKOFF_MAX_MS_DEFAULT = 1000L;
    public static final long RETRY_BACKOFF_MS_DEFAULT = 100L;
    public static final int REQUEST_TIMEOUT_MS_DEFAULT = 305000;
    public static final long CONNECTIONS_MAX_IDLE_MS_DEFAULT = 540000L;

    ClientConfig(Map<String, ?> props) {
        super(CONFIG, props);
    }

    ClientConfig(Map<String, ?> props, boolean doLog) {
        super(CONFIG, props, doLog);
    }
}

