/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.secretregistry.storage;

import io.confluent.kafka.secretregistry.client.rest.RestService;
import io.confluent.kafka.secretregistry.client.rest.entities.Secret;
import io.confluent.kafka.secretregistry.client.rest.entities.requests.RegisterSecretRequest;
import io.confluent.kafka.secretregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.secretregistry.client.rest.utils.UrlList;
import io.confluent.kafka.secretregistry.crypto.SecretTransformer;
import io.confluent.kafka.secretregistry.exceptions.IdGenerationException;
import io.confluent.kafka.secretregistry.exceptions.SecretRegistryException;
import io.confluent.kafka.secretregistry.exceptions.SecretRegistryInitializationException;
import io.confluent.kafka.secretregistry.exceptions.SecretRegistryRequestForwardingException;
import io.confluent.kafka.secretregistry.exceptions.SecretRegistryStoreException;
import io.confluent.kafka.secretregistry.exceptions.SecretRegistryTimeoutException;
import io.confluent.kafka.secretregistry.exceptions.UnknownMasterException;
import io.confluent.kafka.secretregistry.masterelector.kafka.KafkaGroupMasterElector;
import io.confluent.kafka.secretregistry.rest.SecretRegistryConfig;
import io.confluent.kafka.secretregistry.rest.SslFactory;
import io.confluent.kafka.secretregistry.rest.VersionId;
import io.confluent.kafka.secretregistry.rest.exceptions.Errors;
import io.confluent.kafka.secretregistry.storage.InMemoryCache;
import io.confluent.kafka.secretregistry.storage.KafkaStore;
import io.confluent.kafka.secretregistry.storage.KafkaStoreMessageHandler;
import io.confluent.kafka.secretregistry.storage.LookupCache;
import io.confluent.kafka.secretregistry.storage.MasterAwareSecretRegistry;
import io.confluent.kafka.secretregistry.storage.MasterElector;
import io.confluent.kafka.secretregistry.storage.NoopKey;
import io.confluent.kafka.secretregistry.storage.SecretKey;
import io.confluent.kafka.secretregistry.storage.SecretRegistry;
import io.confluent.kafka.secretregistry.storage.SecretRegistryIdentity;
import io.confluent.kafka.secretregistry.storage.SecretRegistryKey;
import io.confluent.kafka.secretregistry.storage.SecretRegistryValue;
import io.confluent.kafka.secretregistry.storage.SecretValue;
import io.confluent.kafka.secretregistry.storage.UriInfo;
import io.confluent.kafka.secretregistry.storage.exceptions.StoreException;
import io.confluent.kafka.secretregistry.storage.exceptions.StoreInitializationException;
import io.confluent.kafka.secretregistry.storage.exceptions.StoreTimeoutException;
import io.confluent.kafka.secretregistry.storage.serialization.SecretRegistrySerializer;
import io.confluent.kafka.secretregistry.storage.serialization.Serializer;
import io.confluent.rest.Application;
import io.confluent.rest.exceptions.RestException;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Value;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaSecretRegistry
implements SecretRegistry,
MasterAwareSecretRegistry {
    public static final int MIN_VERSION = 1;
    public static final int MAX_VERSION = Integer.MAX_VALUE;
    private static final Logger log = LoggerFactory.getLogger(KafkaSecretRegistry.class);
    private static final Pattern LISTENER_PATTERN = Pattern.compile("^(.*)://\\[?([0-9a-zA-Z\\-%._:]*)\\]?:(-?[0-9]+)");
    private final SecretRegistryConfig config;
    private final LookupCache<SecretRegistryKey, SecretRegistryValue> lookupCache;
    final KafkaStore<SecretRegistryKey, SecretRegistryValue> kafkaStore;
    private final Serializer<SecretRegistryKey, SecretRegistryValue> serializer;
    private final int kafkaStoreTimeoutMs;
    private final int initTimeout;
    private final boolean isEligibleForMasterElector;
    private SecretTransformer secretTransformer;
    private SecretRegistryIdentity myIdentity;
    private final Object masterLock = new Object();
    private SecretRegistryIdentity masterIdentity;
    private RestService masterRestService;
    private SslFactory sslFactory;
    private MasterElector masterElector = null;
    private Metrics metrics;
    private Sensor masterNodeSensor;

    public KafkaSecretRegistry(SecretRegistryConfig config) throws SecretRegistryException {
        if (config == null) {
            throw new SecretRegistryException("Schema registry configuration is null");
        }
        this.config = config;
        this.isEligibleForMasterElector = config.getBoolean("master.eligibility");
        this.kafkaStoreTimeoutMs = config.getInt("kafkastore.timeout.ms");
        this.initTimeout = config.getInt("kafkastore.init.timeout.ms");
        this.serializer = new SecretRegistrySerializer();
        this.lookupCache = this.lookupCache();
        this.kafkaStore = this.kafkaStore(config);
        this.secretTransformer = SecretTransformer.getSecretTransformer(config.masterEncryptionKey());
    }

    protected KafkaStore<SecretRegistryKey, SecretRegistryValue> kafkaStore(SecretRegistryConfig config) throws SecretRegistryException {
        return new KafkaStore<SecretRegistryKey, SecretRegistryValue>(config, KafkaSecretRegistry.groupId(config), new KafkaStoreMessageHandler(this, this.lookupCache), this.serializer, this.lookupCache, new NoopKey());
    }

    protected static String groupId(SecretRegistryConfig config) {
        return config.getString("kafkastore.group.id").isEmpty() ? String.format("secret-registry-%s", config.getString("host.name")) : config.getString("kafkastore.group.id");
    }

    protected LookupCache<SecretRegistryKey, SecretRegistryValue> lookupCache() {
        return new InMemoryCache<SecretRegistryKey, SecretRegistryValue>();
    }

    @Override
    public SecretRegistryConfig config() {
        return this.config;
    }

    @Override
    public void initStore() throws SecretRegistryException {
        try {
            this.kafkaStore.init();
            this.maybeRotateKeys();
        }
        catch (StoreException | StoreInitializationException e) {
            throw new SecretRegistryInitializationException("Error initializing kafka store while initializing secret registry", e);
        }
    }

    private void maybeRotateKeys() throws StoreException {
        String oldKey = this.config.masterEncryptionOldKey();
        if (oldKey != null) {
            log.info("Rotating master key");
            SecretTransformer oldTransformer = SecretTransformer.getSecretTransformer(oldKey);
            Iterator<SecretRegistryKey> allKeys = this.kafkaStore.getAllKeys();
            try {
                while (allKeys.hasNext()) {
                    SecretRegistryKey secretKey = allKeys.next();
                    SecretRegistryValue secretValue = this.kafkaStore.get(secretKey);
                    if (!(secretValue instanceof SecretValue)) continue;
                    Secret secret = oldTransformer.transform((SecretValue)secretValue);
                    SecretValue newSecretValue = this.secretTransformer.transform(secret);
                    this.kafkaStore.put(secretKey, newSecretValue);
                }
            }
            catch (Exception e) {
                log.info("Could not rotate, ignoring old master key");
            }
            log.info("Done rotating master key");
        }
    }

    public static UriInfo getUriInfoForIdentity(String host, Integer port, List<String> configuredListeners, String requestedScheme, boolean useAdvertisedEndpoints) throws SecretRegistryException {
        if (useAdvertisedEndpoints && host != null && port != null) {
            return new UriInfo(requestedScheme, host, port);
        }
        return KafkaSecretRegistry.getUriInfoForIdentity(host, port, configuredListeners, requestedScheme);
    }

    public static UriInfo getUriInfoForIdentity(String host, Integer port, List<String> configuredListeners, String requestedScheme) throws SecretRegistryException {
        try {
            if (host == null) {
                InetAddress localhost = InetAddress.getLocalHost();
                host = localhost.getHostAddress();
            }
            if (port == null) {
                port = 8081;
            }
            if (configuredListeners == null) {
                return new UriInfo(requestedScheme, host, port);
            }
            List<UriInfo> listeners = KafkaSecretRegistry.parseListeners(configuredListeners, host, port, Arrays.asList("http", "https"), "http");
            for (UriInfo listener : listeners) {
                if (!requestedScheme.equalsIgnoreCase(listener.scheme())) continue;
                return listener;
            }
        }
        catch (Exception e) {
            throw new SecretRegistryException("Could not obtain URI info", e);
        }
        throw new SecretRegistryException("No listener configured with requested scheme " + requestedScheme);
    }

    public static List<UriInfo> parseListeners(List<String> listenersConfig, String host, Integer deprecatedPort, List<String> supportedSchemes, String defaultScheme) {
        if (listenersConfig.isEmpty() || listenersConfig.get(0).isEmpty()) {
            log.warn("DEPRECATION warning: `listeners` configuration is not configured. Falling back to the deprecated `port` configuration.");
            listenersConfig = new ArrayList<String>(1);
            listenersConfig.add(defaultScheme + "://" + host + ":" + deprecatedPort);
        }
        ArrayList<UriInfo> listeners = new ArrayList<UriInfo>(listenersConfig.size());
        for (String listenerStr : listenersConfig) {
            Matcher listenerMatcher = LISTENER_PATTERN.matcher(listenerStr);
            if (!listenerMatcher.matches()) {
                throw new ConfigException("Listener doesn't have the right format (protocol://hostname:port).");
            }
            String protocol = listenerMatcher.group(1).toLowerCase(Locale.ENGLISH);
            String hostname = listenerMatcher.group(2);
            if (hostname == null || hostname.isEmpty() || hostname.equals("0.0.0.0")) {
                hostname = host;
            }
            int port = Integer.parseInt(listenerMatcher.group(3));
            if (!supportedSchemes.contains(protocol)) {
                log.warn("Found a listener with an unsupported scheme (supported: {}). Ignoring listener '{}'", supportedSchemes, (Object)listenerStr);
                continue;
            }
            listeners.add(new UriInfo(protocol, hostname, port));
        }
        if (listeners.isEmpty()) {
            throw new ConfigException("No listeners are configured. Must have at least one listener.");
        }
        return listeners;
    }

    @Override
    public void initRest(SslFactory sslFactory, UriInfo uriInfo) throws SecretRegistryException {
        try {
            log.info("Initializing REST with URI {}", (Object)uriInfo);
            this.sslFactory = sslFactory;
            this.myIdentity = new SecretRegistryIdentity(uriInfo.host(), uriInfo.port(), this.isEligibleForMasterElector, uriInfo.scheme());
            MetricConfig metricConfig = new MetricConfig().samples(this.config.getInt("metrics.num.samples").intValue()).timeWindow(this.config.getLong("metrics.sample.window.ms").longValue(), TimeUnit.MILLISECONDS);
            List reporters = this.config.getConfiguredInstances("metric.reporters", MetricsReporter.class);
            String jmxPrefix = "kafka.secret.registry";
            reporters.add(new JmxReporter(jmxPrefix));
            this.metrics = new Metrics(metricConfig, reporters, Time.SYSTEM);
            this.masterNodeSensor = this.metrics.sensor("master-slave-role");
            Map configuredTags = Application.parseListToMap((List)this.config.getList("metrics.tag.map"));
            MetricName m = new MetricName("master-slave-role", "master-slave-role", "1.0 indicates the node is the active master in the cluster and is the node where all register secret requests are served.", configuredTags);
            this.masterNodeSensor.add(m, (MeasurableStat)new Value());
            log.info("Joining secret registry with Kafka-based coordination");
            this.masterElector = new KafkaGroupMasterElector(this.config, this.myIdentity, this);
            this.masterElector.init();
        }
        catch (SecretRegistryStoreException e) {
            throw new SecretRegistryInitializationException("Error electing master while initializing secret registry", e);
        }
        catch (SecretRegistryTimeoutException e) {
            throw new SecretRegistryInitializationException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMaster() {
        Object object = this.masterLock;
        synchronized (object) {
            return this.masterIdentity != null && this.masterIdentity.equals(this.myIdentity);
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaster(SecretRegistryIdentity newMaster) throws SecretRegistryTimeoutException, SecretRegistryStoreException, IdGenerationException {
        log.debug("Setting the master to " + newMaster);
        if (newMaster != null && !newMaster.getMasterEligibility()) {
            throw new IllegalStateException("Tried to set an ineligible node to master: " + newMaster);
        }
        Object object = this.masterLock;
        synchronized (object) {
            SecretRegistryIdentity previousMaster = this.masterIdentity;
            this.masterIdentity = newMaster;
            if (this.masterIdentity == null) {
                this.masterRestService = null;
            } else {
                this.masterRestService = new RestService(this.masterIdentity.getUrl());
                if (this.sslFactory != null && this.sslFactory.sslContext() != null) {
                    this.masterRestService.setSslSocketFactory(this.sslFactory.sslContext().getSocketFactory());
                }
            }
            if (this.masterIdentity != null && !this.masterIdentity.equals(previousMaster) && this.isMaster()) {
                this.kafkaStore.markLastWrittenOffsetInvalid();
                try {
                    this.kafkaStore.waitUntilKafkaReaderReachesLastOffset(this.initTimeout);
                }
                catch (StoreException e) {
                    throw new SecretRegistryStoreException("Exception getting latest offset ", e);
                }
            }
            this.masterNodeSensor.record(this.isMaster() ? 1.0 : 0.0);
        }
    }

    public SecretRegistryIdentity myIdentity() {
        return this.myIdentity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecretRegistryIdentity masterIdentity() {
        Object object = this.masterLock;
        synchronized (object) {
            return this.masterIdentity;
        }
    }

    @Override
    public int register(Secret secret) throws SecretRegistryException {
        log.info("Registering secret '{}:{}'", (Object)secret.getPath(), (Object)secret.getKey());
        try {
            this.kafkaStore.waitUntilKafkaReaderReachesLastOffset(this.kafkaStoreTimeoutMs);
            Iterator<Secret> allVersions = this.getAllVersions(secret.getPath(), secret.getKey()).iterator();
            int newVersion = 1;
            while (allVersions.hasNext()) {
                newVersion = allVersions.next().getVersion() + 1;
            }
            secret.setVersion(Integer.valueOf(newVersion));
            SecretValue secretValue = this.secretTransformer.transform(secret);
            this.kafkaStore.put(new SecretKey(secret.getPath(), secret.getKey(), secret.getVersion()), secretValue);
            return newVersion;
        }
        catch (StoreTimeoutException te) {
            throw new SecretRegistryTimeoutException("Write to the Kafka store timed out while", te);
        }
        catch (StoreException e) {
            throw new SecretRegistryStoreException("Error while registering the secret in the backend Kafka store", e);
        }
    }

    public int registerOrForward(Secret secret, Map<String, String> headerProperties) throws SecretRegistryException {
        Object object = this.masterLock;
        synchronized (object) {
            if (this.isMaster()) {
                return this.register(secret);
            }
            if (this.masterIdentity != null) {
                return this.forwardRegisterRequestToMaster(secret, headerProperties);
            }
            throw new UnknownMasterException("Register secret request failed since master is unknown");
        }
    }

    @Override
    public void deleteVersion(String path, String key, int version) throws SecretRegistryException {
        log.info("Deleting secret '{}:{}' version {}", new Object[]{path, key, version});
        try {
            this.kafkaStore.waitUntilKafkaReaderReachesLastOffset(this.kafkaStoreTimeoutMs);
            this.kafkaStore.delete(new SecretKey(path, key, version));
        }
        catch (StoreTimeoutException te) {
            throw new SecretRegistryTimeoutException("Write to the Kafka store timed out while", te);
        }
        catch (StoreException e) {
            throw new SecretRegistryStoreException("Error while deleting the secret in the backend Kafka store", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteVersionOrForward(Map<String, String> headerProperties, String path, String key, int version) throws SecretRegistryException {
        Object object = this.masterLock;
        synchronized (object) {
            if (this.isMaster()) {
                this.deleteVersion(path, key, version);
            } else if (this.masterIdentity != null) {
                this.forwardDeleteVersionRequestToMaster(headerProperties, path, key, version);
            } else {
                throw new UnknownMasterException("Register secret request failed since master is unknown");
            }
        }
    }

    @Override
    public List<Integer> deleteKey(String path, String key) throws SecretRegistryException {
        log.info("Deleting key '{}:{}'", (Object)path, (Object)key);
        try {
            ArrayList<Integer> versions = new ArrayList<Integer>();
            this.kafkaStore.waitUntilKafkaReaderReachesLastOffset(this.kafkaStoreTimeoutMs);
            List<Secret> secrets = this.getAllVersions(path, key);
            for (Secret secret : secrets) {
                this.deleteVersion(secret.getPath(), secret.getKey(), secret.getVersion());
                versions.add(secret.getVersion());
            }
            return versions;
        }
        catch (StoreTimeoutException te) {
            throw new SecretRegistryTimeoutException("Write to the Kafka store timed out while", te);
        }
        catch (StoreException e) {
            throw new SecretRegistryStoreException("Error while deleting the key in the backend Kafka store", e);
        }
    }

    public List<Integer> deleteKeyOrForward(Map<String, String> requestProperties, String path, String key) throws SecretRegistryException {
        Object object = this.masterLock;
        synchronized (object) {
            if (this.isMaster()) {
                return this.deleteKey(path, key);
            }
            if (this.masterIdentity != null) {
                return this.forwardDeleteKeyRequestToMaster(requestProperties, path, key);
            }
            throw new UnknownMasterException("Register secret request failed since master is unknown");
        }
    }

    @Override
    public Set<String> deletePath(String path) throws SecretRegistryException {
        log.info("Deleting path '{}'", (Object)path);
        try {
            HashSet<String> keys = new HashSet<String>();
            this.kafkaStore.waitUntilKafkaReaderReachesLastOffset(this.kafkaStoreTimeoutMs);
            SecretKey key1 = new SecretKey(path, "__min_key__", 1);
            SecretKey key2 = new SecretKey(path, "__max_key__", Integer.MAX_VALUE);
            Iterator<SecretRegistryValue> allVersions = this.kafkaStore.getAll(key1, key2);
            while (allVersions.hasNext()) {
                Secret secret = this.secretTransformer.transform((SecretValue)allVersions.next());
                this.deleteVersion(secret.getPath(), secret.getKey(), secret.getVersion());
                keys.add(secret.getKey());
            }
            return keys;
        }
        catch (StoreTimeoutException te) {
            throw new SecretRegistryTimeoutException("Write to the Kafka store timed out while", te);
        }
        catch (StoreException e) {
            throw new SecretRegistryStoreException("Error while deleting the path in the backend Kafka store", e);
        }
    }

    public Set<String> deletePathOrForward(Map<String, String> requestProperties, String path) throws SecretRegistryException {
        Object object = this.masterLock;
        synchronized (object) {
            if (this.isMaster()) {
                return this.deletePath(path);
            }
            if (this.masterIdentity != null) {
                return this.forwardDeletePathRequestToMaster(requestProperties, path);
            }
            throw new UnknownMasterException("Register secret request failed since master is unknown");
        }
    }

    private int forwardRegisterRequestToMaster(Secret secret, Map<String, String> headerProperties) throws SecretRegistryRequestForwardingException {
        UrlList baseUrl = this.masterRestService.getBaseUrls();
        RegisterSecretRequest registerSecretRequest = new RegisterSecretRequest();
        registerSecretRequest.setSecret(secret.getSecret());
        log.debug(String.format("Forwarding registering secret request %s to %s", registerSecretRequest, baseUrl));
        try {
            int id = this.masterRestService.registerSecret(headerProperties, registerSecretRequest, secret.getPath(), secret.getKey());
            return id;
        }
        catch (IOException e) {
            throw new SecretRegistryRequestForwardingException(String.format("Unexpected error while forwarding the registering secret request %s to %s", registerSecretRequest, baseUrl), e);
        }
        catch (RestClientException e) {
            throw new RestException(e.getMessage(), e.getStatus(), e.getErrorCode(), (Throwable)e);
        }
    }

    private int forwardDeleteVersionRequestToMaster(Map<String, String> headerProperties, String path, String key, Integer version) throws SecretRegistryRequestForwardingException {
        UrlList baseUrl = this.masterRestService.getBaseUrls();
        log.debug(String.format("Forwarding deleteSecretVersion secret version request %s-%s-%s to %s", path, key, version, baseUrl));
        try {
            return this.masterRestService.deleteVersion(headerProperties, path, key, String.valueOf(version));
        }
        catch (IOException e) {
            throw new SecretRegistryRequestForwardingException(String.format("Unexpected error while forwarding deleteSecretVersion secret version request %s-%s-%s to %s", path, key, version, baseUrl), e);
        }
        catch (RestClientException e) {
            throw new RestException(e.getMessage(), e.getStatus(), e.getErrorCode(), (Throwable)e);
        }
    }

    private List<Integer> forwardDeleteKeyRequestToMaster(Map<String, String> requestProperties, String path, String key) throws SecretRegistryRequestForwardingException {
        UrlList baseUrl = this.masterRestService.getBaseUrls();
        log.debug(String.format("Forwarding delete key request for %s-%s to %s", path, key, baseUrl));
        try {
            return this.masterRestService.deleteKey(requestProperties, path, key);
        }
        catch (IOException e) {
            throw new SecretRegistryRequestForwardingException(String.format("Unexpected error while forwarding delete key request %s-%s to %s", path, key, baseUrl), e);
        }
        catch (RestClientException e) {
            throw new RestException(e.getMessage(), e.getStatus(), e.getErrorCode(), (Throwable)e);
        }
    }

    private Set<String> forwardDeletePathRequestToMaster(Map<String, String> requestProperties, String path) throws SecretRegistryRequestForwardingException {
        UrlList baseUrl = this.masterRestService.getBaseUrls();
        log.debug(String.format("Forwarding delete path request for %s to %s", path, baseUrl));
        try {
            return this.masterRestService.deletePath(requestProperties, path);
        }
        catch (IOException e) {
            throw new SecretRegistryRequestForwardingException(String.format("Unexpected error while forwarding delete path request %s to %s", path, baseUrl), e);
        }
        catch (RestClientException e) {
            throw new RestException(e.getMessage(), e.getStatus(), e.getErrorCode(), (Throwable)e);
        }
    }

    public Secret validateAndGetSecret(String path, String key, VersionId versionId) throws SecretRegistryException {
        Secret secret = this.get(path, key, versionId.getVersionId());
        if (secret == null) {
            if (!this.listPaths().contains(path)) {
                throw Errors.pathNotFoundException();
            }
            if (!this.listKeys(path).contains(key)) {
                throw Errors.keyNotFoundException();
            }
            throw Errors.versionNotFoundException();
        }
        return secret;
    }

    @Override
    public Secret get(String path, String key, int version) throws SecretRegistryException {
        log.info("Getting secret '{}:{}' version {}", new Object[]{path, key, version});
        VersionId versionId = new VersionId(version);
        if (versionId.isLatest()) {
            return this.getLatestVersion(path, key);
        }
        SecretKey secretKey = new SecretKey(path, key, version);
        try {
            SecretValue secretValue = (SecretValue)this.kafkaStore.get(secretKey);
            Secret secret = this.secretTransformer.transform(secretValue);
            return secret;
        }
        catch (StoreException e) {
            throw new SecretRegistryStoreException("Error while retrieving secret from the backend Kafka store", e);
        }
    }

    @Override
    public Set<String> listPaths() throws SecretRegistryException {
        log.info("Listing all paths");
        try {
            Iterator<SecretRegistryKey> allKeys = this.kafkaStore.getAllKeys();
            return this.extractUniquePaths(allKeys);
        }
        catch (StoreException e) {
            throw new SecretRegistryStoreException("Error from the backend Kafka store", e);
        }
    }

    private Set<String> extractUniquePaths(Iterator<SecretRegistryKey> allKeys) throws StoreException {
        HashSet<String> paths = new HashSet<String>();
        while (allKeys.hasNext()) {
            SecretRegistryKey k = allKeys.next();
            if (!(k instanceof SecretKey)) continue;
            SecretKey key = (SecretKey)k;
            SecretValue value = (SecretValue)this.kafkaStore.get(key);
            paths.add(key.getPath());
        }
        return paths;
    }

    @Override
    public Set<String> listKeys(String path) throws SecretRegistryException {
        log.info("Listing keys for '{}'", (Object)path);
        try {
            SecretKey key1 = new SecretKey(path, "__min_key__", 1);
            SecretKey key2 = new SecretKey(path, "__max_key__", Integer.MAX_VALUE);
            Iterator<SecretRegistryValue> allVersions = this.kafkaStore.getAll(key1, key2);
            return this.extractUniqueKeys(allVersions);
        }
        catch (StoreException e) {
            throw new SecretRegistryStoreException("Error from the backend Kafka store", e);
        }
    }

    private Set<String> extractUniqueKeys(Iterator<SecretRegistryValue> allVersions) {
        HashSet<String> keys = new HashSet<String>();
        while (allVersions.hasNext()) {
            SecretRegistryValue v = allVersions.next();
            if (!(v instanceof SecretValue)) continue;
            SecretValue value = (SecretValue)v;
            keys.add(value.getKey());
        }
        return keys;
    }

    @Override
    public List<Integer> listVersions(String path, String key) throws SecretRegistryException {
        log.info("Listing versions for '{}:{}'", (Object)path, (Object)key);
        try {
            SecretKey key1 = new SecretKey(path, key, 1);
            SecretKey key2 = new SecretKey(path, key, Integer.MAX_VALUE);
            Iterator<SecretRegistryValue> allVersions = this.kafkaStore.getAll(key1, key2);
            return this.extractUniqueVersions(allVersions);
        }
        catch (StoreException e) {
            throw new SecretRegistryStoreException("Error from the backend Kafka store", e);
        }
    }

    private List<Integer> extractUniqueVersions(Iterator<SecretRegistryValue> allVersions) {
        ArrayList<Integer> versions = new ArrayList<Integer>();
        while (allVersions.hasNext()) {
            SecretRegistryValue v = allVersions.next();
            if (!(v instanceof SecretValue)) continue;
            SecretValue value = (SecretValue)v;
            versions.add(value.getVersion());
        }
        return versions;
    }

    @Override
    public List<Secret> getAllLatest(String path) throws SecretRegistryException {
        log.info("Getting latest for '{}'", (Object)path);
        try {
            SecretKey key1 = new SecretKey(path, "__min_key__", 1);
            SecretKey key2 = new SecretKey(path, "__max_key__", Integer.MAX_VALUE);
            Iterator<SecretRegistryValue> allVersions = this.kafkaStore.getAll(key1, key2);
            ArrayList<Secret> secrets = new ArrayList<Secret>(this.latestKeys(path, allVersions).values());
            Collections.sort(secrets);
            return secrets;
        }
        catch (StoreException e) {
            throw new SecretRegistryStoreException("Error from the backend Kafka store", e);
        }
    }

    @Override
    public List<Secret> getAllVersions(String path, String key) throws SecretRegistryException {
        log.info("Getting versions for '{}:{}'", (Object)path, (Object)key);
        try {
            SecretKey key1 = new SecretKey(path, key, 1);
            SecretKey key2 = new SecretKey(path, key, Integer.MAX_VALUE);
            Iterator<SecretRegistryValue> allVersions = this.kafkaStore.getAll(key1, key2);
            return this.sortSecrets(allVersions);
        }
        catch (StoreException e) {
            throw new SecretRegistryStoreException("Error from the backend Kafka store", e);
        }
    }

    @Override
    public Secret getLatestVersion(String path, String key) throws SecretRegistryException {
        try {
            SecretKey key1 = new SecretKey(path, key, 1);
            SecretKey key2 = new SecretKey(path, key, Integer.MAX_VALUE);
            Iterator<SecretRegistryValue> allVersions = this.kafkaStore.getAll(key1, key2);
            List<Secret> sortedVersions = this.sortSecrets(allVersions);
            Secret latestSecret = null;
            if (sortedVersions.size() > 0) {
                latestSecret = sortedVersions.get(sortedVersions.size() - 1);
            }
            return latestSecret;
        }
        catch (StoreException e) {
            throw new SecretRegistryStoreException("Error from the backend Kafka store", e);
        }
    }

    @Override
    public void close() {
        log.info("Shutting down secret registry");
        this.kafkaStore.close();
        if (this.masterElector != null) {
            this.masterElector.close();
        }
    }

    KafkaStore<SecretRegistryKey, SecretRegistryValue> getKafkaStore() {
        return this.kafkaStore;
    }

    private List<Secret> sortSecrets(Iterator<SecretRegistryValue> secrets) {
        ArrayList<Secret> secretVector = new ArrayList<Secret>();
        while (secrets.hasNext()) {
            SecretValue secretValue = (SecretValue)secrets.next();
            secretVector.add(this.secretTransformer.transform(secretValue));
        }
        Collections.sort(secretVector);
        return secretVector;
    }

    private Map<String, Secret> latestKeys(String path, Iterator<SecretRegistryValue> secrets) {
        HashMap<String, Secret> result = new HashMap<String, Secret>();
        HashMap<String, Integer> maxVersions = new HashMap<String, Integer>();
        while (secrets.hasNext()) {
            int value;
            SecretValue secretValue = (SecretValue)secrets.next();
            Secret secret = this.secretTransformer.transform(secretValue);
            String key = secret.getKey();
            int version = secret.getVersion();
            if (version != (value = maxVersions.merge(key, version, Math::max).intValue())) continue;
            result.put(key, secret);
        }
        return result;
    }
}

