/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.coordinator.transaction.ProducerIdManager;
import kafka.coordinator.transaction.ProducerIdManager$;
import kafka.server.BrokerToControllerChannelManager;
import kafka.server.ControllerRequestCompletionHandler;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.message.AllocateProducerIdsRequestData;
import org.apache.kafka.common.message.AllocateProducerIdsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AllocateProducerIdsRequest;
import org.apache.kafka.common.requests.AllocateProducerIdsResponse;
import org.apache.kafka.server.common.ProducerIdsBlock;
import scala.Function0;
import scala.MatchError;
import scala.reflect.ScalaSignature;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005b\u0001B\u000b\u0017\u0001uA\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\te\u0001\u0011\t\u0011)A\u0005g!A\u0011\b\u0001B\u0001B\u0003%!\b\u0003\u0005A\u0001\t\u0005\t\u0015!\u00030\u0011\u0015\t\u0005\u0001\"\u0001C\u0011\u001dA\u0005A1A\u0005\n%Ca!\u001a\u0001!\u0002\u0013Q\u0005b\u00024\u0001\u0005\u0004%Ia\u001a\u0005\u0007]\u0002\u0001\u000b\u0011\u00025\t\u000f=\u0004\u0001\u0019!C\u0005a\"9\u0011\u000f\u0001a\u0001\n\u0013\u0011\bB\u0002=\u0001A\u0003&\u0011\f\u0003\u0005z\u0001\u0001\u0007I\u0011\u0001\f{\u0011!Y\b\u00011A\u0005\u0002Ya\bB\u0002@\u0001A\u0003&a\u0007\u0003\u0004\u0000\u0001\u0011\u0005\u0013\u0011\u0001\u0005\b\u0003\u0007\u0001A\u0011BA\u0003\u0011!\t9\u0001\u0001C\u0001-\u0005\u0015\u0001\u0002CA\u0005\u0001\u0011\u0005a#a\u0003\t\u0011\u0005}\u0001\u0001\"\u0001\u0017\u0003\u000b\u0011AC\u0015)D!J|G-^2fe&#W*\u00198bO\u0016\u0014(BA\f\u0019\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\u000b\u0005eQ\u0012aC2p_J$\u0017N\\1u_JT\u0011aG\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001a\u0004\n\u0015\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0003\u0005\nQa]2bY\u0006L!a\t\u0011\u0003\r\u0005s\u0017PU3g!\t)c%D\u0001\u0017\u0013\t9cCA\tQe>$WoY3s\u0013\u0012l\u0015M\\1hKJ\u0004\"!\u000b\u0017\u000e\u0003)R!a\u000b\u000e\u0002\u000bU$\u0018\u000e\\:\n\u00055R#a\u0002'pO\u001eLgnZ\u0001\tEJ|7.\u001a:JIB\u0011q\u0004M\u0005\u0003c\u0001\u00121!\u00138u\u0003M\u0011'o\\6fe\u0016\u0003xn\u00195TkB\u0004H.[3s!\ryBGN\u0005\u0003k\u0001\u0012\u0011BR;oGRLwN\u001c\u0019\u0011\u0005}9\u0014B\u0001\u001d!\u0005\u0011auN\\4\u0002#\r|g\u000e\u001e:pY2,'o\u00115b]:,G\u000e\u0005\u0002<}5\tAH\u0003\u0002>5\u000511/\u001a:wKJL!a\u0010\u001f\u0003A\t\u0013xn[3s)>\u001cuN\u001c;s_2dWM]\"iC:tW\r\\'b]\u0006<WM]\u0001\n[\u0006Dx+Y5u\u001bN\fa\u0001P5oSRtD#B\"E\u000b\u001a;\u0005CA\u0013\u0001\u0011\u0015qS\u00011\u00010\u0011\u0015\u0011T\u00011\u00014\u0011\u0015IT\u00011\u0001;\u0011\u0015\u0001U\u00011\u00010\u0003MqW\r\u001f;Qe>$WoY3s\u0013\u0012\u0014En\\2l+\u0005Q\u0005cA&S)6\tAJ\u0003\u0002N\u001d\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005=\u0003\u0016\u0001B;uS2T\u0011!U\u0001\u0005U\u00064\u0018-\u0003\u0002T\u0019\n\u0011\u0012I\u001d:bs\ncwnY6j]\u001e\fV/Z;f!\r)v+W\u0007\u0002-*\u0011q\nI\u0005\u00031Z\u00131\u0001\u0016:z!\tQ6-D\u0001\\\u0015\taV,\u0001\u0004d_6lwN\u001c\u0006\u0003{yS!aG0\u000b\u0005\u0001\f\u0017AB1qC\u000eDWMC\u0001c\u0003\ry'oZ\u0005\u0003In\u0013\u0001\u0003\u0015:pIV\u001cWM]%eg\ncwnY6\u0002)9,\u0007\u0010\u001e)s_\u0012,8-\u001a:JI\ncwnY6!\u0003=\u0011X-];fgRLeN\u00127jO\"$X#\u00015\u0011\u0005%dW\"\u00016\u000b\u0005-d\u0015AB1u_6L7-\u0003\u0002nU\ni\u0011\t^8nS\u000e\u0014un\u001c7fC:\f\u0001C]3rk\u0016\u001cH/\u00138GY&<\u0007\u000e\u001e\u0011\u0002-\r,(O]3oiB\u0013x\u000eZ;dKJLEM\u00117pG.,\u0012!W\u0001\u001bGV\u0014(/\u001a8u!J|G-^2fe&#'\t\\8dW~#S-\u001d\u000b\u0003gZ\u0004\"a\b;\n\u0005U\u0004#\u0001B+oSRDqa^\u0006\u0002\u0002\u0003\u0007\u0011,A\u0002yIE\nqcY;se\u0016tG\u000f\u0015:pIV\u001cWM]%e\u00052|7m\u001b\u0011\u0002\u001d9,\u0007\u0010\u001e)s_\u0012,8-\u001a:JIV\ta'\u0001\noKb$\bK]8ek\u000e,'/\u00133`I\u0015\fHCA:~\u0011\u001d9h\"!AA\u0002Y\nqB\\3yiB\u0013x\u000eZ;dKJLE\rI\u0001\u0013O\u0016tWM]1uKB\u0013x\u000eZ;dKJLE\rF\u00017\u0003Ui\u0017-\u001f2f%\u0016\fX/Z:u\u001d\u0016DHO\u00117pG.$\u0012a]\u0001\fg\u0016tGMU3rk\u0016\u001cH/A\u0011iC:$G.Z!mY>\u001c\u0017\r^3Qe>$WoY3s\u0013\u0012\u001c(+Z:q_:\u001cX\rF\u0002t\u0003\u001bAq!a\u0004\u0014\u0001\u0004\t\t\"\u0001\u0005sKN\u0004xN\\:f!\u0011\t\u0019\"a\u0007\u000e\u0005\u0005U!\u0002BA\f\u00033\t\u0001B]3rk\u0016\u001cHo\u001d\u0006\u00039zKA!!\b\u0002\u0016\tY\u0012\t\u001c7pG\u0006$X\r\u0015:pIV\u001cWM]%egJ+7\u000f]8og\u0016\fQ\u0002[1oI2,G+[7f_V$\b")
public class RPCProducerIdManager
implements ProducerIdManager,
Logging {
    private final int brokerId;
    private final Function0<Object> brokerEpochSupplier;
    private final BrokerToControllerChannelManager controllerChannel;
    private final int maxWaitMs;
    private final ArrayBlockingQueue<Try<ProducerIdsBlock>> nextProducerIdBlock;
    private final AtomicBoolean requestInFlight;
    private ProducerIdsBlock currentProducerIdBlock;
    private long nextProducerId;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public void shutdown() {
        ProducerIdManager.shutdown$(this);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private ArrayBlockingQueue<Try<ProducerIdsBlock>> nextProducerIdBlock() {
        return this.nextProducerIdBlock;
    }

    private AtomicBoolean requestInFlight() {
        return this.requestInFlight;
    }

    private ProducerIdsBlock currentProducerIdBlock() {
        return this.currentProducerIdBlock;
    }

    private void currentProducerIdBlock_$eq(ProducerIdsBlock x$1) {
        this.currentProducerIdBlock = x$1;
    }

    public long nextProducerId() {
        return this.nextProducerId;
    }

    public void nextProducerId_$eq(long x$1) {
        this.nextProducerId = x$1;
    }

    @Override
    public synchronized long generateProducerId() {
        if (this.nextProducerId() == -1L) {
            this.maybeRequestNextBlock();
            this.nextProducerId_$eq(0L);
        } else {
            this.nextProducerId_$eq(this.nextProducerId() + 1L);
            if ((double)this.nextProducerId() >= (double)this.currentProducerIdBlock().firstProducerId() + (double)this.currentProducerIdBlock().size() * ProducerIdManager$.MODULE$.PidPrefetchThreshold()) {
                this.maybeRequestNextBlock();
            }
        }
        if (this.nextProducerId() > this.currentProducerIdBlock().lastProducerId()) {
            Try<ProducerIdsBlock> block = this.nextProducerIdBlock().poll(this.maxWaitMs, TimeUnit.MILLISECONDS);
            if (block == null) {
                throw Errors.COORDINATOR_LOAD_IN_PROGRESS.exception("Timed out waiting for next producer ID block");
            }
            if (block instanceof Success) {
                ProducerIdsBlock nextBlock = (ProducerIdsBlock)((Success)block).value();
                this.currentProducerIdBlock_$eq(nextBlock);
                this.nextProducerId_$eq(this.currentProducerIdBlock().firstProducerId());
            } else {
                if (block instanceof Failure) {
                    throw ((Failure)block).exception();
                }
                throw new MatchError(block);
            }
        }
        return this.nextProducerId();
    }

    private void maybeRequestNextBlock() {
        if (this.nextProducerIdBlock().isEmpty() && this.requestInFlight().compareAndSet(false, true)) {
            this.sendRequest();
            return;
        }
    }

    public void sendRequest() {
        AllocateProducerIdsRequestData message = new AllocateProducerIdsRequestData().setBrokerEpoch(this.brokerEpochSupplier.apply$mcJ$sp()).setBrokerId(this.brokerId);
        AllocateProducerIdsRequest.Builder request = new AllocateProducerIdsRequest.Builder(message);
        this.debug((Function0<String>)(Function0 & Serializable)() -> "Requesting next Producer ID block");
        this.controllerChannel.sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)request, new ControllerRequestCompletionHandler(this){
            private final /* synthetic */ RPCProducerIdManager $outer;

            public void onComplete(ClientResponse response) {
                AllocateProducerIdsResponse message = (AllocateProducerIdsResponse)response.responseBody();
                this.$outer.handleAllocateProducerIdsResponse(message);
            }

            public void onTimeout() {
                this.$outer.handleTimeout();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void handleAllocateProducerIdsResponse(AllocateProducerIdsResponse response) {
        this.requestInFlight().set(false);
        AllocateProducerIdsResponseData data = response.data();
        Errors errors = Errors.forCode((short)data.errorCode());
        if (Errors.NONE.equals(errors)) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(43).append("Got next producer ID block from controller ").append(data).toString());
            if (data.producerIdStart() < this.currentProducerIdBlock().lastProducerId()) {
                this.nextProducerIdBlock().put((Try<ProducerIdsBlock>)new Failure((Throwable)new KafkaException(new StringBuilder(73).append("Producer ID block is not monotonic with current block: current=").append(this.currentProducerIdBlock()).append(" response=").append(data).toString())));
                return;
            }
            if (data.producerIdStart() < 0L || data.producerIdLen() < 0 || data.producerIdStart() > Long.MAX_VALUE - (long)data.producerIdLen()) {
                this.nextProducerIdBlock().put((Try<ProducerIdsBlock>)new Failure((Throwable)new KafkaException(new StringBuilder(45).append("Producer ID block includes invalid ID range: ").append(data).toString())));
                return;
            }
            this.nextProducerIdBlock().put((Try<ProducerIdsBlock>)new Success((Object)new ProducerIdsBlock(this.brokerId, data.producerIdStart(), data.producerIdLen())));
            return;
        }
        if (Errors.STALE_BROKER_EPOCH.equals(errors)) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> "Our broker epoch was stale, trying again.");
            this.maybeRequestNextBlock();
            return;
        }
        if (Errors.BROKER_ID_NOT_REGISTERED.equals(errors)) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> "Our broker ID is not yet known by the controller, trying again.");
            this.maybeRequestNextBlock();
            return;
        }
        if (errors != null) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> "Had an unknown error from the controller, giving up.");
            this.nextProducerIdBlock().put((Try<ProducerIdsBlock>)new Failure((Throwable)errors.exception()));
            return;
        }
        throw new MatchError(null);
    }

    public void handleTimeout() {
        this.warn((Function0<String>)(Function0 & Serializable)() -> "Timed out when requesting AllocateProducerIds from the controller.");
        this.requestInFlight().set(false);
        this.maybeRequestNextBlock();
    }

    public RPCProducerIdManager(int brokerId, Function0<Object> brokerEpochSupplier, BrokerToControllerChannelManager controllerChannel, int maxWaitMs) {
        this.brokerId = brokerId;
        this.brokerEpochSupplier = brokerEpochSupplier;
        this.controllerChannel = controllerChannel;
        this.maxWaitMs = maxWaitMs;
        this.logIdent_$eq(new StringBuilder(27).append("[RPC ProducerId Manager ").append(brokerId).append("]: ").toString());
        this.nextProducerIdBlock = new ArrayBlockingQueue(1);
        this.requestInFlight = new AtomicBoolean(false);
        this.currentProducerIdBlock = ProducerIdsBlock.EMPTY;
        this.nextProducerId = -1L;
    }
}

