/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.snapshot;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.time.Duration;
import java.util.Optional;
import java.util.UUID;
import kafka.log.MergedLog;
import kafka.tier.exceptions.TierMetadataFatalException;
import kafka.tier.state.FileTierPartitionState;
import kafka.tier.state.Header;
import kafka.tier.state.TierPartitionStateCleanupConfig;
import kafka.utils.checksum.Algorithm;
import kafka.utils.checksum.CheckedFileIO;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpsSnapshotMaterializer {
    private static final Logger log = LoggerFactory.getLogger(FtpsSnapshotMaterializer.class);
    private Path ftpsSnapshotsDir;
    private FileTierPartitionState ftps;

    public FtpsSnapshotMaterializer(String ftpsSnapshotsRootDir) {
        this.ftpsSnapshotsDir = Paths.get(ftpsSnapshotsRootDir, UUID.randomUUID().toString());
    }

    public FileTierPartitionState materializeFtpsFromSnapshot(TopicPartition topicPartition, Algorithm checksumAlgorithm, ByteBuffer snapshotBuffer, LogDirFailureChannel logDirFailureChannel, Scheduler scheduler, Time time) throws IOException {
        if (this.ftps != null) {
            throw new IllegalStateException("Attempt to use snapshot materialization util that already has ftps initialized:" + this.ftps);
        }
        if (this.ftpsSnapshotsDir == null) {
            throw new IllegalStateException("Attempt to use snapshot materialization with null ftpsSnapshotsDir");
        }
        boolean tieringEnabled = true;
        boolean compactFeatureFlag = true;
        boolean cleanupEnabled = true;
        TierPartitionStateCleanupConfig cleanupConfig = new TierPartitionStateCleanupConfig(true, Duration.ofDays(30L).toMillis(), Duration.ofDays(30L).toMillis());
        boolean tierPartitionStateSnapshotFeatureFlag = true;
        int brokerId = -1;
        String basePath = MergedLog.tierStateFile(this.ftpsSnapshotsDir.toFile(), 0L, checksumAlgorithm.suffix).getAbsolutePath();
        Path materializationPath = FileTierPartitionState.flushedFilePath(basePath, checksumAlgorithm);
        if (!materializationPath.toFile().getParentFile().mkdirs()) {
            throw new TierMetadataFatalException(String.format("Failed to make directories at path %s", materializationPath));
        }
        try (FileChannel materializationChannel = FileChannel.open(materializationPath, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.READ, StandardOpenOption.WRITE);){
            Utils.writeFully((FileChannel)materializationChannel, (ByteBuffer)snapshotBuffer);
            log.info("Persist source FTPS file from object store to {} with size {}", (Object)materializationPath, (Object)materializationChannel.size());
        }
        var16_16 = null;
        try (CheckedFileIO checkedIOChannel = CheckedFileIO.open(materializationPath, StandardOpenOption.READ);){
            Optional<Header> initialHeaderOpt = FileTierPartitionState.readHeader(checkedIOChannel);
            if (!initialHeaderOpt.isPresent()) {
                throw new IllegalStateException(String.format("TierPartitionState being opened does not contain a valid header, aborting. Topic-Partition %s with checksum algorithm %s", new Object[]{topicPartition, checksumAlgorithm}));
            }
        }
        catch (Throwable throwable) {
            var16_16 = throwable;
            throw throwable;
        }
        this.ftps = new FileTierPartitionState(this.ftpsSnapshotsDir.toFile(), logDirFailureChannel, topicPartition, true, scheduler, checksumAlgorithm != Algorithm.NO_CHECKSUM, true, time, cleanupConfig, true, -1);
        return this.ftps;
    }

    public void cleanup() throws IOException {
        if (this.ftps != null) {
            this.ftps.close();
            this.ftps = null;
        }
        if (this.ftpsSnapshotsDir != null) {
            Utils.delete((File)this.ftpsSnapshotsDir.toFile());
            this.ftpsSnapshotsDir = null;
        }
    }
}

