/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.topic;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import kafka.tier.topic.CompletionCriteria;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TierCatchupConsumer {
    private static final Logger log = LoggerFactory.getLogger(TierCatchupConsumer.class);
    final Supplier<Consumer<byte[], byte[]>> consumerSupplier;
    volatile Consumer<byte[], byte[]> consumer;

    TierCatchupConsumer(Supplier<Consumer<byte[], byte[]>> consumerSupplier) {
        this.consumerSupplier = consumerSupplier;
    }

    public ConsumerRecords<byte[], byte[]> poll(Duration pollDuration) {
        if (this.active()) {
            return this.consumer.poll(pollDuration);
        }
        return null;
    }

    public boolean active() {
        return this.consumer != null;
    }

    void doStart(Set<TopicPartition> tierTopicPartitions) {
        if (!this.maybeStartConsumer(tierTopicPartitions)) {
            throw new IllegalStateException("Unable to startup consumer from the beginning");
        }
    }

    void doStart(Map<TopicPartition, Long> tierTopicPartitionsAndStartOffsets) {
        if (!this.maybeStartConsumer(tierTopicPartitionsAndStartOffsets)) {
            throw new IllegalStateException("Unable to startup consumer from specified offsets");
        }
    }

    boolean tryComplete(CompletionCriteria criteria) {
        boolean hasCaughtUp;
        if (!this.active()) {
            return false;
        }
        Set assignment = this.consumer.assignment();
        try {
            hasCaughtUp = assignment.stream().allMatch(tp -> criteria.isComplete((TopicPartition)tp, this.consumer.position(tp)));
        }
        catch (TimeoutException e) {
            log.warn("Timed out when determining consumer position", (Throwable)e);
            return false;
        }
        if (hasCaughtUp) {
            this.close();
            return true;
        }
        return false;
    }

    synchronized void wakeup() {
        if (this.active()) {
            this.consumer.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        try {
            if (this.active()) {
                this.consumer.close();
            }
        }
        catch (Exception e) {
            log.warn("Ignoring exception when closing consumer", (Throwable)e);
        }
        finally {
            TierCatchupConsumer tierCatchupConsumer = this;
            synchronized (tierCatchupConsumer) {
                this.consumer = null;
            }
        }
    }

    Consumer<byte[], byte[]> consumer() {
        return this.consumer;
    }

    private boolean maybeStartConsumer(Set<TopicPartition> tierTopicPartitions) {
        if (!this.getConsumerAndAssignPartitions(tierTopicPartitions)) {
            return false;
        }
        log.info("Seeking consumer to beginning for {}", tierTopicPartitions);
        this.consumer.seekToBeginning((Collection)this.consumer.assignment());
        return true;
    }

    private boolean maybeStartConsumer(Map<TopicPartition, Long> tierTopicPartitionsAndStartOffsets) {
        if (!this.getConsumerAndAssignPartitions(tierTopicPartitionsAndStartOffsets.keySet())) {
            return false;
        }
        tierTopicPartitionsAndStartOffsets.forEach((tp, offset) -> {
            if (offset > 0L) {
                this.consumer.seek(tp, offset.longValue());
            } else {
                log.info("Seeking consumer to beginning for {}", tp);
                this.consumer.seekToBeginning(Collections.singletonList(tp));
            }
        });
        return true;
    }

    boolean getConsumerAndAssignPartitions(Set<TopicPartition> partitions) {
        if (this.active() || partitions.isEmpty()) {
            return false;
        }
        this.consumer = this.consumerSupplier.get();
        this.consumer.assign(partitions);
        return true;
    }
}

