/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk.migration;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import kafka.api.LeaderAndIsr$;
import kafka.api.PartitionLinkState;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.ReplicaAssignment;
import kafka.server.ConfigType$;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ClusterLinkTopicState$;
import kafka.utils.Logging;
import kafka.zk.ConfigEntityZNode$;
import kafka.zk.ConfluentAssignmentMigration$;
import kafka.zk.KRaftAssignment;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicPartitionStateZNode$;
import kafka.zk.TopicPartitionZNode$;
import kafka.zk.TopicPartitionsZNode$;
import kafka.zk.TopicZNode;
import kafka.zk.TopicZNode$;
import kafka.zk.ZkMigrationClient$;
import kafka.zk.ZkVersion$;
import kafka.zookeeper.AsyncResponse;
import kafka.zookeeper.CreateRequest;
import kafka.zookeeper.DeleteRequest;
import kafka.zookeeper.DeleteResponse;
import kafka.zookeeper.GetChildrenRequest;
import kafka.zookeeper.GetChildrenResponse;
import kafka.zookeeper.SetDataRequest;
import org.apache.kafka.common.MirrorTopicError;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.MirrorTopicRecord;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.metadata.MirrorTopic;
import org.apache.kafka.metadata.PartitionRegistration;
import org.apache.kafka.metadata.migration.ClusterLinkMetadata;
import org.apache.kafka.metadata.migration.MigrationClientAuthException;
import org.apache.kafka.metadata.migration.MigrationClientException;
import org.apache.kafka.metadata.migration.TopicMigrationClient;
import org.apache.kafka.metadata.migration.ZkMigrationLeadershipState;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Iterable;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\tEa\u0001\u0002\n\u0014\u0001iA\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\u0006u\u0001!\ta\u000f\u0005\u0006\u007f\u0001!\t\u0005\u0011\u0005\u0006S\u0002!\tE\u001b\u0005\u0007S\u0002!\t%!\f\t\u000f\u0005]\u0002\u0001\"\u0003\u0002:!9\u0011Q\f\u0001\u0005\n\u0005}\u0003bBA/\u0001\u0011%\u0011Q\u000f\u0005\b\u0003\u0013\u0003A\u0011IAF\u0011\u001d\t9\n\u0001C!\u00033Cq!a(\u0001\t\u0003\n\t\u000bC\u0004\u0002,\u0002!\t%!,\t\u000f\u0005M\u0006\u0001\"\u0011\u00026\"9\u00111\u0019\u0001\u0005\n\u0005\u0015\u0007bBAi\u0001\u0011%\u00111\u001b\u0005\b\u0003o\u0004A\u0011BA}\u0011\u001d\u0011\t\u0001\u0001C\u0005\u0005\u0007\u0011aCW6U_BL7-T5he\u0006$\u0018n\u001c8DY&,g\u000e\u001e\u0006\u0003)U\t\u0011\"\\5he\u0006$\u0018n\u001c8\u000b\u0005Y9\u0012A\u0001>l\u0015\u0005A\u0012!B6bM.\f7\u0001A\n\u0005\u0001m\u0019s\u0006\u0005\u0002\u001dC5\tQD\u0003\u0002\u001f?\u0005!A.\u00198h\u0015\u0005\u0001\u0013\u0001\u00026bm\u0006L!AI\u000f\u0003\r=\u0013'.Z2u!\t!S&D\u0001&\u0015\t!bE\u0003\u0002(Q\u0005AQ.\u001a;bI\u0006$\u0018M\u0003\u0002\u0019S)\u0011!fK\u0001\u0007CB\f7\r[3\u000b\u00031\n1a\u001c:h\u0013\tqSE\u0001\u000bU_BL7-T5he\u0006$\u0018n\u001c8DY&,g\u000e\u001e\t\u0003aMj\u0011!\r\u0006\u0003e]\tQ!\u001e;jYNL!\u0001N\u0019\u0003\u000f1{wmZ5oO\u0006A!p[\"mS\u0016tG\u000f\u0005\u00028q5\tQ#\u0003\u0002:+\ti1*\u00194lCj[7\t\\5f]R\fa\u0001P5oSRtDC\u0001\u001f?!\ti\u0004!D\u0001\u0014\u0011\u0015)$\u00011\u00017\u00035IG/\u001a:bi\u0016$v\u000e]5dgR\u0019\u0011iR2\u0011\u0005\t+U\"A\"\u000b\u0003\u0011\u000bQa]2bY\u0006L!AR\"\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u0011\u000e\u0001\r!S\u0001\nS:$XM]3tiN\u00042AS'P\u001b\u0005Y%B\u0001' \u0003\u0011)H/\u001b7\n\u00059[%aB#ok6\u001cV\r\u001e\t\u0003!\u0002t!!\u00150\u000f\u0005IkfBA*]\u001d\t!6L\u0004\u0002V5:\u0011a+W\u0007\u0002/*\u0011\u0001,G\u0001\u0007yI|w\u000e\u001e \n\u00031J!AK\u0016\n\u0005aI\u0013BA\u0014)\u0013\t!b%\u0003\u0002`K\u0005!Bk\u001c9jG6KwM]1uS>t7\t\\5f]RL!!\u00192\u0003)Q{\u0007/[2WSNLGo\u001c:J]R,'/Z:u\u0015\tyV\u0005C\u0003e\u0007\u0001\u0007Q-A\u0004wSNLGo\u001c:\u0011\u0005\u0019<gB\u0001\u0013_\u0013\tA'M\u0001\u0007U_BL7MV5tSR|'/A\u0006de\u0016\fG/\u001a+pa&\u001cG#C6oq\u0006\u0005\u0011\u0011DA\u0015!\t!C.\u0003\u0002nK\tQ\"l['jOJ\fG/[8o\u0019\u0016\fG-\u001a:tQ&\u00048\u000b^1uK\")q\u000e\u0002a\u0001a\u0006IAo\u001c9jG:\u000bW.\u001a\t\u0003cVt!A]:\u0011\u0005Y\u001b\u0015B\u0001;D\u0003\u0019\u0001&/\u001a3fM&\u0011ao\u001e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Q\u001c\u0005\"B=\u0005\u0001\u0004Q\u0018a\u0002;pa&\u001c\u0017\n\u001a\t\u0003wzl\u0011\u0001 \u0006\u0003{\"\naaY8n[>t\u0017BA@}\u0005\u0011)V/\u001b3\t\u000f\u0005\rA\u00011\u0001\u0002\u0006\u0005Q\u0001/\u0019:uSRLwN\\:\u0011\u000f)\u000b9!a\u0003\u0002\u0012%\u0019\u0011\u0011B&\u0003\u00075\u000b\u0007\u000fE\u0002\u001d\u0003\u001bI1!a\u0004\u001e\u0005\u001dIe\u000e^3hKJ\u0004B!a\u0005\u0002\u00165\ta%C\u0002\u0002\u0018\u0019\u0012Q\u0003U1si&$\u0018n\u001c8SK\u001eL7\u000f\u001e:bi&|g\u000eC\u0004\u0002\u001c\u0011\u0001\r!!\b\u0002\u00175L'O]8s)>\u0004\u0018n\u0019\t\u0006\u0015\u0006}\u00111E\u0005\u0004\u0003CY%\u0001C(qi&|g.\u00197\u0011\t\u0005M\u0011QE\u0005\u0004\u0003O1#aC'jeJ|'\u000fV8qS\u000eDa!a\u000b\u0005\u0001\u0004Y\u0017!B:uCR,G#C6\u00020\u0005E\u00121GA\u001b\u0011\u0015yW\u00011\u0001q\u0011\u0015IX\u00011\u0001{\u0011\u001d\t\u0019!\u0002a\u0001\u0003\u000bAa!a\u000b\u0006\u0001\u0004Y\u0017AI2sK\u0006$X\rV8qS\u000e\u0004\u0016M\u001d;ji&|gN\u0017(pI\u0016\u001c(+Z9vKN$8\u000f\u0006\u0005\u0002<\u0005]\u0013\u0011LA.!\u0019\ti$a\u0012\u0002L5\u0011\u0011q\b\u0006\u0005\u0003\u0003\n\u0019%A\u0005j[6,H/\u00192mK*\u0019\u0011QI\"\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002J\u0005}\"aA*fcB!\u0011QJA*\u001b\t\tyEC\u0002\u0002R]\t\u0011B_8pW\u0016,\u0007/\u001a:\n\t\u0005U\u0013q\n\u0002\u000e\u0007J,\u0017\r^3SKF,Xm\u001d;\t\u000b=4\u0001\u0019\u00019\t\u000f\u0005\ra\u00011\u0001\u0002\u0006!1\u00111\u0006\u0004A\u0002-\f\u0011C]3dkJ\u001c\u0018N^3DQ&dGM]3o)\u0015\t\u0015\u0011MA3\u0011\u0019\t\u0019g\u0002a\u0001a\u0006!\u0001/\u0019;i\u0011\u001d\t9g\u0002a\u0001\u0003S\n1!Y2d!\u0015\tY'!\u001dq\u001b\t\tiG\u0003\u0003\u0002p\u0005\r\u0013aB7vi\u0006\u0014G.Z\u0005\u0005\u0003g\niGA\u0006BeJ\f\u0017PQ;gM\u0016\u0014H\u0003BA<\u0003\u000f\u0003R!!\u001f\u0002\u0004BtA!a\u001f\u0002\u00009\u0019a+! \n\u0003\u0011K1!!!D\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0013\u0002\u0006*\u0019\u0011\u0011Q\"\t\r\u0005\r\u0004\u00021\u0001q\u0003-)\b\u000fZ1uKR{\u0007/[2\u0015\u0017-\fi)a$\u0002\u0012\u0006M\u0015Q\u0013\u0005\u0006_&\u0001\r\u0001\u001d\u0005\u0006s&\u0001\rA\u001f\u0005\b\u0003\u0007I\u0001\u0019AA\u0003\u0011\u001d\tY\"\u0003a\u0001\u0003;Aa!a\u000b\n\u0001\u0004Y\u0017a\u00033fY\u0016$X\rV8qS\u000e$Ra[AN\u0003;CQa\u001c\u0006A\u0002ADa!a\u000b\u000b\u0001\u0004Y\u0017!F2sK\u0006$X\rV8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0006W\u0006\r\u0016\u0011\u0016\u0005\b\u0003K[\u0001\u0019AAT\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u001c\bC\u0002&\u0002\bA\f)\u0001\u0003\u0004\u0002,-\u0001\ra[\u0001\u0016kB$\u0017\r^3U_BL7\rU1si&$\u0018n\u001c8t)\u0015Y\u0017qVAY\u0011\u001d\t)\u000b\u0004a\u0001\u0003OCa!a\u000b\r\u0001\u0004Y\u0017!\u00063fY\u0016$X\rV8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0006W\u0006]\u0016\u0011\u0019\u0005\b\u0003Kk\u0001\u0019AA]!\u0019Q\u0015q\u00019\u0002<B)!*!0\u0002\f%\u0019\u0011qX&\u0003\u0007M+G\u000f\u0003\u0004\u0002,5\u0001\ra[\u0001\u0015GJ,\u0017\r^3U_BL7\rU1si&$\u0018n\u001c8\u0015\t\u0005-\u0013q\u0019\u0005\b\u0003\u0013t\u0001\u0019AAf\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u00042a_Ag\u0013\r\ty\r \u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003e\u0001\u0018M\u001d;ji&|gn\u0015;bi\u0016\u0004\u0016\r\u001e5B]\u0012$\u0015\r^1\u0015\u0011\u0005U\u0017q]Au\u0003[\u0004bAQAla\u0006m\u0017bAAm\u0007\n1A+\u001e9mKJ\u0002RAQAo\u0003CL1!a8D\u0005\u0015\t%O]1z!\r\u0011\u00151]\u0005\u0004\u0003K\u001c%\u0001\u0002\"zi\u0016Dq!!3\u0010\u0001\u0004\tY\rC\u0004\u0002l>\u0001\r!!\u0005\u0002+A\f'\u000f^5uS>t'+Z4jgR\u0014\u0018\r^5p]\"9\u0011q^\bA\u0002\u0005E\u0018aD2p]R\u0014x\u000e\u001c7fe\u0016\u0003xn\u00195\u0011\u0007\t\u000b\u00190C\u0002\u0002v\u000e\u00131!\u00138u\u0003e\u0019'/Z1uKR{\u0007/[2QCJ$\u0018\u000e^5p]N#\u0018\r^3\u0015\u0011\u0005-\u00131`A\u007f\u0003\u007fDq!!3\u0011\u0001\u0004\tY\rC\u0004\u0002lB\u0001\r!!\u0005\t\u000f\u0005=\b\u00031\u0001\u0002r\u0006IR\u000f\u001d3bi\u0016$v\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f)!\u0011)Aa\u0003\u0003\u000e\t=\u0001\u0003BA'\u0005\u000fIAA!\u0003\u0002P\tq1+\u001a;ECR\f'+Z9vKN$\bbBAe#\u0001\u0007\u00111\u001a\u0005\b\u0003W\f\u0002\u0019AA\t\u0011\u001d\ty/\u0005a\u0001\u0003c\u0004")
public class ZkTopicMigrationClient
implements TopicMigrationClient,
Logging {
    private final KafkaZkClient zkClient;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public void iterateTopics(EnumSet<TopicMigrationClient.TopicVisitorInterest> interests, TopicMigrationClient.TopicVisitor visitor) {
        try {
            ZkTopicMigrationClient.$anonfun$iterateTopics$1(this, interests, visitor);
            return;
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public ZkMigrationLeadershipState createTopic(String topicName, Uuid topicId, java.util.Map<Integer, PartitionRegistration> partitions, Optional<MirrorTopic> mirrorTopic, ZkMigrationLeadershipState state) {
        try {
            return ZkTopicMigrationClient.$anonfun$createTopic$1(this, partitions, topicName, topicId, mirrorTopic, state);
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public ZkMigrationLeadershipState createTopic(String topicName, Uuid topicId, java.util.Map<Integer, PartitionRegistration> partitions, ZkMigrationLeadershipState state) {
        return this.createTopic(topicName, topicId, partitions, Optional.empty(), state);
    }

    private scala.collection.immutable.Seq<CreateRequest> createTopicPartitionZNodesRequests(String topicName, java.util.Map<Integer, PartitionRegistration> partitions, ZkMigrationLeadershipState state) {
        String path = TopicPartitionsZNode$.MODULE$.path(topicName);
        CreateRequest createPartitionsZNode = new CreateRequest(path, null, this.zkClient.defaultAcls(path), CreateMode.PERSISTENT, (Option<Object>)None$.MODULE$);
        scala.collection.immutable.Seq createPartitionZNodeReqs = (scala.collection.immutable.Seq)CollectionConverters$.MODULE$.MapHasAsScala(partitions).asScala().toSeq().flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                Integer partitionId = (Integer)x0$1._1();
                PartitionRegistration partition = (PartitionRegistration)x0$1._2();
                TopicPartition topicPartition = new TopicPartition(topicName, Predef$.MODULE$.Integer2int(partitionId));
                return new .colon.colon((Object)this.createTopicPartition(topicPartition), (List)new .colon.colon((Object)this.createTopicPartitionState(topicPartition, partition, state.kraftControllerEpoch()), (List)Nil$.MODULE$));
            }
            throw new MatchError(null);
        });
        return (scala.collection.immutable.Seq)new .colon.colon((Object)createPartitionsZNode, (List)Nil$.MODULE$).$plus$plus((IterableOnce)createPartitionZNodeReqs);
    }

    private void recursiveChildren(String path, ArrayBuffer<String> acc) {
        ((GetChildrenResponse)this.zkClient.retryRequestUntilConnected(new GetChildrenRequest(path, false, (Option<Object>)None$.MODULE$), this.zkClient.retryRequestUntilConnected$default$2())).children().foreach((Function1 & Serializable)child -> {
            this.recursiveChildren(new StringBuilder(1).append(path).append("/").append((String)child).toString(), acc);
            return (ArrayBuffer)acc.append((Object)new StringBuilder(1).append(path).append("/").append((String)child).toString());
        });
    }

    private scala.collection.immutable.Seq<String> recursiveChildren(String path) {
        ArrayBuffer buffer = new ArrayBuffer();
        this.recursiveChildren(path, (ArrayBuffer<String>)buffer);
        return buffer.toSeq();
    }

    public ZkMigrationLeadershipState updateTopic(String topicName, Uuid topicId, java.util.Map<Integer, PartitionRegistration> partitions, Optional<MirrorTopic> mirrorTopic, ZkMigrationLeadershipState state) {
        try {
            return ZkTopicMigrationClient.$anonfun$updateTopic$1(this, partitions, topicName, topicId, mirrorTopic, state);
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public ZkMigrationLeadershipState deleteTopic(String topicName, ZkMigrationLeadershipState state) {
        try {
            return ZkTopicMigrationClient.$anonfun$deleteTopic$1(this, topicName, state);
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public ZkMigrationLeadershipState createTopicPartitions(java.util.Map<String, java.util.Map<Integer, PartitionRegistration>> topicPartitions, ZkMigrationLeadershipState state) {
        try {
            return ZkTopicMigrationClient.$anonfun$createTopicPartitions$1(this, topicPartitions, state);
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    public ZkMigrationLeadershipState updateTopicPartitions(java.util.Map<String, java.util.Map<Integer, PartitionRegistration>> topicPartitions, ZkMigrationLeadershipState state) {
        try {
            return ZkTopicMigrationClient.$anonfun$updateTopicPartitions$1(this, topicPartitions, state);
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public ZkMigrationLeadershipState deleteTopicPartitions(java.util.Map<String, Set<Integer>> topicPartitions, ZkMigrationLeadershipState state) {
        void var6_6;
        Iterable requests = (Iterable)CollectionConverters$.MODULE$.MapHasAsScala(topicPartitions).asScala().flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String topicName = (String)x0$1._1();
                Set partitionIds = (Set)x0$1._2();
                return (scala.collection.mutable.Set)CollectionConverters$.MODULE$.SetHasAsScala(partitionIds).asScala().map((Function1 & Serializable)partitionId -> {
                    TopicPartition topicPartition = new TopicPartition(topicName, Predef$.MODULE$.Integer2int(partitionId));
                    String path = TopicPartitionZNode$.MODULE$.path(topicPartition);
                    return new DeleteRequest(path, ZkVersion$.MODULE$.MatchAnyVersion(), (Option<Object>)None$.MODULE$);
                });
            }
            throw new MatchError(null);
        });
        if (requests.isEmpty()) {
            return state;
        }
        Tuple2<Object, Seq<AsyncResponse>> tuple2 = this.zkClient.retryMigrationRequestsUntilConnected(requests.toSeq(), state);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int migrationZkVersion = tuple2._1$mcI$sp();
        Seq responses = (Seq)tuple2._2();
        scala.collection.immutable.Map resultCodes = ((IterableOnceOps)var6_6.map((Function1 & Serializable)response -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)response.path()), (Object)response.resultCode()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (resultCodes.forall((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)ZkTopicMigrationClient.$anonfun$deleteTopicPartitions$4(x0$2)))) {
            void var5_5;
            return state.withMigrationZkVersion((int)var5_5);
        }
        throw new MigrationClientException(new StringBuilder(64).append("Failed to delete partition states: ").append(topicPartitions).append(". ZK transaction had results ").append(resultCodes).toString());
    }

    private CreateRequest createTopicPartition(TopicPartition topicPartition) {
        try {
            return ZkTopicMigrationClient.$anonfun$createTopicPartition$1(this, topicPartition);
        }
        catch (Throwable throwable) {
            if (throwable instanceof MigrationClientException ? true : throwable instanceof MigrationClientAuthException) {
                throw throwable;
            }
            if (throwable instanceof KeeperException.AuthFailedException ? true : (throwable instanceof KeeperException.NoAuthException ? true : throwable instanceof KeeperException.SessionClosedRequireAuthException)) {
                throw new MigrationClientAuthException(throwable);
            }
            if (throwable instanceof KeeperException) {
                KeeperException keeperException = (KeeperException)throwable;
                throw new MigrationClientException((Throwable)keeperException);
            }
            throw throwable;
        }
    }

    private Tuple2<String, byte[]> partitionStatePathAndData(TopicPartition topicPartition, PartitionRegistration partitionRegistration, int controllerEpoch) {
        None$ none$;
        String path = TopicPartitionStateZNode$.MODULE$.path(topicPartition);
        PartitionRegistration.LinkState linkState = partitionRegistration.linkState;
        if (PartitionRegistration.LinkState.NOT_MIRROR.equals(linkState)) {
            none$ = None$.MODULE$;
        } else {
            boolean topicFailed = linkState.equals((Object)PartitionRegistration.LinkState.FAILED);
            MirrorTopicError error = topicFailed ? MirrorTopicError.UNKNOWN : MirrorTopicError.NO_ERROR;
            none$ = new Some((Object)new PartitionLinkState(partitionRegistration.linkedLeaderEpoch, topicFailed, error));
        }
        None$ linkState2 = none$;
        byte[] data = TopicPartitionStateZNode$.MODULE$.encode(new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(partitionRegistration.leader, partitionRegistration.leaderEpoch, (List<Object>)Predef$.MODULE$.wrapIntArray(partitionRegistration.isr).toList(), partitionRegistration.leaderRecoveryState, partitionRegistration.partitionEpoch, (Option<PartitionLinkState>)linkState2), controllerEpoch));
        return new Tuple2((Object)path, (Object)data);
    }

    /*
     * WARNING - void declaration
     */
    private CreateRequest createTopicPartitionState(TopicPartition topicPartition, PartitionRegistration partitionRegistration, int controllerEpoch) {
        void var6_6;
        void var5_5;
        Tuple2<String, byte[]> tuple2 = this.partitionStatePathAndData(topicPartition, partitionRegistration, controllerEpoch);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        String path = (String)tuple2._1();
        byte[] data = (byte[])tuple2._2();
        return new CreateRequest((String)var5_5, (byte[])var6_6, this.zkClient.defaultAcls((String)var5_5), CreateMode.PERSISTENT, (Option<Object>)new Some((Object)topicPartition));
    }

    /*
     * WARNING - void declaration
     */
    private SetDataRequest updateTopicPartitionState(TopicPartition topicPartition, PartitionRegistration partitionRegistration, int controllerEpoch) {
        void var6_6;
        void var5_5;
        Tuple2<String, byte[]> tuple2 = this.partitionStatePathAndData(topicPartition, partitionRegistration, controllerEpoch);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        String path = (String)tuple2._1();
        byte[] data = (byte[])tuple2._2();
        return new SetDataRequest((String)var5_5, (byte[])var6_6, ZkVersion$.MODULE$.MatchAnyVersion(), (Option<Object>)new Some((Object)topicPartition));
    }

    public static final /* synthetic */ void $anonfun$iterateTopics$7(ZkTopicMigrationClient $this, Option topicIdOpt$1, Map leaderIsrAndControllerEpochs$1, TopicMigrationClient.TopicVisitor visitor$1, Tuple2 x0$3) {
        if (x0$3 != null) {
            TopicPartition topicPartition = (TopicPartition)x0$3._1();
            ReplicaAssignment replicaAssignment = (ReplicaAssignment)x0$3._2();
            KRaftAssignment kraftAssignment = ConfluentAssignmentMigration$.MODULE$.fromZkToKRaftAssignment(replicaAssignment);
            java.util.List replicaList = CollectionConverters$.MODULE$.SeqHasAsJava(kraftAssignment.replicas()).asJava();
            PartitionRecord record = new PartitionRecord().setTopicId((Uuid)topicIdOpt$1.get()).setPartitionId(topicPartition.partition()).setReplicas(CollectionConverters$.MODULE$.SeqHasAsJava(kraftAssignment.replicas()).asJava()).setObservers(CollectionConverters$.MODULE$.SeqHasAsJava(kraftAssignment.observers()).asJava()).setAddingReplicas(CollectionConverters$.MODULE$.SeqHasAsJava(kraftAssignment.addingReplicas()).asJava()).setRemovingReplicas(CollectionConverters$.MODULE$.SeqHasAsJava(kraftAssignment.removingReplicas()).asJava()).setAddingObservers(CollectionConverters$.MODULE$.SeqHasAsJava(kraftAssignment.addingObservers()).asJava()).setRemovingObservers(CollectionConverters$.MODULE$.SeqHasAsJava(kraftAssignment.removingObservers()).asJava());
            Option option = leaderIsrAndControllerEpochs$1.get((Object)topicPartition);
            if (option instanceof Some) {
                LeaderIsrAndControllerEpoch leaderIsrAndEpoch = (LeaderIsrAndControllerEpoch)((Some)option).value();
                record.setIsr(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)leaderIsrAndEpoch.leaderAndIsr().isr().map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).asJava()).setLeader(leaderIsrAndEpoch.leaderAndIsr().leader()).setLeaderEpoch(leaderIsrAndEpoch.leaderAndIsr().leaderEpoch()).setPartitionEpoch(leaderIsrAndEpoch.leaderAndIsr().partitionEpoch()).setLeaderRecoveryState(leaderIsrAndEpoch.leaderAndIsr().leaderRecoveryState().value());
                leaderIsrAndEpoch.leaderAndIsr().clusterLinkState().foreach((Function1 & Serializable)state -> record.setLinkedLeaderEpoch(state.linkedLeaderEpoch()).setLinkState((state.linkFailed() ? PartitionRegistration.LinkState.FAILED : PartitionRegistration.LinkState.ACTIVE).levelCode));
            } else if (None$.MODULE$.equals(option)) {
                $this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(101).append("Could not find partition state in ZK for ").append(topicPartition).append(". Initializing this partition ").append("with ISR={").append(replicaList).append("} and leaderEpoch=0.").toString());
                record.setIsr(replicaList).setLeader(Predef$.MODULE$.Integer2int((Integer)replicaList.get(0))).setLeaderEpoch(0).setPartitionEpoch(0).setLeaderRecoveryState(LeaderRecoveryState.RECOVERED.value());
            } else {
                throw new MatchError((Object)option);
            }
            String logAndRethrow_msg = new StringBuilder(49).append("Error in partition consumer. TopicPartition was ").append(topicPartition).append(".").toString();
            try {
                visitor$1.visitPartition(new TopicIdPartition((Uuid)topicIdOpt$1.get(), topicPartition), new PartitionRegistration(record));
                return;
            }
            catch (Throwable logAndRethrow_e) {
                $this.error((Function0<String>)((Function0 & Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$1(logAndRethrow_msg)), (Function0<Throwable>)((Function0 & Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$2(logAndRethrow_e)));
                throw logAndRethrow_e;
            }
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$iterateTopics$2(ZkTopicMigrationClient $this, EnumSet interests$1, TopicMigrationClient.TopicVisitor visitor$1, TopicZNode.TopicIdReplicaAssignment x0$1) {
        if (x0$1 != null) {
            String topic = x0$1.topic();
            Option<Uuid> topicIdOpt = x0$1.topicId();
            Option<Uuid> legacyTopicIdOpt = x0$1.legacyTopicId();
            Map<TopicPartition, ReplicaAssignment> partitionAssignments = x0$1.assignment();
            Option<ClusterLinkTopicState> clusterLinkOpt = x0$1.clusterLink();
            if (legacyTopicIdOpt.isDefined()) {
                throw new RuntimeException("Cannot migrate legacy Confluent topic IDs. These should have been migrated to normal topic IDs already.");
            }
            Option mirrorTopic = interests$1.contains(TopicMigrationClient.TopicVisitorInterest.MIRROR_STATE) ? clusterLinkOpt.map((Function1 & Serializable)state -> {
                ClusterLinkMetadata linkMetadata = visitor$1.resolveClusterLink(state.linkId());
                if (linkMetadata == null) {
                    throw new RuntimeException(new StringBuilder(44).append("Unable to resolve the link ").append(state.linkName()).append(" of mirror topic ").append(topic).toString());
                }
                return MirrorTopic.fromRecord((MirrorTopicRecord)state.toMirrorTopicRecord(topic, (Uuid)topicIdOpt.get(), (Option<String>)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(linkMetadata.linkPrefix())), (Option<String>)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(linkMetadata.tenantPrefix()))));
            }) : Option$.MODULE$.empty();
            java.util.Map topicAssignment = CollectionConverters$.MODULE$.MapHasAsJava((Map)partitionAssignments.map((Function1 & Serializable)x0$2 -> {
                if (x0$2 != null) {
                    TopicPartition partition = (TopicPartition)x0$2._1();
                    ReplicaAssignment assignment = (ReplicaAssignment)x0$2._2();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition.partition())), (Object)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)assignment.replicas().map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).asJava());
                }
                throw new MatchError(null);
            }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
            String logAndRethrow_msg = new StringBuilder(36).append("Error in topic consumer. Topic was ").append(topic).append(".").toString();
            try {
                visitor$1.visitTopic(topic, (Uuid)topicIdOpt.get(), topicAssignment, OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(mirrorTopic)));
            }
            catch (Throwable logAndRethrow_e) {
                $this.error((Function0<String>)((Function0 & Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$1(logAndRethrow_msg)), (Function0<Throwable>)((Function0 & Serializable)() -> ZkMigrationClient$.$anonfun$logAndRethrow$2(logAndRethrow_e)));
                throw logAndRethrow_e;
            }
            Object var13_11 = null;
            if (interests$1.contains(TopicMigrationClient.TopicVisitorInterest.PARTITIONS)) {
                scala.collection.immutable.Seq partitions = partitionAssignments.keys().toSeq();
                Map<TopicPartition, LeaderIsrAndControllerEpoch> leaderIsrAndControllerEpochs = $this.zkClient.getTopicPartitionStates((Seq<TopicPartition>)partitions);
                partitionAssignments.foreach((Function1 & Serializable)x0$3 -> {
                    ZkTopicMigrationClient.$anonfun$iterateTopics$7($this, topicIdOpt, leaderIsrAndControllerEpochs, visitor$1, x0$3);
                    return BoxedUnit.UNIT;
                });
                return;
            }
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$iterateTopics$1(ZkTopicMigrationClient $this, EnumSet interests$1, TopicMigrationClient.TopicVisitor visitor$1) {
        if (!interests$1.contains(TopicMigrationClient.TopicVisitorInterest.TOPICS)) {
            throw new IllegalArgumentException("Must specify at least TOPICS in topic visitor interests.");
        }
        scala.collection.immutable.Set<String> topics = $this.zkClient.getAllTopicsInCluster($this.zkClient.getAllTopicsInCluster$default$1());
        $this.zkClient.getReplicaAssignmentAndTopicIdForTopics(topics).foreach((Function1 & Serializable)x0$1 -> {
            ZkTopicMigrationClient.$anonfun$iterateTopics$2($this, interests$1, visitor$1, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$createTopic$5(Tuple2 x0$2) {
        if (x0$2 != null) {
            return ((KeeperException.Code)x0$2._2()).equals((Object)KeeperException.Code.OK);
        }
        throw new MatchError(null);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ ZkMigrationLeadershipState $anonfun$createTopic$1(ZkTopicMigrationClient $this, java.util.Map partitions$1, String topicName$1, Uuid topicId$1, Optional mirrorTopic$2, ZkMigrationLeadershipState state$1) {
        void var13_13;
        scala.collection.immutable.Seq<CreateRequest> createPartitionZNodeReqs;
        scala.collection.mutable.Map assignments = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(partitions$1).asScala().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                Integer partitionId = (Integer)x0$1._1();
                PartitionRegistration partition = (PartitionRegistration)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topicName$1, Predef$.MODULE$.Integer2int(partitionId))), (Object)ConfluentAssignmentMigration$.MODULE$.fromKRaftToZkAssignment(partition));
            }
            throw new MatchError(null);
        });
        String path = TopicZNode$.MODULE$.path(topicName$1);
        CreateRequest createTopicZNode = new CreateRequest(path, TopicZNode$.MODULE$.encode((Option<Uuid>)new Some((Object)topicId$1), (Option<Uuid>)None$.MODULE$, (Map<TopicPartition, ReplicaAssignment>)assignments, (Option<ClusterLinkTopicState>)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(mirrorTopic$2)).map((Function1 & Serializable)x$1 -> ClusterLinkTopicState$.MODULE$.apply((MirrorTopic)x$1))), $this.zkClient.defaultAcls(path), CreateMode.PERSISTENT, (Option<Object>)None$.MODULE$);
        scala.collection.immutable.Seq requests = (scala.collection.immutable.Seq)new .colon.colon((Object)createTopicZNode, (List)Nil$.MODULE$).$plus$plus(createPartitionZNodeReqs = $this.createTopicPartitionZNodesRequests(topicName$1, partitions$1, state$1));
        Tuple2<Object, Seq<AsyncResponse>> tuple2 = $this.zkClient.retryMigrationRequestsUntilConnected(requests, state$1);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int migrationZkVersion = tuple2._1$mcI$sp();
        Seq responses = (Seq)tuple2._2();
        scala.collection.immutable.Map resultCodes = ((IterableOnceOps)var13_13.map((Function1 & Serializable)response -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)response.path()), (Object)response.resultCode()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (((Enum)resultCodes.apply((Object)TopicZNode$.MODULE$.path(topicName$1))).equals(KeeperException.Code.NODEEXISTS)) {
            return state$1;
        }
        if (resultCodes.forall((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)ZkTopicMigrationClient.$anonfun$createTopic$5(x0$2)))) {
            void var12_12;
            return state$1.withMigrationZkVersion((int)var12_12);
        }
        throw new MigrationClientException(new StringBuilder(61).append("Failed to create or update topic ").append(topicName$1).append(". ZK operations had results ").append(resultCodes).toString());
    }

    public static final /* synthetic */ boolean $anonfun$updateTopic$5(Tuple2 x0$2) {
        if (x0$2 != null) {
            return ((KeeperException.Code)x0$2._2()).equals((Object)KeeperException.Code.OK);
        }
        throw new MatchError(null);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ ZkMigrationLeadershipState $anonfun$updateTopic$1(ZkTopicMigrationClient $this, java.util.Map partitions$2, String topicName$3, Uuid topicId$2, Optional mirrorTopic$3, ZkMigrationLeadershipState state$3) {
        void var10_10;
        scala.collection.mutable.Map assignments = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(partitions$2).asScala().map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                Integer partitionId = (Integer)x0$1._1();
                PartitionRegistration partition = (PartitionRegistration)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topicName$3, Predef$.MODULE$.Integer2int(partitionId))), (Object)new ReplicaAssignment((Seq<Object>)Predef$.MODULE$.wrapIntArray(partition.replicas), (Seq<Object>)Predef$.MODULE$.wrapIntArray(partition.addingReplicas), (Seq<Object>)Predef$.MODULE$.wrapIntArray(partition.removingReplicas), (Seq<Object>)((Seq)package$.MODULE$.Seq().empty()), (Option<Seq<Object>>)None$.MODULE$));
            }
            throw new MatchError(null);
        });
        SetDataRequest request = new SetDataRequest(TopicZNode$.MODULE$.path(topicName$3), TopicZNode$.MODULE$.encode((Option<Uuid>)new Some((Object)topicId$2), (Option<Uuid>)None$.MODULE$, (Map<TopicPartition, ReplicaAssignment>)assignments, (Option<ClusterLinkTopicState>)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(mirrorTopic$3)).map((Function1 & Serializable)x$3 -> ClusterLinkTopicState$.MODULE$.apply((MirrorTopic)x$3))), ZkVersion$.MODULE$.MatchAnyVersion(), (Option<Object>)None$.MODULE$);
        Tuple2<Object, Seq<AsyncResponse>> tuple2 = $this.zkClient.retryMigrationRequestsUntilConnected(new .colon.colon((Object)request, (List)Nil$.MODULE$), state$3);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int migrationZkVersion = tuple2._1$mcI$sp();
        Seq responses = (Seq)tuple2._2();
        scala.collection.immutable.Map resultCodes = ((IterableOnceOps)var10_10.map((Function1 & Serializable)response -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)response.path()), (Object)response.resultCode()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (resultCodes.forall((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)ZkTopicMigrationClient.$anonfun$updateTopic$5(x0$2)))) {
            void var9_9;
            return state$3.withMigrationZkVersion((int)var9_9);
        }
        throw new MigrationClientException(new StringBuilder(62).append("Failed to update topic metadata: ").append(topicName$3).append(". ZK transaction had results ").append(resultCodes).toString());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ ZkMigrationLeadershipState $anonfun$deleteTopic$1(ZkTopicMigrationClient $this, String topicName$4, ZkMigrationLeadershipState state$4) {
        void var7_7;
        String topicPath = TopicZNode$.MODULE$.path(topicName$4);
        scala.collection.immutable.Seq deleteRequests = (scala.collection.immutable.Seq)((IterableOps)$this.recursiveChildren(topicPath).map((Function1 & Serializable)childPath -> new DeleteRequest((String)childPath, ZkVersion$.MODULE$.MatchAnyVersion(), (Option<Object>)None$.MODULE$))).$plus$plus((IterableOnce)new .colon.colon((Object)new DeleteRequest(ConfigEntityZNode$.MODULE$.path(ConfigType$.MODULE$.Topic(), topicName$4), ZkVersion$.MODULE$.MatchAnyVersion(), (Option<Object>)None$.MODULE$), (List)new .colon.colon((Object)new DeleteRequest(TopicZNode$.MODULE$.path(topicName$4), ZkVersion$.MODULE$.MatchAnyVersion(), (Option<Object>)None$.MODULE$), (List)Nil$.MODULE$)));
        Tuple2<Object, Seq<AsyncResponse>> tuple2 = $this.zkClient.retryMigrationRequestsUntilConnected(deleteRequests, state$4);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int migrationZkVersion = tuple2._1$mcI$sp();
        Seq responses = (Seq)tuple2._2();
        scala.collection.immutable.Map resultCodes = ((IterableOnceOps)var7_7.map((Function1 & Serializable)response -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)response.path()), (Object)response.resultCode()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (((DeleteResponse)var7_7.last()).resultCode().equals((Object)KeeperException.Code.OK)) {
            void var6_6;
            return state$4.withMigrationZkVersion((int)var6_6);
        }
        throw new MigrationClientException(new StringBuilder(51).append("Failed to delete topic ").append(topicName$4).append(". ZK operations had results ").append(resultCodes).toString());
    }

    public static final /* synthetic */ boolean $anonfun$createTopicPartitions$4(Tuple2 x0$2) {
        if (x0$2 != null) {
            KeeperException.Code code = (KeeperException.Code)x0$2._2();
            return code.equals((Object)KeeperException.Code.OK) || code.equals((Object)KeeperException.Code.NODEEXISTS);
        }
        throw new MatchError(null);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ ZkMigrationLeadershipState $anonfun$createTopicPartitions$1(ZkTopicMigrationClient $this, java.util.Map topicPartitions$1, ZkMigrationLeadershipState state$5) {
        void var6_6;
        scala.collection.immutable.Seq requests = (scala.collection.immutable.Seq)CollectionConverters$.MODULE$.MapHasAsScala(topicPartitions$1).asScala().toSeq().flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String topicName = (String)x0$1._1();
                java.util.Map partitions = (java.util.Map)x0$1._2();
                return $this.createTopicPartitionZNodesRequests(topicName, partitions, state$5);
            }
            throw new MatchError(null);
        });
        Tuple2<Object, Seq<AsyncResponse>> tuple2 = $this.zkClient.retryMigrationRequestsUntilConnected(requests, state$5);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int migrationZkVersion = tuple2._1$mcI$sp();
        Seq responses = (Seq)tuple2._2();
        scala.collection.immutable.Map resultCodes = ((IterableOnceOps)var6_6.map((Function1 & Serializable)response -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)response.path()), (Object)response.resultCode()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (resultCodes.forall((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)ZkTopicMigrationClient.$anonfun$createTopicPartitions$4(x0$2)))) {
            void var5_5;
            return state$5.withMigrationZkVersion((int)var5_5);
        }
        throw new MigrationClientException(new StringBuilder(64).append("Failed to create partition states: ").append(topicPartitions$1).append(". ZK transaction had results ").append(resultCodes).toString());
    }

    public static final /* synthetic */ boolean $anonfun$updateTopicPartitions$5(Tuple2 x0$3) {
        if (x0$3 != null) {
            return ((KeeperException.Code)x0$3._2()).equals((Object)KeeperException.Code.OK);
        }
        throw new MatchError(null);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ ZkMigrationLeadershipState $anonfun$updateTopicPartitions$1(ZkTopicMigrationClient $this, java.util.Map topicPartitions$2, ZkMigrationLeadershipState state$6) {
        void var6_6;
        Iterable requests = (Iterable)CollectionConverters$.MODULE$.MapHasAsScala(topicPartitions$2).asScala().flatMap((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String topicName = (String)x0$1._1();
                java.util.Map partitionRegistrations = (java.util.Map)x0$1._2();
                return (Iterable)CollectionConverters$.MODULE$.MapHasAsScala(partitionRegistrations).asScala().flatMap((Function1 & Serializable)x0$2 -> {
                    if (x0$2 != null) {
                        Integer partitionId = (Integer)x0$2._1();
                        PartitionRegistration partitionRegistration = (PartitionRegistration)x0$2._2();
                        TopicPartition topicPartition = new TopicPartition(topicName, Predef$.MODULE$.Integer2int(partitionId));
                        return new .colon.colon((Object)$this.updateTopicPartitionState(topicPartition, partitionRegistration, state$6.kraftControllerEpoch()), (List)Nil$.MODULE$);
                    }
                    throw new MatchError(null);
                });
            }
            throw new MatchError(null);
        });
        if (requests.isEmpty()) {
            return state$6;
        }
        Tuple2<Object, Seq<AsyncResponse>> tuple2 = $this.zkClient.retryMigrationRequestsUntilConnected(requests.toSeq(), state$6);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int migrationZkVersion = tuple2._1$mcI$sp();
        Seq responses = (Seq)tuple2._2();
        scala.collection.immutable.Map resultCodes = ((IterableOnceOps)var6_6.map((Function1 & Serializable)response -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)response.path()), (Object)response.resultCode()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        if (resultCodes.forall((Function1 & Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)ZkTopicMigrationClient.$anonfun$updateTopicPartitions$5(x0$3)))) {
            void var5_5;
            return state$6.withMigrationZkVersion((int)var5_5);
        }
        throw new MigrationClientException(new StringBuilder(64).append("Failed to update partition states: ").append(topicPartitions$2).append(". ZK transaction had results ").append(resultCodes).toString());
    }

    public static final /* synthetic */ boolean $anonfun$deleteTopicPartitions$4(Tuple2 x0$2) {
        if (x0$2 != null) {
            return ((KeeperException.Code)x0$2._2()).equals((Object)KeeperException.Code.OK);
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ CreateRequest $anonfun$createTopicPartition$1(ZkTopicMigrationClient $this, TopicPartition topicPartition$2) {
        String path = TopicPartitionZNode$.MODULE$.path(topicPartition$2);
        return new CreateRequest(path, null, $this.zkClient.defaultAcls(path), CreateMode.PERSISTENT, (Option<Object>)new Some((Object)topicPartition$2));
    }

    public ZkTopicMigrationClient(KafkaZkClient zkClient) {
        this.zkClient = zkClient;
    }
}

