/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.auth;

import com.google.common.annotations.VisibleForTesting;
import io.vertx.core.Handler;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.auth.authorization.AuthorizationContext;
import io.vertx.ext.auth.authorization.OrAuthorization;
import io.vertx.ext.auth.authorization.RoleBasedAuthorization;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.AuthorizationHandler;
import java.util.List;
import java.util.stream.Collectors;

public class RoleBasedAuthZHandler
implements Handler<RoutingContext> {
    private final Authorization delegate;
    private final AuthorizationHandler handler;

    public RoleBasedAuthZHandler(List<String> allowedRoles) {
        List parsedRoles = allowedRoles.stream().filter(role -> !"*".equals(role)).map(role -> "**".equals(role) ? "*" : role).collect(Collectors.toList());
        this.delegate = parsedRoles.contains("*") ? StarAuthHandler.INSTANCE : (Authorization)parsedRoles.stream().reduce(OrAuthorization.create(), (auth, role) -> auth.addAuthorization((Authorization)RoleBasedAuthorization.create((String)role)), OrAuthorization::addAuthorization);
        this.handler = AuthorizationHandler.create((Authorization)this.delegate);
    }

    public void handle(RoutingContext rc) {
        this.handler.handle((Object)rc);
    }

    @VisibleForTesting
    Authorization getDelegate() {
        return this.delegate;
    }

    private static class StarAuthHandler
    implements Authorization {
        private static final StarAuthHandler INSTANCE = new StarAuthHandler();

        private StarAuthHandler() {
        }

        public boolean match(AuthorizationContext context) {
            return true;
        }

        public boolean verify(Authorization authorization) {
            return true;
        }
    }
}

