/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.server;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.api.server.InsertsStreamResponseWriter;
import io.confluent.ksql.api.server.ServerUtils;
import io.confluent.ksql.rest.entity.InsertAck;
import io.confluent.ksql.rest.entity.InsertError;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerResponse;
import java.util.Objects;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonInsertsStreamResponseWriter
implements InsertsStreamResponseWriter {
    private static final Logger LOG = LoggerFactory.getLogger(JsonInsertsStreamResponseWriter.class);
    protected final HttpServerResponse response;
    private final UUID uuid;
    private boolean dataWritten;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public JsonInsertsStreamResponseWriter(HttpServerResponse response, UUID uuid) {
        this.response = Objects.requireNonNull(response);
        this.uuid = uuid;
    }

    @Override
    public InsertsStreamResponseWriter writeInsertResponse(InsertAck insertAck) {
        this.writeBuffer(ServerUtils.serializeObject(insertAck));
        return this;
    }

    @Override
    public InsertsStreamResponseWriter writeError(InsertError error) {
        this.writeBuffer(ServerUtils.serializeObject(error));
        return this;
    }

    @Override
    public void end() {
        LOG.debug("({}) Ending response for insert stream. Data written: {}", (Object)this.uuid, (Object)this.dataWritten);
        if (!this.dataWritten) {
            this.response.write("[]");
        } else {
            this.response.write("]");
        }
        this.response.end();
    }

    private void writeBuffer(Buffer buffer) {
        if (this.dataWritten) {
            Buffer buff = Buffer.buffer().appendByte((byte)44);
            buff.appendBuffer(buffer);
            this.response.write((Object)buff);
        } else {
            Buffer buff = Buffer.buffer().appendByte((byte)91);
            buff.appendBuffer(buffer);
            this.response.write((Object)buff);
            this.dataWritten = true;
        }
    }
}

