/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.server;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.api.server.QueryStreamResponseWriter;
import io.confluent.ksql.api.server.ServerUtils;
import io.confluent.ksql.rest.entity.ConsistencyToken;
import io.confluent.ksql.rest.entity.KsqlErrorMessage;
import io.confluent.ksql.rest.entity.PushContinuationToken;
import io.confluent.ksql.rest.entity.QueryResponseMetadata;
import io.confluent.ksql.util.KeyValue;
import io.confluent.ksql.util.KeyValueMetadata;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerResponse;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonQueryStreamResponseWriter
implements QueryStreamResponseWriter {
    private static final Logger LOG = LoggerFactory.getLogger(JsonQueryStreamResponseWriter.class);
    private final HttpServerResponse response;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public JsonQueryStreamResponseWriter(HttpServerResponse response) {
        this.response = Objects.requireNonNull(response);
    }

    @Override
    public QueryStreamResponseWriter writeMetadata(QueryResponseMetadata metaData) {
        Buffer buff = Buffer.buffer().appendByte((byte)91);
        buff.appendBuffer(ServerUtils.serializeObject(metaData));
        this.response.write((Object)buff);
        return this;
    }

    @Override
    public QueryStreamResponseWriter writeRow(KeyValueMetadata<List<?>, GenericRow> keyValueMetadata) {
        KeyValue keyValue = keyValueMetadata.getKeyValue();
        if (keyValue.value() == null) {
            LOG.warn("Dropped tombstone. Not currently supported");
        } else {
            this.writeBuffer(ServerUtils.serializeObject(((GenericRow)keyValue.value()).values()));
        }
        return this;
    }

    @Override
    public QueryStreamResponseWriter writeContinuationToken(PushContinuationToken pushContinuationToken) {
        this.writeBuffer(ServerUtils.serializeObject(pushContinuationToken));
        return this;
    }

    @Override
    public QueryStreamResponseWriter writeError(KsqlErrorMessage error) {
        this.writeBuffer(ServerUtils.serializeObject(error));
        return this;
    }

    @Override
    public QueryStreamResponseWriter writeConsistencyToken(ConsistencyToken consistencyToken) {
        this.writeBuffer(ServerUtils.serializeObject(consistencyToken));
        return this;
    }

    @Override
    public QueryStreamResponseWriter writeCompletionMessage() {
        return this;
    }

    @Override
    public QueryStreamResponseWriter writeLimitMessage() {
        return this;
    }

    private void writeBuffer(Buffer buffer) {
        Buffer buff = Buffer.buffer().appendByte((byte)44);
        buff.appendBuffer(buffer);
        this.response.write((Object)buff);
    }

    @Override
    public void end() {
        this.response.write("]");
        this.response.end();
    }
}

