/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.server;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.api.server.FailureHandler;
import io.confluent.ksql.api.server.KsqlCorsHandler;
import io.confluent.ksql.api.server.ServerStateHandler;
import io.confluent.ksql.api.util.ApiServerUtils;
import io.confluent.ksql.rest.server.KsqlRestConfig;
import io.confluent.ksql.rest.server.state.ServerState;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.ext.web.Router;
import java.util.Objects;

public class PreconditionVerticle
extends AbstractVerticle {
    private final HttpServerOptions httpServerOptions;
    private final ServerState serverState;
    private HttpServer httpServer;
    private KsqlRestConfig restConfig;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public PreconditionVerticle(HttpServerOptions httpServerOptions, ServerState serverState, KsqlRestConfig restConfig) {
        this.httpServerOptions = Objects.requireNonNull(httpServerOptions);
        this.serverState = Objects.requireNonNull(serverState, "serverState");
        this.restConfig = Objects.requireNonNull(restConfig, "restConfig");
    }

    public void start(Promise<Void> startPromise) {
        this.httpServer = this.vertx.createHttpServer(this.httpServerOptions).requestHandler((Handler)this.setupRouter()).exceptionHandler(ApiServerUtils::unhandledExceptionHandler);
        this.httpServer.listen(ar -> {
            if (ar.succeeded()) {
                startPromise.complete();
            } else {
                startPromise.fail(ar.cause());
            }
        });
    }

    public void stop(Promise<Void> stopPromise) {
        if (this.httpServer == null) {
            stopPromise.complete();
        } else {
            this.httpServer.close(ar -> stopPromise.complete());
        }
    }

    private Router setupRouter() {
        Router router = Router.router((Vertx)this.vertx);
        KsqlCorsHandler.setupCorsHandler(this.restConfig, router);
        router.route(HttpMethod.GET, "/chc/ready").handler(ApiServerUtils::chcHandler);
        router.route(HttpMethod.GET, "/chc/live").handler(ApiServerUtils::chcHandler);
        router.route().handler((Handler)new ServerStateHandler(this.serverState));
        router.route().failureHandler((Handler)new FailureHandler());
        return router;
    }
}

