/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.server;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.api.auth.DefaultApiSecurityContext;
import io.confluent.ksql.api.server.AuthHandlers;
import io.confluent.ksql.api.server.CloseQueryHandler;
import io.confluent.ksql.api.server.ConnectionQueryManager;
import io.confluent.ksql.api.server.FailureHandler;
import io.confluent.ksql.api.server.InsertsStreamHandler;
import io.confluent.ksql.api.server.InternalEndpointHandler;
import io.confluent.ksql.api.server.KsqlCorsHandler;
import io.confluent.ksql.api.server.LoggingHandler;
import io.confluent.ksql.api.server.LoggingRateLimiter;
import io.confluent.ksql.api.server.MetricsCallbackHolder;
import io.confluent.ksql.api.server.OldApiUtils;
import io.confluent.ksql.api.server.QueryStreamHandler;
import io.confluent.ksql.api.server.Server;
import io.confluent.ksql.api.server.ServerStateHandler;
import io.confluent.ksql.api.server.SniHandler;
import io.confluent.ksql.api.spi.Endpoints;
import io.confluent.ksql.rest.entity.ClusterTerminateRequest;
import io.confluent.ksql.rest.entity.HeartbeatMessage;
import io.confluent.ksql.rest.entity.KsqlMediaType;
import io.confluent.ksql.rest.entity.KsqlRequest;
import io.confluent.ksql.rest.entity.LagReportingMessage;
import io.netty.handler.codec.haproxy.HAProxyProtocolException;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.BodyHandler;
import java.nio.channels.ClosedChannelException;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerVerticle
extends AbstractVerticle {
    private static final Logger log = LoggerFactory.getLogger(ServerVerticle.class);
    private static final String JSON_CONTENT_TYPE = "application/json";
    private static final String DELIMITED_CONTENT_TYPE = "application/vnd.ksqlapi.delimited.v1";
    private final Endpoints endpoints;
    private final HttpServerOptions httpServerOptions;
    private final Server server;
    private ConnectionQueryManager connectionQueryManager;
    private HttpServer httpServer;
    private final Optional<Boolean> isInternalListener;
    private final LoggingRateLimiter loggingRateLimiter;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public ServerVerticle(Endpoints endpoints, HttpServerOptions httpServerOptions, Server server, Optional<Boolean> isInternalListener, LoggingRateLimiter loggingRateLimiter) {
        this.endpoints = Objects.requireNonNull(endpoints);
        this.httpServerOptions = Objects.requireNonNull(httpServerOptions);
        this.server = Objects.requireNonNull(server);
        this.isInternalListener = Objects.requireNonNull(isInternalListener);
        this.loggingRateLimiter = Objects.requireNonNull(loggingRateLimiter);
    }

    public void start(Promise<Void> startPromise) {
        this.connectionQueryManager = new ConnectionQueryManager(this.context, this.server);
        this.httpServer = this.vertx.createHttpServer(this.httpServerOptions).requestHandler((Handler)this.setupRouter()).exceptionHandler(ServerVerticle::unhandledExceptionHandler);
        this.httpServer.listen(ar -> {
            if (ar.succeeded()) {
                startPromise.complete();
            } else {
                startPromise.fail(ar.cause());
            }
        });
    }

    public void stop(Promise<Void> stopPromise) {
        if (this.httpServer == null) {
            stopPromise.complete();
        } else {
            this.httpServer.close(ar -> stopPromise.complete());
        }
    }

    int actualPort() {
        return this.httpServer.actualPort();
    }

    private Router setupRouter() {
        Router router = Router.router((Vertx)this.vertx);
        router.route().handler((Handler)new LoggingHandler(this.server, this.loggingRateLimiter));
        if (this.server.getConfig().getBoolean("ksql.server.sni.check.enable").booleanValue()) {
            router.route().handler((Handler)new SniHandler());
        }
        KsqlCorsHandler.setupCorsHandler(this.server.getConfig(), router);
        router.route(HttpMethod.GET, "/chc/ready").handler(ServerVerticle::chcHandler);
        router.route(HttpMethod.GET, "/chc/live").handler(ServerVerticle::chcHandler);
        router.route().failureHandler((Handler)new FailureHandler());
        this.isInternalListener.ifPresent(isInternal -> router.route().handler((Handler)new InternalEndpointHandler((boolean)isInternal)));
        AuthHandlers.setupAuthHandlers(this.server, router, this.isInternalListener.orElse(false));
        router.route().handler((Handler)new ServerStateHandler(this.server.getServerState()));
        router.route(HttpMethod.POST, "/query-stream").produces(DELIMITED_CONTENT_TYPE).produces(JSON_CONTENT_TYPE).produces(KsqlMediaType.KSQL_V1_JSON.mediaType()).handler((Handler)BodyHandler.create((boolean)false)).handler((Handler)new QueryStreamHandler(this.endpoints, this.connectionQueryManager, this.context, this.server, false));
        router.route(HttpMethod.POST, "/query-stream").produces(KsqlMediaType.KSQL_V1_PROTOBUF.mediaType()).handler((Handler)BodyHandler.create((boolean)false)).handler((Handler)new QueryStreamHandler(this.endpoints, this.connectionQueryManager, this.context, this.server, false));
        router.route(HttpMethod.POST, "/inserts-stream").produces(DELIMITED_CONTENT_TYPE).produces(JSON_CONTENT_TYPE).handler((Handler)new InsertsStreamHandler(this.context, this.endpoints, this.server));
        router.route(HttpMethod.POST, "/close-query").handler((Handler)BodyHandler.create((boolean)false)).handler((Handler)new CloseQueryHandler(this.server));
        router.route(HttpMethod.GET, "/").handler(ServerVerticle::handleInfoRedirect);
        router.route(HttpMethod.POST, "/ksql").handler((Handler)BodyHandler.create((boolean)false)).produces(KsqlMediaType.KSQL_V1_JSON.mediaType()).produces(JSON_CONTENT_TYPE).handler(this::handleKsqlRequest);
        router.route(HttpMethod.POST, "/ksql/terminate").handler((Handler)BodyHandler.create((boolean)false)).produces(KsqlMediaType.KSQL_V1_JSON.mediaType()).produces(JSON_CONTENT_TYPE).handler(this::handleTerminateRequest);
        router.route(HttpMethod.POST, "/query").handler((Handler)BodyHandler.create((boolean)false)).produces(KsqlMediaType.KSQL_V1_JSON.mediaType()).produces(JSON_CONTENT_TYPE).handler(this::handleQueryRequest);
        router.route(HttpMethod.POST, "/query").handler((Handler)BodyHandler.create((boolean)false)).produces(DELIMITED_CONTENT_TYPE).produces(KsqlMediaType.KSQL_V1_JSON.mediaType()).produces(JSON_CONTENT_TYPE).handler((Handler)new QueryStreamHandler(this.endpoints, this.connectionQueryManager, this.context, this.server, true));
        router.route(HttpMethod.POST, "/query").handler((Handler)BodyHandler.create((boolean)false)).produces(KsqlMediaType.KSQL_V1_PROTOBUF.mediaType()).handler((Handler)new QueryStreamHandler(this.endpoints, this.connectionQueryManager, this.context, this.server, true));
        router.route(HttpMethod.GET, "/info").produces(KsqlMediaType.KSQL_V1_JSON.mediaType()).produces(JSON_CONTENT_TYPE).handler(this::handleInfoRequest);
        router.route(HttpMethod.POST, "/heartbeat").handler((Handler)BodyHandler.create((boolean)false)).produces(KsqlMediaType.KSQL_V1_JSON.mediaType()).produces(JSON_CONTENT_TYPE).handler(this::handleHeartbeatRequest);
        router.route(HttpMethod.GET, "/clusterStatus").produces(KsqlMediaType.KSQL_V1_JSON.mediaType()).produces(JSON_CONTENT_TYPE).handler(this::handleClusterStatusRequest);
        router.route(HttpMethod.GET, "/status/:type/:entity/:action").produces(KsqlMediaType.KSQL_V1_JSON.mediaType()).produces(JSON_CONTENT_TYPE).handler(this::handleStatusRequest);
        router.route(HttpMethod.GET, "/status").produces(KsqlMediaType.KSQL_V1_JSON.mediaType()).produces(JSON_CONTENT_TYPE).handler(this::handleAllStatusesRequest);
        router.route(HttpMethod.POST, "/lag").handler((Handler)BodyHandler.create((boolean)false)).produces(KsqlMediaType.KSQL_V1_JSON.mediaType()).produces(JSON_CONTENT_TYPE).handler(this::handleLagReportRequest);
        router.route(HttpMethod.GET, "/healthcheck").produces(KsqlMediaType.KSQL_V1_JSON.mediaType()).produces(JSON_CONTENT_TYPE).handler(this::handleHealthcheckRequest);
        router.route(HttpMethod.GET, "/v1/metadata").produces(KsqlMediaType.KSQL_V1_JSON.mediaType()).produces(JSON_CONTENT_TYPE).handler(this::handleServerMetadataRequest);
        router.route(HttpMethod.GET, "/v1/metadata/id").produces(KsqlMediaType.KSQL_V1_JSON.mediaType()).produces(JSON_CONTENT_TYPE).handler(this::handleServerMetadataClusterIdRequest);
        router.route(HttpMethod.GET, "/ws/query").produces(KsqlMediaType.KSQL_V1_JSON.mediaType()).produces(JSON_CONTENT_TYPE).handler(this::handleWebsocket);
        router.route(HttpMethod.GET, "/is_valid_property/:property").produces(KsqlMediaType.KSQL_V1_JSON.mediaType()).produces(JSON_CONTENT_TYPE).handler(this::handleIsValidPropertyRequest);
        router.route(HttpMethod.POST, "/test").handler((Handler)BodyHandler.create((boolean)false)).produces(KsqlMediaType.KSQL_V1_JSON.mediaType()).handler(this::handleTest);
        return router;
    }

    private void handleKsqlRequest(RoutingContext routingContext) {
        OldApiUtils.handleOldApiRequest(this.server, routingContext, KsqlRequest.class, Optional.empty(), (ksqlRequest, apiSecurityContext) -> this.endpoints.executeKsqlRequest((KsqlRequest)ksqlRequest, this.server.getWorkerExecutor(), DefaultApiSecurityContext.create(routingContext, this.server)));
    }

    private void handleTerminateRequest(RoutingContext routingContext) {
        OldApiUtils.handleOldApiRequest(this.server, routingContext, ClusterTerminateRequest.class, Optional.empty(), (request, apiSecurityContext) -> this.endpoints.executeTerminate((ClusterTerminateRequest)request, this.server.getWorkerExecutor(), DefaultApiSecurityContext.create(routingContext, this.server)));
    }

    private void handleQueryRequest(RoutingContext routingContext) {
        CompletableFuture connectionClosedFuture = new CompletableFuture();
        routingContext.request().connection().closeHandler(v -> connectionClosedFuture.complete(null));
        MetricsCallbackHolder metricsCallbackHolder = new MetricsCallbackHolder();
        OldApiUtils.handleOldApiRequest(this.server, routingContext, KsqlRequest.class, Optional.of(metricsCallbackHolder), (request, apiSecurityContext) -> this.endpoints.executeQueryRequest((KsqlRequest)request, this.server.getWorkerExecutor(), connectionClosedFuture, DefaultApiSecurityContext.create(routingContext, this.server), ServerVerticle.isInternalRequest(routingContext), ServerVerticle.getContentType(routingContext), metricsCallbackHolder, this.context));
    }

    private void handleInfoRequest(RoutingContext routingContext) {
        OldApiUtils.handleOldApiRequest(this.server, routingContext, null, Optional.empty(), (request, apiSecurityContext) -> this.endpoints.executeInfo(DefaultApiSecurityContext.create(routingContext, this.server)));
    }

    private void handleClusterStatusRequest(RoutingContext routingContext) {
        OldApiUtils.handleOldApiRequest(this.server, routingContext, null, Optional.empty(), (request, apiSecurityContext) -> this.endpoints.executeClusterStatus(DefaultApiSecurityContext.create(routingContext, this.server)));
    }

    private void handleHeartbeatRequest(RoutingContext routingContext) {
        OldApiUtils.handleOldApiRequest(this.server, routingContext, HeartbeatMessage.class, Optional.empty(), (request, apiSecurityContext) -> this.endpoints.executeHeartbeat((HeartbeatMessage)request, DefaultApiSecurityContext.create(routingContext, this.server)));
    }

    private void handleStatusRequest(RoutingContext routingContext) {
        HttpServerRequest request = routingContext.request();
        String type = request.getParam("type");
        String entity = request.getParam("entity");
        String action = request.getParam("action");
        OldApiUtils.handleOldApiRequest(this.server, routingContext, null, Optional.empty(), (r, apiSecurityContext) -> this.endpoints.executeStatus(type, entity, action, DefaultApiSecurityContext.create(routingContext, this.server)));
    }

    private void handleIsValidPropertyRequest(RoutingContext routingContext) {
        HttpServerRequest request = routingContext.request();
        String property = request.getParam("property");
        OldApiUtils.handleOldApiRequest(this.server, routingContext, null, Optional.empty(), (ksqlRequest, apiSecurityContext) -> this.endpoints.executeIsValidProperty(property, this.server.getWorkerExecutor(), DefaultApiSecurityContext.create(routingContext, this.server)));
    }

    private void handleAllStatusesRequest(RoutingContext routingContext) {
        OldApiUtils.handleOldApiRequest(this.server, routingContext, null, Optional.empty(), (r, apiSecurityContext) -> this.endpoints.executeAllStatuses(DefaultApiSecurityContext.create(routingContext, this.server)));
    }

    private void handleLagReportRequest(RoutingContext routingContext) {
        OldApiUtils.handleOldApiRequest(this.server, routingContext, LagReportingMessage.class, Optional.empty(), (request, apiSecurityContext) -> this.endpoints.executeLagReport((LagReportingMessage)request, DefaultApiSecurityContext.create(routingContext, this.server)));
    }

    private void handleHealthcheckRequest(RoutingContext routingContext) {
        OldApiUtils.handleOldApiRequest(this.server, routingContext, null, Optional.empty(), (request, apiSecurityContext) -> this.endpoints.executeCheckHealth(DefaultApiSecurityContext.create(routingContext, this.server)));
    }

    private void handleServerMetadataRequest(RoutingContext routingContext) {
        OldApiUtils.handleOldApiRequest(this.server, routingContext, null, Optional.empty(), (request, apiSecurityContext) -> this.endpoints.executeServerMetadata(DefaultApiSecurityContext.create(routingContext, this.server)));
    }

    private void handleServerMetadataClusterIdRequest(RoutingContext routingContext) {
        OldApiUtils.handleOldApiRequest(this.server, routingContext, null, Optional.empty(), (request, apiSecurityContext) -> this.endpoints.executeServerMetadataClusterId(DefaultApiSecurityContext.create(routingContext, this.server)));
    }

    private static void handleInfoRedirect(RoutingContext routingContext) {
        routingContext.response().putHeader("location", "/info").setStatusCode(HttpResponseStatus.TEMPORARY_REDIRECT.code()).end();
    }

    private void handleWebsocket(RoutingContext routingContext) {
        DefaultApiSecurityContext apiSecurityContext = DefaultApiSecurityContext.create(routingContext, this.server);
        routingContext.request().toWebSocket(serverWebSocket -> {
            if (serverWebSocket.failed()) {
                routingContext.fail(serverWebSocket.cause());
            } else {
                this.endpoints.executeWebsocketStream((ServerWebSocket)serverWebSocket.result(), routingContext.request().params(), this.server.getWorkerExecutor(), apiSecurityContext, this.context);
            }
        });
    }

    private void handleTest(RoutingContext routingContext) {
        OldApiUtils.handleOldApiRequest(this.server, routingContext, String.class, Optional.empty(), (test, apiSecurityContext) -> this.endpoints.executeTest((String)test, DefaultApiSecurityContext.create(routingContext, this.server)));
    }

    private static void chcHandler(RoutingContext routingContext) {
        routingContext.response().putHeader(HttpHeaders.CONTENT_TYPE.toString(), JSON_CONTENT_TYPE).end(new JsonObject().toBuffer());
    }

    private static KsqlMediaType getContentType(RoutingContext routingContext) {
        String mediaType = routingContext.getAcceptableContentType();
        if (mediaType == null || JSON_CONTENT_TYPE.equals(mediaType)) {
            return KsqlMediaType.LATEST_FORMAT;
        }
        return KsqlMediaType.parse((String)mediaType);
    }

    private static void unhandledExceptionHandler(Throwable t) {
        if (t instanceof ClosedChannelException) {
            log.debug("Unhandled ClosedChannelException (connection likely closed early)", t);
        } else if (t instanceof HAProxyProtocolException) {
            log.error("Failed to decode proxy protocol header", t);
        } else {
            log.error("Unhandled exception", t);
        }
    }

    static Optional<Boolean> isInternalRequest(RoutingContext routingContext) {
        return Optional.ofNullable(routingContext.get("isInternal"));
    }
}

