/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.server;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.ksql.api.server.KsqlApiException;
import io.confluent.ksql.rest.Errors;
import io.confluent.ksql.util.KsqlConstants;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.KsqlPreconditions;
import io.confluent.ksql.util.Pair;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.CumulativeCount;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlidingWindowRateLimiter {
    private static final Logger LOG = LoggerFactory.getLogger(SlidingWindowRateLimiter.class);
    private static long NUM_BYTES_IN_ONE_MEGABYTE = 0x100000L;
    private final Queue<Pair<Long, Long>> responseSizesLog;
    private final long throttleLimit;
    private final long slidingWindowSizeMs;
    private final Sensor rejectSensor;
    private volatile long numBytesInWindow;

    public SlidingWindowRateLimiter(int requestLimitInMB, long slidingWindowSizeMs, String metricNamespace, Metrics metrics, Map<String, String> metricsTags) {
        KsqlPreconditions.checkArgument((requestLimitInMB >= 0 ? 1 : 0) != 0, (String)"Query bandwidth limit can't be negative.");
        KsqlPreconditions.checkArgument((slidingWindowSizeMs >= 0L ? 1 : 0) != 0, (String)"Query throttle window size can't be negative");
        this.throttleLimit = (long)requestLimitInMB * NUM_BYTES_IN_ONE_MEGABYTE;
        this.slidingWindowSizeMs = slidingWindowSizeMs;
        this.responseSizesLog = new LinkedList<Pair<Long, Long>>();
        this.numBytesInWindow = 0L;
        metrics.addMetric(new MetricName(metricNamespace + "-bandwidth-limit-remaining", "_confluent-ksql-limits", "The current value of the bandwidth limiter", metricsTags), (metricConfig, l) -> this.throttleLimit - this.numBytesInWindow);
        this.rejectSensor = metrics.sensor("bandwidth-limit-rejects");
        this.rejectSensor.add(new MetricName(metricNamespace + "-bandwidth-limit-reject-count", "_confluent-ksql-limits", "The number of requests rejected by this limiter", metricsTags), (MeasurableStat)new CumulativeCount());
    }

    public synchronized void allow(KsqlConstants.KsqlQueryType ksqlQueryType) throws KsqlException {
        this.allow(ksqlQueryType, Time.SYSTEM.milliseconds());
    }

    @VisibleForTesting
    protected synchronized void allow(KsqlConstants.KsqlQueryType ksqlQueryType, long timestamp) throws KsqlException {
        KsqlPreconditions.checkArgument((timestamp >= 0L ? 1 : 0) != 0, (String)"Timestamp can't be negative.");
        while (!this.responseSizesLog.isEmpty() && timestamp - (Long)this.responseSizesLog.peek().left >= this.slidingWindowSizeMs) {
            this.numBytesInWindow -= ((Long)this.responseSizesLog.poll().right).longValue();
        }
        if (this.numBytesInWindow > this.throttleLimit) {
            LOG.warn("Hit bandwidth rate limit of " + this.throttleLimit + "MB with use of " + this.numBytesInWindow + "MB");
            this.rejectSensor.record();
            throw new KsqlApiException("Host is at bandwidth rate limit for " + ksqlQueryType.toString().toLowerCase() + " queries.", Errors.ERROR_CODE_BAD_REQUEST);
        }
    }

    public synchronized void add(long responseSizeInBytes) {
        this.add(Time.SYSTEM.milliseconds(), responseSizeInBytes);
    }

    @VisibleForTesting
    protected synchronized void add(long timestamp, long responseSizeInBytes) {
        KsqlPreconditions.checkArgument((timestamp >= 0L ? 1 : 0) != 0, (String)"Timestamp can't be negative.");
        KsqlPreconditions.checkArgument((responseSizeInBytes >= 0L ? 1 : 0) != 0, (String)"Response size can't be negative.");
        this.responseSizesLog.add((Pair<Long, Long>)new Pair((Object)timestamp, (Object)responseSizeInBytes));
        this.numBytesInWindow += responseSizeInBytes;
    }
}

