/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server;

import io.confluent.ksql.execution.streams.RoutingFilter;
import io.confluent.ksql.util.KsqlHostInfo;
import org.apache.kafka.streams.state.HostInfo;

public class ActiveHostFilter
implements RoutingFilter {
    private final HostInfo activeHost;

    public ActiveHostFilter(HostInfo activeHost) {
        this.activeHost = activeHost;
    }

    public RoutingFilter.Host filter(KsqlHostInfo host) {
        if (host.host().equals(this.activeHost.host()) && host.port() == this.activeHost.port()) {
            return RoutingFilter.Host.include((KsqlHostInfo)host);
        }
        return RoutingFilter.Host.exclude((KsqlHostInfo)host, (String)"Host is not the active host for this partition.");
    }
}

