/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server;

import io.confluent.ksql.rest.entity.CommandId;
import io.confluent.ksql.rest.server.CommandTopic;
import io.confluent.ksql.rest.server.KsqlRestConfig;
import io.confluent.ksql.rest.server.computation.Command;
import io.confluent.ksql.rest.server.computation.CommandStore;
import io.confluent.ksql.rest.server.computation.InternalTopicSerdes;
import io.confluent.ksql.rest.server.computation.QueuedCommand;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CommandTopicMigrationUtil {
    private static final Logger log = LoggerFactory.getLogger(CommandTopicMigrationUtil.class);
    public static final CommandId MIGRATION_COMMAND_ID = new CommandId(CommandId.Type.CLUSTER, "migration", CommandId.Action.ALTER);

    private CommandTopicMigrationUtil() {
    }

    public static void commandTopicMigration(String commandTopic, KsqlRestConfig restConfig, KsqlConfig config) {
        TopicPartition topicPartition = new TopicPartition(commandTopic, 0);
        KafkaProducer oldBrokerProducer = new KafkaProducer(config.originals(), InternalTopicSerdes.serializer(), InternalTopicSerdes.serializer());
        ProducerRecord degradedCommand = new ProducerRecord(commandTopic, Integer.valueOf(topicPartition.partition()), (Object)MIGRATION_COMMAND_ID, (Object)new Command("", Collections.emptyMap(), Collections.emptyMap(), Optional.empty(), Optional.of(0x7FFFFFFE), Integer.MAX_VALUE));
        oldBrokerProducer.send(degradedCommand);
        oldBrokerProducer.close();
        KafkaConsumer oldBrokerConsumer = new KafkaConsumer(config.originals(), (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        oldBrokerConsumer.assign(Collections.singleton(topicPartition));
        List<QueuedCommand> commands = CommandTopic.getAllCommandsInCommandTopic((Consumer<byte[], byte[]>)oldBrokerConsumer, topicPartition, Optional.empty(), CommandStore.POLLING_TIMEOUT_FOR_COMMAND_TOPIC);
        oldBrokerConsumer.close();
        ArrayList<QueuedCommand> commandsToMigrate = new ArrayList<QueuedCommand>();
        for (QueuedCommand command : commands) {
            CommandId currentCommandId = command.getAndDeserializeCommandId();
            if (currentCommandId.equals((Object)MIGRATION_COMMAND_ID)) {
                log.info("skipping migration command sent to old command topic when migrating to new one");
                continue;
            }
            commandsToMigrate.add(command);
        }
        Map<String, Object> newBrokerProducerConfigs = restConfig.getCommandProducerProperties();
        newBrokerProducerConfigs.put("transactional.id", config.getString("ksql.service.id") + "-migration-producer");
        try (KafkaProducer newBrokerProducer = new KafkaProducer(newBrokerProducerConfigs, (Serializer)new ByteArraySerializer(), (Serializer)new ByteArraySerializer());){
            newBrokerProducer.initTransactions();
            newBrokerProducer.beginTransaction();
            for (QueuedCommand command : commandsToMigrate) {
                ProducerRecord producerRecord = new ProducerRecord(commandTopic, Integer.valueOf(0), (Object)command.getCommandId(), (Object)command.getCommand());
                newBrokerProducer.send(producerRecord);
            }
            newBrokerProducer.commitTransaction();
        }
        catch (Exception e) {
            throw new KsqlException("error producing messages to command topic during migration", (Throwable)e);
        }
        log.info("Finished migrating command topic for ksql with id {}", (Object)config.getString("ksql.service.id"));
    }
}

