/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.ksql.configdef.ConfigValidators;
import io.confluent.ksql.rest.DefaultErrorMessages;
import io.confluent.ksql.rest.ErrorMessages;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.KsqlServerException;
import io.vertx.core.http.ClientAuth;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.SslConfigs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KsqlRestConfig
extends AbstractConfig {
    private static final Logger log = LoggerFactory.getLogger(KsqlRestConfig.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(KsqlRestConfig.class);
    public static final String LISTENERS_CONFIG = "listeners";
    protected static final String LISTENERS_DOC = "List of listeners. http and https are supported. Each listener must include the protocol, hostname, and port. For example: http://myhost:8080, https://0.0.0.0:8081";
    protected static final String LISTENERS_DEFAULT = "http://0.0.0.0:8088";
    public static final String PROXY_PROTOCOL_LISTENERS_CONFIG = "listeners.proxy.protocol";
    protected static final String PROXY_PROTOCOL_LISTENERS_DOC = "List of listeners expecting proxy protocol headers. Must be a subset of the listeners provided in the configuration `listeners`. http and https are supported. Each listener must include the protocol, hostname, and port. For example: http://myhost:8080, https://0.0.0.0:8081";
    protected static final String PROXY_PROTOCOL_LISTENERS_DEFAULT = "";
    public static final String AUTHENTICATION_SKIP_PATHS_CONFIG = "authentication.skip.paths";
    public static final String AUTHENTICATION_SKIP_PATHS_DOC = "Comma separated list of paths that can be accessed without authentication";
    public static final String AUTHENTICATION_SKIP_PATHS_DEFAULT = "";
    public static final String ACCESS_CONTROL_ALLOW_ORIGIN_CONFIG = "access.control.allow.origin";
    protected static final String ACCESS_CONTROL_ALLOW_ORIGIN_DOC = "Set value for Access-Control-Allow-Origin header";
    protected static final String ACCESS_CONTROL_ALLOW_ORIGIN_DEFAULT = "";
    public static final String ACCESS_CONTROL_ALLOW_METHODS = "access.control.allow.methods";
    protected static final String ACCESS_CONTROL_ALLOW_METHODS_DOC = "Set value to Access-Control-Allow-Origin header for specified methods";
    protected static final List<String> ACCESS_CONTROL_ALLOW_METHODS_DEFAULT = Collections.emptyList();
    public static final String ACCESS_CONTROL_ALLOW_HEADERS = "access.control.allow.headers";
    protected static final String ACCESS_CONTROL_ALLOW_HEADERS_DOC = "Set value to Access-Control-Allow-Origin header for specified headers. Leave blank to use default.";
    protected static final List<String> ACCESS_CONTROL_ALLOW_HEADERS_DEFAULT = Collections.emptyList();
    public static final String AUTHENTICATION_METHOD_CONFIG = "authentication.method";
    public static final String AUTHENTICATION_METHOD_NONE = "NONE";
    public static final String AUTHENTICATION_METHOD_BASIC = "BASIC";
    public static final String AUTHENTICATION_METHOD_DOC = "Method of authentication. Must be BASIC to enable authentication. For BASIC, you must supply a valid JAAS config file for the 'java.security.auth.login.config' system property for the appropriate authentication provider";
    public static final ConfigDef.ValidString AUTHENTICATION_METHOD_VALIDATOR = ConfigDef.ValidString.in((String[])new String[]{"NONE", "BASIC"});
    public static final String AUTHENTICATION_REALM_CONFIG = "authentication.realm";
    public static final String AUTHENTICATION_REALM_DOC = "Security realm to be used in authentication.";
    public static final String AUTHENTICATION_ROLES_CONFIG = "authentication.roles";
    public static final String AUTHENTICATION_ROLES_DOC = "Valid roles to authenticate against.";
    public static final List<String> AUTHENTICATION_ROLES_DEFAULT = Collections.singletonList("*");
    protected static final String SSL_KEYSTORE_LOCATION_DEFAULT = "";
    protected static final String SSL_KEYSTORE_PASSWORD_DEFAULT = "";
    protected static final String SSL_KEY_PASSWORD_DEFAULT = "";
    public static final String SSL_KEYSTORE_TYPE_CONFIG = "ssl.keystore.type";
    protected static final String SSL_KEYSTORE_TYPE_DOC = "The type of keystore file. Must be either 'JKS' or 'PKCS12'.";
    protected static final String SSL_TRUSTSTORE_LOCATION_DEFAULT = "";
    protected static final String SSL_TRUSTSTORE_PASSWORD_DEFAULT = "";
    public static final String SSL_TRUSTSTORE_TYPE_CONFIG = "ssl.truststore.type";
    protected static final String SSL_TRUSTSTORE_TYPE_DOC = "The type of trust store file. Must be either 'JKS' or 'PKCS12'.";
    public static final String SSL_STORE_TYPE_JKS = "JKS";
    public static final String SSL_STORE_TYPE_PKCS12 = "PKCS12";
    public static final ConfigDef.ValidString SSL_STORE_TYPE_VALIDATOR = ConfigDef.ValidString.in((String[])new String[]{"JKS", "PKCS12"});
    public static final String SSL_CLIENT_AUTH_CONFIG = "ssl.client.auth";
    public static final String SSL_CLIENT_AUTHENTICATION_CONFIG = "ssl.client.authentication";
    public static final String SSL_CLIENT_AUTHENTICATION_NONE = "NONE";
    public static final String SSL_CLIENT_AUTHENTICATION_REQUESTED = "REQUESTED";
    public static final String SSL_CLIENT_AUTHENTICATION_REQUIRED = "REQUIRED";
    protected static final String SSL_CLIENT_AUTHENTICATION_DOC = "SSL mutual auth. Set to NONE to disable SSL client authentication, set to REQUESTED to request but not require SSL client authentication, and set to REQUIRED to require SSL client authentication.";
    public static final ConfigDef.ValidString SSL_CLIENT_AUTHENTICATION_VALIDATOR = ConfigDef.ValidString.in((String[])new String[]{"NONE", "REQUESTED", "REQUIRED"});
    public static final String SSL_ENABLED_PROTOCOLS_CONFIG = "ssl.enabled.protocols";
    protected static final String SSL_ENABLED_PROTOCOLS_DOC = "The list of protocols enabled for SSL connections. Comma-separated list. If blank, the default from the Apache Kafka SslConfigs.java file will be used (see 'DEFAULT_SSL_ENABLED_PROTOCOLS' in https://github.com/apache/kafka/blob/trunk/clients/src/main/java/org/apache/kafka/common/config/SslConfigs.java).";
    public static final String SSL_CIPHER_SUITES_CONFIG = "ssl.cipher.suites";
    protected static final String SSL_CIPHER_SUITES_DOC = "A list of SSL cipher suites. If blank, the JVM default will be used.";
    public static final String SSL_KEYSTORE_RELOAD_CONFIG = "ssl.keystore.reload";
    protected static final String SSL_KEYSTORE_RELOAD_DOC = "Enable auto reload of ssl keystore.";
    protected static final boolean SSL_KEYSTORE_RELOAD_DEFAULT = false;
    public static final String SSL_KEYSTORE_WATCH_LOCATION_CONFIG = "ssl.keystore.watch.location";
    protected static final String SSL_KEYSTORE_WATCH_LOCATION_DOC = "Location to watch for keystore file changes, if different from keystore location.";
    protected static final String SSL_KEYSTORE_WATCH_LOCATION_DEFAULT = "";
    private static final String KSQL_CONFIG_PREFIX = "ksql.";
    public static final String COMMAND_CONSUMER_PREFIX = "ksql.server.command.consumer.";
    public static final String COMMAND_PRODUCER_PREFIX = "ksql.server.command.producer.";
    public static final String ADVERTISED_LISTENER_CONFIG = "ksql.advertised.listener";
    public static final String INTERNAL_LISTENER_CONFIG = "ksql.internal.listener";
    private static final String ADVERTISED_LISTENER_DOC = "The listener this node will share with other ksqlDB nodes in the cluster for internal communication. In IaaS environments, this may need to be different from the interface to which the server binds. If this is not set, the advertised listener will either default to ksql.internal.listener, if set, or else the first value from listeners will be used. It is not valid to use the 0.0.0.0 (IPv4) or [::] (IPv6) wildcard addresses.";
    private static final String INTERNAL_LISTENER_DOC = "The listener used for inter-node communication, if different to the 'listeners' config. The ksql.advertised.listener config can be set to provide an externally routable name for this listener, if required. This listener can be used to bind a separate port or network interface for the internal endpoints, separate from the external client endpoints, and provide a layer of security at the network level.";
    public static final String STREAMED_QUERY_DISCONNECT_CHECK_MS_CONFIG = "query.stream.disconnect.check";
    private static final String STREAMED_QUERY_DISCONNECT_CHECK_MS_DOC = "How often to send an empty line as part of the response while streaming queries as JSON; this helps proactively determine if the connection has been terminated in order to avoid keeping the created streams job alive longer than necessary";
    public static final String DISTRIBUTED_COMMAND_RESPONSE_TIMEOUT_MS_CONFIG = "ksql.server.command.response.timeout.ms";
    protected static final String DISTRIBUTED_COMMAND_RESPONSE_TIMEOUT_MS_DOC = "How long to wait for a distributed command to be executed by the local node before returning a response";
    public static final String INSTALL_DIR_CONFIG = "ksql.server.install.dir";
    private static final String INSTALL_DIR_DOC = "The directory that ksql is installed in. This is set in the ksql-server-start script.";
    static final String KSQL_WEBSOCKETS_NUM_THREADS = "ksql.server.websockets.num.threads";
    private static final String KSQL_WEBSOCKETS_NUM_THREADS_DOC = "The number of websocket threads to handle query results";
    public static final String KSQL_SERVER_PRECONDITIONS = "ksql.server.preconditions";
    private static final String KSQL_SERVER_PRECONDITIONS_DOC = "A comma separated list of classes implementing KsqlServerPrecondition. The KSQL server will not start serving requests until all preconditions are satisfied. Until that time, requests will return a 503 error";
    static final String KSQL_SERVER_ERROR_MESSAGES = "ksql.server.error.messages";
    private static final String KSQL_SERVER_ERRORS_DOC = "A class the implementing " + ErrorMessages.class.getSimpleName() + " interface.This allows the KSQL server to return pluggable error messages.";
    public static final String KSQL_SERVER_ENABLE_UNCAUGHT_EXCEPTION_HANDLER = "ksql.server.exception.uncaught.handler.enable";
    private static final String KSQL_SERVER_UNCAUGHT_EXCEPTION_HANDLER_DOC = "Whether or not to set KsqlUncaughtExceptionHandler as the UncaughtExceptionHandler for all threads in the application (this can be overridden). Default is false.";
    public static final String KSQL_HEALTHCHECK_INTERVAL_MS_CONFIG = "ksql.healthcheck.interval.ms";
    private static final String KSQL_HEALTHCHECK_INTERVAL_MS_DOC = "Minimum time between consecutive health check evaluations. Health check queries before the interval has elapsed will receive cached responses.";
    static final String KSQL_COMMAND_RUNNER_BLOCKED_THRESHHOLD_ERROR_MS = "ksql.server.command.blocked.threshold.error.ms";
    private static final String KSQL_COMMAND_RUNNER_BLOCKED_THRESHHOLD_ERROR_MS_DOC = "How long to wait for the command runner to process a command from the command topic before reporting an error metric.";
    public static final String KSQL_HEARTBEAT_ENABLE_CONFIG = "ksql.heartbeat.enable";
    private static final String KSQL_HEARTBEAT_ENABLE_DOC = "Whether the heartheat mechanism is enabled or not. It is disabled by default.";
    public static final String KSQL_HEARTBEAT_SEND_INTERVAL_MS_CONFIG = "ksql.heartbeat.send.interval.ms";
    private static final String KSQL_HEARTBEAT_SEND_INTERVAL_MS_DOC = "Interval at which heartbeats are broadcasted to servers.";
    public static final String KSQL_HEARTBEAT_CHECK_INTERVAL_MS_CONFIG = "ksql.heartbeat.check.interval.ms";
    private static final String KSQL_HEARTBEAT_CHECK_INTERVAL_MS_DOC = "Interval at which server processes received heartbeats.";
    public static final String KSQL_HEARTBEAT_WINDOW_MS_CONFIG = "ksql.heartbeat.window.ms";
    private static final String KSQL_HEARTBEAT_WINDOW_MS_DOC = "Size of time window across which to count missed heartbeats.";
    public static final String KSQL_HEARTBEAT_MISSED_THRESHOLD_CONFIG = "ksql.heartbeat.missed.threshold.ms";
    private static final String KSQL_HEARTBEAT_MISSED_THRESHOLD_DOC = "Minimum number of consecutive missed heartbeats that flag a server as down.";
    public static final String KSQL_HEARTBEAT_DISCOVER_CLUSTER_MS_CONFIG = "ksql.heartbeat.discover.interval.ms";
    private static final String KSQL_HEARTBEAT_DISCOVER_CLUSTER_MS_DOC = "Interval at which server attempts to discover what other ksql servers exist in the cluster.";
    public static final String KSQL_HEARTBEAT_THREAD_POOL_SIZE_CONFIG = "ksql.heartbeat.thread.pool.size";
    private static final String KSQL_HEARTBEAT_THREAD_POOL_SIZE_CONFIG_DOC = "Size of thread pool used for sending / processing heartbeats and cluster discovery.";
    public static final String KSQL_LAG_REPORTING_ENABLE_CONFIG = "ksql.lag.reporting.enable";
    private static final String KSQL_LAG_REPORTING_ENABLE_DOC = "Whether lag reporting is enabled or not. It is disabled by default.";
    public static final String KSQL_LAG_REPORTING_SEND_INTERVAL_MS_CONFIG = "ksql.lag.reporting.send.interval.ms";
    private static final String KSQL_LAG_REPORTING_SEND_INTERVAL_MS_DOC = "Interval at which lag reports are broadcasted to servers.";
    public static final String VERTICLE_INSTANCES = "ksql.verticle.instances";
    public static final int DEFAULT_VERTICLE_INSTANCES = 2 * Runtime.getRuntime().availableProcessors();
    public static final String VERTICLE_INSTANCES_DOC = "The number of server verticle instances to start per listener. Usually you want at least many instances as there are cores you want to use, as each instance is single threaded.";
    public static final String IDLE_CONNECTION_TIMEOUT_SECONDS = "ksql.idle.connection.timeout.seconds";
    public static final int DEFAULT_IDLE_CONNECTION_TIMEOUT_SECONDS = 86400;
    public static final String IDLE_CONNECTION_TIMEOUT_SECONDS_DOC = "The timeout for idle connections. A connection is idle if there is no data in either direction on that connection for the duration of the timeout. This includes connections where the client only makes occasional requests as well as connections where the server takes a long time to send back any data. An example of the latter case is when there is a long period with no new results to send back in response to a streaming query. You can decrease this timeout to close connections more aggressively and save server resources, or make it longer to be more tolerant of low data volume use cases. Note: even though the server's idle connection timeout is set to a high value, you may have firewalls or proxies that enforce their own idle connection timeouts.";
    public static final String WORKER_POOL_SIZE = "ksql.worker.pool.size";
    public static final String WORKER_POOL_DOC = "Max number of worker threads for executing blocking code";
    public static final int DEFAULT_WORKER_POOL_SIZE = 100;
    public static final String MAX_PUSH_QUERIES = "ksql.max.push.queries";
    public static final int DEFAULT_MAX_PUSH_QUERIES = 100;
    public static final String MAX_PUSH_QUERIES_DOC = "The maximum number of push queries allowed on the server at any one time";
    public static final String KSQL_AUTHENTICATION_PLUGIN_CLASS = "ksql.authentication.plugin.class";
    public static final String KSQL_AUTHENTICATION_PLUGIN_DEFAULT = null;
    public static final String KSQL_AUTHENTICATION_PLUGIN_DOC = "An extension class that allows  custom authentication to be plugged in.";
    public static final String KSQL_INTERNAL_SSL_CLIENT_AUTHENTICATION_CONFIG = "ksql.internal.ssl.client.authentication";
    protected static final String KSQL_INTERNAL_SSL_CLIENT_AUTHENTICATION_DOC = "SSL mutual auth for internal requests. Set to NONE to disable SSL client authentication, set to REQUESTED to request but not require SSL client authentication, and set to REQUIRED to require SSL for internal client authentication.";
    public static final String KSQL_SSL_KEYSTORE_ALIAS_EXTERNAL_CONFIG = "ksql.ssl.keystore.alias.external";
    private static final String KSQL_SSL_KEYSTORE_ALIAS_EXTERNAL_DOC = "The key store certificate alias to be used for external client requests. If not set, the system will fall back on the Vert.x default choice";
    public static final String KSQL_SSL_KEYSTORE_ALIAS_INTERNAL_CONFIG = "ksql.ssl.keystore.alias.internal";
    private static final String KSQL_SSL_KEYSTORE_ALIAS_INTERNAL_DOC = "The key store certificate alias to be used for internal client requests. If not set, the system will fall back on the Vert.x default choice";
    public static final String KSQL_LOGGING_SERVER_RATE_LIMITED_RESPONSE_CODES_CONFIG = "ksql.logging.server.rate.limited.response.codes";
    private static final String KSQL_LOGGING_SERVER_RATE_LIMITED_RESPONSE_CODES_DOC = "A list of code:rate_limit pairs, to rate limit the server request logging";
    public static final String KSQL_LOGGING_SERVER_RATE_LIMITED_REQUEST_PATHS_CONFIG = "ksql.logging.server.rate.limited.request.paths";
    private static final String KSQL_LOGGING_SERVER_RATE_LIMITED_REQUEST_PATHS_DOC = "A list of path:rate_limit pairs, to rate limit the server request logging";
    public static final String KSQL_LOCAL_COMMANDS_LOCATION_CONFIG = "ksql.local.commands.location";
    public static final String KSQL_LOCAL_COMMANDS_LOCATION_DEFAULT = "";
    public static final String KSQL_LOCAL_COMMANDS_LOCATION_DOC = "Specify the directory where KSQL tracks local commands, e.g. transient queries";
    public static final String KSQL_ENDPOINT_LOGGING_LOG_QUERIES_CONFIG = "ksql.endpoint.logging.log.queries";
    private static final boolean KSQL_ENDPOINT_LOGGING_LOG_QUERIES_DEFAULT = false;
    private static final String KSQL_ENDPOINT_LOGGING_LOG_QUERIES_DOC = "Whether or not to log the query portion of the URI when logging endpoints. Note that enabling this may log sensitive information.";
    public static final String KSQL_ENDPOINT_LOGGING_IGNORED_PATHS_REGEX_CONFIG = "ksql.endpoint.logging.ignored.paths.regex";
    public static final String KSQL_ENDPOINT_LOGGING_IGNORED_PATHS_REGEX_DEFAULT = "";
    public static final String KSQL_ENDPOINT_LOGGING_IGNORED_PATHS_REGEX_DOC = "A regex that allows users to filter out logging from certain endpoints. Without this filter, all endpoints are logged. An example usage of this configuration would be to disable heartbeat logging (e.g. ksql.endpoint.logging.log.queries =.*heartbeat.* ) which can otherwise be verbose. Note that this works on the entire URI, respecting the ksql.endpoint.logging.log.queries configuration";
    public static final String KSQL_INTERNAL_HTTP2_MAX_POOL_SIZE_CONFIG = "ksql.internal.http2.max.pool.size";
    public static final int KSQL_INTERNAL_HTTP2_MAX_POOL_SIZE_DEFAULT = 3000;
    public static final String KSQL_INTERNAL_HTTP2_MAX_POOL_SIZE_DOC = "The maximum connection pool size used by Vertx for http2 internal connections";
    public static final String KSQL_SERVER_SNI_CHECK_ENABLE = "ksql.server.sni.check.enable";
    public static final boolean KSQL_SERVER_SNI_CHECK_ENABLE_DEFAULT = false;
    private static final String KSQL_SERVER_SNI_CHECK_ENABLE_DOC = "Whether or not to check the SNI against the Host header. If the values don't match, returns a 421 mis-directed response. (NOTE: this check should not be enabled if ksqlDB servers have mutual TLS enabled)";
    public static final String KSQL_COMMAND_TOPIC_RATE_LIMIT_CONFIG = "ksql.server.command.topic.rate.limit";
    public static final double KSQL_COMMAND_TOPIC_RATE_LIMIT_CONFIG_DEFAULT = Double.MAX_VALUE;
    private static final String KSQL_COMMAND_TOPIC_RATE_LIMIT_CONFIG_DEFAULT_DOC = "Sets the number of statements that can be executed against the command topic per second";
    public static final String KSQL_PRECONDITION_CHECKER_BACK_OFF_TIME_MS = "ksql.server.precondition.max.backoff.ms";
    protected static final String KSQL_PRECONDITION_CHECKER_BACK_OFF_TIME_MS_DOC = "The maximum amount of time to wait before checking the KSQL server preconditions again.";
    public static final String KSQL_COMMAND_TOPIC_MIGRATION_CONFIG = "ksql.server.command.topic.migration.enabled";
    public static final String KSQL_COMMAND_TOPIC_MIGRATION_NONE = "NONE";
    public static final String KSQL_COMMAND_TOPIC_MIGRATION_MIGRATOR = "MIGRATOR";
    public static final String KSQL_COMMAND_TOPIC_MIGRATION_MIGRATING = "MIGRATING";
    protected static final String KSQL_COMMAND_TOPIC_MIGRATION_DOC = "Whether or not to migrate the command topic to another Kafka cluster. If the command topic doesn't exist on the Kafka the command producer/consumer are reading from or exists, but is empty, the server then checks for the existence of the command topic on the broker that the server is connected to in the bootstrap.servers config. If it exists, it recreates the command topic on the new broker, then issues a new command to the old command topic to mark it as degraded for other servers that may be running in the cluster. One server should be designated as the MIGRATOR server while the rest of the servers should be set as MIGRATING. Servers that are MIGRATING will wait until the main MIGRATOR has completed the migration.";
    public static final ConfigDef.ValidString KSQL_COMMAND_TOPIC_MIGRATION_VALIDATOR = ConfigDef.ValidString.in((String[])new String[]{"NONE", "MIGRATOR", "MIGRATING"});
    private static final ConfigDef CONFIG_DEF = new ConfigDef().define("authentication.skip.paths", ConfigDef.Type.LIST, (Object)"", ConfigDef.Importance.LOW, "Comma separated list of paths that can be accessed without authentication").define("authentication.method", ConfigDef.Type.STRING, (Object)"NONE", (ConfigDef.Validator)AUTHENTICATION_METHOD_VALIDATOR, ConfigDef.Importance.LOW, "Method of authentication. Must be BASIC to enable authentication. For BASIC, you must supply a valid JAAS config file for the 'java.security.auth.login.config' system property for the appropriate authentication provider").define("authentication.realm", ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, "Security realm to be used in authentication.").define("authentication.roles", ConfigDef.Type.LIST, AUTHENTICATION_ROLES_DEFAULT, ConfigDef.Importance.LOW, "Valid roles to authenticate against.").define("listeners", ConfigDef.Type.LIST, (Object)"http://0.0.0.0:8088", ConfigDef.Importance.HIGH, "List of listeners. http and https are supported. Each listener must include the protocol, hostname, and port. For example: http://myhost:8080, https://0.0.0.0:8081").define("listeners.proxy.protocol", ConfigDef.Type.LIST, (Object)"", ConfigDef.Importance.MEDIUM, "List of listeners expecting proxy protocol headers. Must be a subset of the listeners provided in the configuration `listeners`. http and https are supported. Each listener must include the protocol, hostname, and port. For example: http://myhost:8080, https://0.0.0.0:8081").define("access.control.allow.origin", ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, "Set value for Access-Control-Allow-Origin header").define("access.control.allow.methods", ConfigDef.Type.LIST, ACCESS_CONTROL_ALLOW_METHODS_DEFAULT, ConfigDef.Importance.LOW, "Set value to Access-Control-Allow-Origin header for specified methods").define("access.control.allow.headers", ConfigDef.Type.LIST, ACCESS_CONTROL_ALLOW_HEADERS_DEFAULT, ConfigDef.Importance.LOW, "Set value to Access-Control-Allow-Origin header for specified headers. Leave blank to use default.").define("ssl.keystore.location", ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.HIGH, "The location of the key store file. This is optional for client and can be used for two-way authentication for client.").define("ssl.keystore.password", ConfigDef.Type.PASSWORD, (Object)"", ConfigDef.Importance.HIGH, "The store password for the key store file. This is optional for client and only needed if 'ssl.keystore.location' is configured. Key store password is not supported for PEM format.").define("ssl.key.password", ConfigDef.Type.PASSWORD, (Object)"", ConfigDef.Importance.HIGH, "The password of the private key in the key store file or the PEM key specified in 'ssl.keystore.key'.").define("ssl.keystore.type", ConfigDef.Type.STRING, (Object)"JKS", (ConfigDef.Validator)SSL_STORE_TYPE_VALIDATOR, ConfigDef.Importance.MEDIUM, "The type of keystore file. Must be either 'JKS' or 'PKCS12'.").define("ssl.keystore.reload", ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, "Enable auto reload of ssl keystore.").define("ssl.keystore.watch.location", ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, "Location to watch for keystore file changes, if different from keystore location.").define("ssl.truststore.location", ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.HIGH, "The location of the trust store file.").define("ssl.truststore.password", ConfigDef.Type.PASSWORD, (Object)"", ConfigDef.Importance.HIGH, "The password for the trust store file. If a password is not set, trust store file configured will still be used, but integrity checking is disabled. Trust store password is not supported for PEM format.").define("ssl.truststore.type", ConfigDef.Type.STRING, (Object)"JKS", (ConfigDef.Validator)SSL_STORE_TYPE_VALIDATOR, ConfigDef.Importance.MEDIUM, "The type of trust store file. Must be either 'JKS' or 'PKCS12'.").define("ssl.client.authentication", ConfigDef.Type.STRING, (Object)"NONE", (ConfigDef.Validator)SSL_CLIENT_AUTHENTICATION_VALIDATOR, ConfigDef.Importance.MEDIUM, "SSL mutual auth. Set to NONE to disable SSL client authentication, set to REQUESTED to request but not require SSL client authentication, and set to REQUIRED to require SSL client authentication.").define("ssl.client.auth", ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.MEDIUM, "").define("ksql.internal.ssl.client.authentication", ConfigDef.Type.STRING, (Object)"NONE", (ConfigDef.Validator)SSL_CLIENT_AUTHENTICATION_VALIDATOR, ConfigDef.Importance.MEDIUM, "SSL mutual auth for internal requests. Set to NONE to disable SSL client authentication, set to REQUESTED to request but not require SSL client authentication, and set to REQUIRED to require SSL for internal client authentication.").define("ksql.ssl.keystore.alias.external", ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, "The key store certificate alias to be used for external client requests. If not set, the system will fall back on the Vert.x default choice").define("ksql.ssl.keystore.alias.internal", ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, "The key store certificate alias to be used for internal client requests. If not set, the system will fall back on the Vert.x default choice").define("ssl.enabled.protocols", ConfigDef.Type.LIST, (Object)SslConfigs.DEFAULT_SSL_ENABLED_PROTOCOLS, ConfigDef.Importance.MEDIUM, "The list of protocols enabled for SSL connections. Comma-separated list. If blank, the default from the Apache Kafka SslConfigs.java file will be used (see 'DEFAULT_SSL_ENABLED_PROTOCOLS' in https://github.com/apache/kafka/blob/trunk/clients/src/main/java/org/apache/kafka/common/config/SslConfigs.java).").define("ssl.cipher.suites", ConfigDef.Type.LIST, (Object)"", ConfigDef.Importance.LOW, "A list of SSL cipher suites. If blank, the JVM default will be used.").define("ksql.advertised.listener", ConfigDef.Type.STRING, null, ConfigValidators.nullsAllowed((ConfigDef.Validator)ConfigValidators.validUrl()), ConfigDef.Importance.HIGH, "The listener this node will share with other ksqlDB nodes in the cluster for internal communication. In IaaS environments, this may need to be different from the interface to which the server binds. If this is not set, the advertised listener will either default to ksql.internal.listener, if set, or else the first value from listeners will be used. It is not valid to use the 0.0.0.0 (IPv4) or [::] (IPv6) wildcard addresses.").define("ksql.internal.listener", ConfigDef.Type.STRING, null, ConfigValidators.nullsAllowed((ConfigDef.Validator)ConfigValidators.validUrl()), ConfigDef.Importance.HIGH, "The listener used for inter-node communication, if different to the 'listeners' config. The ksql.advertised.listener config can be set to provide an externally routable name for this listener, if required. This listener can be used to bind a separate port or network interface for the internal endpoints, separate from the external client endpoints, and provide a layer of security at the network level.").define("query.stream.disconnect.check", ConfigDef.Type.LONG, (Object)1000L, ConfigDef.Importance.LOW, "How often to send an empty line as part of the response while streaming queries as JSON; this helps proactively determine if the connection has been terminated in order to avoid keeping the created streams job alive longer than necessary").define("ksql.server.command.response.timeout.ms", ConfigDef.Type.LONG, (Object)5000L, ConfigDef.Importance.LOW, "How long to wait for a distributed command to be executed by the local node before returning a response").define("ksql.server.install.dir", ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, "The directory that ksql is installed in. This is set in the ksql-server-start script.").define("ksql.server.websockets.num.threads", ConfigDef.Type.INT, (Object)5, ConfigDef.Importance.LOW, "The number of websocket threads to handle query results").define("ksql.server.preconditions", ConfigDef.Type.LIST, (Object)"", ConfigDef.Importance.LOW, "A comma separated list of classes implementing KsqlServerPrecondition. The KSQL server will not start serving requests until all preconditions are satisfied. Until that time, requests will return a 503 error").define("ksql.server.exception.uncaught.handler.enable", ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, "Whether or not to set KsqlUncaughtExceptionHandler as the UncaughtExceptionHandler for all threads in the application (this can be overridden). Default is false.").define("ksql.healthcheck.interval.ms", ConfigDef.Type.LONG, (Object)5000L, ConfigDef.Importance.LOW, "Minimum time between consecutive health check evaluations. Health check queries before the interval has elapsed will receive cached responses.").define("ksql.server.command.blocked.threshold.error.ms", ConfigDef.Type.LONG, (Object)15000L, ConfigDef.Importance.LOW, "How long to wait for the command runner to process a command from the command topic before reporting an error metric.").define("ksql.server.error.messages", ConfigDef.Type.CLASS, DefaultErrorMessages.class, ConfigDef.Importance.LOW, KSQL_SERVER_ERRORS_DOC).define("ksql.heartbeat.enable", ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.MEDIUM, "Whether the heartheat mechanism is enabled or not. It is disabled by default.").define("ksql.heartbeat.send.interval.ms", ConfigDef.Type.LONG, (Object)100L, ConfigDef.Importance.MEDIUM, "Interval at which heartbeats are broadcasted to servers.").define("ksql.heartbeat.check.interval.ms", ConfigDef.Type.LONG, (Object)200L, ConfigDef.Importance.MEDIUM, "Interval at which server processes received heartbeats.").define("ksql.heartbeat.window.ms", ConfigDef.Type.LONG, (Object)2000L, ConfigDef.Importance.MEDIUM, "Size of time window across which to count missed heartbeats.").define("ksql.heartbeat.missed.threshold.ms", ConfigDef.Type.LONG, (Object)3L, ConfigDef.Importance.MEDIUM, "Minimum number of consecutive missed heartbeats that flag a server as down.").define("ksql.heartbeat.discover.interval.ms", ConfigDef.Type.LONG, (Object)2000L, ConfigDef.Importance.MEDIUM, "Interval at which server attempts to discover what other ksql servers exist in the cluster.").define("ksql.heartbeat.thread.pool.size", ConfigDef.Type.INT, (Object)3, ConfigDef.Importance.MEDIUM, "Size of thread pool used for sending / processing heartbeats and cluster discovery.").define("ksql.lag.reporting.enable", ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.MEDIUM, "Whether lag reporting is enabled or not. It is disabled by default.").define("ksql.lag.reporting.send.interval.ms", ConfigDef.Type.LONG, (Object)5000L, ConfigDef.Importance.MEDIUM, "Interval at which lag reports are broadcasted to servers.").define("ksql.verticle.instances", ConfigDef.Type.INT, (Object)DEFAULT_VERTICLE_INSTANCES, ConfigValidators.oneOrMore(), ConfigDef.Importance.MEDIUM, "The number of server verticle instances to start per listener. Usually you want at least many instances as there are cores you want to use, as each instance is single threaded.").define("ksql.idle.connection.timeout.seconds", ConfigDef.Type.INT, (Object)86400, ConfigValidators.oneOrMore(), ConfigDef.Importance.LOW, "The timeout for idle connections. A connection is idle if there is no data in either direction on that connection for the duration of the timeout. This includes connections where the client only makes occasional requests as well as connections where the server takes a long time to send back any data. An example of the latter case is when there is a long period with no new results to send back in response to a streaming query. You can decrease this timeout to close connections more aggressively and save server resources, or make it longer to be more tolerant of low data volume use cases. Note: even though the server's idle connection timeout is set to a high value, you may have firewalls or proxies that enforce their own idle connection timeouts.").define("ksql.worker.pool.size", ConfigDef.Type.INT, (Object)100, ConfigValidators.zeroOrPositive(), ConfigDef.Importance.MEDIUM, "Max number of worker threads for executing blocking code").define("ksql.max.push.queries", ConfigDef.Type.INT, (Object)100, ConfigValidators.zeroOrPositive(), ConfigDef.Importance.MEDIUM, "The maximum number of push queries allowed on the server at any one time").define("ksql.authentication.plugin.class", ConfigDef.Type.CLASS, (Object)KSQL_AUTHENTICATION_PLUGIN_DEFAULT, ConfigDef.Importance.LOW, "An extension class that allows  custom authentication to be plugged in.").define("ksql.logging.server.rate.limited.response.codes", ConfigDef.Type.STRING, (Object)"", ConfigValidators.mapWithIntKeyDoubleValue(), ConfigDef.Importance.LOW, "A list of code:rate_limit pairs, to rate limit the server request logging").define("ksql.logging.server.rate.limited.request.paths", ConfigDef.Type.STRING, (Object)"", ConfigValidators.mapWithDoubleValue(), ConfigDef.Importance.LOW, "A list of path:rate_limit pairs, to rate limit the server request logging").define("ksql.local.commands.location", ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, "Specify the directory where KSQL tracks local commands, e.g. transient queries").define("ksql.endpoint.logging.ignored.paths.regex", ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.LOW, "A regex that allows users to filter out logging from certain endpoints. Without this filter, all endpoints are logged. An example usage of this configuration would be to disable heartbeat logging (e.g. ksql.endpoint.logging.log.queries =.*heartbeat.* ) which can otherwise be verbose. Note that this works on the entire URI, respecting the ksql.endpoint.logging.log.queries configuration").define("ksql.endpoint.logging.log.queries", ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, "Whether or not to log the query portion of the URI when logging endpoints. Note that enabling this may log sensitive information.").define("ksql.internal.http2.max.pool.size", ConfigDef.Type.INT, (Object)3000, ConfigDef.Importance.LOW, "The maximum connection pool size used by Vertx for http2 internal connections").define("ksql.server.sni.check.enable", ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, "Whether or not to check the SNI against the Host header. If the values don't match, returns a 421 mis-directed response. (NOTE: this check should not be enabled if ksqlDB servers have mutual TLS enabled)").define("ksql.server.command.topic.rate.limit", ConfigDef.Type.DOUBLE, (Object)Double.MAX_VALUE, ConfigDef.Importance.LOW, "Sets the number of statements that can be executed against the command topic per second").define("ksql.server.precondition.max.backoff.ms", ConfigDef.Type.LONG, (Object)5000L, ConfigDef.Importance.MEDIUM, "The maximum amount of time to wait before checking the KSQL server preconditions again.").define("ksql.server.command.topic.migration.enabled", ConfigDef.Type.STRING, (Object)"NONE", (ConfigDef.Validator)KSQL_COMMAND_TOPIC_MIGRATION_VALIDATOR, ConfigDef.Importance.MEDIUM, "Whether or not to migrate the command topic to another Kafka cluster. If the command topic doesn't exist on the Kafka the command producer/consumer are reading from or exists, but is empty, the server then checks for the existence of the command topic on the broker that the server is connected to in the bootstrap.servers config. If it exists, it recreates the command topic on the new broker, then issues a new command to the old command topic to mark it as degraded for other servers that may be running in the cluster. One server should be designated as the MIGRATOR server while the rest of the servers should be set as MIGRATING. Servers that are MIGRATING will wait until the main MIGRATOR has completed the migration.");

    public KsqlRestConfig(Map<?, ?> props) {
        super(CONFIG_DEF, props);
        List listeners = this.getList(LISTENERS_CONFIG);
        if (listeners.isEmpty()) {
            throw new KsqlException("listeners must be supplied.  List of listeners. http and https are supported. Each listener must include the protocol, hostname, and port. For example: http://myhost:8080, https://0.0.0.0:8081");
        }
        listeners.forEach(listener -> ConfigValidators.validUrl().ensureValid(LISTENERS_CONFIG, listener));
        List proxyProtocolListeners = this.getList(PROXY_PROTOCOL_LISTENERS_CONFIG);
        proxyProtocolListeners.forEach(listener -> ConfigValidators.validUrl().ensureValid(PROXY_PROTOCOL_LISTENERS_CONFIG, listener));
    }

    Map<String, Object> getOriginals() {
        return this.originalsWithPrefix("");
    }

    private Map<String, Object> getPropertiesWithOverrides(String prefix) {
        Map<String, Object> result = this.getOriginals();
        result.putAll(this.originalsWithPrefix(prefix));
        return result;
    }

    Map<String, Object> getCommandConsumerProperties() {
        return this.getPropertiesWithOverrides(COMMAND_CONSUMER_PREFIX);
    }

    public Map<String, Object> getCommandProducerProperties() {
        return this.getPropertiesWithOverrides(COMMAND_PRODUCER_PREFIX);
    }

    public Map<String, Object> getKsqlConfigProperties() {
        return this.getOriginals();
    }

    public URL getInterNodeListener(Function<URL, Integer> portResolver) {
        return this.getInterNodeListener(portResolver, LOGGER);
    }

    @VisibleForTesting
    URL getInterNodeListener(Function<URL, Integer> portResolver, Logger logger) {
        if (this.getString(ADVERTISED_LISTENER_CONFIG) == null) {
            return this.getString(INTERNAL_LISTENER_CONFIG) == null ? this.getInterNodeListenerFromFirstListener(portResolver, logger) : this.getInterNodeListenerFromInternalListener(portResolver, logger);
        }
        return this.getInterNodeListenerFromExplicitConfig(logger);
    }

    private URL getInterNodeListenerFromFirstListener(Function<URL, Integer> portResolver, Logger logger) {
        List configValue = this.getList(LISTENERS_CONFIG);
        URL firstListener = KsqlRestConfig.parseUrl((String)configValue.get(0), LISTENERS_CONFIG);
        InetAddress address = KsqlRestConfig.parseInetAddress(firstListener.getHost()).orElseThrow(() -> new ConfigException(LISTENERS_CONFIG, (Object)configValue, "Could not resolve first host"));
        URL listener = KsqlRestConfig.sanitizeInterNodeListener(firstListener, portResolver, address.isAnyLocalAddress());
        KsqlRestConfig.logInterNodeListener(logger, listener, Optional.of(address), "first 'listeners'");
        return listener;
    }

    private URL getInterNodeListenerFromInternalListener(Function<URL, Integer> portResolver, Logger logger) {
        String configValue = this.getString(INTERNAL_LISTENER_CONFIG);
        URL internalListener = KsqlRestConfig.parseUrl(configValue, INTERNAL_LISTENER_CONFIG);
        InetAddress address = KsqlRestConfig.parseInetAddress(internalListener.getHost()).orElseThrow(() -> new ConfigException(INTERNAL_LISTENER_CONFIG, (Object)configValue, "Could not resolve internal host"));
        URL listener = KsqlRestConfig.sanitizeInterNodeListener(internalListener, portResolver, address.isAnyLocalAddress());
        KsqlRestConfig.logInterNodeListener(logger, listener, Optional.of(address), "'ksql.internal.listener'");
        return listener;
    }

    private URL getInterNodeListenerFromExplicitConfig(Logger logger) {
        String configValue = this.getString(ADVERTISED_LISTENER_CONFIG);
        URL listener = KsqlRestConfig.parseUrl(configValue, ADVERTISED_LISTENER_CONFIG);
        if (listener.getPort() <= 0) {
            throw new ConfigException(ADVERTISED_LISTENER_CONFIG, (Object)configValue, "Must have valid port");
        }
        Optional<InetAddress> address = KsqlRestConfig.parseInetAddress(listener.getHost());
        address.ifPresent(a -> {
            if (a.isAnyLocalAddress()) {
                throw new ConfigException(ADVERTISED_LISTENER_CONFIG, (Object)configValue, "Can not be wildcard");
            }
        });
        URL sanitized = KsqlRestConfig.sanitizeInterNodeListener(listener, foo -> listener.getPort(), false);
        KsqlRestConfig.logInterNodeListener(logger, sanitized, address, "'ksql.advertised.listener'");
        return sanitized;
    }

    private static void logInterNodeListener(Logger logger, URL listener, Optional<InetAddress> address, String sourceConfigName) {
        address.ifPresent(a -> {
            if (a.isLoopbackAddress()) {
                logger.warn("{} config is set to a loopback address: {}. Intra-node communication will only work between nodes running on the same machine.", (Object)sourceConfigName, (Object)listener);
            }
            if (a.isAnyLocalAddress()) {
                logger.warn("{} config uses wildcard address: {}. Intra-node communication will only work between nodes running on the same machine.", (Object)sourceConfigName, (Object)listener);
            }
        });
        logger.info("Using {} config for intra-node communication: {}", (Object)sourceConfigName, (Object)listener);
    }

    public ClientAuth getClientAuth() {
        String clientAuth = this.getString(SSL_CLIENT_AUTHENTICATION_CONFIG);
        if (this.originals().containsKey(SSL_CLIENT_AUTH_CONFIG)) {
            if (this.originals().containsKey(SSL_CLIENT_AUTHENTICATION_CONFIG)) {
                log.warn("The {} configuration is deprecated. Since a value has been supplied for the {} configuration, that will be used instead", (Object)SSL_CLIENT_AUTH_CONFIG, (Object)SSL_CLIENT_AUTHENTICATION_CONFIG);
            } else {
                log.warn("The configuration {} is deprecated and should be replaced with {}", (Object)SSL_CLIENT_AUTH_CONFIG, (Object)SSL_CLIENT_AUTHENTICATION_CONFIG);
                clientAuth = this.getBoolean(SSL_CLIENT_AUTH_CONFIG) != false ? SSL_CLIENT_AUTHENTICATION_REQUIRED : "NONE";
            }
        }
        return this.getClientAuth(clientAuth);
    }

    private ClientAuth getClientAuth(String clientAuth) {
        switch (clientAuth) {
            case "NONE": {
                return ClientAuth.NONE;
            }
            case "REQUESTED": {
                return ClientAuth.REQUEST;
            }
            case "REQUIRED": {
                return ClientAuth.REQUIRED;
            }
        }
        throw new ConfigException("Unknown client auth: " + clientAuth);
    }

    public ClientAuth getClientAuthInternal() {
        return this.getClientAuth(this.getString(KSQL_INTERNAL_SSL_CLIENT_AUTHENTICATION_CONFIG));
    }

    private static URL sanitizeInterNodeListener(URL listener, Function<URL, Integer> portResolver, boolean replaceHost) {
        String host = replaceHost ? KsqlRestConfig.getLocalHostName() : listener.getHost();
        int port = listener.getPort() == 0 ? portResolver.apply(listener).intValue() : listener.getPort();
        try {
            return new URL(listener.getProtocol(), host, port, "");
        }
        catch (MalformedURLException e) {
            throw new KsqlServerException("Resolved first listener to malformed URL", (Throwable)e);
        }
    }

    private static URL parseUrl(String address, String configName) {
        try {
            return new URL(address);
        }
        catch (MalformedURLException e) {
            throw new ConfigException(configName, (Object)address, e.getMessage());
        }
    }

    private static Optional<InetAddress> parseInetAddress(String address) {
        try {
            return Optional.of(InetAddress.getByName(address));
        }
        catch (UnknownHostException e) {
            return Optional.empty();
        }
    }

    private static String getLocalHostName() {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            throw new KsqlServerException("Failed to obtain local host info", (Throwable)e);
        }
    }

    public Map<String, String> getStringAsMap(String key) {
        String value = this.getString(key).trim();
        return KsqlConfig.parseStringAsMap((String)key, (String)value);
    }
}

