/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.ksql.rest.server.LocalCommand;
import io.confluent.ksql.util.KsqlException;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class LocalCommandsFile
implements Closeable {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final byte[] NEW_LINE_SEPARATOR_BYTES = "\n".getBytes(StandardCharsets.UTF_8);
    private final File file;
    private final FileOutputStream writer;

    private LocalCommandsFile(File file, boolean write) {
        this.file = Objects.requireNonNull(file, "file");
        this.writer = write ? LocalCommandsFile.createWriter(file) : null;
    }

    public static LocalCommandsFile createReadonly(File file) {
        return new LocalCommandsFile(file, false);
    }

    public static LocalCommandsFile createWriteable(File file) {
        return new LocalCommandsFile(file, true);
    }

    public synchronized void write(LocalCommand localCommand) throws IOException {
        if (this.writer == null) {
            throw new IOException("Write permission denied.");
        }
        byte[] bytes = MAPPER.writeValueAsBytes((Object)localCommand);
        this.writer.write(bytes);
        this.writer.write(NEW_LINE_SEPARATOR_BYTES);
        this.writer.flush();
    }

    public List<LocalCommand> readRecords() throws IOException {
        ArrayList<LocalCommand> localCommands = new ArrayList<LocalCommand>();
        for (String line : Files.readAllLines(this.file.toPath(), StandardCharsets.UTF_8)) {
            LocalCommand localCommand = (LocalCommand)MAPPER.readValue(line, LocalCommand.class);
            localCommands.add(localCommand);
        }
        return localCommands;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        }
    }

    public File getFile() {
        return this.file;
    }

    private static FileOutputStream createWriter(File file) {
        try {
            return new FileOutputStream(file, true);
        }
        catch (FileNotFoundException e) {
            throw new KsqlException(String.format("Failed to create/open replay file: %s", file.getAbsolutePath()), (Throwable)e);
        }
    }
}

