/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.confluent.ksql.execution.streams.RoutingFilter;
import io.confluent.ksql.execution.streams.RoutingOptions;
import io.confluent.ksql.rest.entity.LagInfoEntity;
import io.confluent.ksql.rest.entity.QueryStateStoreId;
import io.confluent.ksql.rest.server.LagReportingAgent;
import io.confluent.ksql.util.KsqlHostInfo;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.Function;

public final class MaximumLagFilter
implements RoutingFilter {
    private final ImmutableMap<KsqlHostInfo, Optional<LagInfoEntity>> lagByHost;
    private final RoutingOptions routingOptions;
    private final OptionalLong maxEndOffset;

    private MaximumLagFilter(RoutingOptions routingOptions, ImmutableMap<KsqlHostInfo, Optional<LagInfoEntity>> lagByHost, OptionalLong maxEndOffset) {
        this.lagByHost = Objects.requireNonNull(lagByHost, "lagByHost");
        this.routingOptions = Objects.requireNonNull(routingOptions, "routingOptions");
        this.maxEndOffset = Objects.requireNonNull(maxEndOffset, "maxEndOffset");
    }

    public RoutingFilter.Host filter(KsqlHostInfo hostInfo) {
        long allowedOffsetLag = this.routingOptions.getMaxOffsetLagAllowed();
        Optional lagInfoEntity = (Optional)this.lagByHost.get((Object)hostInfo);
        if (lagInfoEntity == null || !lagInfoEntity.isPresent()) {
            return RoutingFilter.Host.exclude((KsqlHostInfo)hostInfo, (String)"Lag information is not present for host.");
        }
        LagInfoEntity hostLag = (LagInfoEntity)lagInfoEntity.get();
        Preconditions.checkState((boolean)this.maxEndOffset.isPresent(), (Object)"Should have a maxEndOffset");
        long endOffset = this.maxEndOffset.getAsLong();
        long offsetLag = Math.max(endOffset - hostLag.getCurrentOffsetPosition(), 0L);
        if (offsetLag <= allowedOffsetLag) {
            return RoutingFilter.Host.include((KsqlHostInfo)hostInfo);
        }
        return RoutingFilter.Host.exclude((KsqlHostInfo)hostInfo, (String)String.format("Host excluded because lag %s exceeds maximum allowed lag %s.", offsetLag, allowedOffsetLag));
    }

    public static Optional<MaximumLagFilter> create(Optional<LagReportingAgent> lagReportingAgent, RoutingOptions routingOptions, List<KsqlHostInfo> hosts, String queryId, String storeName, int partition) {
        if (!lagReportingAgent.isPresent()) {
            return Optional.empty();
        }
        QueryStateStoreId queryStateStoreId = QueryStateStoreId.of((String)queryId, (String)storeName);
        ImmutableMap lagByHost = (ImmutableMap)hosts.stream().collect(ImmutableMap.toImmutableMap(Function.identity(), host -> ((LagReportingAgent)lagReportingAgent.get()).getLagInfoForHost((KsqlHostInfo)host, queryStateStoreId, partition)));
        OptionalLong maxEndOffset = lagByHost.values().stream().filter(Optional::isPresent).map(Optional::get).mapToLong(LagInfoEntity::getEndOffsetPosition).max();
        return Optional.of(new MaximumLagFilter(routingOptions, (ImmutableMap<KsqlHostInfo, Optional<LagInfoEntity>>)lagByHost, maxEndOffset));
    }
}

