/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.ksql.KsqlExecutionContext;
import io.confluent.ksql.ServiceInfo;
import io.confluent.ksql.engine.KsqlEngine;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.function.InternalFunctionRegistry;
import io.confluent.ksql.function.MutableFunctionRegistry;
import io.confluent.ksql.function.UserFunctionLoader;
import io.confluent.ksql.logging.processing.ProcessingLogConfig;
import io.confluent.ksql.logging.processing.ProcessingLogContext;
import io.confluent.ksql.metrics.MetricCollectors;
import io.confluent.ksql.query.id.QueryIdGenerator;
import io.confluent.ksql.query.id.SequentialQueryIdGenerator;
import io.confluent.ksql.rest.server.StandaloneExecutor;
import io.confluent.ksql.rest.server.computation.ConfigStore;
import io.confluent.ksql.rest.server.computation.KafkaConfigStore;
import io.confluent.ksql.rest.util.KsqlInternalTopicUtils;
import io.confluent.ksql.rest.util.RocksDBConfigSetterHandler;
import io.confluent.ksql.services.DisabledKsqlClient;
import io.confluent.ksql.services.KafkaClusterUtil;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.services.ServiceContextFactory;
import io.confluent.ksql.statement.Injector;
import io.confluent.ksql.statement.Injectors;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.ReservedInternalTopics;
import io.confluent.ksql.version.metrics.KsqlVersionCheckerAgent;
import io.confluent.ksql.version.metrics.VersionCheckerAgent;
import java.util.Collections;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.kafka.common.metrics.Metrics;

public final class StandaloneExecutorFactory {
    private StandaloneExecutorFactory() {
    }

    public static StandaloneExecutor create(Map<String, String> properties, String queriesFile, String installDir, MetricCollectors metricCollectors) {
        KsqlConfig tempConfig = new KsqlConfig(properties);
        Function<KsqlConfig, ServiceContext> serviceContextFactory = config -> ServiceContextFactory.create((KsqlConfig)config, DisabledKsqlClient::instance);
        ServiceContext tempServiceContext = serviceContextFactory.apply(tempConfig);
        String kafkaClusterId = KafkaClusterUtil.getKafkaClusterId((ServiceContext)tempServiceContext);
        String ksqlServerId = tempConfig.getString("ksql.service.id");
        Map updatedProperties = tempConfig.originals();
        updatedProperties.putAll(metricCollectors.addConfluentMetricsContextConfigs(ksqlServerId, kafkaClusterId));
        Consumer<KsqlConfig> rocksDBConfigSetterHandler = RocksDBConfigSetterHandler::maybeConfigureRocksDBConfigSetter;
        return StandaloneExecutorFactory.create(updatedProperties, queriesFile, installDir, serviceContextFactory, KafkaConfigStore::new, KsqlVersionCheckerAgent::new, StandaloneExecutor::new, metricCollectors, rocksDBConfigSetterHandler);
    }

    @VisibleForTesting
    static StandaloneExecutor create(Map<String, Object> properties, String queriesFile, String installDir, Function<KsqlConfig, ServiceContext> serviceContextFactory, BiFunction<String, KsqlConfig, ConfigStore> configStoreFactory, Function<Supplier<Boolean>, VersionCheckerAgent> versionCheckerFactory, StandaloneExecutorConstructor constructor, MetricCollectors metricCollectors, Consumer<KsqlConfig> rocksDBConfigSetterHandler) {
        KsqlConfig baseConfig = new KsqlConfig(properties);
        ServiceContext serviceContext = serviceContextFactory.apply(baseConfig);
        String configTopicName = ReservedInternalTopics.configsTopic((KsqlConfig)baseConfig);
        KsqlInternalTopicUtils.ensureTopic(configTopicName, baseConfig, serviceContext.getTopicClient());
        ConfigStore configStore = configStoreFactory.apply(configTopicName, baseConfig);
        KsqlConfig ksqlConfig = configStore.getKsqlConfig();
        ProcessingLogConfig processingLogConfig = new ProcessingLogConfig(properties);
        ProcessingLogContext processingLogContext = ProcessingLogContext.create((ProcessingLogConfig)processingLogConfig, (Metrics)metricCollectors.getMetrics(), (Map)ksqlConfig.getStringAsMap("ksql.metrics.tags.custom"));
        InternalFunctionRegistry functionRegistry = new InternalFunctionRegistry();
        KsqlEngine ksqlEngine = new KsqlEngine(serviceContext, processingLogContext, (FunctionRegistry)functionRegistry, ServiceInfo.create((KsqlConfig)ksqlConfig), (QueryIdGenerator)new SequentialQueryIdGenerator(), ksqlConfig, Collections.emptyList(), metricCollectors);
        UserFunctionLoader udfLoader = UserFunctionLoader.newInstance((KsqlConfig)ksqlConfig, (MutableFunctionRegistry)functionRegistry, (String)installDir, (Metrics)metricCollectors.getMetrics());
        VersionCheckerAgent versionChecker = versionCheckerFactory.apply(() -> ((KsqlEngine)ksqlEngine).hasActiveQueries());
        return constructor.create(serviceContext, processingLogConfig, ksqlConfig, ksqlEngine, queriesFile, udfLoader, true, versionChecker, (BiFunction<KsqlExecutionContext, ServiceContext, Injector>)Injectors.NO_TOPIC_DELETE, metricCollectors, rocksDBConfigSetterHandler);
    }

    static interface StandaloneExecutorConstructor {
        public StandaloneExecutor create(ServiceContext var1, ProcessingLogConfig var2, KsqlConfig var3, KsqlEngine var4, String var5, UserFunctionLoader var6, boolean var7, VersionCheckerAgent var8, BiFunction<KsqlExecutionContext, ServiceContext, Injector> var9, MetricCollectors var10, Consumer<KsqlConfig> var11);
    }
}

