/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.computation;

import com.google.common.util.concurrent.RateLimiter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.KsqlExecutionContext;
import io.confluent.ksql.metastore.MetaStore;
import io.confluent.ksql.metastore.model.DataSource;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.parser.tree.CreateStream;
import io.confluent.ksql.parser.tree.CreateStreamAsSelect;
import io.confluent.ksql.parser.tree.CreateTable;
import io.confluent.ksql.parser.tree.CreateTableAsSelect;
import io.confluent.ksql.parser.tree.InsertInto;
import io.confluent.ksql.parser.tree.Statement;
import io.confluent.ksql.rest.Errors;
import io.confluent.ksql.rest.entity.CommandId;
import io.confluent.ksql.rest.entity.CommandStatus;
import io.confluent.ksql.rest.entity.CommandStatusEntity;
import io.confluent.ksql.rest.entity.KsqlWarning;
import io.confluent.ksql.rest.entity.WarningEntity;
import io.confluent.ksql.rest.server.KsqlRestConfig;
import io.confluent.ksql.rest.server.computation.Command;
import io.confluent.ksql.rest.server.computation.CommandIdAssigner;
import io.confluent.ksql.rest.server.computation.CommandQueue;
import io.confluent.ksql.rest.server.computation.DeprecatedStatementsChecker;
import io.confluent.ksql.rest.server.computation.QueuedCommandStatus;
import io.confluent.ksql.rest.server.computation.ValidatedCommandFactory;
import io.confluent.ksql.rest.server.execution.StatementExecutorResponse;
import io.confluent.ksql.rest.server.resources.KsqlRestException;
import io.confluent.ksql.security.KsqlAuthorizationValidator;
import io.confluent.ksql.security.KsqlSecurityContext;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.statement.ConfiguredStatement;
import io.confluent.ksql.statement.Injector;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.KsqlServerException;
import io.confluent.ksql.util.KsqlStatementException;
import io.confluent.ksql.util.ReservedInternalTopics;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.errors.AuthorizationException;
import org.apache.kafka.common.errors.OutOfOrderSequenceException;
import org.apache.kafka.common.errors.ProducerFencedException;
import org.apache.kafka.common.errors.TimeoutException;

public class DistributingExecutor {
    private final CommandQueue commandQueue;
    private final Duration distributedCmdResponseTimeout;
    private final BiFunction<KsqlExecutionContext, ServiceContext, Injector> injectorFactory;
    private final Optional<KsqlAuthorizationValidator> authorizationValidator;
    private final ValidatedCommandFactory validatedCommandFactory;
    private final CommandIdAssigner commandIdAssigner;
    private final ReservedInternalTopics internalTopics;
    private final Errors errorHandler;
    private final Supplier<String> commandRunnerWarning;
    private final RateLimiter rateLimiter;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public DistributingExecutor(KsqlConfig ksqlConfig, CommandQueue commandQueue, Duration distributedCmdResponseTimeout, BiFunction<KsqlExecutionContext, ServiceContext, Injector> injectorFactory, Optional<KsqlAuthorizationValidator> authorizationValidator, ValidatedCommandFactory validatedCommandFactory, Errors errorHandler, Supplier<String> commandRunnerWarning) {
        this.commandQueue = commandQueue;
        this.distributedCmdResponseTimeout = Objects.requireNonNull(distributedCmdResponseTimeout, "distributedCmdResponseTimeout");
        this.injectorFactory = Objects.requireNonNull(injectorFactory, "injectorFactory");
        this.authorizationValidator = Objects.requireNonNull(authorizationValidator, "authorizationValidator");
        this.validatedCommandFactory = Objects.requireNonNull(validatedCommandFactory, "validatedCommandFactory");
        this.commandIdAssigner = new CommandIdAssigner();
        this.internalTopics = new ReservedInternalTopics(Objects.requireNonNull(ksqlConfig, "ksqlConfig"));
        this.errorHandler = Objects.requireNonNull(errorHandler, "errorHandler");
        this.commandRunnerWarning = Objects.requireNonNull(commandRunnerWarning, "commandRunnerWarning");
        KsqlRestConfig restConfig = new KsqlRestConfig(ksqlConfig.originals());
        this.rateLimiter = RateLimiter.create((double)restConfig.getDouble("ksql.server.command.topic.rate.limit"));
    }

    private Optional<StatementExecutorResponse> checkIfNotExistsResponse(KsqlExecutionContext executionContext, ConfiguredStatement<?> statement) {
        SourceName sourceName = null;
        String type = "";
        if (statement.getStatement() instanceof CreateStream && ((CreateStream)statement.getStatement()).isNotExists()) {
            type = "stream";
            sourceName = ((CreateStream)statement.getStatement()).getName();
        } else if (statement.getStatement() instanceof CreateTable && ((CreateTable)statement.getStatement()).isNotExists()) {
            type = "table";
            sourceName = ((CreateTable)statement.getStatement()).getName();
        } else if (statement.getStatement() instanceof CreateTableAsSelect && ((CreateTableAsSelect)statement.getStatement()).isNotExists()) {
            type = "table";
            sourceName = ((CreateTableAsSelect)statement.getStatement()).getName();
        } else if (statement.getStatement() instanceof CreateStreamAsSelect && ((CreateStreamAsSelect)statement.getStatement()).isNotExists()) {
            type = "stream";
            sourceName = ((CreateStreamAsSelect)statement.getStatement()).getName();
        }
        if (sourceName != null && executionContext.getMetaStore().getSource(sourceName) != null) {
            return Optional.of(StatementExecutorResponse.handled(Optional.of(new WarningEntity(statement.getMaskedStatementText(), String.format("Cannot add %s %s: A %s with the same name already exists.", type, sourceName, type)))));
        }
        return Optional.empty();
    }

    public StatementExecutorResponse execute(ConfiguredStatement<? extends Statement> statement, KsqlExecutionContext executionContext, KsqlSecurityContext securityContext) {
        Optional<StatementExecutorResponse> response;
        String commandRunnerWarningString = this.commandRunnerWarning.get();
        if (!commandRunnerWarningString.equals("")) {
            throw new KsqlServerException("Failed to handle Ksql Statement." + System.lineSeparator() + commandRunnerWarningString);
        }
        ConfiguredStatement injected = this.injectorFactory.apply(executionContext, securityContext.getServiceContext()).inject(statement);
        if (injected.getStatement() instanceof InsertInto) {
            this.validateInsertIntoQueries(executionContext.getMetaStore(), (InsertInto)injected.getStatement());
        }
        if ((response = this.checkIfNotExistsResponse(executionContext, statement)).isPresent()) {
            return response.get();
        }
        this.checkAuthorization(injected, securityContext, executionContext);
        Producer<CommandId, Command> transactionalProducer = this.commandQueue.createTransactionalProducer();
        try {
            transactionalProducer.initTransactions();
        }
        catch (TimeoutException e) {
            throw new KsqlServerException(this.errorHandler.transactionInitTimeoutErrorMessage((Exception)((Object)e)), (Throwable)e);
        }
        catch (Exception e) {
            throw new KsqlStatementException("Could not write the statement into the command topic: " + e.getMessage(), String.format("Could not write the statement '%s' into the command topic: " + e.getMessage(), statement.getMaskedStatementText()), statement.getMaskedStatementText(), KsqlStatementException.Problem.OTHER, (Throwable)e);
        }
        if (!this.rateLimiter.tryAcquire(1L, TimeUnit.SECONDS)) {
            throw new KsqlRestException(Errors.tooManyRequests((String)"DDL/DML rate is crossing the configured rate limit of statements/second"));
        }
        CommandId commandId = null;
        try {
            transactionalProducer.beginTransaction();
            this.commandQueue.waitForCommandConsumer();
            commandId = this.commandIdAssigner.getCommandId(statement.getStatement());
            Command command = this.validatedCommandFactory.create((ConfiguredStatement<? extends Statement>)injected, executionContext.createSandbox(executionContext.getServiceContext()));
            QueuedCommandStatus queuedCommandStatus = this.commandQueue.enqueueCommand(commandId, command, transactionalProducer);
            transactionalProducer.commitTransaction();
            CommandStatus commandStatus = queuedCommandStatus.tryWaitForFinalStatus(this.distributedCmdResponseTimeout);
            StatementExecutorResponse statementExecutorResponse = StatementExecutorResponse.handled(Optional.of(new CommandStatusEntity(injected.getMaskedStatementText(), queuedCommandStatus.getCommandId(), commandStatus, Long.valueOf(queuedCommandStatus.getCommandSequenceNumber()), this.getDeprecatedWarnings(executionContext.getMetaStore(), injected))));
            return statementExecutorResponse;
        }
        catch (AuthorizationException | OutOfOrderSequenceException | ProducerFencedException e) {
            if (commandId != null) {
                this.commandQueue.abortCommand(commandId);
            }
            throw new KsqlStatementException("Could not write the statement into the command topic.", String.format("Could not write the statement '%s' into the command topic.", statement.getMaskedStatementText()), statement.getMaskedStatementText(), KsqlStatementException.Problem.OTHER, e);
        }
        catch (Exception e) {
            transactionalProducer.abortTransaction();
            if (commandId != null) {
                this.commandQueue.abortCommand(commandId);
            }
            throw new KsqlStatementException("Could not write the statement into the command topic.", String.format("Could not write the statement '%s' into the command topic.", statement.getMaskedStatementText()), statement.getMaskedStatementText(), KsqlStatementException.Problem.OTHER, (Throwable)e);
        }
        finally {
            transactionalProducer.close();
        }
    }

    private List<KsqlWarning> getDeprecatedWarnings(MetaStore metaStore, ConfiguredStatement<?> statement) {
        ArrayList<KsqlWarning> deprecatedWarnings = new ArrayList<KsqlWarning>();
        DeprecatedStatementsChecker checker = new DeprecatedStatementsChecker(metaStore);
        checker.checkStatement(statement.getStatement()).ifPresent(deprecations -> deprecatedWarnings.add(new KsqlWarning(deprecations.getNoticeMessage())));
        return deprecatedWarnings;
    }

    private void checkAuthorization(ConfiguredStatement<?> configured, KsqlSecurityContext userSecurityContext, KsqlExecutionContext serverExecutionContext) {
        Statement statement = configured.getStatement();
        MetaStore metaStore = serverExecutionContext.getMetaStore();
        this.authorizationValidator.ifPresent(validator -> validator.checkAuthorization(userSecurityContext, metaStore, statement));
        try {
            this.authorizationValidator.ifPresent(validator -> validator.checkAuthorization(new KsqlSecurityContext(Optional.empty(), serverExecutionContext.getServiceContext()), metaStore, statement));
        }
        catch (Exception e) {
            throw new KsqlServerException("The KSQL server is not permitted to execute the command", (Throwable)e);
        }
    }

    private void validateInsertIntoQueries(MetaStore metaStore, InsertInto insertInto) {
        DataSource dataSource = metaStore.getSource(insertInto.getTarget());
        if (dataSource == null) {
            throw new KsqlException("Cannot insert into an unknown stream/table: " + insertInto.getTarget());
        }
        if (this.internalTopics.isReadOnly(dataSource.getKafkaTopicName())) {
            throw new KsqlException("Cannot insert into read-only topic: " + dataSource.getKafkaTopicName());
        }
        if (!dataSource.getSchema().headers().isEmpty()) {
            throw new KsqlException("Cannot insert into " + insertInto.getTarget().text() + " because it has header columns");
        }
    }
}

