/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.computation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.rest.server.computation.ConfigStore;
import io.confluent.ksql.rest.server.computation.ConfigTopicKey;
import io.confluent.ksql.rest.server.computation.InternalTopicSerdes;
import io.confluent.ksql.util.KsqlConfig;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serdes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaConfigStore
implements ConfigStore {
    private static final Logger log = LoggerFactory.getLogger(KafkaConfigStore.class);
    public static final String CONFIG_MSG_KEY = "ksql-standalone-configs";
    private final KsqlConfig ksqlConfig;

    private static KafkaConsumer<byte[], byte[]> createConsumer(KsqlConfig ksqlConfig) {
        return new KafkaConsumer(ksqlConfig.getKsqlStreamConfigProps(), Serdes.ByteArray().deserializer(), Serdes.ByteArray().deserializer());
    }

    private static KafkaProducer<ConfigTopicKey.StringKey, KsqlProperties> createProducer(KsqlConfig ksqlConfig) {
        return new KafkaProducer(ksqlConfig.getKsqlStreamConfigProps(), InternalTopicSerdes.serializer(), InternalTopicSerdes.serializer());
    }

    public KafkaConfigStore(String topicName, KsqlConfig currentConfig) {
        this(topicName, currentConfig, () -> KafkaConfigStore.createConsumer(currentConfig), () -> KafkaConfigStore.createProducer(currentConfig));
    }

    KafkaConfigStore(String topicName, KsqlConfig currentConfig, Supplier<KafkaConsumer<byte[], byte[]>> consumer, Supplier<KafkaProducer<ConfigTopicKey.StringKey, KsqlProperties>> producer) {
        KsqlProperties currentProperties = KsqlProperties.createFor(currentConfig);
        KsqlProperties savedProperties = new KafkaWriteOnceStore<KsqlProperties>(topicName, new ConfigTopicKey.StringKey(CONFIG_MSG_KEY), InternalTopicSerdes.deserializer(ConfigTopicKey.class), InternalTopicSerdes.deserializer(KsqlProperties.class), consumer, producer).readMaybeWrite(currentProperties);
        this.ksqlConfig = currentConfig.overrideBreakingConfigsWithOriginalValues(savedProperties.getKsqlProperties());
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public KsqlConfig getKsqlConfig() {
        return this.ksqlConfig;
    }

    private static class KafkaWriteOnceStore<V> {
        private final String topicName;
        private final ConfigTopicKey.StringKey key;
        private final Deserializer<ConfigTopicKey> keyDeserializer;
        private final Deserializer<V> deserializer;
        private final Supplier<KafkaConsumer<byte[], byte[]>> consumerSupplier;
        private final Supplier<KafkaProducer<ConfigTopicKey.StringKey, V>> producerSupplier;

        KafkaWriteOnceStore(String topicName, ConfigTopicKey.StringKey key, Deserializer<ConfigTopicKey> keyDeserializer, Deserializer<V> deserializer, Supplier<KafkaConsumer<byte[], byte[]>> consumerSupplier, Supplier<KafkaProducer<ConfigTopicKey.StringKey, V>> producerSupplier) {
            this.topicName = topicName;
            this.key = key;
            this.keyDeserializer = keyDeserializer;
            this.deserializer = deserializer;
            this.consumerSupplier = consumerSupplier;
            this.producerSupplier = producerSupplier;
        }

        private boolean matchKey(ConsumerRecord<byte[], byte[]> record) {
            try {
                ConfigTopicKey recordKey = (ConfigTopicKey)this.keyDeserializer.deserialize(this.topicName, (byte[])record.key());
                return this.key.equals(recordKey);
            }
            catch (SerializationException e) {
                return false;
            }
        }

        private Optional<V> read() {
            TopicPartition topicPartition = new TopicPartition(this.topicName, 0);
            List<TopicPartition> topicPartitionAsList = Collections.singletonList(topicPartition);
            try (KafkaConsumer<byte[], byte[]> consumer = this.consumerSupplier.get();){
                consumer.assign(topicPartitionAsList);
                consumer.seekToBeginning(topicPartitionAsList);
                Map offsets = consumer.endOffsets(topicPartitionAsList);
                long endOffset = (Long)offsets.get(topicPartition);
                while (consumer.position(topicPartition) < endOffset) {
                    log.debug("Reading from topic {}. Position({}) End({})", new Object[]{this.topicName, consumer.position(topicPartition), endOffset});
                    ConsumerRecords records = consumer.poll(Duration.of(5L, ChronoUnit.SECONDS));
                    Optional<ConsumerRecord> record = records.records(topicPartition).stream().filter(this::matchKey).findFirst();
                    if (!record.isPresent()) continue;
                    byte[] value = (byte[])record.get().value();
                    log.debug("Found existing value in topic {}", (Object)this.topicName);
                    Optional<Object> optional = Optional.of(this.deserializer.deserialize(this.topicName, value));
                    return optional;
                }
                log.debug("No value found on topic {}", (Object)this.topicName);
                Optional optional = Optional.empty();
                return optional;
            }
        }

        private void write(String topicName, V value) {
            try (KafkaProducer<ConfigTopicKey.StringKey, V> producer = this.producerSupplier.get();){
                producer.send(new ProducerRecord(topicName, (Object)this.key, value));
                producer.flush();
            }
        }

        V readMaybeWrite(V value) {
            Optional<V> properties = this.read();
            if (properties.isPresent()) {
                return properties.get();
            }
            log.debug("Writing current config to config topic");
            this.write(this.topicName, value);
            return this.read().get();
        }
    }

    public static class KsqlProperties {
        private final Map<String, String> ksqlProperties;

        @JsonCreator
        KsqlProperties(@JsonProperty(value="ksqlProperties") Optional<Map<String, String>> ksqlProperties) {
            this.ksqlProperties = ksqlProperties.isPresent() ? (Map)ksqlProperties.get().entrySet().stream().filter(kv -> kv.getValue() != null).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue)) : Collections.emptyMap();
        }

        @JsonInclude(content=JsonInclude.Include.ALWAYS)
        @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
        public Map<String, String> getKsqlProperties() {
            return this.ksqlProperties;
        }

        static KsqlProperties createFor(KsqlConfig ksqlConfig) {
            return new KsqlProperties(Optional.of(ksqlConfig.getAllConfigPropsWithSecretsObfuscated()));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KsqlProperties that = (KsqlProperties)o;
            return Objects.equals(this.ksqlProperties, that.ksqlProperties);
        }

        public int hashCode() {
            return Objects.hash(this.ksqlProperties);
        }
    }
}

