/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.execution;

import io.confluent.ksql.parser.tree.Statement;
import io.confluent.ksql.rest.Errors;
import io.confluent.ksql.rest.entity.CommandStatusEntity;
import io.confluent.ksql.rest.entity.KsqlEntityList;
import io.confluent.ksql.rest.server.computation.CommandQueue;
import io.confluent.ksql.rest.server.execution.CommandQueueSync;
import io.confluent.ksql.rest.server.resources.KsqlRestException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;

public class DefaultCommandQueueSync
implements CommandQueueSync {
    private final CommandQueue commandQueue;
    private final Duration timeout;
    private final Predicate<Class<? extends Statement>> mustSync;

    public DefaultCommandQueueSync(CommandQueue commandQueue, Predicate<Class<? extends Statement>> mustSync, Duration timeout) {
        this.commandQueue = Objects.requireNonNull(commandQueue, "commandQueue");
        this.timeout = Objects.requireNonNull(timeout, "timeout");
        this.mustSync = Objects.requireNonNull(mustSync, "mustSync");
    }

    @Override
    public void waitFor(KsqlEntityList previousCommands, Class<? extends Statement> statementClass) {
        if (this.mustSync.test(statementClass)) {
            ArrayList reversed = new ArrayList(previousCommands);
            Collections.reverse(reversed);
            reversed.stream().filter(e -> e instanceof CommandStatusEntity).map(CommandStatusEntity.class::cast).map(CommandStatusEntity::getCommandSequenceNumber).findFirst().ifPresent(seqNum -> {
                try {
                    this.commandQueue.ensureConsumedPast((long)seqNum, this.timeout);
                }
                catch (InterruptedException e) {
                    throw new KsqlRestException(Errors.serverShuttingDown());
                }
                catch (TimeoutException e) {
                    throw new KsqlRestException(Errors.commandQueueCatchUpTimeout((long)seqNum));
                }
            });
        }
    }
}

