/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import io.confluent.ksql.KsqlExecutionContext;
import io.confluent.ksql.exception.KafkaResponseGetFailedException;
import io.confluent.ksql.execution.ddl.commands.KsqlTopic;
import io.confluent.ksql.metastore.MetaStore;
import io.confluent.ksql.metastore.model.DataSource;
import io.confluent.ksql.metastore.model.KsqlStream;
import io.confluent.ksql.metastore.model.KsqlTable;
import io.confluent.ksql.name.Name;
import io.confluent.ksql.name.SourceName;
import io.confluent.ksql.parser.tree.DescribeStreams;
import io.confluent.ksql.parser.tree.DescribeTables;
import io.confluent.ksql.parser.tree.ListStreams;
import io.confluent.ksql.parser.tree.ListTables;
import io.confluent.ksql.parser.tree.ShowColumns;
import io.confluent.ksql.parser.tree.StatementWithExtendedClause;
import io.confluent.ksql.query.QueryId;
import io.confluent.ksql.rest.SessionProperties;
import io.confluent.ksql.rest.entity.ConsumerPartitionOffsets;
import io.confluent.ksql.rest.entity.KsqlEntity;
import io.confluent.ksql.rest.entity.KsqlWarning;
import io.confluent.ksql.rest.entity.QueryOffsetSummary;
import io.confluent.ksql.rest.entity.QueryStatusCount;
import io.confluent.ksql.rest.entity.QueryTopicOffsetSummary;
import io.confluent.ksql.rest.entity.RunningQuery;
import io.confluent.ksql.rest.entity.SourceDescription;
import io.confluent.ksql.rest.entity.SourceDescriptionEntity;
import io.confluent.ksql.rest.entity.SourceDescriptionFactory;
import io.confluent.ksql.rest.entity.SourceDescriptionList;
import io.confluent.ksql.rest.entity.SourceInfo;
import io.confluent.ksql.rest.entity.StreamsList;
import io.confluent.ksql.rest.entity.TablesList;
import io.confluent.ksql.rest.server.KsqlRestApplication;
import io.confluent.ksql.rest.server.execution.RemoteHostExecutor;
import io.confluent.ksql.rest.server.execution.RemoteSourceDescriptionExecutor;
import io.confluent.ksql.rest.server.execution.StatementExecutorResponse;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.statement.ConfiguredStatement;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlConstants;
import io.confluent.ksql.util.KsqlStatementException;
import io.confluent.ksql.util.PersistentQueryMetadata;
import io.confluent.ksql.util.QueryApplicationId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;

public final class ListSourceExecutor {
    private ListSourceExecutor() {
    }

    private static Optional<KsqlEntity> sourceDescriptionList(ConfiguredStatement<? extends StatementWithExtendedClause> statement, SessionProperties sessionProperties, KsqlExecutionContext executionContext, ServiceContext serviceContext, List<? extends DataSource> sources, boolean extended) {
        RemoteHostExecutor remoteHostExecutor = RemoteHostExecutor.create(statement, sessionProperties, executionContext, serviceContext.getKsqlClient());
        Multimap<String, SourceDescription> remoteSourceDescriptions = extended ? RemoteSourceDescriptionExecutor.fetchSourceDescriptions(remoteHostExecutor) : ImmutableMultimap.of();
        List descriptions = sources.stream().map(s -> ListSourceExecutor.describeSource(statement.getSessionConfig().getConfig(false), executionContext, serviceContext, s.getName(), extended, statement, sessionProperties, remoteSourceDescriptions.get((Object)s.getName().toString()))).collect(Collectors.toList());
        return Optional.of(new SourceDescriptionList(statement.getMaskedStatementText(), descriptions.stream().map(d -> ((SourceDescriptionWithWarnings)d).description).collect(Collectors.toList()), descriptions.stream().flatMap(d -> ((SourceDescriptionWithWarnings)d).warnings.stream()).collect(Collectors.toList())));
    }

    public static StatementExecutorResponse streams(ConfiguredStatement<ListStreams> statement, SessionProperties sessionProperties, KsqlExecutionContext executionContext, ServiceContext serviceContext) {
        List<KsqlStream<?>> ksqlStreams = ListSourceExecutor.getSpecificStreams(executionContext);
        ListStreams listStreams = (ListStreams)statement.getStatement();
        if (listStreams.getShowExtended()) {
            return StatementExecutorResponse.handled(ListSourceExecutor.sourceDescriptionList(statement, sessionProperties, executionContext, serviceContext, ksqlStreams, listStreams.getShowExtended()));
        }
        return StatementExecutorResponse.handled(Optional.of(new StreamsList(statement.getMaskedStatementText(), (Collection)ksqlStreams.stream().map(ListSourceExecutor::sourceSteam).collect(Collectors.toList()))));
    }

    public static StatementExecutorResponse tables(ConfiguredStatement<ListTables> statement, SessionProperties sessionProperties, KsqlExecutionContext executionContext, ServiceContext serviceContext) {
        List<KsqlTable<?>> ksqlTables = ListSourceExecutor.getSpecificTables(executionContext);
        ListTables listTables = (ListTables)statement.getStatement();
        if (listTables.getShowExtended()) {
            return StatementExecutorResponse.handled(ListSourceExecutor.sourceDescriptionList(statement, sessionProperties, executionContext, serviceContext, ksqlTables, listTables.getShowExtended()));
        }
        return StatementExecutorResponse.handled(Optional.of(new TablesList(statement.getMaskedStatementText(), (Collection)ksqlTables.stream().map(ListSourceExecutor::sourceTable).collect(Collectors.toList()))));
    }

    public static StatementExecutorResponse describeStreams(ConfiguredStatement<DescribeStreams> statement, SessionProperties sessionProperties, KsqlExecutionContext executionContext, ServiceContext serviceContext) {
        List<KsqlStream<?>> ksqlStreams = ListSourceExecutor.getSpecificStreams(executionContext);
        DescribeStreams describeStreams = (DescribeStreams)statement.getStatement();
        return StatementExecutorResponse.handled(ListSourceExecutor.sourceDescriptionList(statement, sessionProperties, executionContext, serviceContext, ksqlStreams, describeStreams.getShowExtended()));
    }

    public static StatementExecutorResponse describeTables(ConfiguredStatement<DescribeTables> statement, SessionProperties sessionProperties, KsqlExecutionContext executionContext, ServiceContext serviceContext) {
        List<KsqlTable<?>> ksqlTables = ListSourceExecutor.getSpecificTables(executionContext);
        DescribeTables describeTables = (DescribeTables)statement.getStatement();
        return StatementExecutorResponse.handled(ListSourceExecutor.sourceDescriptionList(statement, sessionProperties, executionContext, serviceContext, ksqlTables, describeTables.getShowExtended()));
    }

    public static StatementExecutorResponse columns(ConfiguredStatement<ShowColumns> statement, SessionProperties sessionProperties, KsqlExecutionContext executionContext, ServiceContext serviceContext) {
        ShowColumns showColumns = (ShowColumns)statement.getStatement();
        SourceDescriptionWithWarnings descriptionWithWarnings = ListSourceExecutor.describeSource(statement.getSessionConfig().getConfig(false), executionContext, serviceContext, showColumns.getTable(), showColumns.isExtended(), statement, sessionProperties, (Collection<SourceDescription>)ImmutableList.of());
        return StatementExecutorResponse.handled(Optional.of(new SourceDescriptionEntity(statement.getMaskedStatementText(), descriptionWithWarnings.description, descriptionWithWarnings.warnings)));
    }

    private static List<KsqlTable<?>> getSpecificTables(KsqlExecutionContext executionContext) {
        return executionContext.getMetaStore().getAllDataSources().values().stream().filter(KsqlTable.class::isInstance).filter(structuredDataSource -> !structuredDataSource.getName().equals((Object)KsqlRestApplication.getCommandsStreamName())).map(table -> (KsqlTable)table).collect(Collectors.toList());
    }

    private static List<KsqlStream<?>> getSpecificStreams(KsqlExecutionContext executionContext) {
        return executionContext.getMetaStore().getAllDataSources().values().stream().filter(KsqlStream.class::isInstance).filter(structuredDataSource -> !structuredDataSource.getName().equals((Object)KsqlRestApplication.getCommandsStreamName())).map(table -> (KsqlStream)table).collect(Collectors.toList());
    }

    private static SourceDescriptionWithWarnings describeSource(KsqlConfig ksqlConfig, KsqlExecutionContext ksqlExecutionContext, ServiceContext serviceContext, SourceName name, boolean extended, ConfiguredStatement<? extends StatementWithExtendedClause> statement, SessionProperties sessionProperties, Collection<SourceDescription> remoteSourceDescriptions) {
        DataSource dataSource = ksqlExecutionContext.getMetaStore().getSource(name);
        if (dataSource == null) {
            throw new KsqlStatementException(String.format("Could not find STREAM/TABLE '%s' in the Metastore" + ksqlExecutionContext.getMetaStore().checkAlternatives(name, Optional.empty()), name.text()), statement.getMaskedStatementText());
        }
        List<RunningQuery> readQueries = ListSourceExecutor.getQueries(ksqlExecutionContext, q -> q.getSourceNames().contains(dataSource.getName()));
        List<RunningQuery> writeQueries = ListSourceExecutor.getQueries(ksqlExecutionContext, q -> q.getSinkName().equals(Optional.of(dataSource.getName())));
        Optional<TopicDescription> topicDescription = Optional.empty();
        List<QueryOffsetSummary> queryOffsetSummaries = Collections.emptyList();
        List<String> sourceConstraints = Collections.emptyList();
        LinkedList<KsqlWarning> warnings = new LinkedList<KsqlWarning>();
        try {
            topicDescription = Optional.of(serviceContext.getTopicClient().describeTopic(dataSource.getKafkaTopicName(), Boolean.valueOf(true)));
            sourceConstraints = ListSourceExecutor.getSourceConstraints(name, ksqlExecutionContext.getMetaStore());
        }
        catch (KafkaResponseGetFailedException | KafkaException e) {
            warnings.add(new KsqlWarning("Error from Kafka: " + e.getMessage()));
        }
        if (extended) {
            queryOffsetSummaries = ListSourceExecutor.queryOffsetSummaries(ksqlConfig, serviceContext, writeQueries);
            return new SourceDescriptionWithWarnings(warnings, SourceDescriptionFactory.create(dataSource, extended, readQueries, writeQueries, topicDescription, queryOffsetSummaries, sourceConstraints, remoteSourceDescriptions.stream().flatMap(sd -> sd.getClusterStatistics().stream()), remoteSourceDescriptions.stream().flatMap(sd -> sd.getClusterErrorStats().stream()), sessionProperties.getKsqlHostInfo(), ksqlExecutionContext.metricCollectors()));
        }
        return new SourceDescriptionWithWarnings(warnings, SourceDescriptionFactory.create(dataSource, extended, readQueries, writeQueries, topicDescription, queryOffsetSummaries, sourceConstraints, Stream.empty(), Stream.empty(), sessionProperties.getKsqlHostInfo(), ksqlExecutionContext.metricCollectors()));
    }

    private static List<String> getSourceConstraints(SourceName sourceName, MetaStore metaStore) {
        return metaStore.getSourceConstraints(sourceName).stream().map(Name::text).collect(Collectors.toList());
    }

    private static List<QueryOffsetSummary> queryOffsetSummaries(KsqlConfig ksqlConfig, ServiceContext serviceContext, List<RunningQuery> writeQueries) {
        HashMap<String, Map> offsetsPerQuery = new HashMap<String, Map>(writeQueries.size());
        HashMap topicsPerQuery = new HashMap();
        HashSet allTopics = new HashSet();
        for (RunningQuery query : writeQueries) {
            QueryId queryId = query.getId();
            String applicationId = QueryApplicationId.build((KsqlConfig)ksqlConfig, (boolean)true, (QueryId)queryId);
            Map topicAndConsumerOffsets = serviceContext.getConsumerGroupClient().listConsumerGroupOffsets(applicationId);
            offsetsPerQuery.put(applicationId, topicAndConsumerOffsets);
            Set topics = topicAndConsumerOffsets.keySet().stream().map(TopicPartition::topic).collect(Collectors.toSet());
            topicsPerQuery.put(applicationId, topics);
            allTopics.addAll(topics);
        }
        Map sourceTopicDescriptions = serviceContext.getTopicClient().describeTopics(allTopics);
        Map topicAndStartOffsets = serviceContext.getTopicClient().listTopicsStartOffsets(allTopics);
        Map topicAndEndOffsets = serviceContext.getTopicClient().listTopicsEndOffsets(allTopics);
        ArrayList<QueryOffsetSummary> offsetSummaries = new ArrayList<QueryOffsetSummary>();
        for (Map.Entry entry : topicsPerQuery.entrySet()) {
            ArrayList<QueryTopicOffsetSummary> topicSummaries = new ArrayList<QueryTopicOffsetSummary>();
            for (String topic : (Set)entry.getValue()) {
                topicSummaries.add(new QueryTopicOffsetSummary(topic, ListSourceExecutor.consumerPartitionOffsets((TopicDescription)sourceTopicDescriptions.get(topic), topicAndStartOffsets, topicAndEndOffsets, (Map)offsetsPerQuery.get(entry.getKey()))));
            }
            offsetSummaries.add(new QueryOffsetSummary((String)entry.getKey(), topicSummaries));
        }
        return offsetSummaries;
    }

    private static List<ConsumerPartitionOffsets> consumerPartitionOffsets(TopicDescription topicDescription, Map<TopicPartition, Long> topicAndStartOffsets, Map<TopicPartition, Long> topicAndEndOffsets, Map<TopicPartition, OffsetAndMetadata> topicAndConsumerOffsets) {
        ArrayList<ConsumerPartitionOffsets> consumerPartitionOffsets = new ArrayList<ConsumerPartitionOffsets>();
        for (TopicPartitionInfo topicPartitionInfo : topicDescription.partitions()) {
            TopicPartition tp = new TopicPartition(topicDescription.name(), topicPartitionInfo.partition());
            Long startOffsetResultInfo = topicAndStartOffsets.get(tp);
            Long endOffsetResultInfo = topicAndEndOffsets.get(tp);
            OffsetAndMetadata offsetAndMetadata = topicAndConsumerOffsets.get(tp);
            consumerPartitionOffsets.add(new ConsumerPartitionOffsets(topicPartitionInfo.partition(), startOffsetResultInfo.longValue(), endOffsetResultInfo.longValue(), offsetAndMetadata != null ? offsetAndMetadata.offset() : 0L));
        }
        return consumerPartitionOffsets;
    }

    private static List<RunningQuery> getQueries(KsqlExecutionContext ksqlEngine, Predicate<PersistentQueryMetadata> predicate) {
        return ksqlEngine.getPersistentQueries().stream().filter(predicate).map(q -> new RunningQuery(q.getStatementString(), (Set)(q.getSinkName().isPresent() ? ImmutableSet.of((Object)((SourceName)q.getSinkName().get()).text()) : ImmutableSet.of()), (Set)(q.getResultTopic().isPresent() ? ImmutableSet.of((Object)((KsqlTopic)q.getResultTopic().get()).getKafkaTopicName()) : ImmutableSet.of()), q.getQueryId(), new QueryStatusCount(Collections.singletonMap(q.getQueryStatus(), 1)), KsqlConstants.KsqlQueryType.PERSISTENT)).collect(Collectors.toList());
    }

    private static SourceInfo.Stream sourceSteam(KsqlStream<?> dataSource) {
        return new SourceInfo.Stream(dataSource.getName().text(), dataSource.getKsqlTopic().getKafkaTopicName(), dataSource.getKsqlTopic().getKeyFormat().getFormat(), dataSource.getKsqlTopic().getValueFormat().getFormat(), dataSource.getKsqlTopic().getKeyFormat().isWindowed());
    }

    private static SourceInfo.Table sourceTable(KsqlTable<?> dataSource) {
        return new SourceInfo.Table(dataSource.getName().text(), dataSource.getKsqlTopic().getKafkaTopicName(), dataSource.getKsqlTopic().getKeyFormat().getFormat(), dataSource.getKsqlTopic().getValueFormat().getFormat(), dataSource.getKsqlTopic().getKeyFormat().isWindowed());
    }

    private static final class SourceDescriptionWithWarnings {
        private final List<KsqlWarning> warnings;
        private final SourceDescription description;

        private SourceDescriptionWithWarnings(List<KsqlWarning> warnings, SourceDescription description) {
            this.warnings = warnings;
            this.description = description;
        }
    }
}

