/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.execution;

import io.confluent.ksql.KsqlExecutionContext;
import io.confluent.ksql.parser.tree.ListVariables;
import io.confluent.ksql.rest.SessionProperties;
import io.confluent.ksql.rest.entity.VariablesList;
import io.confluent.ksql.rest.server.execution.StatementExecutorResponse;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.statement.ConfiguredStatement;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public final class ListVariablesExecutor {
    private ListVariablesExecutor() {
    }

    public static StatementExecutorResponse execute(ConfiguredStatement<ListVariables> statement, SessionProperties sessionProperties, KsqlExecutionContext executionContext, ServiceContext serviceContext) {
        List sessionVariables = sessionProperties.getSessionVariables().entrySet().stream().map(e -> new VariablesList.Variable((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList());
        return StatementExecutorResponse.handled(Optional.of(new VariablesList(statement.getMaskedStatementText(), sessionVariables)));
    }
}

