/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.resources;

import com.google.common.collect.ImmutableMap;
import io.confluent.ksql.engine.KsqlEngine;
import io.confluent.ksql.rest.EndpointResponse;
import io.confluent.ksql.rest.entity.ActiveStandbyEntity;
import io.confluent.ksql.rest.entity.ClusterStatusResponse;
import io.confluent.ksql.rest.entity.HostStatusEntity;
import io.confluent.ksql.rest.entity.HostStoreLags;
import io.confluent.ksql.rest.entity.KsqlHostInfoEntity;
import io.confluent.ksql.rest.entity.TopicPartitionEntity;
import io.confluent.ksql.rest.server.HeartbeatAgent;
import io.confluent.ksql.rest.server.LagReportingAgent;
import io.confluent.ksql.util.HostStatus;
import io.confluent.ksql.util.KsqlHostInfo;
import io.confluent.ksql.util.PersistentQueryMetadata;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.streams.StreamsMetadata;
import org.apache.kafka.streams.state.HostInfo;

public class ClusterStatusResource {
    private final KsqlEngine engine;
    private final HeartbeatAgent heartbeatAgent;
    private final Optional<LagReportingAgent> lagReportingAgent;
    static final HostStoreLags EMPTY_HOST_STORE_LAGS = new HostStoreLags((Map)ImmutableMap.of(), 0L);

    public ClusterStatusResource(KsqlEngine engine, HeartbeatAgent heartbeatAgent, Optional<LagReportingAgent> lagReportingAgent) {
        this.engine = Objects.requireNonNull(engine, "engine");
        this.heartbeatAgent = Objects.requireNonNull(heartbeatAgent, "heartbeatAgent");
        this.lagReportingAgent = Objects.requireNonNull(lagReportingAgent, "lagReportingAgent");
    }

    public EndpointResponse checkClusterStatus() {
        ClusterStatusResponse response = this.getResponse();
        return EndpointResponse.ok((Object)response);
    }

    private ClusterStatusResponse getResponse() {
        Map<KsqlHostInfo, HostStatus> allHostStatus = this.heartbeatAgent.getHostsStatus();
        Map<KsqlHostInfoEntity, HostStatusEntity> response = allHostStatus.entrySet().stream().collect(Collectors.toMap(entry -> new KsqlHostInfoEntity(((KsqlHostInfo)entry.getKey()).host(), ((KsqlHostInfo)entry.getKey()).port()), entry -> new HostStatusEntity(((HostStatus)entry.getValue()).isHostAlive(), ((HostStatus)entry.getValue()).getLastStatusUpdateMs(), this.getActiveStandbyInformation((KsqlHostInfo)entry.getKey()), this.getHostStoreLags((KsqlHostInfo)entry.getKey(), ((HostStatus)entry.getValue()).isHostAlive()))));
        return new ClusterStatusResponse(response);
    }

    private HostStoreLags getHostStoreLags(KsqlHostInfo ksqlHostInfo, boolean isAlive) {
        if (!isAlive) {
            return EMPTY_HOST_STORE_LAGS;
        }
        return this.lagReportingAgent.flatMap(agent -> agent.getLagPerHost(ksqlHostInfo)).orElse(EMPTY_HOST_STORE_LAGS);
    }

    private Map<String, ActiveStandbyEntity> getActiveStandbyInformation(KsqlHostInfo ksqlHostInfo) {
        HashMap<String, ActiveStandbyEntity> perQueryMap = new HashMap<String, ActiveStandbyEntity>();
        for (PersistentQueryMetadata persistentQueryMetadata : this.engine.getPersistentQueries()) {
            for (StreamsMetadata streamsMetadata : persistentQueryMetadata.getAllStreamsHostMetadata()) {
                if (!streamsMetadata.hostInfo().equals((Object)this.asHostInfo(ksqlHostInfo))) continue;
                QueryIdAndStreamsMetadata queryIdAndStreamsMetadata = new QueryIdAndStreamsMetadata(persistentQueryMetadata.getQueryId().toString(), streamsMetadata);
                perQueryMap.putIfAbsent(queryIdAndStreamsMetadata.queryId, queryIdAndStreamsMetadata.toActiveStandbyEntity());
            }
        }
        return perQueryMap;
    }

    private HostInfo asHostInfo(KsqlHostInfo ksqlHostInfo) {
        return new HostInfo(ksqlHostInfo.host(), ksqlHostInfo.port());
    }

    private static final class QueryIdAndStreamsMetadata {
        final String queryId;
        final StreamsMetadata streamsMetadata;

        QueryIdAndStreamsMetadata(String queryId, StreamsMetadata streamsMetadata) {
            this.queryId = Objects.requireNonNull(queryId, "queryId");
            this.streamsMetadata = Objects.requireNonNull(streamsMetadata, "md");
        }

        public ActiveStandbyEntity toActiveStandbyEntity() {
            Set activePartitions = this.streamsMetadata.topicPartitions().stream().map(topicPartition -> new TopicPartitionEntity(topicPartition.topic(), topicPartition.partition())).collect(Collectors.toSet());
            Set standByPartitions = this.streamsMetadata.standbyTopicPartitions().stream().map(topicPartition -> new TopicPartitionEntity(topicPartition.topic(), topicPartition.partition())).collect(Collectors.toSet());
            return new ActiveStandbyEntity(this.streamsMetadata.stateStoreNames(), activePartitions, this.streamsMetadata.standbyStateStoreNames(), standByPartitions);
        }
    }
}

