/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.resources.streaming;

import io.confluent.ksql.execution.scalablepush.PushRoutingOptions;
import io.confluent.ksql.util.KsqlConfig;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class PushQueryConfigRoutingOptions
implements PushRoutingOptions {
    private final KsqlConfig ksqlConfig;
    private final Map<String, ?> configOverrides;
    private final Map<String, ?> requestProperties;

    public PushQueryConfigRoutingOptions(KsqlConfig ksqlConfig, Map<String, ?> configOverrides, Map<String, ?> requestProperties) {
        this.ksqlConfig = Objects.requireNonNull(ksqlConfig, "ksqlConfig");
        this.configOverrides = Objects.requireNonNull(configOverrides, "configOverrides");
        this.requestProperties = Objects.requireNonNull(requestProperties, "requestProperties");
    }

    public boolean getHasBeenForwarded() {
        if (this.requestProperties.containsKey("request.ksql.query.push.skip.forwarding")) {
            return (Boolean)this.requestProperties.get("request.ksql.query.push.skip.forwarding");
        }
        return false;
    }

    public boolean getIsDebugRequest() {
        if (this.requestProperties.containsKey("request.ksql.debug.request")) {
            return (Boolean)this.requestProperties.get("request.ksql.debug.request");
        }
        return false;
    }

    public Optional<String> getContinuationToken() {
        if (this.requestProperties.containsKey("request.ksql.query.push.continuation.token")) {
            return Optional.of((String)this.requestProperties.get("request.ksql.query.push.continuation.token"));
        }
        return Optional.empty();
    }

    public Optional<String> getCatchupConsumerGroup() {
        if (this.requestProperties.containsKey("request.ksql.query.push.catchup.consumer.group")) {
            return Optional.of((String)this.requestProperties.get("request.ksql.query.push.catchup.consumer.group"));
        }
        return Optional.empty();
    }

    public boolean shouldOutputContinuationToken() {
        if (this.getHasBeenForwarded()) {
            return true;
        }
        if (this.configOverrides.containsKey("ksql.query.push.v2.continuation.tokens.enabled")) {
            return (Boolean)this.configOverrides.get("ksql.query.push.v2.continuation.tokens.enabled");
        }
        return this.ksqlConfig.getBoolean("ksql.query.push.v2.continuation.tokens.enabled");
    }

    public boolean alosEnabled() {
        if (this.configOverrides.containsKey("ksql.query.push.v2.alos.enabled")) {
            return (Boolean)this.configOverrides.get("ksql.query.push.v2.alos.enabled");
        }
        return this.ksqlConfig.getBoolean("ksql.query.push.v2.alos.enabled");
    }
}

