/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.resources.streaming;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import io.confluent.ksql.KsqlExecutionContext;
import io.confluent.ksql.api.server.MetricsCallbackHolder;
import io.confluent.ksql.api.server.NextHandlerOutput;
import io.confluent.ksql.execution.pull.PullQueryResult;
import io.confluent.ksql.parser.KsqlParser;
import io.confluent.ksql.parser.tree.PrintTopic;
import io.confluent.ksql.parser.tree.Query;
import io.confluent.ksql.properties.DenyListPropertyValidator;
import io.confluent.ksql.rest.ApiJsonMapper;
import io.confluent.ksql.rest.EndpointResponse;
import io.confluent.ksql.rest.Errors;
import io.confluent.ksql.rest.entity.KsqlRequest;
import io.confluent.ksql.rest.server.KsqlRestConfig;
import io.confluent.ksql.rest.server.StatementParser;
import io.confluent.ksql.rest.server.computation.CommandQueue;
import io.confluent.ksql.rest.server.query.QueryExecutor;
import io.confluent.ksql.rest.server.query.QueryMetadataHolder;
import io.confluent.ksql.rest.server.resources.KsqlRestException;
import io.confluent.ksql.rest.server.resources.streaming.PullQueryStreamWriter;
import io.confluent.ksql.rest.server.resources.streaming.QueryStreamWriter;
import io.confluent.ksql.rest.server.resources.streaming.TopicStreamWriter;
import io.confluent.ksql.rest.util.CommandStoreUtil;
import io.confluent.ksql.security.KsqlAuthorizationValidator;
import io.confluent.ksql.security.KsqlSecurityContext;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.KsqlStatementException;
import io.confluent.ksql.util.PushQueryMetadata;
import io.confluent.ksql.version.metrics.ActivenessRegistrar;
import io.vertx.core.Context;
import java.time.Clock;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamedQueryResource {
    private static final Logger log = LoggerFactory.getLogger(StreamedQueryResource.class);
    private static final ObjectMapper OBJECT_MAPPER = ApiJsonMapper.INSTANCE.get();
    private final KsqlExecutionContext ksqlEngine;
    private final StatementParser statementParser;
    private final CommandQueue commandQueue;
    private final Duration disconnectCheckInterval;
    private final Duration commandQueueCatchupTimeout;
    private final ActivenessRegistrar activenessRegistrar;
    private final Optional<KsqlAuthorizationValidator> authorizationValidator;
    private final Errors errorHandler;
    private final DenyListPropertyValidator denyListPropertyValidator;
    private final QueryExecutor queryExecutor;
    private KsqlRestConfig ksqlRestConfig;

    public StreamedQueryResource(KsqlExecutionContext ksqlEngine, KsqlRestConfig ksqlRestConfig, CommandQueue commandQueue, Duration disconnectCheckInterval, Duration commandQueueCatchupTimeout, ActivenessRegistrar activenessRegistrar, Optional<KsqlAuthorizationValidator> authorizationValidator, Errors errorHandler, DenyListPropertyValidator denyListPropertyValidator, QueryExecutor queryExecutor) {
        this(ksqlEngine, ksqlRestConfig, new StatementParser(ksqlEngine), commandQueue, disconnectCheckInterval, commandQueueCatchupTimeout, activenessRegistrar, authorizationValidator, errorHandler, denyListPropertyValidator, queryExecutor);
    }

    @VisibleForTesting
    StreamedQueryResource(KsqlExecutionContext ksqlEngine, KsqlRestConfig ksqlRestConfig, StatementParser statementParser, CommandQueue commandQueue, Duration disconnectCheckInterval, Duration commandQueueCatchupTimeout, ActivenessRegistrar activenessRegistrar, Optional<KsqlAuthorizationValidator> authorizationValidator, Errors errorHandler, DenyListPropertyValidator denyListPropertyValidator, QueryExecutor queryExecutor) {
        this.ksqlEngine = Objects.requireNonNull(ksqlEngine, "ksqlEngine");
        this.ksqlRestConfig = Objects.requireNonNull(ksqlRestConfig, "ksqlRestConfig");
        this.statementParser = Objects.requireNonNull(statementParser, "statementParser");
        this.commandQueue = Objects.requireNonNull(commandQueue, "commandQueue");
        this.disconnectCheckInterval = Objects.requireNonNull(disconnectCheckInterval, "disconnectCheckInterval");
        this.commandQueueCatchupTimeout = Objects.requireNonNull(commandQueueCatchupTimeout, "commandQueueCatchupTimeout");
        this.activenessRegistrar = Objects.requireNonNull(activenessRegistrar, "activenessRegistrar");
        this.authorizationValidator = authorizationValidator;
        this.errorHandler = Objects.requireNonNull(errorHandler, "errorHandler");
        this.denyListPropertyValidator = Objects.requireNonNull(denyListPropertyValidator, "denyListPropertyValidator");
        this.queryExecutor = queryExecutor;
    }

    public EndpointResponse streamQuery(KsqlSecurityContext securityContext, KsqlRequest request, CompletableFuture<Void> connectionClosedFuture, Optional<Boolean> isInternalRequest, MetricsCallbackHolder metricsCallbackHolder, Context context) {
        this.throwIfNotConfigured();
        this.activenessRegistrar.updateLastRequestTime();
        KsqlParser.PreparedStatement<?> statement = this.parseStatement(request);
        CommandStoreUtil.httpWaitForCommandSequenceNumber(this.commandQueue, request, this.commandQueueCatchupTimeout);
        return this.handleStatement(securityContext, request, statement, connectionClosedFuture, isInternalRequest, metricsCallbackHolder, context);
    }

    private KsqlParser.PreparedStatement<?> parseStatement(KsqlRequest request) {
        String ksql = request.getUnmaskedKsql();
        if (ksql.trim().isEmpty()) {
            throw new KsqlRestException(Errors.badRequest((String)"\"ksql\" field must be populated"));
        }
        try {
            return this.statementParser.parseSingleStatement(ksql);
        }
        catch (KsqlException | IllegalArgumentException e) {
            throw new KsqlRestException(Errors.badStatement((Throwable)e, (String)ksql));
        }
    }

    private void throwIfNotConfigured() {
        if (!this.ksqlEngine.getKsqlConfig().getKsqlStreamConfigProps().containsKey("application.server")) {
            throw new KsqlRestException(Errors.notReady());
        }
    }

    private EndpointResponse handleStatement(KsqlSecurityContext securityContext, KsqlRequest request, KsqlParser.PreparedStatement<?> statement, CompletableFuture<Void> connectionClosedFuture, Optional<Boolean> isInternalRequest, MetricsCallbackHolder metricsCallbackHolder, Context context) {
        try {
            this.authorizationValidator.ifPresent(validator -> validator.checkAuthorization(securityContext, this.ksqlEngine.getMetaStore(), statement.getStatement()));
            Map configProperties = request.getConfigOverrides();
            this.denyListPropertyValidator.validateAll(configProperties);
            if (statement.getStatement() instanceof Query) {
                if (this.shouldMigrateToQueryStream(request.getConfigOverrides())) {
                    return EndpointResponse.ok((Object)new NextHandlerOutput());
                }
                QueryMetadataHolder queryMetadataHolder = this.queryExecutor.handleStatement(securityContext.getServiceContext(), request.getConfigOverrides(), request.getRequestProperties(), statement, isInternalRequest, metricsCallbackHolder, context, false);
                return this.handleQuery(statement, connectionClosedFuture, queryMetadataHolder);
            }
            if (statement.getStatement() instanceof PrintTopic) {
                return this.handlePrintTopic(securityContext.getServiceContext(), configProperties, statement, connectionClosedFuture);
            }
            return Errors.badRequest((String)String.format("Statement type `%s' not supported for this resource", statement.getClass().getName()));
        }
        catch (TopicAuthorizationException e) {
            return this.errorHandler.accessDeniedFromKafkaResponse((Exception)((Object)e));
        }
        catch (KsqlStatementException e) {
            return Errors.badStatement((String)e.getRawMessage(), (String)e.getSqlStatement());
        }
        catch (KsqlException e) {
            return this.errorHandler.generateResponse((Exception)((Object)e), Errors.badRequest((Throwable)e));
        }
    }

    private EndpointResponse handleQuery(KsqlParser.PreparedStatement<Query> statement, CompletableFuture<Void> connectionClosedFuture, QueryMetadataHolder queryMetadataHolder) {
        if (queryMetadataHolder.getPullQueryResult().isPresent()) {
            PullQueryResult result = queryMetadataHolder.getPullQueryResult().get();
            PullQueryStreamWriter pullQueryStreamWriter = new PullQueryStreamWriter(result, this.disconnectCheckInterval.toMillis(), OBJECT_MAPPER, result.getPullQueryQueue(), Clock.systemUTC(), connectionClosedFuture, statement);
            return EndpointResponse.ok((Object)pullQueryStreamWriter);
        }
        if (queryMetadataHolder.getPushQueryMetadata().isPresent()) {
            PushQueryMetadata query = queryMetadataHolder.getPushQueryMetadata().get();
            boolean emptyStream = queryMetadataHolder.getStreamPullQueryMetadata().map(streamPullQueryMetadata -> streamPullQueryMetadata.getEndOffsets().isEmpty()).orElse(false);
            QueryStreamWriter queryStreamWriter = new QueryStreamWriter(query, this.disconnectCheckInterval.toMillis(), OBJECT_MAPPER, connectionClosedFuture, emptyStream);
            return EndpointResponse.ok((Object)queryStreamWriter);
        }
        return Errors.badRequest((String)String.format("Statement type `%s' not supported for this resource", statement.getClass().getName()));
    }

    private EndpointResponse handlePrintTopic(ServiceContext serviceContext, Map<String, Object> streamProperties, KsqlParser.PreparedStatement<PrintTopic> statement, CompletableFuture<Void> connectionClosedFuture) {
        PrintTopic printTopic = (PrintTopic)statement.getStatement();
        String topicName = printTopic.getTopic();
        if (!serviceContext.getTopicClient().isTopicExists(topicName)) {
            Collection<String> possibleAlternatives = StreamedQueryResource.findPossibleTopicMatches(topicName, serviceContext);
            String reverseSuggestion = possibleAlternatives.isEmpty() ? "" : possibleAlternatives.stream().map(name -> "\tprint " + name + ";").collect(Collectors.joining(System.lineSeparator(), System.lineSeparator() + "Did you mean:" + System.lineSeparator(), ""));
            throw new KsqlRestException(Errors.badRequest((String)("Could not find topic '" + topicName + "', or the KSQL user does not have permissions to list the topic. Topic names are case-sensitive." + reverseSuggestion)));
        }
        HashMap<String, Object> propertiesWithOverrides = new HashMap<String, Object>(this.ksqlEngine.getKsqlConfig().getKsqlStreamConfigProps());
        propertiesWithOverrides.putAll(streamProperties);
        TopicStreamWriter topicStreamWriter = TopicStreamWriter.create(serviceContext, propertiesWithOverrides, printTopic, this.disconnectCheckInterval, connectionClosedFuture);
        log.info("Printing topic '{}'", (Object)topicName);
        return EndpointResponse.ok((Object)topicStreamWriter);
    }

    private static Collection<String> findPossibleTopicMatches(String topicName, ServiceContext serviceContext) {
        return serviceContext.getTopicClient().listTopicNames().stream().filter(name -> name.equalsIgnoreCase(topicName)).collect(Collectors.toSet());
    }

    private boolean shouldMigrateToQueryStream(Map<String, Object> overrides) {
        if (overrides.containsKey("ksql.endpoint.migrate.query")) {
            return (Boolean)overrides.get("ksql.endpoint.migrate.query");
        }
        return this.ksqlEngine.getKsqlConfig().getBoolean("ksql.endpoint.migrate.query");
    }
}

