/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.resources.streaming;

import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.name.ColumnName;
import io.confluent.ksql.schema.ksql.Column;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.ksql.SimpleColumn;
import io.confluent.ksql.schema.ksql.SystemColumns;
import io.confluent.ksql.util.KeyValue;
import io.confluent.ksql.util.PushQueryMetadata;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@Immutable
public final class TombstoneFactory {
    private final ImmutableMap<Integer, Integer> keyIndexes;
    private final int numColumns;

    public static TombstoneFactory create(LogicalSchema schema, PushQueryMetadata.ResultType resultType) {
        return new TombstoneFactory(TombstoneFactory.buildKeyIdx(schema, resultType), schema.value().size());
    }

    private TombstoneFactory(ImmutableMap<Integer, Integer> keyIndexes, int numColumns) {
        this.keyIndexes = Objects.requireNonNull(keyIndexes, "keyIndexes");
        this.numColumns = numColumns;
        if (numColumns < 0) {
            throw new IllegalArgumentException("numColumns: " + numColumns + " < 0");
        }
    }

    public GenericRow createRow(KeyValue<List<?>, GenericRow> row) {
        if (row.value() != null) {
            throw new IllegalArgumentException("Not a tombstone: " + row);
        }
        List key = (List)row.key();
        if (key.size() < this.keyIndexes.size()) {
            throw new IllegalArgumentException("Not enough key columns. expected at least" + this.keyIndexes.size() + ", got: " + key);
        }
        GenericRow values = new GenericRow(this.numColumns);
        for (int columnIdx = 0; columnIdx < this.numColumns; ++columnIdx) {
            Integer keyIdx = (Integer)this.keyIndexes.get((Object)columnIdx);
            if (keyIdx == null) {
                values.append(null);
                continue;
            }
            values.append(key.get(keyIdx));
        }
        return values;
    }

    private static ImmutableMap<Integer, Integer> buildKeyIdx(LogicalSchema schema, PushQueryMetadata.ResultType resultType) {
        List<ColumnName> keyColumns = TombstoneFactory.keyColumnNames(schema, resultType);
        List projection = schema.value();
        HashMap<ColumnName, Integer> columnIndexes = new HashMap<ColumnName, Integer>(projection.size());
        for (int columnIndex = 0; columnIndex < projection.size(); ++columnIndex) {
            Column column = (Column)projection.get(columnIndex);
            columnIndexes.put(column.name(), columnIndex);
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int keyIndex = 0; keyIndex < keyColumns.size(); ++keyIndex) {
            Integer columnIndex = (Integer)columnIndexes.get(keyColumns.get(keyIndex));
            if (columnIndex == null) continue;
            builder.put((Object)columnIndex, (Object)keyIndex);
        }
        return builder.build();
    }

    private static List<ColumnName> keyColumnNames(LogicalSchema schema, PushQueryMetadata.ResultType resultType) {
        List<ColumnName> keyNames = schema.key().stream().map(SimpleColumn::name).collect(Collectors.toList());
        if (resultType == PushQueryMetadata.ResultType.WINDOWED_TABLE) {
            keyNames.addAll(SystemColumns.windowBoundsColumnNames());
        }
        return keyNames;
    }
}

