/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.resources.streaming;

import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import io.confluent.ksql.api.server.MetricsCallbackHolder;
import io.confluent.ksql.engine.KsqlEngine;
import io.confluent.ksql.parser.KsqlParser;
import io.confluent.ksql.parser.tree.PrintTopic;
import io.confluent.ksql.parser.tree.Query;
import io.confluent.ksql.parser.tree.Statement;
import io.confluent.ksql.properties.DenyListPropertyValidator;
import io.confluent.ksql.rest.ApiJsonMapper;
import io.confluent.ksql.rest.Errors;
import io.confluent.ksql.rest.entity.KsqlMediaType;
import io.confluent.ksql.rest.entity.KsqlRequest;
import io.confluent.ksql.rest.entity.StreamedRow;
import io.confluent.ksql.rest.server.StatementParser;
import io.confluent.ksql.rest.server.computation.CommandQueue;
import io.confluent.ksql.rest.server.query.QueryExecutor;
import io.confluent.ksql.rest.server.query.QueryMetadataHolder;
import io.confluent.ksql.rest.server.resources.streaming.Flow;
import io.confluent.ksql.rest.server.resources.streaming.PrintPublisher;
import io.confluent.ksql.rest.server.resources.streaming.PullQueryPublisher;
import io.confluent.ksql.rest.server.resources.streaming.PushQueryPublisher;
import io.confluent.ksql.rest.server.resources.streaming.SessionUtil;
import io.confluent.ksql.rest.server.resources.streaming.WebSocketSubscriber;
import io.confluent.ksql.rest.util.CommandStoreUtil;
import io.confluent.ksql.security.KsqlAuthorizationValidator;
import io.confluent.ksql.security.KsqlSecurityContext;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlStatementException;
import io.confluent.ksql.version.metrics.ActivenessRegistrar;
import io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;
import io.vertx.core.Context;
import io.vertx.core.MultiMap;
import io.vertx.core.http.ServerWebSocket;
import java.time.Duration;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WSQueryEndpoint {
    private static final Logger log = LoggerFactory.getLogger(WSQueryEndpoint.class);
    private final KsqlConfig ksqlConfig;
    private final StatementParser statementParser;
    private final KsqlEngine ksqlEngine;
    private final CommandQueue commandQueue;
    private final ListeningScheduledExecutorService exec;
    private final ActivenessRegistrar activenessRegistrar;
    private final Duration commandQueueCatchupTimeout;
    private final Optional<KsqlAuthorizationValidator> authorizationValidator;
    private final Errors errorHandler;
    private final DenyListPropertyValidator denyListPropertyValidator;
    private final QueryExecutor queryExecutor;

    public WSQueryEndpoint(KsqlConfig ksqlConfig, StatementParser statementParser, KsqlEngine ksqlEngine, CommandQueue commandQueue, ListeningScheduledExecutorService exec, ActivenessRegistrar activenessRegistrar, Duration commandQueueCatchupTimeout, Optional<KsqlAuthorizationValidator> authorizationValidator, Errors errorHandler, DenyListPropertyValidator denyListPropertyValidator, QueryExecutor queryExecutor) {
        this.ksqlConfig = Objects.requireNonNull(ksqlConfig, "ksqlConfig");
        this.statementParser = Objects.requireNonNull(statementParser, "statementParser");
        this.ksqlEngine = Objects.requireNonNull(ksqlEngine, "ksqlEngine");
        this.commandQueue = Objects.requireNonNull(commandQueue, "commandQueue");
        this.exec = Objects.requireNonNull(exec, "exec");
        this.activenessRegistrar = Objects.requireNonNull(activenessRegistrar, "activenessRegistrar");
        this.commandQueueCatchupTimeout = Objects.requireNonNull(commandQueueCatchupTimeout, "commandQueueCatchupTimeout");
        this.authorizationValidator = Objects.requireNonNull(authorizationValidator, "authorizationValidator");
        this.errorHandler = Objects.requireNonNull(errorHandler, "errorHandler");
        this.denyListPropertyValidator = Objects.requireNonNull(denyListPropertyValidator, "denyListPropertyValidator");
        this.queryExecutor = queryExecutor;
    }

    public void executeStreamQuery(ServerWebSocket webSocket, MultiMap requestParams, KsqlSecurityContext ksqlSecurityContext, Context context, Optional<Long> timeout) {
        block9: {
            try {
                long startTimeNanos = Time.SYSTEM.nanoseconds();
                if (timeout.isPresent()) {
                    log.info("Setting websocket timeout to " + timeout.get() + " ms");
                    this.exec.schedule(() -> SessionUtil.closeSilently(webSocket, WebSocketCloseStatus.INTERNAL_SERVER_ERROR.code(), "The request token has expired."), timeout.get().longValue(), TimeUnit.MILLISECONDS);
                }
                this.activenessRegistrar.updateLastRequestTime();
                WSQueryEndpoint.validateVersion(requestParams);
                KsqlRequest request = this.parseRequest(requestParams);
                try {
                    CommandStoreUtil.waitForCommandSequenceNumber(this.commandQueue, request, this.commandQueueCatchupTimeout);
                }
                catch (InterruptedException e) {
                    log.debug("Interrupted while waiting for command queue to reach specified command sequence number", (Throwable)e);
                    SessionUtil.closeSilently(webSocket, WebSocketCloseStatus.INTERNAL_SERVER_ERROR.code(), e.getMessage());
                    return;
                }
                catch (TimeoutException e) {
                    log.debug("Timeout while processing request", (Throwable)e);
                    SessionUtil.closeSilently(webSocket, WebSocketCloseStatus.TRY_AGAIN_LATER.code(), e.getMessage());
                    return;
                }
                KsqlParser.PreparedStatement<?> preparedStatement = this.parseStatement(request);
                Statement statement = preparedStatement.getStatement();
                this.authorizationValidator.ifPresent(validator -> validator.checkAuthorization(ksqlSecurityContext, this.ksqlEngine.getMetaStore(), statement));
                RequestContext requestContext = new RequestContext(webSocket, request, ksqlSecurityContext);
                if (statement instanceof Query) {
                    this.handleQuery(requestContext, (Query)statement, startTimeNanos, context);
                    break block9;
                }
                if (statement instanceof PrintTopic) {
                    this.handlePrintTopic(requestContext, (PrintTopic)statement);
                    break block9;
                }
                throw new IllegalArgumentException("Unexpected statement type " + statement);
            }
            catch (TopicAuthorizationException e) {
                log.debug("Error processing request", (Throwable)e);
                SessionUtil.closeSilently(webSocket, WebSocketCloseStatus.INVALID_MESSAGE_TYPE.code(), this.errorHandler.kafkaAuthorizationErrorMessage((Exception)((Object)e)));
            }
            catch (Exception e) {
                log.debug("Error processing request", (Throwable)e);
                SessionUtil.closeSilently(webSocket, WebSocketCloseStatus.INVALID_MESSAGE_TYPE.code(), e.getMessage());
            }
        }
    }

    private static void validateVersion(MultiMap requestParams) {
        String version = requestParams.get("version");
        if (version == null) {
            return;
        }
        try {
            KsqlMediaType.valueOf((String)"JSON", (int)Integer.parseInt(version));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Received invalid api version: " + version, e);
        }
    }

    private KsqlRequest parseRequest(MultiMap requestParams) {
        try {
            String jsonRequest = requestParams.get("request");
            if (jsonRequest == null || jsonRequest.isEmpty()) {
                throw new IllegalArgumentException("missing request parameter");
            }
            KsqlRequest request = (KsqlRequest)ApiJsonMapper.INSTANCE.get().readValue(jsonRequest, KsqlRequest.class);
            if (request.getUnmaskedKsql().isEmpty()) {
                throw new IllegalArgumentException("\"ksql\" field of \"request\" must be populated");
            }
            this.denyListPropertyValidator.validateAll(request.getConfigOverrides());
            return request;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error parsing request: " + e.getMessage(), e);
        }
    }

    private KsqlParser.PreparedStatement<?> parseStatement(KsqlRequest request) {
        try {
            return this.statementParser.parseSingleStatement(request.getUnmaskedKsql());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error parsing query: " + e.getMessage(), e);
        }
    }

    private void attachCloseHandler(ServerWebSocket websocket, WebSocketSubscriber<?> subscriber) {
        websocket.closeHandler(v -> {
            if (subscriber != null) {
                subscriber.close();
                log.debug("Websocket {} closed, reason: {},  code: {}", new Object[]{websocket.textHandlerID(), websocket.closeReason(), websocket.closeStatusCode()});
            }
        });
    }

    private void handleQuery(RequestContext info, Query query, long startTimeNanos, Context context) {
        WebSocketSubscriber<StreamedRow> streamSubscriber = new WebSocketSubscriber<StreamedRow>(info.websocket);
        this.attachCloseHandler(info.websocket, streamSubscriber);
        KsqlParser.PreparedStatement statement = KsqlParser.PreparedStatement.of((String)info.request.getUnmaskedKsql(), (Statement)query);
        MetricsCallbackHolder metricsCallbackHolder = new MetricsCallbackHolder();
        QueryMetadataHolder queryMetadataHolder = this.queryExecutor.handleStatement(info.securityContext.getServiceContext(), info.request.getConfigOverrides(), info.request.getRequestProperties(), statement, Optional.empty(), metricsCallbackHolder, context, true);
        if (queryMetadataHolder.getPullQueryResult().isPresent()) {
            new PullQueryPublisher(this.exec, queryMetadataHolder.getPullQueryResult().get(), metricsCallbackHolder, startTimeNanos).subscribe((Flow.Subscriber<Collection<StreamedRow>>)streamSubscriber);
        } else if (queryMetadataHolder.getPushQueryMetadata().isPresent()) {
            new PushQueryPublisher(this.exec, queryMetadataHolder.getPushQueryMetadata().get(), metricsCallbackHolder, startTimeNanos).subscribe((Flow.Subscriber<Collection<StreamedRow>>)streamSubscriber);
        } else {
            throw new KsqlStatementException("Unknown query type", statement.getMaskedStatementText());
        }
    }

    private void handlePrintTopic(RequestContext info, PrintTopic printTopic) {
        String topicName = printTopic.getTopic();
        if (!info.securityContext.getServiceContext().getTopicClient().isTopicExists(topicName)) {
            throw new IllegalArgumentException("Topic does not exist, or KSQL does not have permission to list the topic: " + topicName);
        }
        WebSocketSubscriber<String> topicSubscriber = new WebSocketSubscriber<String>(info.websocket);
        this.attachCloseHandler(info.websocket, topicSubscriber);
        new PrintPublisher(this.exec, info.securityContext.getServiceContext(), this.ksqlConfig.getKsqlStreamConfigProps(), printTopic).subscribe((Flow.Subscriber<Collection<String>>)topicSubscriber);
    }

    private static final class RequestContext {
        private final ServerWebSocket websocket;
        private final KsqlRequest request;
        private final KsqlSecurityContext securityContext;

        private RequestContext(ServerWebSocket websocket, KsqlRequest request, KsqlSecurityContext securityContext) {
            this.websocket = websocket;
            this.request = request;
            this.securityContext = securityContext;
        }
    }
}

