/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.server.restore;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.properties.PropertiesUtil;
import io.confluent.ksql.query.QueryId;
import io.confluent.ksql.rest.DefaultErrorMessages;
import io.confluent.ksql.rest.entity.CommandId;
import io.confluent.ksql.rest.server.BackupReplayFile;
import io.confluent.ksql.rest.server.computation.Command;
import io.confluent.ksql.rest.server.computation.InternalTopicSerdes;
import io.confluent.ksql.rest.server.resources.IncompatibleKsqlCommandVersionException;
import io.confluent.ksql.rest.server.restore.RestoreOptions;
import io.confluent.ksql.rest.util.KsqlInternalTopicUtils;
import io.confluent.ksql.services.KafkaTopicClient;
import io.confluent.ksql.services.KafkaTopicClientImpl;
import io.confluent.ksql.util.JavaSystemExit;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.Pair;
import io.confluent.ksql.util.QueryApplicationId;
import io.confluent.ksql.util.ReservedInternalTopics;
import io.confluent.ksql.util.SystemExit;
import java.io.Console;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.errors.AuthorizationException;
import org.apache.kafka.common.errors.OutOfOrderSequenceException;
import org.apache.kafka.common.errors.ProducerFencedException;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.processor.internals.DefaultKafkaClientSupplier;
import org.apache.kafka.streams.processor.internals.StateDirectory;
import org.json.JSONObject;

public class KsqlRestoreCommandTopic {
    private static final Serializer<byte[]> BYTES_SERIALIZER = new ByteArraySerializer();
    private static final int COMMAND_TOPIC_PARTITION = 0;
    private static long timer;
    private final KsqlConfig serverConfig;
    private final String commandTopicName;
    private final KafkaTopicClient topicClient;
    private final Supplier<Producer<byte[], byte[]>> kafkaProducerSupplier;

    private static KsqlConfig loadServerConfig(File configFile) {
        Map serverProps = PropertiesUtil.loadProperties((File)configFile);
        return new KsqlConfig(serverProps);
    }

    public static List<Pair<byte[], byte[]>> loadBackup(File file, RestoreOptions restoreOptions, KsqlConfig ksqlConfig) throws IOException {
        List<Pair<byte[], byte[]>> records;
        try (BackupReplayFile commandTopicBackupFile = BackupReplayFile.readOnly(file);){
            records = commandTopicBackupFile.readRecords();
        }
        records = KsqlRestoreCommandTopic.checkValidCommands(records, restoreOptions.isSkipIncompatibleCommands(), ksqlConfig);
        return records;
    }

    private static List<Pair<byte[], byte[]>> checkValidCommands(List<Pair<byte[], byte[]>> records, boolean skipIncompatibleCommands, KsqlConfig ksqlConfig) {
        int n = 0;
        int numFilteredCommands = 0;
        ArrayList<Pair<byte[], byte[]>> filteredRecords = new ArrayList<Pair<byte[], byte[]>>();
        ArrayList<Object> incompatibleCommands = new ArrayList<Object>();
        for (Pair<byte[], byte[]> record : records) {
            Throwable throwable;
            Object deserializer;
            ++n;
            try {
                deserializer = InternalTopicSerdes.deserializer(CommandId.class);
                throwable = null;
                try {
                    deserializer.deserialize(null, (byte[])record.getLeft());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (deserializer != null) {
                        if (throwable != null) {
                            try {
                                deserializer.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            deserializer.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new KsqlException(String.format("Invalid CommandId string (line %d): %s (%s)", n, new String((byte[])record.getLeft(), StandardCharsets.UTF_8), e.getMessage()));
            }
            try {
                deserializer = InternalTopicSerdes.deserializer(Command.class);
                throwable = null;
                try {
                    deserializer.deserialize(null, (byte[])record.getRight());
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (deserializer != null) {
                        if (throwable != null) {
                            try {
                                deserializer.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            deserializer.close();
                        }
                    }
                }
            }
            catch (IncompatibleKsqlCommandVersionException | SerializationException e) {
                if (skipIncompatibleCommands) {
                    incompatibleCommands.add(record.getRight());
                    ++numFilteredCommands;
                    continue;
                }
                throw new KsqlException(String.format("Incompatible Command string (line %d): %s (%s)", n, new String((byte[])record.getLeft(), StandardCharsets.UTF_8), e.getMessage()));
            }
            catch (Exception e) {
                throw new KsqlException(String.format("Invalid Command string (line %d): %s (%s)", n, new String((byte[])record.getRight(), StandardCharsets.UTF_8), e.getMessage()));
            }
            filteredRecords.add(record);
        }
        if (skipIncompatibleCommands) {
            System.out.printf("%s incompatible command(s) skipped from backup file.%n", numFilteredCommands);
            incompatibleCommands.forEach(command -> KsqlRestoreCommandTopic.maybeCleanUpQuery(command, ksqlConfig));
        }
        return filteredRecords;
    }

    private static void checkFileExists(File file) throws Exception {
        if (!file.exists()) {
            throw new NoSuchFileException("File does not exist: " + file.getPath());
        }
        if (!file.isFile()) {
            throw new NoSuchFileException("Invalid file: " + file.getPath());
        }
        if (!file.canRead()) {
            throw new Exception("You don't have Read permissions on file: " + file.getPath());
        }
    }

    private static void resetTimer() {
        timer = System.currentTimeMillis();
    }

    private static long currentTimer() {
        return System.currentTimeMillis() - timer;
    }

    private static boolean promptQuestion() {
        System.out.println("Restoring the command topic will DELETE your actual metadata.");
        System.out.print("Continue [yes or no] (default: no)? ");
        Console console = System.console();
        String decision = console.readLine();
        return "yes".equalsIgnoreCase(decision);
    }

    public static void main(String[] args) throws Exception {
        KsqlRestoreCommandTopic.mainInternal(args, (SystemExit)new JavaSystemExit());
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH"})
    public static void mainInternal(String[] args, SystemExit systemExit) throws Exception {
        RestoreOptions restoreOptions = RestoreOptions.parse(args);
        if (restoreOptions == null) {
            systemExit.exit(1);
        }
        File configFile = restoreOptions.getConfigFile();
        File backupFile = restoreOptions.getBackupFile();
        try {
            KsqlRestoreCommandTopic.checkFileExists(configFile);
            KsqlRestoreCommandTopic.checkFileExists(backupFile);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            systemExit.exit(2);
        }
        KsqlConfig serverConfig = KsqlRestoreCommandTopic.loadServerConfig(configFile);
        KsqlRestoreCommandTopic restoreMetadata = new KsqlRestoreCommandTopic(serverConfig);
        if (!restoreOptions.isAutomaticYes() && !KsqlRestoreCommandTopic.promptQuestion()) {
            systemExit.exit(0);
        }
        System.out.println("Loading backup file ...");
        KsqlRestoreCommandTopic.resetTimer();
        List<Pair<byte[], byte[]>> backupCommands = null;
        try {
            backupCommands = KsqlRestoreCommandTopic.loadBackup(backupFile, restoreOptions, serverConfig);
        }
        catch (Exception e) {
            System.err.printf("Failed loading backup file.%nError = %s%n", e.getMessage());
            for (StackTraceElement s : e.getStackTrace()) {
                System.err.printf("%s%n", s.toString());
            }
            systemExit.exit(1);
        }
        System.out.printf("Backup (%d records) loaded in memory in %s ms.%n", backupCommands.size(), KsqlRestoreCommandTopic.currentTimer());
        System.out.println();
        System.out.println("Restoring command topic ...");
        KsqlRestoreCommandTopic.resetTimer();
        try {
            restoreMetadata.restore(backupCommands);
        }
        catch (Exception e) {
            System.err.printf("Failed restoring command topic.%nError = %s%n", e.getMessage());
            systemExit.exit(1);
        }
        System.out.printf("Restore process completed in %d ms.%n", KsqlRestoreCommandTopic.currentTimer());
        System.out.println();
        System.out.println("You need to restart the ksqlDB server to re-load the command topic.");
    }

    private static KafkaProducer<byte[], byte[]> transactionalProducer(KsqlConfig serverConfig) {
        HashMap<String, String> transactionalProperties = new HashMap<String, String>(serverConfig.getProducerClientConfigProps());
        transactionalProperties.put("transactional.id", serverConfig.getString("ksql.service.id"));
        transactionalProperties.put("acks", "all");
        transactionalProperties.putAll(serverConfig.originalsWithPrefix("ksql.server.command.consumer."));
        return new KafkaProducer(transactionalProperties, BYTES_SERIALIZER, BYTES_SERIALIZER);
    }

    KsqlRestoreCommandTopic(KsqlConfig serverConfig) {
        this(serverConfig, ReservedInternalTopics.commandTopic((KsqlConfig)serverConfig), (KafkaTopicClient)new KafkaTopicClientImpl(() -> KsqlRestoreCommandTopic.createAdminClient(serverConfig)), () -> KsqlRestoreCommandTopic.transactionalProducer(serverConfig));
    }

    @VisibleForTesting
    KsqlRestoreCommandTopic(KsqlConfig serverConfig, String commandTopicName, KafkaTopicClient topicClient, Supplier<Producer<byte[], byte[]>> kafkaProducerSupplier) {
        this.serverConfig = Objects.requireNonNull(serverConfig, "serverConfig");
        this.commandTopicName = Objects.requireNonNull(commandTopicName, "commandTopicName");
        this.topicClient = Objects.requireNonNull(topicClient, "topicClient");
        this.kafkaProducerSupplier = Objects.requireNonNull(kafkaProducerSupplier, "kafkaProducerSupplier");
    }

    public void restore(List<Pair<byte[], byte[]>> backupCommands) {
        this.deleteCommandTopicIfExists();
        KsqlInternalTopicUtils.ensureTopic(this.commandTopicName, this.serverConfig, this.topicClient);
        this.restoreCommandTopic(backupCommands);
    }

    private void deleteCommandTopicIfExists() {
        if (this.topicClient.isTopicExists(this.commandTopicName)) {
            this.topicClient.deleteTopics(Collections.singletonList(this.commandTopicName));
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void restoreCommandTopic(List<Pair<byte[], byte[]>> commands) {
        try (Producer<byte[], byte[]> kafkaProducer = this.createTransactionalProducer();){
            for (int i = 0; i < commands.size(); ++i) {
                Pair<byte[], byte[]> command = commands.get(i);
                try {
                    kafkaProducer.beginTransaction();
                    this.enqueueCommand(kafkaProducer, (byte[])command.getLeft(), (byte[])command.getRight());
                    kafkaProducer.commitTransaction();
                    continue;
                }
                catch (AuthorizationException | OutOfOrderSequenceException | ProducerFencedException e) {
                    throw new KsqlException(String.format("Failed restoring command (line %d): %s", i + 1, new String((byte[])commands.get(i).getLeft(), StandardCharsets.UTF_8)), e);
                }
                catch (InterruptedException e) {
                    kafkaProducer.abortTransaction();
                    throw new KsqlException("Restore process was interrupted.", (Throwable)e);
                }
                catch (Exception e) {
                    kafkaProducer.abortTransaction();
                    throw new KsqlException(String.format("Failed restoring command (line %d): %s", i + 1, new String((byte[])commands.get(i).getLeft(), StandardCharsets.UTF_8)), (Throwable)e);
                }
            }
        }
    }

    private void enqueueCommand(Producer<byte[], byte[]> kafkaProducer, byte[] commandId, byte[] command) throws ExecutionException, InterruptedException {
        ProducerRecord producerRecord = new ProducerRecord(this.commandTopicName, Integer.valueOf(0), (Object)commandId, (Object)command);
        kafkaProducer.send(producerRecord).get();
    }

    private Producer<byte[], byte[]> createTransactionalProducer() {
        try {
            Producer<byte[], byte[]> kafkaProducer = this.kafkaProducerSupplier.get();
            kafkaProducer.initTransactions();
            return kafkaProducer;
        }
        catch (TimeoutException e) {
            DefaultErrorMessages errorMessages = new DefaultErrorMessages();
            throw new KsqlException(errorMessages.transactionInitTimeoutErrorMessage((Exception)((Object)e)), (Throwable)e);
        }
        catch (Exception e) {
            throw new KsqlException("Failed to initialize topic transactions.", (Throwable)e);
        }
    }

    private static void maybeCleanUpQuery(byte[] command, KsqlConfig ksqlConfig) {
        JSONObject plan;
        boolean queryIdFound = false;
        HashMap<String, Object> streamsProperties = new HashMap<String, Object>(ksqlConfig.getKsqlStreamConfigProps());
        boolean sharedRuntimeQuery = false;
        String queryId = "";
        JSONObject jsonObject = new JSONObject(new String(command, StandardCharsets.UTF_8));
        if (KsqlRestoreCommandTopic.hasKey(jsonObject, "plan") && !jsonObject.isNull("plan") && KsqlRestoreCommandTopic.hasKey(plan = jsonObject.getJSONObject("plan"), "queryPlan") && !plan.isNull("queryPlan")) {
            JSONObject queryPlan = plan.getJSONObject("queryPlan");
            queryId = queryPlan.getString("queryId");
            if (KsqlRestoreCommandTopic.hasKey(queryPlan, "runtimeId") && !queryPlan.isNull("runtimeId") && ((Optional)queryPlan.get("runtimeId")).isPresent()) {
                streamsProperties.put("application.id", ((Optional)queryPlan.get("runtimeId")).get());
                sharedRuntimeQuery = true;
            } else {
                streamsProperties.put("application.id", QueryApplicationId.build((KsqlConfig)ksqlConfig, (boolean)true, (QueryId)new QueryId(queryId)));
            }
            queryIdFound = true;
        }
        if (queryIdFound) {
            StreamsConfig streamsConfig = new StreamsConfig(streamsProperties);
            String topicPrefix = sharedRuntimeQuery ? streamsConfig.getString("application.id") : QueryApplicationId.buildInternalTopicPrefix((KsqlConfig)ksqlConfig, (boolean)sharedRuntimeQuery) + queryId;
            try {
                Admin admin = new DefaultKafkaClientSupplier().getAdmin(ksqlConfig.getKsqlAdminClientConfigProps());
                KafkaTopicClientImpl topicClient = new KafkaTopicClientImpl(() -> admin);
                topicClient.deleteInternalTopics(topicPrefix);
                new StateDirectory(streamsConfig, Time.SYSTEM, true, ksqlConfig.getBoolean("ksql.runtime.feature.shared.enabled").booleanValue()).clean();
                System.out.printf("Cleaned up internal state store and internal topics for query %s%n", topicPrefix);
            }
            catch (Exception e) {
                System.out.printf("Failed to clean up query %s %n", topicPrefix);
            }
        }
    }

    private static boolean hasKey(JSONObject jsonObject, String key) {
        return jsonObject != null && jsonObject.has(key);
    }

    private static Admin createAdminClient(KsqlConfig serverConfig) {
        HashMap adminClientConfigs = new HashMap(serverConfig.getKsqlAdminClientConfigProps());
        adminClientConfigs.putAll(serverConfig.originalsWithPrefix("ksql.server.command.consumer."));
        return new DefaultKafkaClientSupplier().getAdmin(adminClientConfigs);
    }
}

