/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.util;

import io.confluent.ksql.security.KsqlAuthTokenProvider;
import io.confluent.ksql.util.KsqlConfig;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.time.Clock;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class AuthenticationUtil {
    final Clock clock;
    private static final Logger log = LoggerFactory.getLogger(AuthenticationUtil.class);
    private static final String BEARER = "Bearer ";

    public AuthenticationUtil(Clock clock) {
        this.clock = Objects.requireNonNull(clock);
    }

    public Optional<Long> getTokenTimeout(Optional<String> token, KsqlConfig ksqlConfig, Optional<KsqlAuthTokenProvider> authTokenProvider) {
        long maxTimeout = ksqlConfig.getLong("ksql.websocket.connection.max.timeout.ms");
        if (maxTimeout > 0L) {
            if (authTokenProvider.isPresent() && token.isPresent()) {
                try {
                    long tokenTimeout = authTokenProvider.get().getLifetimeMs(StringUtils.removeStart((String)token.get(), (String)BEARER)) - this.clock.millis();
                    return Optional.of(Math.min(tokenTimeout, maxTimeout));
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage());
                }
            }
            return Optional.of(maxTimeout);
        }
        return Optional.empty();
    }
}

