/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.util;

import com.google.common.collect.ImmutableMap;
import io.confluent.ksql.services.KafkaTopicClient;
import io.confluent.ksql.util.KsqlConfig;
import java.util.Map;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.TopicPartitionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KsqlInternalTopicUtils {
    private static final Logger log = LoggerFactory.getLogger(KsqlInternalTopicUtils.class);
    private static final int INTERNAL_TOPIC_PARTITION_COUNT = 1;
    private static final long INTERNAL_TOPIC_RETENTION_MS = -1L;
    private static final ImmutableMap<String, ?> INTERNAL_TOPIC_CONFIG = ImmutableMap.of((Object)"retention.ms", (Object)-1L, (Object)"cleanup.policy", (Object)"delete", (Object)"unclean.leader.election.enable", (Object)false);

    private KsqlInternalTopicUtils() {
    }

    public static void ensureTopic(String name, KsqlConfig ksqlConfig, KafkaTopicClient topicClient) {
        if (topicClient.isTopicExists(name)) {
            KsqlInternalTopicUtils.validateTopicConfig(name, ksqlConfig, topicClient);
            return;
        }
        short replicationFactor = ksqlConfig.getShort("ksql.internal.topic.replicas");
        if (replicationFactor < 2) {
            log.warn("Creating topic {} with replication factor of {} which is less than 2. This is not advisable in a production environment. ", (Object)name, (Object)replicationFactor);
        }
        short minInSyncReplicas = ksqlConfig.getShort("ksql.internal.topic.min.insync.replicas");
        topicClient.createTopic(name, 1, replicationFactor, (Map)ImmutableMap.builder().putAll(INTERNAL_TOPIC_CONFIG).put((Object)"min.insync.replicas", (Object)minInSyncReplicas).build());
    }

    private static void validateTopicConfig(String name, KsqlConfig ksqlConfig, KafkaTopicClient topicClient) {
        TopicDescription description = topicClient.describeTopic(name);
        int actualPartitionCount = description.partitions().size();
        if (actualPartitionCount != 1) {
            throw new IllegalStateException("Invalid partition count on topic '" + name + "'. Expected: " + 1 + ", but was: " + actualPartitionCount);
        }
        short replicationFactor = ksqlConfig.getShort("ksql.internal.topic.replicas");
        int actualRf = ((TopicPartitionInfo)description.partitions().get(0)).replicas().size();
        if (actualRf < replicationFactor) {
            throw new IllegalStateException("Invalid replication factor on topic '" + name + "'. Expected: " + replicationFactor + ", but was: " + actualRf);
        }
        if (replicationFactor < 2) {
            log.warn("Topic {} has replication factor of {} which is less than 2. This is not advisable in a production environment. ", (Object)name, (Object)replicationFactor);
        }
        Map existingConfig = topicClient.getTopicConfig(name);
        if (topicClient.addTopicConfig(name, INTERNAL_TOPIC_CONFIG)) {
            log.warn("Topic {} was created with or modified to have an invalid configuration: {} - overriding the following configurations: {}", new Object[]{name, existingConfig, INTERNAL_TOPIC_CONFIG});
        }
    }
}

