/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.engine.QueryCleanupService;
import io.confluent.ksql.rest.util.PersistentQueryCleanup;
import io.confluent.ksql.services.ServiceContext;
import io.confluent.ksql.util.BinPackedPersistentQueryMetadataImpl;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.PersistentQueryMetadata;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentQueryCleanupImpl
implements PersistentQueryCleanup {
    private static final Logger LOG = LoggerFactory.getLogger(PersistentQueryCleanupImpl.class);
    private final String stateDir;
    private final ServiceContext serviceContext;
    private final QueryCleanupService queryCleanupService;
    private final KsqlConfig ksqlConfig;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public PersistentQueryCleanupImpl(String stateDir, ServiceContext serviceContext, KsqlConfig ksqlConfig) {
        this.stateDir = stateDir;
        this.ksqlConfig = ksqlConfig;
        this.serviceContext = serviceContext;
        this.queryCleanupService = new QueryCleanupService();
        this.queryCleanupService.startAsync();
    }

    @Override
    public void cleanupLeakedQueries(List<PersistentQueryMetadata> persistentQueries) {
        Set stateStoreNames = persistentQueries.stream().flatMap(s -> {
            ArrayList<String> doNotDelete = new ArrayList<String>(Collections.singletonList(s.getQueryApplicationId()));
            if (s instanceof BinPackedPersistentQueryMetadataImpl) {
                doNotDelete.add(s.getQueryApplicationId() + "/__" + s.getQueryId().toString() + "__");
            }
            return doNotDelete.stream();
        }).collect(Collectors.toSet());
        String[] stateDirFileNames = new File(this.stateDir).list();
        if (stateDirFileNames == null) {
            LOG.info("No state stores to clean up");
        } else {
            Set<String> allStateStores = Arrays.stream(stateDirFileNames).flatMap(f -> {
                String[] fileNames = new File(this.stateDir + "/" + f).list();
                if (null == fileNames) {
                    return Stream.of(f);
                }
                if (Arrays.stream(fileNames).anyMatch(t -> t.matches("__*__"))) {
                    return Arrays.stream(fileNames).filter(t -> t.matches("__*__")).map(s -> f + "/" + s);
                }
                return Stream.of(f);
            }).collect(Collectors.toSet());
            allStateStores.removeAll(stateStoreNames);
            allStateStores.forEach(storeName -> this.queryCleanupService.addCleanupTask(new QueryCleanupService.QueryCleanupTask(this.serviceContext, storeName.split("/")[0], 1 < storeName.split("__").length ? Optional.of(storeName.split("__")[1]) : Optional.empty(), false, this.stateDir, this.ksqlConfig.getString("ksql.service.id"), this.ksqlConfig.getString("ksql.persistent.prefix"))));
        }
    }

    @Override
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public QueryCleanupService getQueryCleanupService() {
        return this.queryCleanupService;
    }
}

