/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.util;

import io.confluent.ksql.KsqlExecutionContext;
import io.confluent.ksql.rest.server.KsqlRestConfig;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlStatementException;

public final class QueryCapacityUtil {
    private QueryCapacityUtil() {
    }

    public static boolean exceedsPersistentQueryCapacity(KsqlExecutionContext executionContext, KsqlConfig ksqlConfig) {
        return executionContext.getPersistentQueries().size() > QueryCapacityUtil.getQueryLimit(ksqlConfig);
    }

    public static void throwTooManyActivePersistentQueriesException(KsqlExecutionContext executionContext, KsqlConfig ksqlConfig, String statementStr) {
        String sanitizedMessage = String.format("Not executing statement(s) as it would cause the number of active, persistent queries to exceed the configured limit. Use the TERMINATE command to terminate existing queries, or increase the '%s' setting via the 'ksql-server.properties' file. Current persistent query count: %d. Configured limit: %d.", "ksql.query.persistent.active.limit", executionContext.getPersistentQueries().size(), QueryCapacityUtil.getQueryLimit(ksqlConfig));
        String unloggedMessage = String.format("Not executing statement(s) '%s' as it would cause the number of active, persistent queries to exceed the configured limit. Use the TERMINATE command to terminate existing queries, or increase the '%s' setting via the 'ksql-server.properties' file. Current persistent query count: %d. Configured limit: %d.", statementStr, "ksql.query.persistent.active.limit", executionContext.getPersistentQueries().size(), QueryCapacityUtil.getQueryLimit(ksqlConfig));
        throw new KsqlStatementException(sanitizedMessage, unloggedMessage, statementStr, KsqlStatementException.Problem.REQUEST);
    }

    private static int getQueryLimit(KsqlConfig ksqlConfig) {
        return ksqlConfig.getInt("ksql.query.persistent.active.limit");
    }

    public static boolean exceedsPushQueryCapacity(KsqlExecutionContext executionContext, KsqlRestConfig ksqlRestConfig) {
        return QueryCapacityUtil.getNumLivePushQueries(executionContext) >= QueryCapacityUtil.getPushQueryLimit(ksqlRestConfig);
    }

    public static void throwTooManyActivePushQueriesException(KsqlExecutionContext executionContext, KsqlRestConfig ksqlRestConfig, String statementStr) {
        String sanitizedMessage = String.format("Not executing statement(s) as it would cause the number of active, push queries to exceed the configured limit. Terminate existing PUSH queries, or increase the '%s' setting via the 'ksql-server.properties' file. Current push query count: %d. Configured limit: %d.", "ksql.max.push.queries", QueryCapacityUtil.getNumLivePushQueries(executionContext), QueryCapacityUtil.getPushQueryLimit(ksqlRestConfig));
        String unloggedMessage = String.format("Not executing statement(s) '%s' as it would cause the number of active, push queries to exceed the configured limit. Terminate existing PUSH queries, or increase the '%s' setting via the 'ksql-server.properties' file. Current push query count: %d. Configured limit: %d.", statementStr, "ksql.max.push.queries", QueryCapacityUtil.getNumLivePushQueries(executionContext), QueryCapacityUtil.getPushQueryLimit(ksqlRestConfig));
        throw new KsqlStatementException(sanitizedMessage, unloggedMessage, statementStr);
    }

    private static int getNumLivePushQueries(KsqlExecutionContext ctx) {
        return ctx.getAllLiveQueries().size() - ctx.getPersistentQueries().size();
    }

    private static int getPushQueryLimit(KsqlRestConfig ksqlRestConfig) {
        return ksqlRestConfig.getInt("ksql.max.push.queries");
    }
}

