/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.clients.CloudAdmin;
import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import joptsimple.OptionSpec;
import kafka.admin.AdminOperationException;
import kafka.admin.BrokerHealthCommandOptions;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import org.apache.kafka.clients.admin.AlterBrokerHealthOptions;
import org.apache.kafka.clients.admin.AlterBrokerHealthSpec;
import org.apache.kafka.clients.admin.BrokerComponent;
import org.apache.kafka.clients.admin.BrokerHealthStatusResult;
import org.apache.kafka.clients.admin.ComponentHealthStatus;
import org.apache.kafka.clients.admin.DegradedBrokerComponent;
import org.apache.kafka.clients.admin.DescribeBrokerHealthOptions;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;

public final class BrokerHealthCommand$
implements Logging {
    public static final BrokerHealthCommand$ MODULE$ = new BrokerHealthCommand$();
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public void main(String[] args) {
        int exitCode = 0;
        try {
            try {
                this.run(args, (Option<CloudAdmin>)None$.MODULE$);
            }
            catch (Throwable e) {
                exitCode = 1;
                this.printException(e);
            }
        }
        catch (Throwable throwable) {
            throw Exit$.MODULE$.exit(exitCode, (Option<String>)None$.MODULE$);
        }
        throw Exit$.MODULE$.exit(exitCode, (Option<String>)None$.MODULE$);
    }

    public void run(String[] args, Option<CloudAdmin> clientOption) {
        BrokerHealthCommandOptions opts = (BrokerHealthCommandOptions)((Object)new Some((Object)new BrokerHealthCommandOptions(args)).get());
        try (CloudAdmin client = (CloudAdmin)clientOption.getOrElse((Function0 & Serializable)() -> MODULE$.createAdminClient(opts));){
            try {
                if (opts.options.has((OptionSpec)opts.describeOpt())) {
                    this.describeBrokerHealth(client);
                } else {
                    this.alterBrokerHealth(client, opts);
                }
            }
            catch (ExecutionException e) {
                if (e.getCause() != null) {
                    throw e.getCause();
                }
                throw e;
            }
        }
    }

    public Option<CloudAdmin> run$default$2() {
        return None$.MODULE$;
    }

    private void printException(Throwable e) {
        Predef$.MODULE$.println((Object)new StringBuilder(44).append("Error while running broker health command : ").append(e.getMessage()).toString());
    }

    private void describeBrokerHealth(CloudAdmin client) {
        ((Collection)client.describeBrokerHealth(new DescribeBrokerHealthOptions()).future().get()).forEach(result -> {
            Predef$.MODULE$.println((Object)new StringBuilder(18).append("\tDegraded Broker: ").append(result.brokerId()).toString());
            MODULE$.printDegradedBrokerComponents(result.degradedBrokerComponents());
            Predef$.MODULE$.println();
            Predef$.MODULE$.println();
        });
    }

    private void printDegradedBrokerComponents(Set<DegradedBrokerComponent> degradedBrokerComponents) {
        degradedBrokerComponents.forEach(degradedBrokerComponent -> {
            Predef$.MODULE$.println((Object)new StringBuilder(22).append("\t\tDegraded Component: ").append(degradedBrokerComponent.brokerComponent()).toString());
            Predef$.MODULE$.println((Object)new StringBuilder(10).append("\t\tReason: ").append(degradedBrokerComponent.reason()).toString());
        });
    }

    private void alterBrokerHealth(CloudAdmin client, BrokerHealthCommandOptions opts) {
        int controllerId;
        ComponentHealthStatus componentHealthStatus = this.parseHealthStatus(((String)opts.options.valueOf(opts.healthStatusOpt())).toUpperCase());
        BrokerComponent brokerComponent = this.parseBrokerComponent(((String)opts.options.valueOf(opts.componentOpt())).toUpperCase());
        scala.collection.immutable.Set<Integer> brokerIds = this.parseBrokerIds((String)opts.options.valueOf(opts.brokerIdsOpt()));
        if (brokerIds.contains((Object)(controllerId = ((Node)client.describeCluster().controller().get()).id()))) {
            ComponentHealthStatus componentHealthStatus2 = componentHealthStatus;
            ComponentHealthStatus componentHealthStatus3 = ComponentHealthStatus.DEGRADED;
            if (!(componentHealthStatus2 != null ? !componentHealthStatus2.equals(componentHealthStatus3) : componentHealthStatus3 != null)) {
                Predef$.MODULE$.println((Object)new StringBuilder(73).append("The controller:(").append(controllerId).append(")'s ").append(brokerComponent.name()).append(" component health status is being marked as DEGRADED.").toString());
            }
        }
        AlterBrokerHealthSpec requestData = new AlterBrokerHealthSpec(CollectionConverters$.MODULE$.SetHasAsJava(this.parseBrokerIds((String)opts.options.valueOf(opts.brokerIdsOpt()))).asJava(), brokerComponent, componentHealthStatus, (String)opts.options.valueOf(opts.reasonOpt()), opts.options.has((OptionSpec)opts.forceOpt()));
        client.alterBrokerHealth(requestData, new AlterBrokerHealthOptions()).values().forEach((x0$1, x1$1) -> {
            try {
                BrokerHealthStatusResult result = (BrokerHealthStatusResult)x1$1.get();
                Predef$.MODULE$.print((Object)new StringBuilder(9).append("\tBroker: ").append(result.brokerId()).toString());
                Predef$.MODULE$.print((Object)new StringBuilder(13).append("\t\tComponent: ").append(result.brokerComponent()).toString());
                Predef$.MODULE$.print((Object)new StringBuilder(9).append("\t\tState: ").append(result.componentHealthStatus()).toString());
                Predef$.MODULE$.println();
                return;
            }
            catch (ExecutionException e) {
                if (e.getCause() != null) {
                    MODULE$.printBrokerFailedMessage(e.getCause(), (Integer)x0$1);
                    return;
                }
                MODULE$.printBrokerFailedMessage(e, (Integer)x0$1);
                return;
            }
            catch (InterruptedException e) {
                MODULE$.printBrokerFailedMessage(e, (Integer)x0$1);
                return;
            }
        });
    }

    private void printBrokerFailedMessage(Throwable throwable, Integer brokerId) {
        Predef$.MODULE$.print((Object)new StringBuilder(19).append("\tBroker: ").append(brokerId).append("\tFailed: ").append(throwable.getMessage()).append("\n").toString());
    }

    private CloudAdmin createAdminClient(BrokerHealthCommandOptions opts) {
        Properties props = opts.options.has(opts.commandConfigOpt()) ? Utils.loadProps((String)((String)opts.options.valueOf(opts.commandConfigOpt())), null) : new Properties();
        props.setProperty("bootstrap.servers", (String)opts.options.valueOf(opts.bootstrapServer()));
        return CloudAdmin.create((Properties)props);
    }

    private scala.collection.immutable.Set<Integer> parseBrokerIds(String brokerIdsString) {
        StringOps$.MODULE$.foreach$extension(Predef$.MODULE$.augmentString(brokerIdsString), (Function1 & Serializable)ch -> {
            BrokerHealthCommand$.$anonfun$parseBrokerIds$1(brokerIdsString, BoxesRunTime.unboxToChar((Object)ch));
            return BoxedUnit.UNIT;
        });
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])brokerIdsString.split(",")), (Function1 & Serializable)brokerId -> Predef$.MODULE$.int2Integer(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(brokerId))), ClassTag$.MODULE$.apply(Integer.class))).toSet();
    }

    private ComponentHealthStatus parseHealthStatus(String healthStatusString) {
        ComponentHealthStatus healthStatus = ComponentHealthStatus.forString((String)healthStatusString);
        if (healthStatus.equals((Object)ComponentHealthStatus.UNKNOWN)) {
            throw new AdminOperationException(new StringBuilder(68).append("Broker component: ").append(healthStatusString).append(" is not valid. Must be one of HEALTHY or DEGRADED.").toString());
        }
        return healthStatus;
    }

    private BrokerComponent parseBrokerComponent(String brokerComponentString) {
        BrokerComponent brokerComponent = BrokerComponent.forString((String)brokerComponentString);
        if (brokerComponent.equals((Object)BrokerComponent.UNKNOWN)) {
            throw new AdminOperationException(new StringBuilder(71).append("Broker component: ").append(brokerComponentString).append(" is not valid. Must be one of UNSPECIFIED or STORAGE.").toString());
        }
        if (brokerComponent.equals((Object)BrokerComponent.NETWORK)) {
            throw new UnsupportedOperationException(new StringBuilder(113).append("Broker component: ").append(brokerComponent).append(" is not currently supported. Please use component UNSPECIFIED if you wish to demote the broker.").toString());
        }
        return brokerComponent;
    }

    public static final /* synthetic */ void $anonfun$parseBrokerIds$1(String brokerIdsString$1, char ch) {
        if (!((Object)BoxesRunTime.boxToCharacter((char)ch)).equals(BoxesRunTime.boxToCharacter((char)',')) && !RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(ch))) {
            throw new AdminOperationException(new StringBuilder(54).append("Broker ids: ").append(brokerIdsString$1).append(", must not include invalid character - '").append(ch).append("'.").toString());
        }
    }

    private BrokerHealthCommand$() {
    }
}

