/*
 * Decompiled with CFR 0.152.
 */
package kafka.raft;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.concurrent.DefaultEventExecutor;
import io.confluent.kafka.concurrent.EventExecutor;
import io.confluent.kafka.raft.CompositeRaftTracer;
import io.confluent.kafka.raft.RaftTracer;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import kafka.durability.audit.manager.KRaftDurabilityAuditor$;
import kafka.log.LocalLog$;
import kafka.raft.KafkaMetadataLog;
import kafka.raft.KafkaMetadataLog$;
import kafka.raft.KafkaNetworkChannel;
import kafka.raft.KafkaRaftManager$;
import kafka.raft.MetadataLogConfig$;
import kafka.raft.RaftManager;
import kafka.raft.TimingWheelExpirationService;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRaftServer;
import kafka.server.KafkaRaftServer$;
import kafka.server.KafkaRaftServer$ControllerRole$;
import kafka.server.MetaProperties;
import kafka.tier.raft.KRaftSnapshotManager;
import kafka.tier.store.TierObjectStore;
import kafka.utils.CoreUtils$;
import kafka.utils.FileLock;
import kafka.utils.Logging;
import kafka.utils.timer.SystemTimer;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.ManualMetadataUpdater;
import org.apache.kafka.clients.MetadataUpdater;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.ExpirationService;
import org.apache.kafka.raft.FileBasedStateStore;
import org.apache.kafka.raft.KafkaRaftClient;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.raft.NetworkChannel;
import org.apache.kafka.raft.QuorumStateStore;
import org.apache.kafka.raft.RaftClient;
import org.apache.kafka.raft.RaftConfig;
import org.apache.kafka.raft.RaftRequest;
import org.apache.kafka.raft.ReplicatedLog;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.util.KafkaScheduler;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.server.util.ShutdownableThread;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\r-v!\u0002$H\u0011\u0003ae!\u0002(H\u0011\u0003y\u0005\"\u0002,\u0002\t\u00039f\u0001\u0002-\u0002\u0001eC\u0001\"\\\u0002\u0003\u0002\u0003\u0006IA\u001c\u0005\n\u007f\u000e\u0011\t\u0011)A\u0005\u0003\u0003A!\"a\u0006\u0004\u0005\u0003\u0005\u000b\u0011BA\r\u0011\u001916\u0001\"\u0001\u0002&!9\u0011\u0011H\u0002\u0005B\u0005m\u0002bBA\"\u0007\u0011\u0005\u0013Q\t\u0005\b\u0003\u001b\u001aA\u0011IA#\u0011\u001d\ty%\u0001C\u0005\u0003#Bq!a\u001b\u0002\t\u0013\tiGB\u0003O\u000f\u0002\tI\b\u0003\u0006\u0002\n6\u0011)\u0019!C\u0001\u0003\u0017C!\"a&\u000e\u0005\u0003\u0005\u000b\u0011BAG\u0011)\tI*\u0004B\u0001B\u0003%\u00111\u0014\u0005\u000b\u0003Ck!\u0011!Q\u0001\n\u0005\r\u0006BCAZ\u001b\t\u0005\t\u0015!\u0003\u00026\"Q\u0011qX\u0007\u0003\u0002\u0003\u0006I!!1\t\u0015\u0005\u001dWB!A!\u0002\u0013\tI\r\u0003\u0006\u0002T6\u0011\t\u0011)A\u0005\u0003+D!\"a8\u000e\u0005\u0003\u0005\u000b\u0011BAq\u0011)\t9/\u0004BC\u0002\u0013\u0005\u0011\u0011\u001e\u0005\u000b\u0005Wi!\u0011!Q\u0001\n\u0005-\bBCA\f\u001b\t\u0005\t\u0015!\u0003\u0002\u001a!Q!QF\u0007\u0003\u0002\u0003\u0006IAa\f\t\rYkA\u0011\u0001B#\u0011%\u0011y&\u0004b\u0001\n\u0013\u0011\t\u0007\u0003\u0005\u0003p5\u0001\u000b\u0011\u0002B2\u0011%\u0011\t(\u0004b\u0001\n\u0003\u0011\u0019\b\u0003\u0005\u0003\u00026\u0001\u000b\u0011\u0002B;\u0011%\u0011\u0019)\u0004b\u0001\n\u0013\u0011)\t\u0003\u0005\u0003\u000e6\u0001\u000b\u0011\u0002BD\u0011!yXB1A\u0005\n\t=\u0005\u0002\u0003BI\u001b\u0001\u0006I!!\u0001\t\u0013\tMUB1A\u0005\n\tU\u0005\u0002\u0003BO\u001b\u0001\u0006IAa&\t\u0013\t}UB1A\u0005\n\t\u0005\u0006\u0002\u0003BU\u001b\u0001\u0006IAa)\t\u0013\u0005]TB1A\u0005\n\t-\u0006\u0002\u0003BW\u001b\u0001\u0006I!a\u0015\t\u0013\t=VB1A\u0005\n\tE\u0006\u0002\u0003B[\u001b\u0001\u0006IAa-\t\u0013\t]VB1A\u0005B\te\u0006\u0002\u0003Ba\u001b\u0001\u0006IAa/\t\u0013\t\rWB1A\u0005\n\t\u0015\u0007\u0002\u0003Bg\u001b\u0001\u0006IAa2\t\u0013\t=WB1A\u0005\n\tE\u0007\u0002\u0003Bp\u001b\u0001\u0006IAa5\t\u0013\t\u0005XB1A\u0005\n\t\r\b\u0002\u0003Bv\u001b\u0001\u0006IA!:\t\u00115l!\u0019!C!\u0005[D\u0001B!=\u000eA\u0003%!q\u001e\u0005\n\u0005gl!\u0019!C\u0005\u0005kD\u0001ba\u0001\u000eA\u0003%!q\u001f\u0005\n\u0007\u000bi\u0001\u0019!C\u0005\u0007\u000fA\u0011b!\b\u000e\u0001\u0004%Iaa\b\t\u0011\r\u0015R\u0002)Q\u0005\u0007\u0013Aqaa\n\u000e\t\u0003\tY\u0004C\u0004\u0004*5!\t!a\u000f\t\u000f\r-R\u0002\"\u0011\u0004.!91\u0011I\u0007\u0005B\r\r\u0003bBB9\u001b\u0011%11\u000f\u0005\b\u0007\u0003kA\u0011BBB\u0011\u001d\u0019))\u0004C\u0005\u0007\u000fCqa!#\u000e\t\u0013\u0019Y\tC\u0004\u0004\u000e6!Iaa$\t\u000f\r]U\u0002\"\u0003\u0004\u001a\"91\u0011U\u0007\u0005B\r\r\u0016\u0001E&bM.\f'+\u00194u\u001b\u0006t\u0017mZ3s\u0015\tA\u0015*\u0001\u0003sC\u001a$(\"\u0001&\u0002\u000b-\fgm[1\u0004\u0001A\u0011Q*A\u0007\u0002\u000f\n\u00012*\u00194lCJ\u000bg\r^'b]\u0006<WM]\n\u0003\u0003A\u0003\"!\u0015+\u000e\u0003IS\u0011aU\u0001\u0006g\u000e\fG.Y\u0005\u0003+J\u0013a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001M\u00051\u0011\u0016M\u001a;J_RC'/Z1e'\r\u0019!l\u001a\t\u00037\u0016l\u0011\u0001\u0018\u0006\u0003;z\u000bA!\u001e;jY*\u0011q\fY\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005)\u000b'B\u00012d\u0003\u0019\t\u0007/Y2iK*\tA-A\u0002pe\u001eL!A\u001a/\u0003%MCW\u000f\u001e3po:\f'\r\\3UQJ,\u0017\r\u001a\t\u0003Q.l\u0011!\u001b\u0006\u0003U&\u000bQ!\u001e;jYNL!\u0001\\5\u0003\u000f1{wmZ5oO\u000611\r\\5f]R\u0004$a\u001c<\u0011\u0007A\u0014H/D\u0001r\u0015\tA\u0005-\u0003\u0002tc\ny1*\u00194lCJ\u000bg\r^\"mS\u0016tG\u000f\u0005\u0002vm2\u0001A!C<\u0005\u0003\u0003\u0005\tQ!\u0001y\u0005\ryF%M\t\u0003sr\u0004\"!\u0015>\n\u0005m\u0014&a\u0002(pi\"Lgn\u001a\t\u0003#vL!A *\u0003\u0007\u0005s\u00170\u0001\tuQJ,\u0017\r\u001a(b[\u0016\u0004&/\u001a4jqB!\u00111AA\t\u001d\u0011\t)!!\u0004\u0011\u0007\u0005\u001d!+\u0004\u0002\u0002\n)\u0019\u00111B&\u0002\rq\u0012xn\u001c;?\u0013\r\tyAU\u0001\u0007!J,G-\u001a4\n\t\u0005M\u0011Q\u0003\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005=!+A\tgCR\fGNR1vYRD\u0015M\u001c3mKJ\u0004B!a\u0007\u0002\"5\u0011\u0011Q\u0004\u0006\u0004\u0003?q\u0016!\u00024bk2$\u0018\u0002BA\u0012\u0003;\u0011ABR1vYRD\u0015M\u001c3mKJ$\u0002\"a\n\u0002,\u0005U\u0012q\u0007\t\u0004\u0003S\u0019Q\"A\u0001\t\r5<\u0001\u0019AA\u0017a\u0011\ty#a\r\u0011\tA\u0014\u0018\u0011\u0007\t\u0004k\u0006MBAC<\u0002,\u0005\u0005\t\u0011!B\u0001q\"1qp\u0002a\u0001\u0003\u0003Aq!a\u0006\b\u0001\u0004\tI\"\u0001\u0004e_^{'o\u001b\u000b\u0003\u0003{\u00012!UA \u0013\r\t\tE\u0015\u0002\u0005+:LG/\u0001\tj]&$\u0018.\u0019;f'\",H\u000fZ8x]R\u0011\u0011q\t\t\u0004#\u0006%\u0013bAA&%\n9!i\\8mK\u0006t\u0017!C5t%Vtg.\u001b8h\u0003I\u0019'/Z1uK2{w\rR5sK\u000e$xN]=\u0015\r\u0005M\u00131MA4!\u0011\t)&a\u0018\u000e\u0005\u0005]#\u0002BA-\u00037\n!![8\u000b\u0005\u0005u\u0013\u0001\u00026bm\u0006LA!!\u0019\u0002X\t!a)\u001b7f\u0011\u001d\t)g\u0003a\u0001\u0003'\na\u0001\\8h\t&\u0014\bbBA5\u0017\u0001\u0007\u0011\u0011A\u0001\u000bY><G)\u001b:OC6,\u0017a\u00037pG.$\u0015\r^1ESJ$B!a\u001c\u0002vA\u0019\u0001.!\u001d\n\u0007\u0005M\u0014N\u0001\u0005GS2,Gj\\2l\u0011\u001d\t9\b\u0004a\u0001\u0003'\nq\u0001Z1uC\u0012K'/\u0006\u0003\u0002|\u0005\u00155#B\u0007Q\u0003{:\u0007#B'\u0002\u0000\u0005\r\u0015bAAA\u000f\nY!+\u00194u\u001b\u0006t\u0017mZ3s!\r)\u0018Q\u0011\u0003\u0007\u0003\u000fk!\u0019\u0001=\u0003\u0003Q\u000ba\"\\3uCB\u0013x\u000e]3si&,7/\u0006\u0002\u0002\u000eB!\u0011qRAJ\u001b\t\t\tJ\u0003\u0002`\u0013&!\u0011QSAI\u00059iU\r^1Qe>\u0004XM\u001d;jKN\fq\"\\3uCB\u0013x\u000e]3si&,7\u000fI\u0001\u0007G>tg-[4\u0011\t\u0005=\u0015QT\u0005\u0005\u0003?\u000b\tJA\u0006LC\u001a\\\u0017mQ8oM&<\u0017a\u0003:fG>\u0014HmU3sI\u0016\u0004b!!*\u00020\u0006\rUBAAT\u0015\u0011\tI+a+\u0002\u001bM,'/[1mSj\fG/[8o\u0015\r\tiKX\u0001\u0007G>lWn\u001c8\n\t\u0005E\u0016q\u0015\u0002\f%\u0016\u001cwN\u001d3TKJ$W-\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0011\t\u0005]\u00161X\u0007\u0003\u0003sS1!!,a\u0013\u0011\ti,!/\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u00069Ao\u001c9jG&#\u0007\u0003BA\\\u0003\u0007LA!!2\u0002:\n!Q+^5e\u0003\u0011!\u0018.\\3\u0011\t\u0005-\u0017qZ\u0007\u0003\u0003\u001bT1A[A]\u0013\u0011\t\t.!4\u0003\tQKW.Z\u0001\b[\u0016$(/[2t!\u0011\t9.a7\u000e\u0005\u0005e'\u0002BAj\u0003sKA!!8\u0002Z\n9Q*\u001a;sS\u000e\u001c\u0018a\u0005;ie\u0016\fGMT1nKB\u0013XMZ5y\u001fB$\b#B)\u0002d\u0006\u0005\u0011bAAs%\n1q\n\u001d;j_:\fAdY8oiJ|G\u000e\\3s#V|'/^7W_R,'o\u001d$viV\u0014X-\u0006\u0002\u0002lB1\u0011Q^A{\u0003sl!!a<\u000b\t\u0005E\u00181_\u0001\u000bG>t7-\u001e:sK:$(bA/\u0002\\%!\u0011q_Ax\u0005E\u0019u.\u001c9mKR\f'\r\\3GkR,(/\u001a\t\t\u0003w\fiP!\u0001\u0003\u000e5\u0011\u00111_\u0005\u0005\u0003\u007f\f\u0019PA\u0002NCB\u0004BAa\u0001\u0003\n5\u0011!Q\u0001\u0006\u0005\u0005\u000f\tY&\u0001\u0003mC:<\u0017\u0002\u0002B\u0006\u0005\u000b\u0011q!\u00138uK\u001e,'\u000f\u0005\u0003\u0003\u0010\t\u0015b\u0002\u0002B\t\u0005CqAAa\u0005\u0003 9!!Q\u0003B\u000f\u001d\u0011\u00119Ba\u0007\u000f\t\u0005\u001d!\u0011D\u0005\u0002I&\u0011!mY\u0005\u0003\u0015\u0006L!\u0001\u00131\n\u0007\t\r\u0012/\u0001\u0006SC\u001a$8i\u001c8gS\u001eLAAa\n\u0003*\tY\u0011\t\u001a3sKN\u001c8\u000b]3d\u0015\r\u0011\u0019#]\u0001\u001eG>tGO]8mY\u0016\u0014\u0018+^8sk64v\u000e^3sg\u001a+H/\u001e:fA\u0005\u0011B/[3s\u001f\nTWm\u0019;Ti>\u0014Xm\u00149u!\u0019\tYP!\r\u00036%!!1GAz\u0005!y\u0005\u000f^5p]\u0006d\u0007\u0003\u0002B\u001c\u0005\u0003j!A!\u000f\u000b\t\tm\"QH\u0001\u0006gR|'/\u001a\u0006\u0004\u0005\u007fI\u0015\u0001\u0002;jKJLAAa\u0011\u0003:\tyA+[3s\u001f\nTWm\u0019;Ti>\u0014X\r\u0006\r\u0003H\t%#1\nB'\u0005\u001f\u0012\tFa\u0015\u0003V\t]#\u0011\fB.\u0005;\u0002B!T\u0007\u0002\u0004\"9\u0011\u0011R\u000eA\u0002\u00055\u0005bBAM7\u0001\u0007\u00111\u0014\u0005\b\u0003C[\u0002\u0019AAR\u0011\u001d\t\u0019l\u0007a\u0001\u0003kCq!a0\u001c\u0001\u0004\t\t\rC\u0004\u0002Hn\u0001\r!!3\t\u000f\u0005M7\u00041\u0001\u0002V\"9\u0011q\\\u000eA\u0002\u0005\u0005\bbBAt7\u0001\u0007\u00111\u001e\u0005\b\u0003/Y\u0002\u0019AA\r\u0011\u001d\u0011ic\u0007a\u0001\u0005_\taa\u00197pg\u0016$WC\u0001B2!\u0011\u0011)Ga\u001b\u000e\u0005\t\u001d$\u0002\u0002B5\u0003_\fa!\u0019;p[&\u001c\u0017\u0002\u0002B7\u0005O\u0012Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0017aB2m_N,G\rI\u0001\fCBLg+\u001a:tS>t7/\u0006\u0002\u0003vA!!q\u000fB?\u001b\t\u0011IHC\u0002\u0003|\u0001\fqa\u00197jK:$8/\u0003\u0003\u0003\u0000\te$aC!qSZ+'o]5p]N\fA\"\u00199j-\u0016\u00148/[8og\u0002\n!B]1gi\u000e{gNZ5h+\t\u00119\tE\u0002q\u0005\u0013K1Aa#r\u0005)\u0011\u0016M\u001a;D_:4\u0017nZ\u0001\fe\u00064GoQ8oM&<\u0007%\u0006\u0002\u0002\u0002\u0005\tB\u000f\u001b:fC\u0012t\u0015-\\3Qe\u00164\u0017\u000e\u001f\u0011\u0002\u00151|wmQ8oi\u0016DH/\u0006\u0002\u0003\u0018B!\u00111\u001aBM\u0013\u0011\u0011Y*!4\u0003\u00151{wmQ8oi\u0016DH/A\u0006m_\u001e\u001cuN\u001c;fqR\u0004\u0013!C:dQ\u0016$W\u000f\\3s+\t\u0011\u0019\u000bE\u0002\\\u0005KK1Aa*]\u00059Y\u0015MZ6b'\u000eDW\rZ;mKJ\f!b]2iK\u0012,H.\u001a:!+\t\t\u0019&\u0001\u0005eCR\fG)\u001b:!\u0003-!\u0017\r^1ESJdunY6\u0016\u0005\tM\u0006#B)\u0002d\u0006=\u0014\u0001\u00043bi\u0006$\u0015N\u001d'pG.\u0004\u0013!\u0004:fa2L7-\u0019;fI2{w-\u0006\u0002\u0003<B\u0019\u0001O!0\n\u0007\t}\u0016OA\u0007SKBd\u0017nY1uK\u0012dunZ\u0001\u000fe\u0016\u0004H.[2bi\u0016$Gj\\4!\u0003)qW\r^\"iC:tW\r\\\u000b\u0003\u0005\u000f\u00042!\u0014Be\u0013\r\u0011Ym\u0012\u0002\u0014\u0017\u000647.\u0019(fi^|'o[\"iC:tW\r\\\u0001\f]\u0016$8\t[1o]\u0016d\u0007%A\bfqBL'/\u0019;j_:$\u0016.\\3s+\t\u0011\u0019\u000e\u0005\u0003\u0003V\nmWB\u0001Bl\u0015\r\u0011I.[\u0001\u0006i&lWM]\u0005\u0005\u0005;\u00149NA\u0006TsN$X-\u001c+j[\u0016\u0014\u0018\u0001E3ya&\u0014\u0018\r^5p]RKW.\u001a:!\u0003E)\u0007\u0010]5sCRLwN\\*feZL7-Z\u000b\u0003\u0005K\u00042!\u0014Bt\u0013\r\u0011Io\u0012\u0002\u001d)&l\u0017N\\4XQ\u0016,G.\u0012=qSJ\fG/[8o'\u0016\u0014h/[2f\u0003I)\u0007\u0010]5sCRLwN\\*feZL7-\u001a\u0011\u0016\u0005\t=\b\u0003\u00029s\u0003\u0007\u000bqa\u00197jK:$\b%\u0001\u0007sC\u001a$\u0018j\u001c+ie\u0016\fG-\u0006\u0002\u0003xB\u0019!\u0011`\u0002\u000f\u0007\tm\bA\u0004\u0003\u0003~\u000e\u0005a\u0002BA\u0004\u0005\u007fL\u0011AS\u0005\u0003\u0011&\u000bQB]1gi&{G\u000b\u001b:fC\u0012\u0004\u0013\u0001C3yK\u000e,Ho\u001c:\u0016\u0005\r%\u0001#B)\u0002d\u000e-\u0001\u0003BB\u0007\u00073i!aa\u0004\u000b\t\u0005E8\u0011\u0003\u0006\u0004\u0015\u000eM!\u0002BB\u000b\u0007/\t\u0011bY8oM2,XM\u001c;\u000b\u0005\u0005e\u0013\u0002BB\u000e\u0007\u001f\u0011Q\"\u0012<f]R,\u00050Z2vi>\u0014\u0018\u0001D3yK\u000e,Ho\u001c:`I\u0015\fH\u0003BA\u001f\u0007CA\u0011ba\t:\u0003\u0003\u0005\ra!\u0003\u0002\u0007a$\u0013'A\u0005fq\u0016\u001cW\u000f^8sA\u000591\u000f^1siV\u0004\u0018\u0001C:ikR$wn\u001e8\u0002\u0011I,w-[:uKJ$B!!\u0010\u00040!91\u0011G\u001fA\u0002\rM\u0012\u0001\u00037jgR,g.\u001a:\u0011\r\rU21HAB\u001d\r\u00018qG\u0005\u0004\u0007s\t\u0018A\u0003*bMR\u001cE.[3oi&!1QHB \u0005!a\u0015n\u001d;f]\u0016\u0014(bAB\u001dc\u0006i\u0001.\u00198eY\u0016\u0014V-];fgR$\u0002b!\u0012\u0004T\r\r4q\r\t\u0007\u0003[\f)pa\u0012\u0011\t\r%3qJ\u0007\u0003\u0007\u0017RAa!\u0014\u0002:\u0006A\u0001O]8u_\u000e|G.\u0003\u0003\u0004R\r-#AC!qS6+7o]1hK\"91Q\u000b A\u0002\r]\u0013A\u00025fC\u0012,'\u000f\u0005\u0003\u0004Z\r}SBAB.\u0015\u0011\u0019i&!/\u0002\u0011I,\u0017/^3tiNLAa!\u0019\u0004\\\ti!+Z9vKN$\b*Z1eKJDqa!\u001a?\u0001\u0004\u00199%A\u0004sKF,Xm\u001d;\t\u000f\r%d\b1\u0001\u0004l\u0005i1M]3bi\u0016$G+[7f\u001bN\u00042!UB7\u0013\r\u0019yG\u0015\u0002\u0005\u0019>tw-A\u000fnCf\u0014WMQ;jY\u0012\u0014\u0016M\u001a;T]\u0006\u00048\u000f[8u\u001b\u0006t\u0017mZ3s)\t\u0019)\bE\u0003R\u0003G\u001c9\b\u0005\u0003\u0004z\ruTBAB>\u0015\rA%QH\u0005\u0005\u0007\u007f\u001aYH\u0001\u000bL%\u00064Go\u00158baNDw\u000e^'b]\u0006<WM]\u0001\u0010EVLG\u000e\u001a*bMR\u001cE.[3oiR\u0011!q^\u0001\u0014EVLG\u000e\u001a(fi^|'o[\"iC:tW\r\u001c\u000b\u0003\u0005\u000f\fQb\u0019:fCR,G)\u0019;b\t&\u0014HCAA*\u0003A\u0011W/\u001b7e\u001b\u0016$\u0018\rZ1uC2{w\r\u0006\u0002\u0004\u0012B\u0019Qja%\n\u0007\rUuI\u0001\tLC\u001a\\\u0017-T3uC\u0012\fG/\u0019'pO\u0006\u0011\"-^5mI:+Go^8sW\u000ec\u0017.\u001a8u)\t\u0019Y\n\u0005\u0003\u0003x\ru\u0015\u0002BBP\u0005s\u0012QBT3uo>\u00148n\u00117jK:$\u0018A\u00047fC\u0012,'/\u00118e\u000bB|7\r[\u000b\u0003\u0007K\u00032\u0001]BT\u0013\r\u0019I+\u001d\u0002\u000f\u0019\u0016\fG-\u001a:B]\u0012,\u0005o\\2i\u0001")
public class KafkaRaftManager<T>
implements RaftManager<T>,
Logging {
    private final MetaProperties metaProperties;
    private final KafkaConfig config;
    private final RecordSerde<T> recordSerde;
    private final TopicPartition topicPartition;
    private final Uuid topicId;
    private final Time time;
    private final Metrics metrics;
    private final CompletableFuture<java.util.Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture;
    private final Optional<TierObjectStore> tierObjectStoreOpt;
    private final AtomicBoolean closed;
    private final ApiVersions apiVersions;
    private final RaftConfig raftConfig;
    private final String threadNamePrefix;
    private final LogContext logContext;
    private final KafkaScheduler scheduler;
    private final File dataDir;
    private final Option<FileLock> dataDirLock;
    private final ReplicatedLog replicatedLog;
    private final KafkaNetworkChannel netChannel;
    private final SystemTimer expirationTimer;
    private final TimingWheelExpirationService expirationService;
    private final KafkaRaftClient<T> client;
    private final RaftIoThread raftIoThread;
    private Option<EventExecutor> executor;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public MetaProperties metaProperties() {
        return this.metaProperties;
    }

    public CompletableFuture<java.util.Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture() {
        return this.controllerQuorumVotersFuture;
    }

    private AtomicBoolean closed() {
        return this.closed;
    }

    public ApiVersions apiVersions() {
        return this.apiVersions;
    }

    private RaftConfig raftConfig() {
        return this.raftConfig;
    }

    private String threadNamePrefix() {
        return this.threadNamePrefix;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    private KafkaScheduler scheduler() {
        return this.scheduler;
    }

    private File dataDir() {
        return this.dataDir;
    }

    private Option<FileLock> dataDirLock() {
        return this.dataDirLock;
    }

    @Override
    public ReplicatedLog replicatedLog() {
        return this.replicatedLog;
    }

    private KafkaNetworkChannel netChannel() {
        return this.netChannel;
    }

    private SystemTimer expirationTimer() {
        return this.expirationTimer;
    }

    private TimingWheelExpirationService expirationService() {
        return this.expirationService;
    }

    @Override
    public KafkaRaftClient<T> client() {
        return this.client;
    }

    private RaftIoThread raftIoThread() {
        return this.raftIoThread;
    }

    private Option<EventExecutor> executor() {
        return this.executor;
    }

    private void executor_$eq(Option<EventExecutor> x$1) {
        this.executor = x$1;
    }

    public void startup() {
        java.util.Map<Integer, RaftConfig.AddressSpec> voterAddresses = this.controllerQuorumVotersFuture().get();
        CollectionConverters$.MODULE$.SetHasAsScala(voterAddresses.entrySet()).asScala().foreach((Function1 & Serializable)voterAddressEntry -> {
            KafkaRaftManager.$anonfun$startup$1(this, voterAddressEntry);
            return BoxedUnit.UNIT;
        });
        this.netChannel().start();
        this.raftIoThread().start();
    }

    public void shutdown() {
        if (!this.closed().getAndSet(true)) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.expirationService().shutdown(), this, Level.WARN);
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.expirationTimer().shutdown(), this, Level.WARN);
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.raftIoThread().shutdown(), this, Level.WARN);
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.client().close(), this, Level.WARN);
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.scheduler().shutdown(), this, Level.WARN);
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.netChannel().close(), this, Level.WARN);
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.replicatedLog().close(), this, Level.WARN);
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.dataDirLock().foreach((Function1 & Serializable)x$3 -> {
                x$3.destroy();
                return BoxedUnit.UNIT;
            }), this, Level.WARN);
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.executor().foreach((Function1 & Serializable)x$4 -> x$4.shutdown()), this, Level.WARN);
            return;
        }
    }

    @Override
    public void register(RaftClient.Listener<T> listener) {
        this.client().register(listener);
    }

    @Override
    public CompletableFuture<ApiMessage> handleRequest(RequestHeader header, ApiMessage request, long createdTimeMs) {
        RaftRequest.Inbound inboundRequest = new RaftRequest.Inbound(header.correlationId(), request, createdTimeMs);
        this.client().handle(inboundRequest);
        return inboundRequest.completion.thenApply(response -> response.data());
    }

    private Option<KRaftSnapshotManager> maybeBuildRaftSnapshotManager() {
        if (!Predef$.MODULE$.Boolean2boolean(this.config.confluentConfig().clusterMetadataSnapshotTierUploadEnableFlag())) {
            return None$.MODULE$;
        }
        if (!this.tierObjectStoreOpt.isPresent()) {
            throw new ConfigException(new StringBuilder(45).append("tier.enable is set to ").append(this.config.confluentConfig().tierEnable()).append(", should be set to true").toString());
        }
        Function<TopicIdPartition, Optional<Path>> topicIdPath = tpId -> {
            TopicIdPartition topicIdPartition = tpId;
            TopicIdPartition topicIdPartition2 = new TopicIdPartition(KafkaRaftServer$.MODULE$.MetadataTopicId(), KafkaRaftServer$.MODULE$.MetadataPartition());
            if (topicIdPartition != null && topicIdPartition.equals(topicIdPartition2)) {
                return Optional.of(Paths.get($this.config.metadataLogDir(), new String[0]));
            }
            return Optional.empty();
        };
        int pendingTasksCapacity = 100;
        this.executor_$eq((Option<EventExecutor>)new Some((Object)new DefaultEventExecutor(Executors.defaultThreadFactory(), pendingTasksCapacity)));
        return new Some((Object)KRaftSnapshotManager.create((EventExecutor)this.executor().get(), this.tierObjectStoreOpt.get(), this.logContext(), topicIdPath, this.metaProperties().clusterId()));
    }

    private KafkaRaftClient<T> buildRaftClient() {
        FileBasedStateStore quorumStateStore = new FileBasedStateStore(new File(this.dataDir(), "quorum-state"));
        OptionalInt nodeId = OptionalInt.of(this.config.nodeId());
        ObjectRef tracers = ObjectRef.create((Object)new .colon.colon((Object)KRaftDurabilityAuditor$.MODULE$, (List)Nil$.MODULE$));
        this.maybeBuildRaftSnapshotManager().foreach((Function1 & Serializable)snapshotTracer -> {
            tracers.elem = ((List)tracers.elem).$colon$colon((Object)snapshotTracer);
            return BoxedUnit.UNIT;
        });
        KafkaRaftClient client = new KafkaRaftClient(this.recordSerde, (NetworkChannel)this.netChannel(), this.replicatedLog(), (QuorumStateStore)quorumStateStore, this.time, this.metrics, (ExpirationService)this.expirationService(), this.logContext(), this.metaProperties().clusterId(), nodeId, this.raftConfig(), (RaftTracer)new CompositeRaftTracer(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((List)tracers.elem)).asJava(), this.logContext()));
        client.initialize();
        return client;
    }

    private KafkaNetworkChannel buildNetworkChannel() {
        NetworkClient netClient = this.buildNetworkClient();
        return new KafkaNetworkChannel(this.time, (KafkaClient)netClient, Predef$.MODULE$.Integer2int(this.config.quorumRequestTimeoutMs()), this.threadNamePrefix());
    }

    private File createDataDir() {
        TopicPartition logDirName_topicPartition = this.topicPartition;
        Object var2_1 = null;
        String logDirName = LocalLog$.MODULE$.logDirName(logDirName_topicPartition);
        return KafkaRaftManager$.MODULE$.kafka$raft$KafkaRaftManager$$createLogDirectory(new File(this.config.metadataLogDir()), logDirName);
    }

    private KafkaMetadataLog buildMetadataLog() {
        return KafkaMetadataLog$.MODULE$.apply(this.topicPartition, this.topicId, this.dataDir(), this.time, this.metrics, (Scheduler)this.scheduler(), MetadataLogConfig$.MODULE$.apply(this.config, 0x800000, 0x800000), x$5 -> this.client().traceLogStartOffsetChange(), x$6 -> this.client().traceLogSnapshotGeneration());
    }

    /*
     * WARNING - void declaration
     */
    private NetworkClient buildNetworkClient() {
        void clientChannelBuilder_logContext;
        void clientChannelBuilder_saslHandshakeRequestEnable;
        void clientChannelBuilder_time;
        void clientChannelBuilder_clientSaslMechanism;
        void clientChannelBuilder_config;
        ListenerName controllerListenerName = new ListenerName((String)this.config.controllerListenerNames().head());
        SecurityProtocol controllerSecurityProtocol = (SecurityProtocol)this.config.effectiveListenerSecurityProtocolMap().getOrElse((Object)controllerListenerName, (Function0 & Serializable)() -> SecurityProtocol.forName((String)controllerListenerName.value()));
        LogContext logContext = this.logContext();
        boolean bl = this.config.saslInterBrokerHandshakeRequestEnable();
        Time time = this.time;
        String string = this.config.saslMechanismControllerProtocol();
        KafkaConfig kafkaConfig = this.config;
        JaasContext.Type clientChannelBuilder_contextType = JaasContext.Type.SERVER;
        Object var12_8 = null;
        kafkaConfig = null;
        string = null;
        time = null;
        logContext = null;
        ChannelBuilder channelBuilder = ChannelBuilders.clientChannelBuilder((SecurityProtocol)controllerSecurityProtocol, (JaasContext.Type)clientChannelBuilder_contextType, (AbstractConfig)clientChannelBuilder_config, (ListenerName)controllerListenerName, (String)clientChannelBuilder_clientSaslMechanism, (Time)clientChannelBuilder_time, (boolean)clientChannelBuilder_saslHandshakeRequestEnable, (LogContext)clientChannelBuilder_logContext, null, null);
        String metricGroupPrefix = "raft-channel";
        boolean collectPerConnectionMetrics = false;
        Selector selector = new Selector(-1, Predef$.MODULE$.Long2long(this.config.connectionsMaxIdleMs()), this.metrics, this.time, metricGroupPrefix, CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().empty()).asJava(), collectPerConnectionMetrics, channelBuilder, this.logContext());
        String clientId = new StringBuilder(12).append("raft-client-").append(this.config.nodeId()).toString();
        int maxInflightRequestsPerConnection = 1;
        int reconnectBackoffMs = 50;
        int reconnectBackoffMsMs = 500;
        boolean discoverBrokerVersions = true;
        return new NetworkClient((Selectable)selector, (MetadataUpdater)new ManualMetadataUpdater(), clientId, maxInflightRequestsPerConnection, Int$.MODULE$.int2long(reconnectBackoffMs), Int$.MODULE$.int2long(reconnectBackoffMsMs), -1, Predef$.MODULE$.Integer2int(this.config.socketReceiveBufferBytes()), Predef$.MODULE$.Integer2int(this.config.quorumRequestTimeoutMs()), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMs()), Predef$.MODULE$.Long2long(this.config.connectionSetupTimeoutMaxMs()), this.time, discoverBrokerVersions, this.apiVersions(), this.logContext());
    }

    @Override
    public LeaderAndEpoch leaderAndEpoch() {
        return this.client().leaderAndEpoch();
    }

    public static final /* synthetic */ void $anonfun$startup$1(KafkaRaftManager $this, Map.Entry voterAddressEntry) {
        RaftConfig.AddressSpec addressSpec = (RaftConfig.AddressSpec)voterAddressEntry.getValue();
        if (addressSpec instanceof RaftConfig.InetAddressSpec) {
            RaftConfig.InetAddressSpec inetAddressSpec = (RaftConfig.InetAddressSpec)addressSpec;
            $this.netChannel().updateEndpoint(Predef$.MODULE$.Integer2int((Integer)voterAddressEntry.getKey()), inetAddressSpec);
            return;
        }
        if (addressSpec instanceof RaftConfig.UnknownAddressSpec) {
            $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(79).append("Skipping channel update for destination ID: ").append(voterAddressEntry.getKey()).append(" ").append("because of non-routable endpoint: ").append(RaftConfig.NON_ROUTABLE_ADDRESS.toString()).toString());
            return;
        }
        if (addressSpec != null) {
            $this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(72).append("Unexpected address spec (type: ").append(addressSpec.getClass()).append(") for channel update for ").append("destination ID: ").append(voterAddressEntry.getKey()).toString());
            return;
        }
        throw new MatchError(null);
    }

    public KafkaRaftManager(MetaProperties metaProperties, KafkaConfig config, RecordSerde<T> recordSerde, TopicPartition topicPartition, Uuid topicId, Time time, Metrics metrics, Option<String> threadNamePrefixOpt, CompletableFuture<java.util.Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture, FaultHandler fatalFaultHandler, Optional<TierObjectStore> tierObjectStoreOpt) {
        this.metaProperties = metaProperties;
        this.config = config;
        this.recordSerde = recordSerde;
        this.topicPartition = topicPartition;
        this.topicId = topicId;
        this.time = time;
        this.metrics = metrics;
        this.controllerQuorumVotersFuture = controllerQuorumVotersFuture;
        this.tierObjectStoreOpt = tierObjectStoreOpt;
        this.closed = new AtomicBoolean(false);
        this.apiVersions = new ApiVersions();
        this.raftConfig = new RaftConfig((AbstractConfig)config);
        this.threadNamePrefix = (String)threadNamePrefixOpt.getOrElse((Function0 & Serializable)() -> "kafka-raft");
        this.logContext = new LogContext(new StringBuilder(18).append("[RaftManager id=").append(config.nodeId()).append("] ").toString());
        this.logIdent_$eq(this.logContext().logPrefix());
        this.scheduler = new KafkaScheduler(1, true, new StringBuilder(10).append(this.threadNamePrefix()).append("-scheduler").toString(), false);
        this.scheduler().startup();
        this.dataDir = this.createDataDir();
        boolean differentMetadataLogDir = !((SeqOps)config.logDirs().map((Function1 & Serializable)x$2 -> Paths.get(x$2, new String[0]).toAbsolutePath())).contains((Object)Paths.get(config.metadataLogDir(), new String[0]).toAbsolutePath());
        Set<KafkaRaftServer.ProcessRole> set = config.processRoles();
        Object object = Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaRaftServer$ControllerRole$[]{KafkaRaftServer$ControllerRole$.MODULE$}));
        boolean isOnlyController = !(set != null ? !set.equals(object) : object != null);
        this.dataDirLock = differentMetadataLogDir || isOnlyController ? new Some((Object)KafkaRaftManager$.MODULE$.kafka$raft$KafkaRaftManager$$lockDataDir(new File(config.metadataLogDir()))) : None$.MODULE$;
        this.replicatedLog = this.buildMetadataLog();
        this.netChannel = this.buildNetworkChannel();
        this.expirationTimer = new SystemTimer("raft-expiration-executor", 1L, 20, Time.SYSTEM.hiResClockMs());
        this.expirationService = new TimingWheelExpirationService(this.expirationTimer());
        this.client = this.buildRaftClient();
        this.raftIoThread = new RaftIoThread(this.client(), this.threadNamePrefix(), fatalFaultHandler);
        this.executor = None$.MODULE$;
    }

    public static class RaftIoThread
    extends ShutdownableThread
    implements Logging {
        private final KafkaRaftClient<?> client;
        private final FaultHandler fatalFaultHandler;
        private Logger logger;
        private String logIdent;
        private volatile boolean bitmap$0;

        @Override
        public String loggerName() {
            return Logging.loggerName$(this);
        }

        @Override
        public String msgWithLogIdent(String msg) {
            return Logging.msgWithLogIdent$(this, msg);
        }

        @Override
        public void trace(Function0<String> msg) {
            Logging.trace$(this, msg);
        }

        @Override
        public void trace(Function0<String> msg, Function0<Throwable> e) {
            Logging.trace$(this, msg, e);
        }

        @Override
        public boolean isDebugEnabled() {
            return Logging.isDebugEnabled$(this);
        }

        @Override
        public boolean isTraceEnabled() {
            return Logging.isTraceEnabled$(this);
        }

        @Override
        public void debug(Function0<String> msg) {
            Logging.debug$(this, msg);
        }

        @Override
        public void debug(Function0<String> msg, Function0<Throwable> e) {
            Logging.debug$(this, msg, e);
        }

        @Override
        public void info(Function0<String> msg) {
            Logging.info$(this, msg);
        }

        @Override
        public void info(Function0<String> msg, Function0<Throwable> e) {
            Logging.info$(this, msg, e);
        }

        @Override
        public void warn(Function0<String> msg) {
            Logging.warn$(this, msg);
        }

        @Override
        public void warn(Function0<String> msg, Function0<Throwable> e) {
            Logging.warn$(this, msg, e);
        }

        @Override
        public void error(Function0<String> msg) {
            Logging.error$(this, msg);
        }

        @Override
        public void error(Function0<String> msg, Function0<Throwable> e) {
            Logging.error$(this, msg, e);
        }

        @Override
        public void fatal(Function0<String> msg) {
            Logging.fatal$(this, msg);
        }

        @Override
        public void fatal(Function0<String> msg, Function0<Throwable> e) {
            Logging.fatal$(this, msg, e);
        }

        private Logger logger$lzycompute() {
            synchronized (this) {
                if (!this.bitmap$0) {
                    this.logger = Logging.logger$(this);
                    this.bitmap$0 = true;
                }
            }
            return this.logger;
        }

        @Override
        public Logger logger() {
            if (!this.bitmap$0) {
                return this.logger$lzycompute();
            }
            return this.logger;
        }

        @Override
        public String logIdent() {
            return this.logIdent;
        }

        @Override
        public void logIdent_$eq(String x$1) {
            this.logIdent = x$1;
        }

        public void doWork() {
            try {
                this.client.poll();
                return;
            }
            catch (Throwable t) {
                throw this.fatalFaultHandler.handleFault("Unexpected error in raft IO thread", t);
            }
        }

        public boolean initiateShutdown() {
            if (super.initiateShutdown()) {
                this.client.shutdown(5000).whenComplete((x$1, exception) -> {
                    if (exception != null) {
                        this.error((Function0<String>)(Function0 & Serializable)() -> "Graceful shutdown of RaftClient failed", (Function0<Throwable>)(Function0 & Serializable)() -> exception);
                        return;
                    }
                    this.info((Function0<String>)(Function0 & Serializable)() -> "Completed graceful shutdown of RaftClient");
                });
                return true;
            }
            return false;
        }

        public boolean isRunning() {
            return this.client.isRunning() && !this.isThreadFailed();
        }

        public RaftIoThread(KafkaRaftClient<?> client, String threadNamePrefix, FaultHandler fatalFaultHandler) {
            this.client = client;
            this.fatalFaultHandler = fatalFaultHandler;
            super(new StringBuilder(10).append(threadNamePrefix).append("-io-thread").toString(), false);
            this.logIdent_$eq(this.logPrefix);
        }
    }
}

