/*
 * Decompiled with CFR 0.152.
 */
package kafka.restore.configmap;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kafka.restore.configmap.PartitionConfig;

public class TopicConfig {
    private String name;
    private String topicId;
    private long fromTimestamp;
    private long revertCompactionSinceTimestamp;
    private List<PartitionConfig> partitionConfigs = new ArrayList<PartitionConfig>();

    public TopicConfig() {
    }

    public TopicConfig(String name, String topicId, long fromTimestamp, long revertCompactionSinceTimestamp) {
        this.name = name;
        this.topicId = topicId;
        this.fromTimestamp = fromTimestamp;
        this.revertCompactionSinceTimestamp = revertCompactionSinceTimestamp;
    }

    public void addPartition(PartitionConfig pc) {
        this.partitionConfigs.add(pc);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getFromTimestamp() {
        return this.fromTimestamp;
    }

    public void setFromTimestamp(long fromTimestamp) {
        this.fromTimestamp = fromTimestamp;
    }

    public long getRevertCompactionSinceTimestamp() {
        return this.revertCompactionSinceTimestamp;
    }

    public void setRevertCompactionSinceTimestamp(long revertCompactionSinceTimestamp) {
        this.revertCompactionSinceTimestamp = revertCompactionSinceTimestamp;
    }

    public List<PartitionConfig> getPartitionConfigs() {
        return this.partitionConfigs;
    }

    public void setPartitionConfigs(List<PartitionConfig> partitionConfigs) {
        this.partitionConfigs = partitionConfigs;
    }

    public static TopicConfig fromMap(Map<String, Object> map) {
        Object ts;
        TopicConfig topicConfig = new TopicConfig();
        if (map.containsKey("name")) {
            topicConfig.name = (String)map.get("name");
        }
        if (map.containsKey("topicId")) {
            topicConfig.topicId = (String)map.get("topicId");
        }
        if (map.containsKey("fromTimestamp")) {
            ts = map.get("fromTimestamp");
            if (ts instanceof Integer) {
                topicConfig.fromTimestamp = ((Integer)ts).intValue();
            } else if (ts instanceof Long) {
                topicConfig.fromTimestamp = (Long)ts;
            }
        }
        if (map.containsKey("revertCompactionSinceTimestamp")) {
            ts = map.get("revertCompactionSinceTimestamp");
            if (ts instanceof Integer) {
                topicConfig.revertCompactionSinceTimestamp = ((Integer)ts).intValue();
            } else if (ts instanceof Long) {
                topicConfig.revertCompactionSinceTimestamp = (Long)ts;
            }
        }
        if (map.containsKey("partitionConfigs")) {
            List partitionList = (List)map.get("partitionConfigs");
            for (Object replica : partitionList) {
                topicConfig.partitionConfigs.add(PartitionConfig.fromMap((Map)replica));
            }
        }
        return topicConfig;
    }

    public String getTopicId() {
        return this.topicId;
    }

    public void setTopicId(String topicId) {
        this.topicId = topicId;
    }
}

