/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.network.RequestChannel;
import kafka.server.AbstractQuotaChannelManager;
import kafka.server.ActiveTenantsManager;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientSensors;
import kafka.server.ControllerMutationQuota;
import kafka.server.ControllerMutationQuotaManager$;
import kafka.server.PermissiveControllerMutationQuota;
import kafka.server.QuotaType$ControllerMutation$;
import kafka.server.StrictControllerMutationQuota;
import kafka.server.UnboundedControllerMutationQuota$;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.QuotaViolationException;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.quota.ClientQuotaCallback;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005Eu!\u0002\u000e\u001c\u0011\u0003\u0001c!\u0002\u0012\u001c\u0011\u0003\u0019\u0003\"\u0002\u0016\u0002\t\u0003Y\u0003b\u0002\u0017\u0002\u0005\u0004%\t!\f\u0005\u0007c\u0005\u0001\u000b\u0011\u0002\u0018\t\u000bI\nA\u0011A\u001a\u0007\t\tZ\u0002A\u0012\u0005\t\u0015\u001a\u0011)\u0019!C\u0005\u0017\"AqJ\u0002B\u0001B\u0003%A\n\u0003\u0005=\r\t\u0015\r\u0011\"\u0003Q\u0011!!fA!A!\u0002\u0013\t\u0006\u0002C+\u0007\u0005\u000b\u0007I\u0011\u000b,\t\u0013u3!\u0011!Q\u0001\n]s\u0006\u0002C0\u0007\u0005\u000b\u0007I\u0011\u00021\t\u001114!\u0011!Q\u0001\n\u0005D\u0001\"\u001c\u0004\u0003\u0006\u0004%IA\u001c\u0005\ts\u001a\u0011\t\u0011)A\u0005_\")!F\u0002C\u0001u\"9\u00111\u0001\u0004\u0005R\u0005\u0015\u0001bBA\r\r\u0011\u0005\u00131\u0004\u0005\b\u0003G1A\u0011IA\u0013\u0011\u001d\t9F\u0002C\u0001\u00033Bq!a\u0016\u0007\t\u0003\t)\u0007C\u0004\u0002v\u0019!\t!a\u001e\t\u000f\u0005Ud\u0001\"\u0001\u0002~!9\u0011\u0011\u0011\u0004\u0005\u0002\u0005\r\u0015AH\"p]R\u0014x\u000e\u001c7fe6+H/\u0019;j_:\fVo\u001c;b\u001b\u0006t\u0017mZ3s\u0015\taR$\u0001\u0004tKJ4XM\u001d\u0006\u0002=\u0005)1.\u00194lC\u000e\u0001\u0001CA\u0011\u0002\u001b\u0005Y\"AH\"p]R\u0014x\u000e\u001c7fe6+H/\u0019;j_:\fVo\u001c;b\u001b\u0006t\u0017mZ3s'\t\tA\u0005\u0005\u0002&Q5\taEC\u0001(\u0003\u0015\u00198-\u00197b\u0013\tIcE\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0001\na$U;pi\u0006\u001cuN\u001c;s_2dWM]'vi\u0006$\u0018n\u001c8EK\u001a\fW\u000f\u001c;\u0016\u00039\u0002\"!J\u0018\n\u0005A2#A\u0002#pk\ndW-A\u0010Rk>$\u0018mQ8oiJ|G\u000e\\3s\u001bV$\u0018\r^5p]\u0012+g-Y;mi\u0002\na\u0002\u001e5s_R$H.\u001a+j[\u0016l5\u000f\u0006\u00025oA\u0011Q%N\u0005\u0003m\u0019\u0012A\u0001T8oO\")\u0001(\u0002a\u0001s\u0005\tQ\r\u0005\u0002;\t6\t1H\u0003\u0002={\u00059Q.\u001a;sS\u000e\u001c(B\u0001 @\u0003\u0019\u0019w.\\7p]*\u0011a\u0004\u0011\u0006\u0003\u0003\n\u000ba!\u00199bG\",'\"A\"\u0002\u0007=\u0014x-\u0003\u0002Fw\t9\u0012+^8uCZKw\u000e\\1uS>tW\t_2faRLwN\\\n\u0003\r\u001d\u0003\"!\t%\n\u0005%[\"AE\"mS\u0016tG/U;pi\u0006l\u0015M\\1hKJ\faaY8oM&<W#\u0001'\u0011\u0005\u0005j\u0015B\u0001(\u001c\u0005a\u0019E.[3oiF+x\u000e^1NC:\fw-\u001a:D_:4\u0017nZ\u0001\bG>tg-[4!+\u0005\t\u0006C\u0001\u001eS\u0013\t\u00196HA\u0004NKR\u0014\u0018nY:\u0002\u00115,GO]5dg\u0002\nA\u0001^5nKV\tq\u000b\u0005\u0002Y76\t\u0011L\u0003\u0002[{\u0005)Q\u000f^5mg&\u0011A,\u0017\u0002\u0005)&lW-A\u0003uS6,\u0007%\u0003\u0002V\u0011\u0006\u0001B\u000f\u001b:fC\u0012t\u0015-\\3Qe\u00164\u0017\u000e_\u000b\u0002CB\u0011!-\u001b\b\u0003G\u001e\u0004\"\u0001\u001a\u0014\u000e\u0003\u0015T!AZ\u0010\u0002\rq\u0012xn\u001c;?\u0013\tAg%\u0001\u0004Qe\u0016$WMZ\u0005\u0003U.\u0014aa\u0015;sS:<'B\u00015'\u0003E!\bN]3bI:\u000bW.\u001a)sK\u001aL\u0007\u0010I\u0001\u0014G2LWM\u001c;Rk>$\u0018mQ1mY\n\f7m[\u000b\u0002_B\u0019Q\u0005\u001d:\n\u0005E4#AB(qi&|g\u000e\u0005\u0002to6\tAO\u0003\u0002vm\u0006)\u0011/^8uC*\u0011AdP\u0005\u0003qR\u00141c\u00117jK:$\u0018+^8uC\u000e\u000bG\u000e\u001c2bG.\fAc\u00197jK:$\u0018+^8uC\u000e\u000bG\u000e\u001c2bG.\u0004CcB>}{z|\u0018\u0011\u0001\t\u0003C\u0019AQAS\tA\u00021CQ\u0001P\tA\u0002ECQ!V\tA\u0002]CQaX\tA\u0002\u0005DQ!\\\tA\u0002=\fAc\u00197jK:$(+\u0019;f\u001b\u0016$(/[2OC6,G\u0003BA\u0004\u0003\u001f\u0001B!!\u0003\u0002\f5\tQ(C\u0002\u0002\u000eu\u0012!\"T3ue&\u001cg*Y7f\u0011\u001d\t\tB\u0005a\u0001\u0003'\tq\"];pi\u0006lU\r\u001e:jGR\u000bwm\u001d\t\u0006E\u0006U\u0011-Y\u0005\u0004\u0003/Y'aA'ba\u0006\u0019\"-Y2laJ,7o];sK\u0016s\u0017M\u00197fIV\u0011\u0011Q\u0004\t\u0004K\u0005}\u0011bAA\u0011M\t9!i\\8mK\u0006t\u0017A\u0007:fG>\u0014H-\u00118e\u000f\u0016$H\u000b\u001b:piRdW\rV5nK6\u001bHCCA\u0014\u0003[\tY%a\u0014\u0002TA\u0019Q%!\u000b\n\u0007\u0005-bEA\u0002J]RDq!a\f\u0015\u0001\u0004\t\t$A\u0004tKN\u001c\u0018n\u001c8\u0011\t\u0005M\u0012Q\t\b\u0005\u0003k\tyD\u0004\u0003\u00028\u0005mbb\u00013\u0002:%\ta$C\u0002\u0002>u\tqA\\3uo>\u00148.\u0003\u0003\u0002B\u0005\r\u0013A\u0004*fcV,7\u000f^\"iC:tW\r\u001c\u0006\u0004\u0003{i\u0012\u0002BA$\u0003\u0013\u0012qaU3tg&|gN\u0003\u0003\u0002B\u0005\r\u0003BBA')\u0001\u0007\u0011-\u0001\u0005dY&,g\u000e^%e\u0011\u0019\t\t\u0006\u0006a\u0001]\u0005)a/\u00197vK\"1\u0011Q\u000b\u000bA\u0002Q\na\u0001^5nK6\u001b\u0018!\u00058foN#(/[2u#V|G/\u0019$peR1\u00111LA1\u0003G\u00022!IA/\u0013\r\tyf\u0007\u0002\u0018\u0007>tGO]8mY\u0016\u0014X*\u001e;bi&|g.U;pi\u0006Dq!a\f\u0016\u0001\u0004\t\t\u0004\u0003\u0004\u0002NU\u0001\r!\u0019\u000b\u0005\u00037\n9\u0007C\u0004\u0002jY\u0001\r!a\u001b\u0002\u000fI,\u0017/^3tiB!\u0011QNA9\u001d\u0011\ty'a\u0010\u000e\u0005\u0005\r\u0013\u0002BA:\u0003\u0013\u0012qAU3rk\u0016\u001cH/A\u000boK^\u0004VM]7jgNLg/Z)v_R\fgi\u001c:\u0015\r\u0005m\u0013\u0011PA>\u0011\u001d\tyc\u0006a\u0001\u0003cAa!!\u0014\u0018\u0001\u0004\tG\u0003BA.\u0003\u007fBq!!\u001b\u0019\u0001\u0004\tY'A\u0006oK^\fVo\u001c;b\r>\u0014HCBA.\u0003\u000b\u000b9\tC\u0004\u0002je\u0001\r!a\u001b\t\u000f\u0005%\u0015\u00041\u0001\u0002\f\u0006\u00112\u000f\u001e:jGR\u001c\u0016N\\2f-\u0016\u00148/[8o!\r)\u0013QR\u0005\u0004\u0003\u001f3#!B*i_J$\b")
public class ControllerMutationQuotaManager
extends ClientQuotaManager {
    private final ClientQuotaManagerConfig config;
    private final Metrics metrics;
    private final String threadNamePrefix;
    private final Option<ClientQuotaCallback> clientQuotaCallback;

    public static long throttleTimeMs(QuotaViolationException e) {
        return ControllerMutationQuotaManager$.MODULE$.throttleTimeMs(e);
    }

    public static double QuotaControllerMutationDefault() {
        return ControllerMutationQuotaManager$.MODULE$.QuotaControllerMutationDefault();
    }

    private ClientQuotaManagerConfig config() {
        return this.config;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    @Override
    public Time time() {
        return super.time();
    }

    private String threadNamePrefix() {
        return this.threadNamePrefix;
    }

    private Option<ClientQuotaCallback> clientQuotaCallback() {
        return this.clientQuotaCallback;
    }

    @Override
    public MetricName clientRateMetricName(Map<String, String> quotaMetricTags) {
        return this.metrics().metricName("mutation-rate", "ControllerMutation", "Tracking mutation-rate per user/client-id", CollectionConverters$.MODULE$.MapHasAsJava(quotaMetricTags).asJava());
    }

    @Override
    public boolean backpressureEnabled() {
        return false;
    }

    @Override
    public int recordAndGetThrottleTimeMs(RequestChannel.Session session, String clientId, double value, long timeMs) {
        Sensor quotaSensor = this.getOrCreateQuotaSensors(session, clientId).quotaSensor();
        try {
            synchronized (quotaSensor) {
                quotaSensor.checkQuotas(timeMs);
                quotaSensor.record(value, timeMs, false);
            }
            return 0;
        }
        catch (QuotaViolationException e) {
            int throttleTimeMs = (int)ControllerMutationQuotaManager$.MODULE$.throttleTimeMs(e);
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Quota violated for sensor (").append(quotaSensor.name()).append("). Delay time: (").append(throttleTimeMs).append(")").toString());
            return throttleTimeMs;
        }
    }

    public ControllerMutationQuota newStrictQuotaFor(RequestChannel.Session session, String clientId) {
        if (this.quotasEnabled()) {
            ClientSensors clientSensors = this.getOrCreateQuotaSensors(session, clientId);
            return new StrictControllerMutationQuota(this.time(), clientSensors.quotaSensor());
        }
        return UnboundedControllerMutationQuota$.MODULE$;
    }

    public ControllerMutationQuota newStrictQuotaFor(RequestChannel.Request request) {
        return this.newStrictQuotaFor(request.session(), request.header().clientId());
    }

    public ControllerMutationQuota newPermissiveQuotaFor(RequestChannel.Session session, String clientId) {
        if (this.quotasEnabled()) {
            ClientSensors clientSensors = this.getOrCreateQuotaSensors(session, clientId);
            return new PermissiveControllerMutationQuota(this.time(), clientSensors.quotaSensor());
        }
        return UnboundedControllerMutationQuota$.MODULE$;
    }

    public ControllerMutationQuota newPermissiveQuotaFor(RequestChannel.Request request) {
        return this.newPermissiveQuotaFor(request.session(), request.header().clientId());
    }

    public ControllerMutationQuota newQuotaFor(RequestChannel.Request request, short strictSinceVersion) {
        if (request.header().apiVersion() >= strictSinceVersion) {
            return this.newStrictQuotaFor(request);
        }
        return this.newPermissiveQuotaFor(request);
    }

    public ControllerMutationQuotaManager(ClientQuotaManagerConfig config, Metrics metrics, Time time, String threadNamePrefix, Option<ClientQuotaCallback> clientQuotaCallback) {
        this.config = config;
        this.metrics = metrics;
        this.threadNamePrefix = threadNamePrefix;
        this.clientQuotaCallback = clientQuotaCallback;
        super(config, metrics, QuotaType$ControllerMutation$.MODULE$, time, threadNamePrefix, clientQuotaCallback, (Option<ActiveTenantsManager>)None$.MODULE$, (Option<AbstractQuotaChannelManager>)None$.MODULE$);
    }
}

