/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.server.AbstractFetcherThread;
import kafka.server.BrokerTopicStats;
import kafka.server.FailedPartitions;
import kafka.server.InitialFetchState;
import kafka.server.LeaderEndPoint;
import kafka.server.OffsetTruncationState;
import kafka.server.ReplicaAlterLogDirsTierStateMachine;
import kafka.server.ReplicaManager;
import kafka.server.ReplicationQuotaManager;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.utils.ExponentialBackoff;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.apache.kafka.storage.internals.log.LogStartOffsetIncrementReason;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005Ed\u0001B\n\u0015\u0001eA\u0001B\b\u0001\u0003\u0002\u0003\u0006Ia\b\u0005\tY\u0001\u0011\t\u0011)A\u0005[!A\u0001\u0007\u0001B\u0001B\u0003%\u0011\u0007\u0003\u00055\u0001\t\u0005\t\u0015!\u00036\u0011!\u0011\u0005A!A!\u0002\u0013\u0019\u0005\u0002\u0003$\u0001\u0005\u0003\u0005\u000b\u0011B$\t\u0011)\u0003!\u0011!Q\u0001\n-CQA\u0014\u0001\u0005\u0002=CQ\u0001\u0017\u0001\u0005ReCQa\u001a\u0001\u0005R!DQ!\u001c\u0001\u0005R9DQ\u0001\u001d\u0001\u0005REDQ\u0001 \u0001\u0005BuDq!!\n\u0001\t\u0003\n9\u0003C\u0005\u0002F\u0001\u0011\r\u0011\"\u0015\u0002H!A\u0011q\n\u0001!\u0002\u0013\tI\u0005C\u0004\u0002R\u0001!\t%a\u0015\t\u000f\u0005\u0005\u0004\u0001\"\u0015\u0002d\tI\"+\u001a9mS\u000e\f\u0017\t\u001c;fe2{w\rR5sgRC'/Z1e\u0015\t)b#\u0001\u0004tKJ4XM\u001d\u0006\u0002/\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u001b!\tYB$D\u0001\u0015\u0013\tiBCA\u000bBEN$(/Y2u\r\u0016$8\r[3s)\"\u0014X-\u00193\u0002\t9\fW.\u001a\t\u0003A%r!!I\u0014\u0011\u0005\t*S\"A\u0012\u000b\u0005\u0011B\u0012A\u0002\u001fs_>$hHC\u0001'\u0003\u0015\u00198-\u00197b\u0013\tAS%\u0001\u0004Qe\u0016$WMZ\u0005\u0003U-\u0012aa\u0015;sS:<'B\u0001\u0015&\u0003\u0019aW-\u00193feB\u00111DL\u0005\u0003_Q\u0011a\u0002T3bI\u0016\u0014XI\u001c3Q_&tG/\u0001\tgC&dW\r\u001a)beRLG/[8ogB\u00111DM\u0005\u0003gQ\u0011\u0001CR1jY\u0016$\u0007+\u0019:uSRLwN\\:\u0002%\u0015D\bo\u001c8f]RL\u0017\r\u001c\"bG.|gM\u001a\t\u0003m\u0001k\u0011a\u000e\u0006\u0003qe\nQ!\u001e;jYNT!AO\u001e\u0002\r\r|W.\\8o\u0015\t9BH\u0003\u0002>}\u00051\u0011\r]1dQ\u0016T\u0011aP\u0001\u0004_J<\u0017BA!8\u0005I)\u0005\u0010]8oK:$\u0018.\u00197CC\u000e\\wN\u001a4\u0002\u0015I,\u0007\u000f\\5dC6;'\u000f\u0005\u0002\u001c\t&\u0011Q\t\u0006\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0003\u0015\tXo\u001c;b!\tY\u0002*\u0003\u0002J)\t9\"+\u001a9mS\u000e\fG/[8o#V|G/Y'b]\u0006<WM]\u0001\u0011EJ|7.\u001a:U_BL7m\u0015;biN\u0004\"a\u0007'\n\u00055#\"\u0001\u0005\"s_.,'\u000fV8qS\u000e\u001cF/\u0019;t\u0003\u0019a\u0014N\\5u}QA\u0001+\u0015*T)V3v\u000b\u0005\u0002\u001c\u0001!)a\u0004\u0003a\u0001?!)A\u0006\u0003a\u0001[!)\u0001\u0007\u0003a\u0001c!)A\u0007\u0003a\u0001k!)!\t\u0003a\u0001\u0007\")a\t\u0003a\u0001\u000f\")!\n\u0003a\u0001\u0017\u0006YA.\u0019;fgR,\u0005o\\2i)\tQ\u0016\rE\u0002\\9zk\u0011!J\u0005\u0003;\u0016\u0012aa\u00149uS>t\u0007CA.`\u0013\t\u0001WEA\u0002J]RDQAY\u0005A\u0002\r\fa\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0002eK6\t\u0011(\u0003\u0002gs\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017A\u00047pON#\u0018M\u001d;PM\u001a\u001cX\r\u001e\u000b\u0003S2\u0004\"a\u00176\n\u0005-,#\u0001\u0002'p]\u001eDQA\u0019\u0006A\u0002\r\fA\u0002\\8h\u000b:$wJ\u001a4tKR$\"![8\t\u000b\t\\\u0001\u0019A2\u0002#\u0015tGm\u00144gg\u0016$hi\u001c:Fa>\u001c\u0007\u000eF\u0002ssj\u00042a\u0017/t!\t!x/D\u0001v\u0015\tQdO\u0003\u0002\u0016w%\u0011\u00010\u001e\u0002\u000f\u001f\u001a47/\u001a;B]\u0012,\u0005o\\2i\u0011\u0015\u0011G\u00021\u0001d\u0011\u0015YH\u00021\u0001_\u0003\u0015)\u0007o\\2i\u0003Q\u0001(o\\2fgN\u0004\u0016M\u001d;ji&|g\u000eR1uCR9a0a\u0005\u0002\u0016\u0005e\u0001cA.]\u007fB!\u0011\u0011AA\b\u001b\t\t\u0019A\u0003\u0003\u0002\u0006\u0005\u001d\u0011a\u00017pO*!\u0011\u0011BA\u0006\u0003%Ig\u000e^3s]\u0006d7OC\u0002\u0002\u000em\nqa\u001d;pe\u0006<W-\u0003\u0003\u0002\u0012\u0005\r!!\u0004'pO\u0006\u0003\b/\u001a8e\u0013:4w\u000eC\u0003c\u001b\u0001\u00071\r\u0003\u0004\u0002\u00185\u0001\r![\u0001\fM\u0016$8\r[(gMN,G\u000fC\u0004\u0002\u001c5\u0001\r!!\b\u0002\u001bA\f'\u000f^5uS>tG)\u0019;b!\u0011\ty\"!\t\u000e\u0003\u0001I1!a\t\u001d\u0005%1U\r^2i\t\u0006$\u0018-A\u0007bI\u0012\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0005\u0003S\t)\u0004E\u0003\u0002,\u0005E2-\u0004\u0002\u0002.)\u0019\u0011qF\u0013\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u00024\u00055\"aA*fi\"9\u0011q\u0007\bA\u0002\u0005e\u0012AE5oSRL\u0017\r\u001c$fi\u000eD7\u000b^1uKN\u0004r!a\u000b\u0002<\r\fy$\u0003\u0003\u0002>\u00055\"aA'baB\u00191$!\u0011\n\u0007\u0005\rCCA\tJ]&$\u0018.\u00197GKR\u001c\u0007n\u0015;bi\u0016\fq$[:PM\u001a\u001cX\r\u001e$pe2+\u0017\rZ3s\u000bB|7\r[*vaB|'\u000f^3e+\t\tI\u0005E\u0002\\\u0003\u0017J1!!\u0014&\u0005\u001d\u0011un\u001c7fC:\f\u0001%[:PM\u001a\u001cX\r\u001e$pe2+\u0017\rZ3s\u000bB|7\r[*vaB|'\u000f^3eA\u0005AAO];oG\u0006$X\r\u0006\u0004\u0002J\u0005U\u0013q\u000b\u0005\u0006EF\u0001\ra\u0019\u0005\b\u00033\n\u0002\u0019AA.\u0003=!(/\u001e8dCRLwN\\*uCR,\u0007cA\u000e\u0002^%\u0019\u0011q\f\u000b\u0003+=3gm]3u)J,hnY1uS>t7\u000b^1uK\u00069BO];oG\u0006$XMR;mYf\fe\u000eZ*uCJ$\u0018\t\u001e\u000b\u0007\u0003K\nY'!\u001c\u0011\u0007m\u000b9'C\u0002\u0002j\u0015\u0012A!\u00168ji\")!M\u0005a\u0001G\"1\u0011q\u000e\nA\u0002%\faa\u001c4gg\u0016$\b")
public class ReplicaAlterLogDirsThread
extends AbstractFetcherThread {
    private final ReplicaManager replicaMgr;
    private final ReplicationQuotaManager quota;
    private final boolean isOffsetForLeaderEpochSupported;

    @Override
    public Option<Object> latestEpoch(TopicPartition topicPartition) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).latestEpoch();
    }

    @Override
    public long logStartOffset(TopicPartition topicPartition) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).logStartOffset();
    }

    @Override
    public long logEndOffset(TopicPartition topicPartition) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).logEndOffset();
    }

    @Override
    public Option<OffsetAndEpoch> endOffsetForEpoch(TopicPartition topicPartition, int epoch) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).endOffsetForEpoch(epoch);
    }

    @Override
    public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, FetchResponseData.PartitionData partitionData) {
        Partition partition = this.replicaMgr.getPartitionOrException(topicPartition);
        AbstractLog futureLog = partition.futureLocalLogOrException();
        MemoryRecords records = this.toMemoryRecords(FetchResponse.recordsOrFail((FetchResponseData.PartitionData)partitionData));
        if (fetchOffset != futureLog.logEndOffset()) {
            throw new IllegalStateException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Offset mismatch for the future replica %s: fetched offset = %d, log end offset = %d."), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, BoxesRunTime.boxToLong((long)fetchOffset), BoxesRunTime.boxToLong((long)futureLog.logEndOffset())})));
        }
        Option<LogAppendInfo> logAppendInfo = records.sizeInBytes() > 0 ? partition.appendRecordsToFollowerOrFutureReplica(records, true) : None$.MODULE$;
        futureLog.updateHighWatermark(partitionData.highWatermark());
        futureLog.maybeIncrementLogStartOffset(partitionData.logStartOffset(), LogStartOffsetIncrementReason.LeaderOffsetIncremented);
        if (partition.maybeReplaceCurrentWithFutureReplica()) {
            this.removePartitions((Set<TopicPartition>)((Set)Set$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))));
        }
        this.quota.record(records.sizeInBytes());
        return logAppendInfo;
    }

    @Override
    public Set<TopicPartition> addPartitions(Map<TopicPartition, InitialFetchState> initialFetchStates) {
        Set<TopicPartition> set;
        this.partitionMapLock().lockInterruptibly();
        try {
            Map filteredFetchStates = (Map)initialFetchStates.filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ReplicaAlterLogDirsThread.$anonfun$addPartitions$1(this, x0$1)));
            set = super.addPartitions((Map<TopicPartition, InitialFetchState>)filteredFetchStates);
        }
        finally {
            this.partitionMapLock().unlock();
        }
        return set;
    }

    @Override
    public boolean isOffsetForLeaderEpochSupported() {
        return this.isOffsetForLeaderEpochSupported;
    }

    @Override
    public boolean truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
        this.replicaMgr.getPartitionOrException(topicPartition).truncateTo(truncationState.offset(), true);
        return true;
    }

    @Override
    public void truncateFullyAndStartAt(TopicPartition topicPartition, long offset) {
        this.replicaMgr.getPartitionOrException(topicPartition).truncateFullyAndStartAt(offset, true);
    }

    public static final /* synthetic */ boolean $anonfun$addPartitions$1(ReplicaAlterLogDirsThread $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            return $this.replicaMgr.futureLogExists(tp);
        }
        throw new MatchError(null);
    }

    public ReplicaAlterLogDirsThread(String name, LeaderEndPoint leader, FailedPartitions failedPartitions, ExponentialBackoff exponentialBackoff, ReplicaManager replicaMgr, ReplicationQuotaManager quota, BrokerTopicStats brokerTopicStats) {
        this.replicaMgr = replicaMgr;
        this.quota = quota;
        ReplicaAlterLogDirsTierStateMachine x$4 = new ReplicaAlterLogDirsTierStateMachine();
        Map x$9 = (Map)Map$.MODULE$.empty();
        super(name, name, leader, failedPartitions, exponentialBackoff, x$4, false, brokerTopicStats, (Map<String, String>)x$9);
        this.isOffsetForLeaderEpochSupported = true;
    }
}

