/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Properties;
import java.util.UUID;
import kafka.admin.AdminOperationException;
import kafka.admin.AdminUtils$;
import kafka.admin.BrokerMetadata;
import kafka.admin.RackAwareMode;
import kafka.admin.RackAwareMode$Disabled$;
import kafka.admin.RackAwareMode$Enforced$;
import kafka.admin.RackAwareMode$Safe$;
import kafka.cluster.Broker;
import kafka.cluster.Observer$;
import kafka.common.TopicAlreadyMarkedForDeletionException;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaAssignment$;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigType$;
import kafka.server.DynamicConfig$Broker$;
import kafka.server.DynamicConfig$Client$;
import kafka.server.DynamicConfig$Ip$;
import kafka.server.DynamicConfig$User$;
import kafka.server.link.ClusterLinkTopicState;
import kafka.utils.CoreUtils$;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import kafka.zk.ClusterLinkData;
import kafka.zk.ConfigEntityZNode$;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicZNode;
import kafka.zk.TopicZNode$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.BrokerNotAvailableException;
import org.apache.kafka.common.errors.ClusterLinkExistsException;
import org.apache.kafka.common.errors.ClusterLinkNotFoundException;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.metadata.TopicPlacement;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.zookeeper.KeeperException;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.SetOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\r=g\u0001B#G\u0001-C\u0001\u0002\u0017\u0001\u0003\u0002\u0003\u0006I!\u0017\u0005\u0006;\u0002!\tA\u0018\u0005\u0006C\u0002!\tA\u0019\u0005\n\u0003\u0003\u0002\u0011\u0013!C\u0001\u0003\u0007B\u0011\"!\u0017\u0001#\u0003%\t!a\u0017\t\u0013\u0005}\u0003!%A\u0005\u0002\u0005\u0005\u0004\"CA3\u0001E\u0005I\u0011AA1\u0011%\t9\u0007AI\u0001\n\u0003\tI\u0007C\u0004\u0002n\u0001!\t!a\u001c\t\u0013\u00055\u0005!%A\u0005\u0002\u0005m\u0003\"CAH\u0001E\u0005I\u0011AAI\u0011\u001d\t)\n\u0001C\u0001\u0003/C\u0011\"a0\u0001#\u0003%\t!!\u0019\t\u0013\u0005\u0005\u0007!%A\u0005\u0002\u0005\u0005\u0004\"CAb\u0001E\u0005I\u0011AA1\u0011%\t)\rAI\u0001\n\u0003\tI\u0007C\u0004\u0002H\u0002!\t!!3\t\u000f\u0005=\u0007\u0001\"\u0001\u0002R\"I\u0011Q\u001e\u0001\u0012\u0002\u0013\u0005\u0011q\u001e\u0005\b\u0003g\u0004A\u0011AA{\u0011%\u00119\u0001AI\u0001\n\u0003\t\t\u0007C\u0005\u0003\n\u0001\t\n\u0011\"\u0001\u0002b!I!1\u0002\u0001\u0012\u0002\u0013\u0005\u0011\u0011\u000e\u0005\b\u0005\u001b\u0001A\u0011\u0001B\b\u0011\u001d\u0011\u0019\u0002\u0001C\u0001\u0005+A\u0011Ba\u0014\u0001#\u0003%\tA!\u0015\t\u0013\tU\u0003!%A\u0005\u0002\t]\u0003\"\u0003B.\u0001E\u0005I\u0011AA1\u0011%\u0011i\u0006AI\u0001\n\u0003\u0011y\u0006C\u0005\u0003d\u0001\t\n\u0011\"\u0001\u0002j!9!Q\r\u0001\u0005\u0002\t\u001d\u0004\"\u0003B<\u0001E\u0005I\u0011\u0001B)\u0011\u001d\u0011I\b\u0001C\u0001\u0005wBqA!#\u0001\t\u0003\u0011Y\tC\u0005\u0003\u0018\u0002\t\n\u0011\"\u0001\u0002j!9!\u0011\u0014\u0001\u0005\n\tm\u0005b\u0002BV\u0001\u0011\u0005!Q\u0016\u0005\b\u0005k\u0003A\u0011\u0001B\\\u0011%\u0011I\rAI\u0001\n\u0003\t\t\u0007C\u0004\u0003L\u0002!IA!4\t\u000f\tU\u0007\u0001\"\u0001\u0003X\"9!q\u001c\u0001\u0005\u0002\t\u0005\b\"\u0003Bv\u0001E\u0005I\u0011AA1\u0011\u001d\u0011i\u000f\u0001C\u0001\u0005_DqAa>\u0001\t\u0003\u0011I\u0010C\u0004\u0003\u0000\u0002!\ta!\u0001\t\u000f\r\u001d\u0001\u0001\"\u0001\u0004\n!91q\u0002\u0001\u0005\u0002\rE\u0001bBB\b\u0001\u0011\u00051\u0011\u0004\u0005\b\u0007?\u0001A\u0011AB\u0011\u0011\u001d\u0019)\u0003\u0001C\u0001\u0007OAqa!\u0010\u0001\t\u0003\u0019y\u0004C\u0004\u0004D\u0001!\ta!\u0012\t\u000f\r%\u0003\u0001\"\u0003\u0004L!I1\u0011\f\u0001\u0012\u0002\u0013%\u0011\u0011\r\u0005\b\u00077\u0002A\u0011AB/\u0011\u001d\u0019\u0019\u0007\u0001C\u0001\u0007KBqa!\u001b\u0001\t\u0003\u0019Y\u0007C\u0004\u0004p\u0001!\ta!\u001d\t\u000f\t\r\u0002\u0001\"\u0001\u0004z!9!1\u0005\u0001\u0005\u0002\r\r\u0005bBBD\u0001\u0011\u00051\u0011\u0012\u0005\b\u00073\u0003A\u0011ABN\u0011\u001d\u0019\t\u000b\u0001C\u0001\u0007GCqa!,\u0001\t\u0003\u0019y\u000bC\u0004\u00044\u0002!\ta!.\t\u000f\re\u0006\u0001\"\u0001\u0004<\"91q\u0018\u0001\u0005\u0002\r\u0005'!D!e[&t'l[\"mS\u0016tGO\u0003\u0002H\u0011\u0006\u0011!p\u001b\u0006\u0002\u0013\u0006)1.\u00194lC\u000e\u00011c\u0001\u0001M%B\u0011Q\nU\u0007\u0002\u001d*\tq*A\u0003tG\u0006d\u0017-\u0003\u0002R\u001d\n1\u0011I\\=SK\u001a\u0004\"a\u0015,\u000e\u0003QS!!\u0016%\u0002\u000bU$\u0018\u000e\\:\n\u0005]#&a\u0002'pO\u001eLgnZ\u0001\tu.\u001cE.[3oiB\u0011!lW\u0007\u0002\r&\u0011AL\u0012\u0002\u000e\u0017\u000647.\u0019.l\u00072LWM\u001c;\u0002\rqJg.\u001b;?)\ty\u0006\r\u0005\u0002[\u0001!)\u0001L\u0001a\u00013\u0006Y1M]3bi\u0016$v\u000e]5d)5\u0019gm\u001d={\u0003\u0013\tI\"a\t\u0002(A\u0011Q\nZ\u0005\u0003K:\u0013A!\u00168ji\")qm\u0001a\u0001Q\u0006)Ao\u001c9jGB\u0011\u0011\u000e\u001d\b\u0003U:\u0004\"a\u001b(\u000e\u00031T!!\u001c&\u0002\rq\u0012xn\u001c;?\u0013\tyg*\u0001\u0004Qe\u0016$WMZ\u0005\u0003cJ\u0014aa\u0015;sS:<'BA8O\u0011\u0015!8\u00011\u0001v\u0003)\u0001\u0018M\u001d;ji&|gn\u001d\t\u0003\u001bZL!a\u001e(\u0003\u0007%sG\u000fC\u0003z\u0007\u0001\u0007Q/A\tsKBd\u0017nY1uS>tg)Y2u_JDqa_\u0002\u0011\u0002\u0003\u0007A0A\u0006u_BL7mQ8oM&<\u0007cA?\u0002\u00065\taPC\u0002\u0000\u0003\u0003\tA!\u001e;jY*\u0011\u00111A\u0001\u0005U\u00064\u0018-C\u0002\u0002\by\u0014!\u0002\u0015:pa\u0016\u0014H/[3t\u0011%\tYa\u0001I\u0001\u0002\u0004\ti!A\u0007sC\u000e\\\u0017i^1sK6{G-\u001a\t\u0005\u0003\u001f\t)\"\u0004\u0002\u0002\u0012)\u0019\u00111\u0003%\u0002\u000b\u0005$W.\u001b8\n\t\u0005]\u0011\u0011\u0003\u0002\u000e%\u0006\u001c7.Q<be\u0016lu\u000eZ3\t\u0013\u0005m1\u0001%AA\u0002\u0005u\u0011!E;tKNlu\u000eZ3s]R{\u0007/[2JIB\u0019Q*a\b\n\u0007\u0005\u0005bJA\u0004C_>dW-\u00198\t\u0013\u0005\u00152\u0001%AA\u0002\u0005u\u0011!E;tKNdUmZ1dsR{\u0007/[2JI\"I\u0011\u0011F\u0002\u0011\u0002\u0003\u0007\u00111F\u0001\fG2,8\u000f^3s\u0019&t7\u000eE\u0003N\u0003[\t\t$C\u0002\u000209\u0013aa\u00149uS>t\u0007\u0003BA\u001a\u0003{i!!!\u000e\u000b\t\u0005]\u0012\u0011H\u0001\u0005Y&t7NC\u0002\u0002<!\u000baa]3sm\u0016\u0014\u0018\u0002BA \u0003k\u0011Qc\u00117vgR,'\u000fT5oWR{\u0007/[2Ti\u0006$X-A\u000bde\u0016\fG/\u001a+pa&\u001cG\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0005\u0015#f\u0001?\u0002H-\u0012\u0011\u0011\n\t\u0005\u0003\u0017\n)&\u0004\u0002\u0002N)!\u0011qJA)\u0003%)hn\u00195fG.,GMC\u0002\u0002T9\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\t9&!\u0014\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u000bde\u0016\fG/\u001a+pa&\u001cG\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\u0005u#\u0006BA\u0007\u0003\u000f\nQc\u0019:fCR,Gk\u001c9jG\u0012\"WMZ1vYR$c'\u0006\u0002\u0002d)\"\u0011QDA$\u0003U\u0019'/Z1uKR{\u0007/[2%I\u00164\u0017-\u001e7uI]\nQc\u0019:fCR,Gk\u001c9jG\u0012\"WMZ1vYR$\u0003(\u0006\u0002\u0002l)\"\u00111FA$\u0003I9W\r\u001e\"s_.,'/T3uC\u0012\fG/Y:\u0015\r\u0005E\u00141QAC!\u0019\t\u0019(!\u001f\u0002~5\u0011\u0011Q\u000f\u0006\u0004\u0003or\u0015AC2pY2,7\r^5p]&!\u00111PA;\u0005\r\u0019V-\u001d\t\u0005\u0003\u001f\ty(\u0003\u0003\u0002\u0002\u0006E!A\u0004\"s_.,'/T3uC\u0012\fG/\u0019\u0005\n\u0003\u0017I\u0001\u0013!a\u0001\u0003\u001bA\u0011\"a\"\n!\u0003\u0005\r!!#\u0002\u0015\t\u0014xn[3s\u0019&\u001cH\u000fE\u0003N\u0003[\tY\tE\u0003\u0002t\u0005eT/\u0001\u000fhKR\u0014%o\\6fe6+G/\u00193bi\u0006\u001cH\u0005Z3gCVdG\u000fJ\u0019\u00029\u001d,GO\u0011:pW\u0016\u0014X*\u001a;bI\u0006$\u0018m\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u00111\u0013\u0016\u0005\u0003\u0013\u000b9%A\rde\u0016\fG/\u001a+pa&\u001cw+\u001b;i\u0003N\u001c\u0018n\u001a8nK:$HcD2\u0002\u001a\u0006m\u0015qTA[\u0003s\u000bY,!0\t\u000b\u001dd\u0001\u0019\u00015\t\r\u0005uE\u00021\u0001}\u0003\u0019\u0019wN\u001c4jO\"9\u0011\u0011\u0015\u0007A\u0002\u0005\r\u0016A\u00079beRLG/[8o%\u0016\u0004H.[2b\u0003N\u001c\u0018n\u001a8nK:$\bcBA:\u0003K+\u0018\u0011V\u0005\u0005\u0003O\u000b)HA\u0002NCB\u0004B!a+\u000226\u0011\u0011Q\u0016\u0006\u0004\u0003_C\u0015AC2p]R\u0014x\u000e\u001c7fe&!\u00111WAW\u0005E\u0011V\r\u001d7jG\u0006\f5o]5h]6,g\u000e\u001e\u0005\n\u0003oc\u0001\u0013!a\u0001\u0003;\t\u0001B^1mS\u0012\fG/\u001a\u0005\n\u00037a\u0001\u0013!a\u0001\u0003;A\u0011\"!\n\r!\u0003\u0005\r!!\b\t\u0013\u0005%B\u0002%AA\u0002\u0005-\u0012aI2sK\u0006$X\rV8qS\u000e<\u0016\u000e\u001e5BgNLwM\\7f]R$C-\u001a4bk2$H\u0005N\u0001$GJ,\u0017\r^3U_BL7mV5uQ\u0006\u001b8/[4o[\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00136\u0003\r\u001a'/Z1uKR{\u0007/[2XSRD\u0017i]:jO:lWM\u001c;%I\u00164\u0017-\u001e7uIY\n1e\u0019:fCR,Gk\u001c9jG^KG\u000f[!tg&<g.\\3oi\u0012\"WMZ1vYR$s'A\u0006u_BL7-\u0012=jgR\u001cH\u0003BA\u000f\u0003\u0017Da!!4\u0012\u0001\u0004A\u0017!\u0003;pa&\u001cg*Y7f\u0003M1\u0018\r\\5eCR,Gk\u001c9jG\u000e\u0013X-\u0019;f)-\u0019\u00171[Ak\u0003/\fI.!;\t\u000b\u001d\u0014\u0002\u0019\u00015\t\u000f\u0005\u0005&\u00031\u0001\u0002$\"1\u0011Q\u0014\nA\u0002qDq!a7\u0013\u0001\u0004\ti.\u0001\bu_BL7m]*vaBd\u0017.\u001a:\u0011\u000b5\u000by.a9\n\u0007\u0005\u0005hJA\u0005Gk:\u001cG/[8oaA)\u00111OAsQ&!\u0011q]A;\u0005\r\u0019V\r\u001e\u0005\n\u0003W\u0014\u0002\u0013!a\u0001\u0003G\fQb\u0019:fCR,G\rV8qS\u000e\u001c\u0018!\b<bY&$\u0017\r^3U_BL7m\u0011:fCR,G\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\u0005E(\u0006BAr\u0003\u000f\nQd\u001e:ji\u0016$v\u000e]5d!\u0006\u0014H/\u001b;j_:\f5o]5h]6,g\u000e\u001e\u000b\u000eG\u0006]\u0018\u0011`A\u007f\u0005\u0003\u0011\u0019A!\u0002\t\u000b\u001d$\u0002\u0019\u00015\t\u000f\u0005mH\u00031\u0001\u0002$\u0006\t\"/\u001a9mS\u000e\f\u0017i]:jO:lWM\u001c;\t\u000f\u0005}H\u00031\u0001\u0002\u001e\u0005A\u0011n]+qI\u0006$X\rC\u0005\u0002\u001cQ\u0001\n\u00111\u0001\u0002\u001e!I\u0011Q\u0005\u000b\u0011\u0002\u0003\u0007\u0011Q\u0004\u0005\n\u0003S!\u0002\u0013!a\u0001\u0003W\tqe\u001e:ji\u0016$v\u000e]5d!\u0006\u0014H/\u001b;j_:\f5o]5h]6,g\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%i\u00059sO]5uKR{\u0007/[2QCJ$\u0018\u000e^5p]\u0006\u001b8/[4o[\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00136\u0003\u001d:(/\u001b;f)>\u0004\u0018n\u0019)beRLG/[8o\u0003N\u001c\u0018n\u001a8nK:$H\u0005Z3gCVdG\u000f\n\u001c\u0002\u0017\u0011,G.\u001a;f)>\u0004\u0018n\u0019\u000b\u0004G\nE\u0001\"B4\u0019\u0001\u0004A\u0017!D1eIB\u000b'\u000f^5uS>t7\u000f\u0006\u000b\u0002$\n]!\u0011\u0004B\u000f\u0005C\u0011)C!\u000b\u0003.\t%#1\n\u0005\u0006Of\u0001\r\u0001\u001b\u0005\b\u00057I\u0002\u0019AAR\u0003I)\u00070[:uS:<\u0017i]:jO:lWM\u001c;\t\u000f\t}\u0011\u00041\u0001\u0002r\u0005Q\u0011\r\u001c7Ce>\\WM]:\t\u0011\t\r\u0012\u0004%AA\u0002U\fQB\\;n!\u0006\u0014H/\u001b;j_:\u001c\b\"CA~3A\u0005\t\u0019\u0001B\u0014!\u0015i\u0015QFAR\u0011%\u0011Y#\u0007I\u0001\u0002\u0004\ti\"\u0001\u0007wC2LG-\u0019;f\u001f:d\u0017\u0010C\u0005\u00030e\u0001\n\u00111\u0001\u00032\u0005qAo\u001c9jGBc\u0017mY3nK:$\b#B'\u0002.\tM\u0002\u0003\u0002B\u001b\u0005\u000bj!Aa\u000e\u000b\t\te\"1H\u0001\t[\u0016$\u0018\rZ1uC*\u0019\u0011J!\u0010\u000b\t\t}\"\u0011I\u0001\u0007CB\f7\r[3\u000b\u0005\t\r\u0013aA8sO&!!q\tB\u001c\u00059!v\u000e]5d!2\f7-Z7f]RD\u0011\"!\u000b\u001a!\u0003\u0005\r!a\u000b\t\u000f\t5\u0013\u00041\u0001\u0002\u001e\u0005A\"/Y2l\u001b&D\u0018N\\4TkB\u0004xN\u001d;F]\u0006\u0014G.\u001a3\u0002/\u0005$G\rU1si&$\u0018n\u001c8tI\u0011,g-Y;mi\u0012\"TC\u0001B*U\r)\u0018qI\u0001\u0018C\u0012$\u0007+\u0019:uSRLwN\\:%I\u00164\u0017-\u001e7uIU*\"A!\u0017+\t\t\u001d\u0012qI\u0001\u0018C\u0012$\u0007+\u0019:uSRLwN\\:%I\u00164\u0017-\u001e7uIY\nq#\u00193e!\u0006\u0014H/\u001b;j_:\u001cH\u0005Z3gCVdG\u000fJ\u001c\u0016\u0005\t\u0005$\u0006\u0002B\u0019\u0003\u000f\nq#\u00193e!\u0006\u0014H/\u001b;j_:\u001cH\u0005Z3gCVdG\u000f\n\u001d\u0002;\r\u0014X-\u0019;f\u001d\u0016<\b+\u0019:uSRLwN\\:BgNLwM\\7f]R$\u0002#a)\u0003j\t-$Q\u000eB8\u0005c\u0012\u0019H!\u001e\t\u000b\u001d|\u0002\u0019\u00015\t\u000f\tmq\u00041\u0001\u0002$\"9!qD\u0010A\u0002\u0005E\u0004\u0002\u0003B\u0012?A\u0005\t\u0019A;\t\u000f\u0005mx\u00041\u0001\u0003(!9!qF\u0010A\u0002\tE\u0002b\u0002B'?\u0001\u0007\u0011QD\u0001(GJ,\u0017\r^3OK^\u0004\u0016M\u001d;ji&|gn]!tg&<g.\\3oi\u0012\"WMZ1vYR$C'A\u000bwC2LG-\u0019;f\u001d\u0016<\b+\u0019:uSRLwN\\:\u0015\u0011\tu$1\u0011BC\u0005\u000f\u0003b!\u0014B@\u0003\u0017+\u0018b\u0001BA\u001d\n1A+\u001e9mKJBQaZ\u0011A\u0002!DqAa\u0007\"\u0001\u0004\t\u0019\u000b\u0003\u0004\u0003$\u0005\u0002\r!^\u0001\u001fGJ,\u0017\r^3QCJ$\u0018\u000e^5p]N<\u0016\u000e\u001e5BgNLwM\\7f]R$\"\"a)\u0003\u000e\n=%\u0011\u0013BK\u0011\u00159'\u00051\u0001i\u0011\u001d\u0011YB\ta\u0001\u0003GCqAa%#\u0001\u0004\t\u0019+\u0001\foK^\u0004\u0016M\u001d;ji&|g.Q:tS\u001etW.\u001a8u\u0011%\tIC\tI\u0001\u0002\u0004\tY#\u0001\u0015de\u0016\fG/\u001a)beRLG/[8og^KG\u000f[!tg&<g.\\3oi\u0012\"WMZ1vYR$C'A\rwC2LG-\u0019;f%\u0016\u0004H.[2b\u0003N\u001c\u0018n\u001a8nK:$HcB2\u0003\u001e\n}%1\u0015\u0005\b\u0003w$\u0003\u0019AAR\u0011\u0019\u0011\t\u000b\na\u0001k\u0006IR\r\u001f9fGR,GMU3qY&\u001c\u0017\r^5p]\u001a\u000b7\r^8s\u0011\u001d\u0011)\u000b\na\u0001\u0005O\u000b!#\u0019<bS2\f'\r\\3Ce>\\WM]%egB!\u0011N!+v\u0013\r\t9O]\u0001\fa\u0006\u00148/\u001a\"s_.,'\u000f\u0006\u0003\u00030\nE\u0006\u0003B'\u0002.UDaAa-&\u0001\u0004A\u0017A\u00022s_.,'/A\u0007dQ\u0006tw-Z\"p]\u001aLwm\u001d\u000b\nG\ne&Q\u0018Ba\u0005\u000bDaAa/'\u0001\u0004A\u0017AC3oi&$\u0018\u0010V=qK\"1!q\u0018\u0014A\u0002!\f!\"\u001a8uSRLh*Y7f\u0011\u0019\u0011\u0019M\na\u0001y\u000691m\u001c8gS\u001e\u001c\b\"\u0003BdMA\u0005\t\u0019AA\u000f\u00039I7/V:fe\u000ec\u0017.\u001a8u\u0013\u0012\fqc\u00195b]\u001e,7i\u001c8gS\u001e\u001cH\u0005Z3gCVdG\u000f\n\u001b\u0002%Q\u0014\u0018p\u00117fC:\fVo\u001c;b\u001d>$Wm\u001d\u000b\t\u0003;\u0011yM!5\u0003T\"1!1\u0018\u0015A\u0002!DaAa0)\u0001\u0004A\u0007b\u0002BdQ\u0001\u0007\u0011QD\u0001\u0015G\"\fgnZ3DY&,g\u000e^%e\u0007>tg-[4\u0015\u000b\r\u0014IN!8\t\r\tm\u0017\u00061\u0001i\u0003E\u0019\u0018M\\5uSj,Gm\u00117jK:$\u0018\n\u001a\u0005\u0007\u0005\u0007L\u0003\u0019\u0001?\u0002=\rD\u0017M\\4f+N,'o\u0014:Vg\u0016\u00148\t\\5f]RLEmQ8oM&<GcB2\u0003d\n\u001d(\u0011\u001e\u0005\u0007\u0005KT\u0003\u0019\u00015\u0002'M\fg.\u001b;ju\u0016$WI\u001c;jift\u0015-\\3\t\r\t\r'\u00061\u0001}\u0011%\u00119M\u000bI\u0001\u0002\u0004\ti\"\u0001\u0015dQ\u0006tw-Z+tKJ|%/V:fe\u000ec\u0017.\u001a8u\u0013\u0012\u001cuN\u001c4jO\u0012\"WMZ1vYR$3'\u0001\twC2LG-\u0019;f\u0013B\u001cuN\u001c4jOR)1M!=\u0003v\"1!1\u001f\u0017A\u0002!\f!!\u001b9\t\r\t\rG\u00061\u0001}\u00039\u0019\u0007.\u00198hK&\u00038i\u001c8gS\u001e$Ra\u0019B~\u0005{DaAa=.\u0001\u0004A\u0007B\u0002Bb[\u0001\u0007A0A\nwC2LG-\u0019;f)>\u0004\u0018nY\"p]\u001aLw\rF\u0003d\u0007\u0007\u0019)\u0001C\u0003h]\u0001\u0007\u0001\u000e\u0003\u0004\u0003D:\u0002\r\u0001`\u0001\u0012G\"\fgnZ3U_BL7mQ8oM&<G#B2\u0004\f\r5\u0001\"B40\u0001\u0004A\u0007B\u0002Bb_\u0001\u0007A0\u0001\ndQ\u0006tw-\u001a\"s_.,'oQ8oM&<G#B2\u0004\u0014\r]\u0001bBB\u000ba\u0001\u0007\u00111R\u0001\bEJ|7.\u001a:t\u0011\u0019\u0011\u0019\r\ra\u0001yR)1ma\u0007\u0004\u001e!9!1W\u0019A\u0002\t=\u0006B\u0002Bbc\u0001\u0007A0\u0001\u000bwC2LG-\u0019;f\u0005J|7.\u001a:D_:4\u0017n\u001a\u000b\u0004G\u000e\r\u0002B\u0002Bbe\u0001\u0007A0A\fdQ\u0006tw-Z\"mkN$XM\u001d'j].\u001cuN\u001c4jOR)1m!\u000b\u0004:!911F\u001aA\u0002\r5\u0012A\u00027j].LE\r\u0005\u0003\u00040\rURBAB\u0019\u0015\u0011\u0019\u0019Da\u000f\u0002\r\r|W.\\8o\u0013\u0011\u00199d!\r\u0003\tU+\u0018\u000e\u001a\u0005\u0007\u0007w\u0019\u0004\u0019\u0001?\u0002\u001fA,'o]5ti\u0016tG\u000f\u0015:paN\faCZ3uG\"\u001cE.^:uKJd\u0015N\\6D_:4\u0017n\u001a\u000b\u0004y\u000e\u0005\u0003bBB\u0016i\u0001\u00071QF\u0001\u0018K:\u001cXO]3DYV\u001cH/\u001a:MS:\\W\t_5tiN$2aYB$\u0011\u001d\u0019Y#\u000ea\u0001\u0007[\t!c\u00195b]\u001e,WI\u001c;jif\u001cuN\u001c4jORI1m!\u0014\u0004R\rU3q\u000b\u0005\u0007\u0007\u001f2\u0004\u0019\u00015\u0002\u001dI|w\u000e^#oi&$\u0018\u0010V=qK\"111\u000b\u001cA\u0002!\fqCZ;mYN\u000bg.\u001b;ju\u0016$WI\u001c;jift\u0015-\\3\t\r\t\rg\u00071\u0001}\u0011%\u00119M\u000eI\u0001\u0002\u0004\ti\"\u0001\u000fdQ\u0006tw-Z#oi&$\u0018pQ8oM&<G\u0005Z3gCVdG\u000f\n\u001b\u0002#\u0019,Go\u00195F]RLG/_\"p]\u001aLw\rF\u0003}\u0007?\u001a\t\u0007\u0003\u0004\u0004Pa\u0002\r\u0001\u001b\u0005\u0007\u0005KD\u0004\u0019\u00015\u0002%\u001d,G/\u00117m)>\u0004\u0018nY\"p]\u001aLwm\u001d\u000b\u0003\u0007O\u0002b!a\u001d\u0002&\"d\u0018!\u00064fi\u000eD\u0017\t\u001c7F]RLG/_\"p]\u001aLwm\u001d\u000b\u0005\u0007O\u001ai\u0007\u0003\u0004\u0003<j\u0002\r\u0001[\u0001\u001bM\u0016$8\r[!mY\u000eC\u0017\u000e\u001c3F]RLG/_\"p]\u001aLwm\u001d\u000b\u0007\u0007O\u001a\u0019h!\u001e\t\r\r=3\b1\u0001i\u0011\u0019\u00199h\u000fa\u0001Q\u0006y1\r[5mI\u0016sG/\u001b;z)f\u0004X\r\u0006\u0003\u0004|\ru\u0004CBA:\u0003KCW\u000fC\u0004\u0004\u0000q\u0002\ra!!\u0002\rQ|\u0007/[2t!\u0011I'\u0011\u00165\u0015\t\t=6Q\u0011\u0005\u0006Ov\u0002\r\u0001[\u0001\u0012GJ,\u0017\r^3DYV\u001cH/\u001a:MS:\\G#B2\u0004\f\u000eU\u0005bBBG}\u0001\u00071qR\u0001\u0010G2,8\u000f^3s\u0019&t7\u000eR1uCB\u0019!l!%\n\u0007\rMeIA\bDYV\u001cH/\u001a:MS:\\G)\u0019;b\u0011\u0019\u00199J\u0010a\u0001y\u0006\t\u0002/\u001a:tSN$XM\u001c;D_:4\u0017nZ:\u0002\u001d\u001d,Go\u00117vgR,'\u000fT5oWR!1QTBP!\u0015i\u0015QFBH\u0011\u001d\u0019Yc\u0010a\u0001\u0007[\tqbZ3u\u00072,8\u000f^3s\u0019&t7n\u001d\u000b\u0005\u0007K\u001b9\u000b\u0005\u0005\u0002t\u0005\u00156QFBH\u0011\u001d\u0019I\u000b\u0011a\u0001\u0007W\u000bq\u0001\\5oW&#7\u000fE\u0003j\u0005S\u001bi#\u0001\nhKR\fE\u000e\\\"mkN$XM\u001d'j].\u001cHCABY!\u0019\t\u0019(!\u001f\u0004\u0010\u0006q1/\u001a;DYV\u001cH/\u001a:MS:\\GcA2\u00048\"91Q\u0012\"A\u0002\r=\u0015!\u00053fY\u0016$Xm\u00117vgR,'\u000fT5oWR\u00191m!0\t\u000f\r-2\t1\u0001\u0004.\u0005\u0001S.Y=cKJ+WM\\2ssB$8\t\\;ti\u0016\u0014H*\u001b8l\u0007>tg-[4t)\r\u001971\u0019\u0005\b\u0007\u000b$\u0005\u0019ABd\u0003E\u0019wN\u001c4jOR\u0013\u0018M\\:g_JlWM\u001d\t\u0007\u001b\u000e%Gp!4\n\u0007\r-gJA\u0005Gk:\u001cG/[8ocA!Q*!\f}\u0001")
public class AdminZkClient
implements Logging {
    private final KafkaZkClient zkClient;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public void createTopic(String topic, int partitions, int replicationFactor, Properties topicConfig, RackAwareMode rackAwareMode, boolean usesModernTopicId, boolean usesLegacyTopicId, Option<ClusterLinkTopicState> clusterLink) {
        Seq<BrokerMetadata> brokerMetadatas = this.getBrokerMetadatas(rackAwareMode, this.getBrokerMetadatas$default$2());
        Map replicaAssignment = (Map)AdminUtils$.MODULE$.assignReplicasToBrokers((Iterable<BrokerMetadata>)brokerMetadatas, partitions, replicationFactor, -1, -1).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                int partition = x0$1._1$mcI$sp();
                Seq replicas = (Seq)x0$1._2();
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)partition), (Object)ReplicaAssignment$.MODULE$.apply((Seq<Object>)replicas, (Seq<Object>)((Seq)Seq$.MODULE$.empty())));
            }
            throw new MatchError(null);
        });
        boolean x$7 = this.createTopicWithAssignment$default$4();
        this.createTopicWithAssignment(topic, topicConfig, (Map<Object, ReplicaAssignment>)replicaAssignment, x$7, usesModernTopicId, usesLegacyTopicId, clusterLink);
    }

    public Properties createTopic$default$4() {
        return new Properties();
    }

    public RackAwareMode createTopic$default$5() {
        return RackAwareMode$Enforced$.MODULE$;
    }

    public boolean createTopic$default$6() {
        return false;
    }

    public boolean createTopic$default$7() {
        return false;
    }

    public Option<ClusterLinkTopicState> createTopic$default$8() {
        return None$.MODULE$;
    }

    public Seq<BrokerMetadata> getBrokerMetadatas(RackAwareMode rackAwareMode, Option<Seq<Object>> brokerList) {
        Seq<Broker> allBrokers = this.zkClient.getAllBrokersInCluster();
        Seq brokers = (Seq)brokerList.map((Function1 & Serializable)brokerIds -> (Seq)allBrokers.filter((Function1 & Serializable)b -> BoxesRunTime.boxToBoolean((boolean)brokerIds.contains((Object)BoxesRunTime.boxToInteger((int)b.id()))))).getOrElse((Function0 & Serializable)() -> allBrokers);
        Seq brokersWithRack = (Seq)brokers.filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClient.$anonfun$getBrokerMetadatas$4(x$1)));
        RackAwareMode rackAwareMode2 = rackAwareMode;
        RackAwareMode$Enforced$ rackAwareMode$Enforced$ = RackAwareMode$Enforced$.MODULE$;
        if (rackAwareMode2 != null && rackAwareMode2.equals(rackAwareMode$Enforced$) && brokersWithRack.nonEmpty() && brokersWithRack.size() < brokers.size()) {
            throw new AdminOperationException("Not all brokers have rack information. Add --disable-rack-aware in command line to make replica assignment without rack information.");
        }
        return (Seq)(RackAwareMode$Disabled$.MODULE$.equals(rackAwareMode) ? (Seq)brokers.map((Function1 & Serializable)broker -> new BrokerMetadata(broker.id(), (Option<String>)None$.MODULE$, (Map<String, String>)((Map)Map$.MODULE$.empty()))) : (RackAwareMode$Safe$.MODULE$.equals(rackAwareMode) && brokersWithRack.size() < brokers.size() ? (Seq)brokers.map((Function1 & Serializable)broker -> new BrokerMetadata(broker.id(), (Option<String>)None$.MODULE$, (Map<String, String>)((Map)Map$.MODULE$.empty()))) : (Seq)brokers.map((Function1 & Serializable)broker -> new BrokerMetadata(broker.id(), broker.rack(), (Map<String, String>)((Map)Map$.MODULE$.empty()))))).sortBy((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.id()), (Ordering)Ordering.Int$.MODULE$);
    }

    public RackAwareMode getBrokerMetadatas$default$1() {
        return RackAwareMode$Enforced$.MODULE$;
    }

    public Option<Seq<Object>> getBrokerMetadatas$default$2() {
        return None$.MODULE$;
    }

    public void createTopicWithAssignment(String topic, Properties config, Map<Object, ReplicaAssignment> partitionReplicaAssignment, boolean validate, boolean usesModernTopicId, boolean usesLegacyTopicId, Option<ClusterLinkTopicState> clusterLink) {
        if (validate) {
            this.validateTopicCreate(topic, partitionReplicaAssignment, config, (Function0<Set<String>>)(Function0 & Serializable)() -> $this.zkClient.getAllTopicsInCluster($this.zkClient.getAllTopicsInCluster$default$1()), this.validateTopicCreate$default$5());
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(69).append("Creating topic ").append(topic).append(" with configuration ").append(config).append(" and initial partition ").append("assignment ").append(partitionReplicaAssignment).toString());
        this.zkClient.setOrCreateEntityConfigs(ConfigType$.MODULE$.Topic(), topic, config);
        this.writeTopicPartitionAssignment(topic, partitionReplicaAssignment, false, usesModernTopicId, usesLegacyTopicId, clusterLink);
    }

    public boolean createTopicWithAssignment$default$4() {
        return true;
    }

    public boolean createTopicWithAssignment$default$5() {
        return false;
    }

    public boolean createTopicWithAssignment$default$6() {
        return false;
    }

    public Option<ClusterLinkTopicState> createTopicWithAssignment$default$7() {
        return None$.MODULE$;
    }

    public boolean topicExists(String topicName) {
        return this.zkClient.topicExists(topicName);
    }

    public void validateTopicCreate(String topic, Map<Object, ReplicaAssignment> partitionReplicaAssignment, Properties config, Function0<Set<String>> topicsSupplier, Set<String> createdTopics) {
        Topic.validate((String)topic);
        if (this.zkClient.isTopicMarkedForDeletion(topic)) {
            throw new TopicExistsException(new StringBuilder(32).append("Topic '").append(topic).append("' is marked for deletion.").toString());
        }
        if (this.zkClient.topicExists(topic)) {
            throw new TopicExistsException(new StringBuilder(24).append("Topic '").append(topic).append("' already exists.").toString());
        }
        if (Topic.hasCollisionChars((String)topic)) {
            Set topics = (Set)topicsSupplier.apply();
            if (topics.contains((Object)topic) || createdTopics.contains((Object)topic)) {
                throw new TopicExistsException(new StringBuilder(24).append("Topic '").append(topic).append("' already exists.").toString());
            }
            Set collidingTopics = (Set)((SetOps)topics.filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClient.$anonfun$validateTopicCreate$1(topic, x$3)))).$plus$plus((IterableOnce)createdTopics.filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClient.$anonfun$validateTopicCreate$2(topic, x$4))));
            if (collidingTopics.nonEmpty()) {
                throw new InvalidTopicException(new StringBuilder(40).append("Topic '").append(topic).append("' collides with existing topics: ").append(collidingTopics.mkString(", ")).toString());
            }
        }
        if (((IterableOnceOps)partitionReplicaAssignment.values().map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)AdminZkClient.$anonfun$validateTopicCreate$3(x$5)))).toSet().size() != 1) {
            throw new InvalidReplicaAssignmentException("All partitions should have the same number of replicas");
        }
        if (((IterableOnceOps)partitionReplicaAssignment.values().map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)AdminZkClient.$anonfun$validateTopicCreate$4(x$6)))).toSet().size() != 1) {
            throw new InvalidReplicaAssignmentException("All partitions should have the same number of observers");
        }
        partitionReplicaAssignment.values().foreach((Function1 & Serializable)assignment -> {
            AdminZkClient.$anonfun$validateTopicCreate$5(partitionReplicaAssignment, assignment);
            return BoxedUnit.UNIT;
        });
        int partitionSize = partitionReplicaAssignment.size();
        int sequenceSum = partitionSize * (partitionSize - 1) / 2;
        if (partitionReplicaAssignment.size() != partitionReplicaAssignment.toSet().size() || BoxesRunTime.unboxToInt((Object)((IterableOnceOps)partitionReplicaAssignment.keys().filter((Function1)(JFunction1.mcZI.sp & Serializable)x$7 -> x$7 >= 0)).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) != sequenceSum) {
            throw new InvalidReplicaAssignmentException("partitions should be a consecutive 0-based integer sequence");
        }
        LogConfig.validate((Properties)config);
    }

    public Set<String> validateTopicCreate$default$5() {
        return Predef$.MODULE$.Set().empty();
    }

    public void writeTopicPartitionAssignment(String topic, Map<Object, ReplicaAssignment> replicaAssignment, boolean isUpdate, boolean usesModernTopicId, boolean usesLegacyTopicId, Option<ClusterLinkTopicState> clusterLink) {
        try {
            scala.collection.immutable.Map assignment = replicaAssignment.map((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    int partitionId = x0$1._1$mcI$sp();
                    ReplicaAssignment replicas = (ReplicaAssignment)x0$1._2();
                    return new Tuple2((Object)new TopicPartition(topic, partitionId), (Object)replicas);
                }
                throw new MatchError(null);
            }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            if (!isUpdate) {
                None$ legacyTopicIdOpt = usesLegacyTopicId ? new Some((Object)Uuid.randomUuid()) : None$.MODULE$;
                None$ topicIdOpt = usesModernTopicId ? new Some((Object)Uuid.randomUuid()) : None$.MODULE$;
                this.zkClient.createTopicAssignment(topic, (Option<Uuid>)topicIdOpt, (Option<Uuid>)legacyTopicIdOpt, (Map<TopicPartition, ReplicaAssignment>)assignment, clusterLink);
                topicIdOpt.orElse(() -> AdminZkClient.$anonfun$writeTopicPartitionAssignment$2((Option)legacyTopicIdOpt)).foreach((Function1 & Serializable)topicId -> {
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(27).append("Assigned topicId ").append(topicId).append(" to topic ").append(topic$3).toString());
                    return BoxedUnit.UNIT;
                });
            } else {
                TopicZNode.TopicIdReplicaAssignment oldAssignment = (TopicZNode.TopicIdReplicaAssignment)this.zkClient.getReplicaAssignmentAndTopicIdForTopics((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})))).head();
                this.zkClient.setTopicAssignment(topic, oldAssignment.topicId(), oldAssignment.legacyTopicId(), (Map<TopicPartition, ReplicaAssignment>)assignment, clusterLink, this.zkClient.setTopicAssignment$default$6());
            }
            this.debug((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Updated path %s with %s for replica assignment"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{TopicZNode$.MODULE$.path(topic), assignment})));
            return;
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            throw new TopicExistsException(new StringBuilder(24).append("Topic '").append(topic).append("' already exists.").toString());
        }
        catch (Throwable e2) {
            throw new AdminOperationException(e2.toString());
        }
    }

    public boolean writeTopicPartitionAssignment$default$4() {
        return false;
    }

    public boolean writeTopicPartitionAssignment$default$5() {
        return false;
    }

    public Option<ClusterLinkTopicState> writeTopicPartitionAssignment$default$6() {
        return None$.MODULE$;
    }

    public void deleteTopic(String topic) {
        if (this.zkClient.topicExists(topic)) {
            try {
                this.zkClient.createDeleteTopicPath(topic);
                return;
            }
            catch (KeeperException.NodeExistsException nodeExistsException) {
                throw new TopicAlreadyMarkedForDeletionException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("topic %s is already marked for deletion"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
            }
            catch (Throwable e) {
                throw new AdminOperationException(e.getMessage());
            }
        }
        throw new UnknownTopicOrPartitionException(new StringBuilder(33).append("Topic `").append(topic).append("` to delete does not exist").toString());
    }

    public Map<Object, ReplicaAssignment> addPartitions(String topic, Map<Object, ReplicaAssignment> existingAssignment, Seq<BrokerMetadata> allBrokers, int numPartitions, Option<Map<Object, ReplicaAssignment>> replicaAssignment, boolean validateOnly, Option<TopicPlacement> topicPlacement, Option<ClusterLinkTopicState> clusterLink, boolean rackMixingSupportEnabled) {
        Map<Object, ReplicaAssignment> proposedAssignmentForNewPartitions = this.createNewPartitionsAssignment(topic, existingAssignment, allBrokers, numPartitions, replicaAssignment, topicPlacement, rackMixingSupportEnabled);
        if (validateOnly) {
            return (Map)existingAssignment.$plus$plus(proposedAssignmentForNewPartitions);
        }
        return this.createPartitionsWithAssignment(topic, existingAssignment, proposedAssignmentForNewPartitions, clusterLink);
    }

    public int addPartitions$default$4() {
        return 1;
    }

    public Option<Map<Object, ReplicaAssignment>> addPartitions$default$5() {
        return None$.MODULE$;
    }

    public boolean addPartitions$default$6() {
        return false;
    }

    public Option<TopicPlacement> addPartitions$default$7() {
        return None$.MODULE$;
    }

    public Option<ClusterLinkTopicState> addPartitions$default$8() {
        return None$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    public Map<Object, ReplicaAssignment> createNewPartitionsAssignment(String topic, Map<Object, ReplicaAssignment> existingAssignment, Seq<BrokerMetadata> allBrokers, int numPartitions, Option<Map<Object, ReplicaAssignment>> replicaAssignment, Option<TopicPlacement> topicPlacement, boolean rackMixingSupportEnabled) {
        void var9_9;
        Tuple2<Seq<Object>, Object> tuple2 = this.validateNewPartitions(topic, existingAssignment, numPartitions);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Seq existingAssignmentPartition0 = (Seq)tuple2._1();
        int n = tuple2._2$mcI$sp();
        replicaAssignment.foreach(arg_0 -> AdminZkClient.$anonfun$createNewPartitionsAssignment$1$adapted(this, (Seq)var9_9, allBrokers, arg_0));
        return (Map)((Map)replicaAssignment.getOrElse(() -> AdminZkClient.$anonfun$createNewPartitionsAssignment$3(allBrokers, (Seq)var9_9, topicPlacement, n, rackMixingSupportEnabled, existingAssignment))).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                int tp = x0$1._1$mcI$sp();
                ReplicaAssignment replicas = (ReplicaAssignment)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp)), (Object)replicas);
            }
            throw new MatchError(null);
        });
    }

    public int createNewPartitionsAssignment$default$4() {
        return 1;
    }

    public Tuple2<Seq<Object>, Object> validateNewPartitions(String topic, Map<Object, ReplicaAssignment> existingAssignment, int numPartitions) {
        Seq<Object> existingAssignmentPartition0 = ((ReplicaAssignment)existingAssignment.getOrElse((Object)BoxesRunTime.boxToInteger((int)0), (Function0 & Serializable)() -> {
            throw new AdminOperationException(new StringBuilder(92).append("Unexpected existing replica assignment for topic '").append(topic).append("', partition id 0 is missing. ").append("Assignment: ").append(existingAssignment).toString());
        })).replicas();
        int partitionsToAdd = numPartitions - existingAssignment.size();
        if (partitionsToAdd <= 0) {
            throw new InvalidPartitionsException(new StringBuilder(120).append("The number of partitions for a topic can only be increased. ").append("Topic ").append(topic).append(" currently has ").append(existingAssignment.size()).append(" partitions, ").append(numPartitions).append(" would not be an increase.").toString());
        }
        return new Tuple2(existingAssignmentPartition0, (Object)BoxesRunTime.boxToInteger((int)partitionsToAdd));
    }

    public Map<Object, ReplicaAssignment> createPartitionsWithAssignment(String topic, Map<Object, ReplicaAssignment> existingAssignment, Map<Object, ReplicaAssignment> newPartitionAssignment, Option<ClusterLinkTopicState> clusterLink) {
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(68).append("Creating ").append(newPartitionAssignment.size()).append(" partitions for '").append(topic).append("' with the following replica assignment: ").append(newPartitionAssignment).append(".").toString());
        Map combinedAssignment = (Map)existingAssignment.$plus$plus(newPartitionAssignment);
        boolean x$5 = this.writeTopicPartitionAssignment$default$4();
        boolean x$6 = this.writeTopicPartitionAssignment$default$5();
        this.writeTopicPartitionAssignment(topic, (Map<Object, ReplicaAssignment>)combinedAssignment, true, x$5, x$6, clusterLink);
        return combinedAssignment;
    }

    public Option<ClusterLinkTopicState> createPartitionsWithAssignment$default$4() {
        return None$.MODULE$;
    }

    private void validateReplicaAssignment(Map<Object, ReplicaAssignment> replicaAssignment, int expectedReplicationFactor, scala.collection.immutable.Set<Object> availableBrokerIds) {
        Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(partitionId, assignment) -> {
            AdminZkClient.$anonfun$validateReplicaAssignment$1(availableBrokerIds, BoxesRunTime.unboxToInt((Object)partitionId), assignment);
            return BoxedUnit.UNIT;
        };
        replicaAssignment.foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1(forKeyValue$extension_f, arg_0, arg_1));
        Object var8_4 = null;
        Map badRepFactors = (Map)replicaAssignment.collect((PartialFunction)new Serializable(null, expectedReplicationFactor){
            private static final long serialVersionUID = 0L;
            private final int expectedReplicationFactor$1;

            public final <A1 extends Tuple2<Object, ReplicaAssignment>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 != null) {
                    int partition = x1._1$mcI$sp();
                    ReplicaAssignment assignment = (ReplicaAssignment)x1._2();
                    if (assignment.replicas().size() != this.expectedReplicationFactor$1) {
                        return (B1)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)BoxesRunTime.boxToInteger((int)assignment.replicas().size()));
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<Object, ReplicaAssignment> x1) {
                return x1 != null && ((ReplicaAssignment)x1._2()).replicas().size() != this.expectedReplicationFactor$1;
            }
            {
                this.expectedReplicationFactor$1 = expectedReplicationFactor$1;
            }
        });
        if (badRepFactors.nonEmpty()) {
            scala.collection.immutable.Seq sortedBadRepFactors = (scala.collection.immutable.Seq)badRepFactors.toSeq().sortBy((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)AdminZkClient.$anonfun$validateReplicaAssignment$2(x0$1)), (Ordering)Ordering.Int$.MODULE$);
            scala.collection.immutable.Seq partitions = (scala.collection.immutable.Seq)sortedBadRepFactors.map((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToInteger((int)AdminZkClient.$anonfun$validateReplicaAssignment$3(x0$2)));
            scala.collection.immutable.Seq repFactors = (scala.collection.immutable.Seq)sortedBadRepFactors.map((Function1 & Serializable)x0$3 -> BoxesRunTime.boxToInteger((int)AdminZkClient.$anonfun$validateReplicaAssignment$4(x0$3)));
            throw new InvalidReplicaAssignmentException(new StringBuilder(131).append("Inconsistent replication factor between partitions, ").append("partition 0 has ").append(expectedReplicationFactor).append(" while partitions [").append(partitions.mkString(", ")).append("] have ").append("replication factors [").append(repFactors.mkString(", ")).append("], respectively.").toString());
        }
    }

    public Option<Object> parseBroker(String broker) {
        String string = ConfigEntityName$.MODULE$.Default();
        if (!(string != null ? !string.equals(broker) : broker != null)) {
            return None$.MODULE$;
        }
        try {
            return new Some((Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(broker))));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(new StringBuilder(78).append("Error parsing broker ").append(broker).append(". The broker's Entity Name must be a single integer value").toString());
        }
    }

    public void changeConfigs(String entityType, String entityName, Properties configs, boolean isUserClientId) {
        String string = ConfigType$.MODULE$.Topic();
        if (!(string != null ? !string.equals(entityType) : entityType != null)) {
            this.changeTopicConfig(entityName, configs);
            return;
        }
        String string2 = ConfigType$.MODULE$.Client();
        if (!(string2 != null ? !string2.equals(entityType) : entityType != null)) {
            this.changeClientIdConfig(entityName, configs);
            return;
        }
        String string3 = ConfigType$.MODULE$.User();
        if (!(string3 != null ? !string3.equals(entityType) : entityType != null)) {
            this.changeUserOrUserClientIdConfig(entityName, configs, isUserClientId);
            return;
        }
        String string4 = ConfigType$.MODULE$.Broker();
        if (!(string4 != null ? !string4.equals(entityType) : entityType != null)) {
            this.changeBrokerConfig(this.parseBroker(entityName), configs);
            return;
        }
        String string5 = ConfigType$.MODULE$.Ip();
        if (!(string5 != null ? !string5.equals(entityType) : entityType != null)) {
            this.changeIpConfig(entityName, configs);
            return;
        }
        String string6 = ConfigType$.MODULE$.ClusterLink();
        if (!(string6 != null ? !string6.equals(entityType) : entityType != null)) {
            throw new IllegalArgumentException("Cluster link configs can be altered only using Admin API");
        }
        throw new IllegalArgumentException(new StringBuilder(45).append(entityType).append(" is not a known entityType. Should be one of ").append(ConfigType$.MODULE$.all()).toString());
    }

    public boolean changeConfigs$default$4() {
        return false;
    }

    private boolean tryCleanQuotaNodes(String entityType, String entityName, boolean isUserClientId) {
        String currPath = ConfigEntityZNode$.MODULE$.path(entityType, entityName);
        if (this.zkClient.getChildren(currPath).isEmpty()) {
            ObjectRef pathToDelete = ObjectRef.create((Object)currPath);
            if (isUserClientId) {
                String user = entityName.substring(0, entityName.indexOf("/"));
                String clientId = entityName.substring(entityName.lastIndexOf("/") + 1);
                String clientsPath = ConfigEntityZNode$.MODULE$.path(ConfigType$.MODULE$.User(), new StringBuilder(1).append(user).append("/").append(ConfigType$.MODULE$.Client()).toString());
                Seq<String> seq = this.zkClient.getChildren(clientsPath);
                .colon.colon colon2 = new .colon.colon((Object)clientId, (List)Nil$.MODULE$);
                if (seq != null && seq.equals((Object)colon2)) {
                    pathToDelete.elem = clientsPath;
                    Properties userData = this.fetchEntityConfig(ConfigType$.MODULE$.User(), user);
                    String userPath = ConfigEntityZNode$.MODULE$.path(ConfigType$.MODULE$.User(), user);
                    Seq<String> userChildren = this.zkClient.getChildren(userPath);
                    if (userData.isEmpty()) {
                        Seq<String> seq2 = userChildren;
                        .colon.colon colon3 = new .colon.colon((Object)ConfigType$.MODULE$.Client(), (List)Nil$.MODULE$);
                        if (seq2 != null && seq2.equals((Object)colon3)) {
                            pathToDelete.elem = userPath;
                        }
                    }
                }
            }
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(69).append("Deleting zk node ").append((String)pathToDelete$1.elem).append(" since node of entityType ").append(entityType).append(" and entityName ").append(entityName).append(" is empty.").toString());
            this.zkClient.deletePath((String)pathToDelete.elem, this.zkClient.deletePath$default$2(), this.zkClient.deletePath$default$3());
            return true;
        }
        return false;
    }

    public void changeClientIdConfig(String sanitizedClientId, Properties configs) {
        DynamicConfig$Client$.MODULE$.validate(configs);
        this.changeEntityConfig(ConfigType$.MODULE$.Client(), sanitizedClientId, configs, false);
    }

    public void changeUserOrUserClientIdConfig(String sanitizedEntityName, Properties configs, boolean isUserClientId) {
        String string = sanitizedEntityName;
        String string2 = ConfigEntityName$.MODULE$.Default();
        if (!(string == null ? string2 != null : !string.equals(string2)) || sanitizedEntityName.contains("/clients")) {
            DynamicConfig$Client$.MODULE$.validate(configs);
        } else {
            DynamicConfig$User$.MODULE$.validate(configs);
        }
        this.changeEntityConfig(ConfigType$.MODULE$.User(), sanitizedEntityName, configs, isUserClientId);
    }

    public boolean changeUserOrUserClientIdConfig$default$3() {
        return false;
    }

    public void validateIpConfig(String ip, Properties configs) {
        if (!DynamicConfig$Ip$.MODULE$.isValidIpEntity(ip)) {
            throw new AdminOperationException(new StringBuilder(38).append(ip).append(" is not a valid IP or resolvable host.").toString());
        }
        DynamicConfig$Ip$.MODULE$.validate(configs);
    }

    public void changeIpConfig(String ip, Properties configs) {
        this.validateIpConfig(ip, configs);
        this.changeEntityConfig(ConfigType$.MODULE$.Ip(), ip, configs, false);
    }

    public void validateTopicConfig(String topic, Properties configs) {
        Topic.validate((String)topic);
        if (!this.zkClient.topicExists(topic)) {
            throw new UnknownTopicOrPartitionException(new StringBuilder(24).append("Topic '").append(topic).append("' does not exist.").toString());
        }
        LogConfig.validate((Properties)configs);
    }

    public void changeTopicConfig(String topic, Properties configs) {
        this.validateTopicConfig(topic, configs);
        this.changeEntityConfig(ConfigType$.MODULE$.Topic(), topic, configs, false);
    }

    public void changeBrokerConfig(Seq<Object> brokers, Properties configs) {
        this.validateBrokerConfig(configs);
        brokers.foreach((Function1)(JFunction1.mcVI.sp & Serializable)broker -> this.changeEntityConfig(ConfigType$.MODULE$.Broker(), Integer.toString(broker), configs, false));
    }

    public void changeBrokerConfig(Option<Object> broker, Properties configs) {
        this.validateBrokerConfig(configs);
        this.changeEntityConfig(ConfigType$.MODULE$.Broker(), (String)broker.map((Function1 & Serializable)x$11 -> AdminZkClient.$anonfun$changeBrokerConfig$2(BoxesRunTime.unboxToInt((Object)x$11))).getOrElse((Function0 & Serializable)() -> ConfigEntityName$.MODULE$.Default()), configs, false);
    }

    public void validateBrokerConfig(Properties configs) {
        DynamicConfig$Broker$.MODULE$.validate(configs);
    }

    public void changeClusterLinkConfig(Uuid linkId, Properties persistentProps) {
        this.ensureClusterLinkExists(linkId);
        this.changeEntityConfig(ConfigType$.MODULE$.ClusterLink(), CoreUtils$.MODULE$.toJavaUUID(linkId).toString(), persistentProps, false);
    }

    public Properties fetchClusterLinkConfig(Uuid linkId) {
        return this.fetchEntityConfig(ConfigType$.MODULE$.ClusterLink(), CoreUtils$.MODULE$.toJavaUUID(linkId).toString());
    }

    public void ensureClusterLinkExists(Uuid linkId) {
        if (!this.zkClient.clusterLinkExists(linkId)) {
            throw new ClusterLinkNotFoundException(new StringBuilder(39).append("Cluster link with ID '").append(linkId).append("' does not exist.").toString());
        }
    }

    private void changeEntityConfig(String rootEntityType, String fullSanitizedEntityName, Properties configs, boolean isUserClientId) {
        String sanitizedEntityPath = new StringBuilder(11).append(rootEntityType).append('/').append(fullSanitizedEntityName).toString();
        boolean needUpdateConfigs = true;
        if ((ConfigType$.MODULE$.Client().equals(rootEntityType) || ConfigType$.MODULE$.User().equals(rootEntityType) || ConfigType$.MODULE$.Ip().equals(rootEntityType)) && configs.isEmpty() && this.tryCleanQuotaNodes(rootEntityType, fullSanitizedEntityName, isUserClientId)) {
            needUpdateConfigs = false;
        }
        if (needUpdateConfigs) {
            this.zkClient.setOrCreateEntityConfigs(rootEntityType, fullSanitizedEntityName, configs);
        }
        this.zkClient.createConfigChangeNotification(sanitizedEntityPath);
    }

    private boolean changeEntityConfig$default$4() {
        return false;
    }

    public Properties fetchEntityConfig(String rootEntityType, String sanitizedEntityName) {
        return this.zkClient.getEntityConfigs(rootEntityType, sanitizedEntityName);
    }

    public Map<String, Properties> getAllTopicConfigs() {
        return ((IterableOnceOps)this.zkClient.getAllTopicsInCluster(this.zkClient.getAllTopicsInCluster$default$1()).map((Function1 & Serializable)topic -> new Tuple2(topic, (Object)this.fetchEntityConfig(ConfigType$.MODULE$.Topic(), (String)topic)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Map<String, Properties> fetchAllEntityConfigs(String entityType) {
        return ((IterableOnceOps)this.zkClient.getAllEntitiesWithConfig(entityType).map((Function1 & Serializable)entity -> new Tuple2(entity, (Object)this.fetchEntityConfig(entityType, (String)entity)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Map<String, Properties> fetchAllChildEntityConfigs(String rootEntityType, String childEntityType) {
        return ((IterableOnceOps)((IterableOps)this.entityPaths$1((Option)None$.MODULE$, rootEntityType).flatMap((Function1 & Serializable)entity -> this.entityPaths$1((Option)new Some((Object)new StringBuilder(11).append((String)entity).append('/').append(childEntityType).toString()), rootEntityType))).map((Function1 & Serializable)entityPath -> new Tuple2(entityPath, (Object)this.fetchEntityConfig(rootEntityType, (String)entityPath)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Map<String, Object> numPartitions(scala.collection.immutable.Set<String> topics) {
        return (Map)this.zkClient.getPartitionsForTopics(topics).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                String topic = (String)x0$1._1();
                Seq partitions = (Seq)x0$1._2();
                return new Tuple2((Object)topic, (Object)BoxesRunTime.boxToInteger((int)partitions.size()));
            }
            throw new MatchError(null);
        });
    }

    public Option<Object> numPartitions(String topic) {
        return this.zkClient.getTopicPartitionCount(topic);
    }

    public void createClusterLink(ClusterLinkData clusterLinkData, Properties persistentConfigs) {
        Uuid linkId = clusterLinkData.linkId();
        if (this.zkClient.clusterLinkExists(linkId)) {
            throw new ClusterLinkExistsException(new StringBuilder(39).append("Cluster link with ID '").append(linkId).append("' already exists.").toString());
        }
        String javaLinkId = CoreUtils$.MODULE$.toJavaUUID(clusterLinkData.linkId()).toString();
        this.zkClient.setOrCreateEntityConfigs(ConfigType$.MODULE$.ClusterLink(), javaLinkId, persistentConfigs);
        this.zkClient.createClusterLink(clusterLinkData);
        this.zkClient.createConfigChangeNotification(new StringBuilder(11).append(ConfigType$.MODULE$.ClusterLink()).append('/').append(javaLinkId).toString());
    }

    public Option<ClusterLinkData> getClusterLink(Uuid linkId) {
        UUID javaLinkId = CoreUtils$.MODULE$.toJavaUUID(linkId);
        return this.zkClient.getClusterLinks((scala.collection.immutable.Set<UUID>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UUID[]{javaLinkId})))).get((Object)javaLinkId);
    }

    public Map<Uuid, ClusterLinkData> getClusterLinks(scala.collection.immutable.Set<Uuid> linkIds) {
        scala.collection.immutable.Set javaLinkIds = (scala.collection.immutable.Set)linkIds.map((Function1 & Serializable)uuid -> CoreUtils$.MODULE$.toJavaUUID((Uuid)uuid));
        return (Map)this.zkClient.getClusterLinks((scala.collection.immutable.Set<UUID>)javaLinkIds).map((Function1 & Serializable)entry -> new Tuple2((Object)CoreUtils$.MODULE$.toKafkaUUID((UUID)entry._1()), entry._2()));
    }

    public Seq<ClusterLinkData> getAllClusterLinks() {
        return this.zkClient.getClusterLinks((scala.collection.immutable.Set<UUID>)((IterableOnceOps)this.zkClient.getChildren("/cluster_links").map((Function1 & Serializable)x$1 -> UUID.fromString(x$1))).toSet()).values().toSeq();
    }

    public void setClusterLink(ClusterLinkData clusterLinkData) {
        Uuid linkId = clusterLinkData.linkId();
        this.ensureClusterLinkExists(linkId);
        this.zkClient.setClusterLink(clusterLinkData);
        String javaLinkId = CoreUtils$.MODULE$.toJavaUUID(linkId).toString();
        this.zkClient.createConfigChangeNotification(new StringBuilder(11).append(ConfigType$.MODULE$.ClusterLink()).append('/').append(javaLinkId).toString());
    }

    public void deleteClusterLink(Uuid linkId) {
        this.ensureClusterLinkExists(linkId);
        this.zkClient.deleteClusterLink(linkId);
        String javaLinkId = CoreUtils$.MODULE$.toJavaUUID(linkId).toString();
        this.zkClient.deleteEntityConfig(ConfigType$.MODULE$.ClusterLink(), javaLinkId, this.zkClient.deleteEntityConfig$default$3());
        this.zkClient.createConfigChangeNotification(new StringBuilder(11).append(ConfigType$.MODULE$.ClusterLink()).append('/').append(javaLinkId).toString());
    }

    public void maybeReencryptClusterLinkConfigs(Function1<Properties, Option<Properties>> configTransformer) {
        this.getAllClusterLinks().foreach((Function1 & Serializable)link -> {
            AdminZkClient.$anonfun$maybeReencryptClusterLinkConfigs$1(this, configTransformer, link);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$getBrokerMetadatas$4(Broker x$1) {
        return x$1.rack().nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$validateTopicCreate$1(String topic$2, String x$3) {
        return Topic.hasCollision((String)topic$2, (String)x$3);
    }

    public static final /* synthetic */ boolean $anonfun$validateTopicCreate$2(String topic$2, String x$4) {
        return Topic.hasCollision((String)topic$2, (String)x$4);
    }

    public static final /* synthetic */ int $anonfun$validateTopicCreate$3(ReplicaAssignment x$5) {
        return x$5.replicas().size();
    }

    public static final /* synthetic */ int $anonfun$validateTopicCreate$4(ReplicaAssignment x$6) {
        return x$6.observers().size();
    }

    public static final /* synthetic */ void $anonfun$validateTopicCreate$5(Map partitionReplicaAssignment$2, ReplicaAssignment assignment) {
        if (assignment.replicas().size() != assignment.replicas().toSet().size()) {
            throw new InvalidReplicaAssignmentException(new StringBuilder(36).append("Duplicate replica assignment found: ").append(partitionReplicaAssignment$2).toString());
        }
        if (assignment.observers().size() != assignment.observers().toSet().size()) {
            throw new InvalidReplicaAssignmentException(new StringBuilder(38).append("Duplicate observers assignment found: ").append(partitionReplicaAssignment$2).toString());
        }
    }

    public static final /* synthetic */ Option $anonfun$writeTopicPartitionAssignment$2(Option legacyTopicIdOpt$1) {
        return legacyTopicIdOpt$1;
    }

    public static final /* synthetic */ boolean $anonfun$createNewPartitionsAssignment$4(Seq existingAssignmentPartition0$1, BrokerMetadata x$10) {
        return x$10.id() >= BoxesRunTime.unboxToInt((Object)existingAssignmentPartition0$1.head());
    }

    public static final /* synthetic */ Map $anonfun$createNewPartitionsAssignment$3(Seq allBrokers$2, Seq existingAssignmentPartition0$1, Option topicPlacement$1, int partitionsToAdd$1, boolean rackMixingSupportEnabled$1, Map existingAssignment$1) {
        int startIndex = package$.MODULE$.max(0, allBrokers$2.indexWhere((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)AdminZkClient.$anonfun$createNewPartitionsAssignment$4(existingAssignmentPartition0$1, x$10))));
        return Observer$.MODULE$.getReplicaAssignment((Seq<BrokerMetadata>)allBrokers$2, (Option<TopicPlacement>)topicPlacement$1, partitionsToAdd$1, existingAssignmentPartition0$1.size(), rackMixingSupportEnabled$1, startIndex, existingAssignment$1.size());
    }

    public static final /* synthetic */ void $anonfun$validateReplicaAssignment$1(scala.collection.immutable.Set availableBrokerIds$1, int partitionId, ReplicaAssignment assignment) {
        if (assignment.replicas().isEmpty()) {
            throw new InvalidReplicaAssignmentException(new StringBuilder(54).append("Cannot have replication factor of 0 for partition id ").append(partitionId).append(".").toString());
        }
        if (assignment.replicas().size() != assignment.replicas().toSet().size()) {
            throw new InvalidReplicaAssignmentException(new StringBuilder(72).append("Duplicate brokers not allowed in replica assignment: ").append(assignment.replicas().mkString(", ")).append(" for partition id ").append(partitionId).append(".").toString());
        }
        if (!assignment.replicas().toSet().subsetOf((Set)availableBrokerIds$1)) {
            throw new BrokerNotAvailableException(new StringBuilder(101).append("Some brokers specified for partition id ").append(partitionId).append(" are not available. ").append("Specified brokers: ").append(assignment.replicas().mkString(", ")).append(", ").append("available brokers: ").append(availableBrokerIds$1.mkString(", ")).append(".").toString());
        }
    }

    public static final /* synthetic */ int $anonfun$validateReplicaAssignment$2(Tuple2 x0$1) {
        if (x0$1 != null) {
            return x0$1._1$mcI$sp();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ int $anonfun$validateReplicaAssignment$3(Tuple2 x0$2) {
        if (x0$2 != null) {
            return x0$2._1$mcI$sp();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ int $anonfun$validateReplicaAssignment$4(Tuple2 x0$3) {
        if (x0$3 != null) {
            return x0$3._2$mcI$sp();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ String $anonfun$changeBrokerConfig$2(int x$11) {
        return Integer.toString(x$11);
    }

    private final Seq entityPaths$1(Option rootPath, String rootEntityType$1) {
        String string;
        if (rootPath instanceof Some) {
            String path = (String)((Some)rootPath).value();
            string = new StringBuilder(11).append(rootEntityType$1).append('/').append(path).toString();
        } else if (None$.MODULE$.equals(rootPath)) {
            string = rootEntityType$1;
        } else {
            throw new MatchError((Object)rootPath);
        }
        String root = string;
        Seq<String> entityNames = this.zkClient.getAllEntitiesWithConfig(root);
        if (rootPath instanceof Some) {
            String path = (String)((Some)rootPath).value();
            return (Seq)entityNames.map((Function1 & Serializable)entityName -> new StringBuilder(11).append(path).append('/').append((String)entityName).toString());
        }
        if (None$.MODULE$.equals(rootPath)) {
            return entityNames;
        }
        throw new MatchError((Object)rootPath);
    }

    public static final /* synthetic */ void $anonfun$maybeReencryptClusterLinkConfigs$1(AdminZkClient $this, Function1 configTransformer$1, ClusterLinkData link) {
        String javaLinkId = CoreUtils$.MODULE$.toJavaUUID(link.linkId()).toString();
        $this.zkClient.transformEntityConfigs(ConfigType$.MODULE$.ClusterLink(), javaLinkId, (Function1<Properties, Option<Properties>>)configTransformer$1);
    }

    public AdminZkClient(KafkaZkClient zkClient) {
        this.zkClient = zkClient;
    }

    public static final /* synthetic */ Object $anonfun$createNewPartitionsAssignment$1$adapted(AdminZkClient $this, Seq existingAssignmentPartition0$1, Seq allBrokers$2, Map proposedReplicaAssignment) {
        $this.validateReplicaAssignment((Map<Object, ReplicaAssignment>)proposedReplicaAssignment, existingAssignmentPartition0$1.size(), (scala.collection.immutable.Set<Object>)((IterableOnceOps)allBrokers$2.map((Function1 & Serializable)x$9 -> BoxesRunTime.boxToInteger((int)x$9.id()))).toSet());
        return BoxedUnit.UNIT;
    }
}

